/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;

public abstract class WorldGenScatteredPiece
extends StructurePiece {
    protected final int c;
    protected final int d;
    protected final int e;
    protected int f = -1;

    protected WorldGenScatteredPiece(WorldGenFeatureStructurePieceType type, int x2, int y2, int z2, int width, int height, int depth, EnumDirection orientation) {
        super(type, 0, StructurePiece.a(x2, y2, z2, orientation, width, height, depth));
        this.c = width;
        this.d = height;
        this.e = depth;
        this.a(orientation);
    }

    protected WorldGenScatteredPiece(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
        super(type, nbt);
        this.c = nbt.h("Width");
        this.d = nbt.h("Height");
        this.e = nbt.h("Depth");
        this.f = nbt.h("HPos");
    }

    @Override
    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
        nbt.a("Width", this.c);
        nbt.a("Height", this.d);
        nbt.a("Depth", this.e);
        nbt.a("HPos", this.f);
    }

    protected boolean a(GeneratorAccess world, StructureBoundingBox boundingBox, int deltaY) {
        if (this.f >= 0) {
            return true;
        }
        int i2 = 0;
        int j2 = 0;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int k2 = this.A.i(); k2 <= this.A.l(); ++k2) {
            for (int l2 = this.A.g(); l2 <= this.A.j(); ++l2) {
                mutableBlockPos.d(l2, 64, k2);
                if (!boundingBox.b(mutableBlockPos)) continue;
                i2 += world.a(HeightMap.Type.f, (BlockPosition)mutableBlockPos).v();
                ++j2;
            }
        }
        if (j2 == 0) {
            return false;
        }
        this.f = i2 / j2;
        this.A.a(0, this.f - this.A.h() + deltaY, 0);
        return true;
    }

    protected boolean a(GeneratorAccess world, int i2) {
        if (this.f >= 0) {
            return true;
        }
        int j2 = world.ag();
        boolean bl = false;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int k2 = this.A.i(); k2 <= this.A.l(); ++k2) {
            for (int l2 = this.A.g(); l2 <= this.A.j(); ++l2) {
                mutableBlockPos.d(l2, 0, k2);
                j2 = Math.min(j2, world.a(HeightMap.Type.f, (BlockPosition)mutableBlockPos).v());
                bl = true;
            }
        }
        if (!bl) {
            return false;
        }
        this.f = j2;
        this.A.a(0, this.f - this.A.h() + i2, 0);
        return true;
    }
}

