/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockVine;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlackstoneReplace;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockAge;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorLavaSubmergedBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorPredicates;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestRandomBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import org.slf4j.Logger;

public class WorldGenFeatureRuinedPortalPieces
extends DefinedStructurePiece {
    private static final Logger e = LogUtils.getLogger();
    private static final float f = 0.3f;
    private static final float g = 0.07f;
    private static final float h = 0.2f;
    private static final float i = 0.2f;
    private final Position j;
    private final a k;

    public WorldGenFeatureRuinedPortalPieces(DefinedStructureManager manager, BlockPosition pos, Position verticalPlacement, a properties, MinecraftKey id, DefinedStructure structure, EnumBlockRotation rotation, EnumBlockMirror mirror, BlockPosition blockPos) {
        super(WorldGenFeatureStructurePieceType.J, 0, manager, id, id.toString(), WorldGenFeatureRuinedPortalPieces.a(mirror, rotation, verticalPlacement, blockPos, properties), pos);
        this.j = verticalPlacement;
        this.k = properties;
    }

    public WorldGenFeatureRuinedPortalPieces(DefinedStructureManager manager, NBTTagCompound nbt) {
        super(WorldGenFeatureStructurePieceType.J, nbt, manager, id -> WorldGenFeatureRuinedPortalPieces.a(manager, nbt, id));
        this.j = Position.a(nbt.l("VerticalPlacement"));
        this.k = (a)net.minecraft.world.level.levelgen.structure.WorldGenFeatureRuinedPortalPieces$a.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("Properties"))).getOrThrow(true, arg_0 -> ((Logger)e).error(arg_0));
    }

    @Override
    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
        super.a(context, nbt);
        nbt.a("Rotation", this.c.d().name());
        nbt.a("Mirror", this.c.c().name());
        nbt.a("VerticalPlacement", this.j.a());
        net.minecraft.world.level.levelgen.structure.WorldGenFeatureRuinedPortalPieces$a.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.k).resultOrPartial(arg_0 -> ((Logger)e).error(arg_0)).ifPresent(tag -> nbt.a("Properties", (NBTBase)tag));
    }

    private static DefinedStructureInfo a(DefinedStructureManager manager, NBTTagCompound nbt, MinecraftKey id) {
        DefinedStructure structureTemplate = manager.a(id);
        BlockPosition blockPos = new BlockPosition(structureTemplate.a().u() / 2, 0, structureTemplate.a().w() / 2);
        return WorldGenFeatureRuinedPortalPieces.a(EnumBlockMirror.valueOf(nbt.l("Mirror")), EnumBlockRotation.valueOf(nbt.l("Rotation")), Position.a(nbt.l("VerticalPlacement")), blockPos, (a)net.minecraft.world.level.levelgen.structure.WorldGenFeatureRuinedPortalPieces$a.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("Properties"))).getOrThrow(true, arg_0 -> ((Logger)e).error(arg_0)));
    }

    private static DefinedStructureInfo a(EnumBlockMirror mirror, EnumBlockRotation rotation, Position verticalPlacement, BlockPosition pos, a properties) {
        DefinedStructureProcessorBlockIgnore blockIgnoreProcessor = properties.d ? DefinedStructureProcessorBlockIgnore.b : DefinedStructureProcessorBlockIgnore.d;
        ArrayList list = Lists.newArrayList();
        list.add(WorldGenFeatureRuinedPortalPieces.a(Blocks.bK, 0.3f, Blocks.a));
        list.add(WorldGenFeatureRuinedPortalPieces.a(verticalPlacement, properties));
        if (!properties.b) {
            list.add(WorldGenFeatureRuinedPortalPieces.a(Blocks.cT, 0.07f, Blocks.iX));
        }
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(rotation).a(mirror).a(pos).a(blockIgnoreProcessor).a(new DefinedStructureProcessorRule(list)).a(new DefinedStructureProcessorBlockAge(properties.c)).a(new ProtectedBlockProcessor(TagsBlock.bp)).a(new DefinedStructureProcessorLavaSubmergedBlock());
        if (properties.g) {
            structurePlaceSettings.a(DefinedStructureProcessorBlackstoneReplace.b);
        }
        return structurePlaceSettings;
    }

    private static DefinedStructureProcessorPredicates a(Position verticalPlacement, a properties) {
        if (verticalPlacement == Position.c) {
            return WorldGenFeatureRuinedPortalPieces.a(Blocks.B, Blocks.iX);
        }
        if (properties.b) {
            return WorldGenFeatureRuinedPortalPieces.a(Blocks.B, Blocks.cT);
        }
        return WorldGenFeatureRuinedPortalPieces.a(Blocks.B, 0.2f, Blocks.iX);
    }

    @Override
    @Override
    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos2) {
        StructureBoundingBox boundingBox = this.b.b(this.c, this.d);
        if (!chunkBox.b(boundingBox.f())) {
            return;
        }
        chunkBox.b(boundingBox);
        super.a(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, pos2);
        this.b(random, world);
        this.a(random, world);
        if (this.k.f || this.k.e) {
            BlockPosition.a(this.f()).forEach(pos -> {
                if (this.k.f) {
                    this.a(random, (GeneratorAccess)world, (BlockPosition)pos);
                }
                if (this.k.e) {
                    this.b(random, world, (BlockPosition)pos);
                }
            });
        }
    }

    @Override
    @Override
    protected void a(String metadata, BlockPosition pos, WorldAccess world, Random random, StructureBoundingBox boundingBox) {
    }

    private void a(Random random, GeneratorAccess world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos);
        if (blockState.g() || blockState.a(Blocks.dX)) {
            return;
        }
        EnumDirection direction = WorldGenFeatureRuinedPortalPieces.b(random);
        BlockPosition blockPos = pos.a(direction);
        IBlockData blockState2 = world.a_(blockPos);
        if (!blockState2.g()) {
            return;
        }
        if (!Block.a(blockState.k(world, pos), direction)) {
            return;
        }
        BlockStateBoolean booleanProperty = BlockVine.a(direction.f());
        world.a(blockPos, (IBlockData)Blocks.dX.n().a(booleanProperty, true), 3);
    }

    private void b(Random random, GeneratorAccess world, BlockPosition pos) {
        if (random.nextFloat() < 0.5f && world.a_(pos).a(Blocks.cT) && world.a_(pos.b()).g()) {
            world.a(pos.b(), (IBlockData)Blocks.an.n().a(BlockLeaves.c, true), 3);
        }
    }

    private void a(Random random, GeneratorAccess world) {
        for (int i2 = this.A.g() + 1; i2 < this.A.j(); ++i2) {
            for (int j2 = this.A.i() + 1; j2 < this.A.l(); ++j2) {
                BlockPosition blockPos = new BlockPosition(i2, this.A.h(), j2);
                if (!world.a_(blockPos).a(Blocks.cT)) continue;
                this.c(random, world, blockPos.c());
            }
        }
    }

    private void c(Random random, GeneratorAccess world, BlockPosition pos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.i();
        this.d(random, world, mutableBlockPos);
        for (int i2 = 8; i2 > 0 && random.nextFloat() < 0.5f; --i2) {
            mutableBlockPos.c(EnumDirection.a);
            this.d(random, world, mutableBlockPos);
        }
    }

    private void b(Random random, GeneratorAccess world) {
        boolean bl = this.j == Position.a || this.j == Position.c;
        BlockPosition blockPos = this.A.f();
        int i2 = blockPos.u();
        int j2 = blockPos.w();
        float[] fs = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.9f, 0.9f, 0.8f, 0.7f, 0.6f, 0.4f, 0.2f};
        int k2 = fs.length;
        int l2 = (this.A.c() + this.A.e()) / 2;
        int m2 = random.nextInt(Math.max(1, 8 - l2 / 2));
        int n2 = 3;
        BlockPosition.MutableBlockPosition mutableBlockPos = BlockPosition.b.i();
        for (int o2 = i2 - k2; o2 <= i2 + k2; ++o2) {
            for (int p2 = j2 - k2; p2 <= j2 + k2; ++p2) {
                int q2 = Math.abs(o2 - i2) + Math.abs(p2 - j2);
                int r2 = Math.max(0, q2 + m2);
                if (r2 >= k2) continue;
                float f2 = fs[r2];
                if (!(random.nextDouble() < (double)f2)) continue;
                int s2 = WorldGenFeatureRuinedPortalPieces.a(world, o2, p2, this.j);
                int t2 = bl ? s2 : Math.min(this.A.h(), s2);
                mutableBlockPos.d(o2, t2, p2);
                if (Math.abs(t2 - this.A.h()) > 3 || !this.a(world, mutableBlockPos)) continue;
                this.d(random, world, mutableBlockPos);
                if (this.k.e) {
                    this.b(random, world, mutableBlockPos);
                }
                this.c(random, world, mutableBlockPos.c());
            }
        }
    }

    private boolean a(GeneratorAccess world, BlockPosition pos) {
        IBlockData blockState = world.a_(pos);
        return !blockState.a(Blocks.a) && !blockState.a(Blocks.bQ) && !blockState.a(TagsBlock.bp) && (this.j == Position.f || !blockState.a(Blocks.B));
    }

    private void d(Random random, GeneratorAccess world, BlockPosition pos) {
        if (!this.k.b && random.nextFloat() < 0.07f) {
            world.a(pos, Blocks.iX.n(), 3);
        } else {
            world.a(pos, Blocks.cT.n(), 3);
        }
    }

    private static int a(GeneratorAccess world, int x2, int y2, Position verticalPlacement) {
        return world.a(WorldGenFeatureRuinedPortalPieces.a(verticalPlacement), x2, y2) - 1;
    }

    public static HeightMap.Type a(Position verticalPlacement) {
        return verticalPlacement == Position.c ? HeightMap.Type.c : HeightMap.Type.a;
    }

    private static DefinedStructureProcessorPredicates a(Block old, float chance, Block updated) {
        return new DefinedStructureProcessorPredicates(new DefinedStructureTestRandomBlock(old, chance), DefinedStructureTestTrue.b, updated.n());
    }

    private static DefinedStructureProcessorPredicates a(Block old, Block updated) {
        return new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(old), DefinedStructureTestTrue.b, updated.n());
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position a = new Position("on_land_surface");
        public static final /* enum */ Position b = new Position("partly_buried");
        public static final /* enum */ Position c = new Position("on_ocean_floor");
        public static final /* enum */ Position d = new Position("in_mountain");
        public static final /* enum */ Position e = new Position("underground");
        public static final /* enum */ Position f = new Position("in_nether");
        private static final Map<String, Position> g;
        private final String h;
        private static final /* synthetic */ Position[] i;

        public static Position[] values() {
            return (Position[])i.clone();
        }

        public static Position valueOf(String string) {
            return Enum.valueOf(Position.class, string);
        }

        private Position(String id) {
            this.h = id;
        }

        public String a() {
            return this.h;
        }

        public static Position a(String id) {
            return g.get(id);
        }

        private static /* synthetic */ Position[] b() {
            return new Position[]{a, b, c, d, e, f};
        }

        static {
            i = Position.b();
            g = Arrays.stream(Position.values()).collect(Collectors.toMap(Position::a, verticalPlacement -> verticalPlacement));
        }
    }

    public static class a {
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("cold").forGetter(properties -> properties.b), (App)Codec.FLOAT.fieldOf("mossiness").forGetter(properties -> Float.valueOf(properties.c)), (App)Codec.BOOL.fieldOf("air_pocket").forGetter(properties -> properties.d), (App)Codec.BOOL.fieldOf("overgrown").forGetter(properties -> properties.e), (App)Codec.BOOL.fieldOf("vines").forGetter(properties -> properties.f), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(properties -> properties.g)).apply((Applicative)instance, a::new));
        public boolean b;
        public float c = 0.2f;
        public boolean d;
        public boolean e;
        public boolean f;
        public boolean g;

        public a() {
        }

        public a(boolean cold, float mossiness, boolean airPocket, boolean overgrown, boolean vines, boolean replaceWithBlackstone) {
            this.b = cold;
            this.c = mossiness;
            this.d = airPocket;
            this.e = overgrown;
            this.f = vines;
            this.g = replaceWithBlackstone;
        }
    }
}

