/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2BooleanMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.visitors.CollectFields;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.slf4j.Logger;

public class StructureCheck {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = -1;
    private final ChunkScanAccess c;
    private final IRegistryCustom d;
    private final IRegistry<BiomeBase> e;
    private final IRegistry<StructureFeature<?, ?>> f;
    private final DefinedStructureManager g;
    private final ResourceKey<WorldDimension> h;
    private final ChunkGenerator i;
    private final LevelHeightAccessor j;
    private final WorldChunkManager k;
    private final long l;
    private final DataFixer m;
    private final Long2ObjectMap<Object2IntMap<StructureFeature<?, ?>>> n = new Long2ObjectOpenHashMap();
    private final Map<StructureFeature<?, ?>, Long2BooleanMap> o = new HashMap();

    public StructureCheck(ChunkScanAccess chunkIoWorker, IRegistryCustom registryManager, DefinedStructureManager structureManager, ResourceKey<WorldDimension> worldKey, ChunkGenerator chunkGenerator, LevelHeightAccessor world, WorldChunkManager biomeSource, long seed, DataFixer dataFixer) {
        this.c = chunkIoWorker;
        this.d = registryManager;
        this.g = structureManager;
        this.h = worldKey;
        this.i = chunkGenerator;
        this.j = world;
        this.k = biomeSource;
        this.l = seed;
        this.m = dataFixer;
        this.e = registryManager.b(IRegistry.aP);
        this.f = registryManager.b(IRegistry.aL);
    }

    public StructureCheckResult a(ChunkCoordIntPair chunkPos, StructureFeature<?, ?> configuredStructureFeature, boolean skipExistingChunk) {
        long l2 = chunkPos.a();
        Object2IntMap object2IntMap = (Object2IntMap)this.n.get(l2);
        if (object2IntMap != null) {
            return this.a(object2IntMap, configuredStructureFeature, skipExistingChunk);
        }
        StructureCheckResult structureCheckResult = this.a(chunkPos, configuredStructureFeature, skipExistingChunk, l2);
        if (structureCheckResult != null) {
            return structureCheckResult;
        }
        boolean bl = this.o.computeIfAbsent(configuredStructureFeature, configuredStructureFeaturex -> new Long2BooleanOpenHashMap()).computeIfAbsent(l2, lx -> this.b(chunkPos, configuredStructureFeature));
        return !bl ? StructureCheckResult.b : StructureCheckResult.c;
    }

    private <FC extends WorldGenFeatureConfiguration, F extends StructureGenerator<FC>> boolean b(ChunkCoordIntPair pos, StructureFeature<FC, F> feature) {
        return ((StructureGenerator)feature.d).a(this.d, this.i, this.k, this.g, this.l, pos, feature.e, this.j, feature.a()::a);
    }

    @Nullable
    private StructureCheckResult a(ChunkCoordIntPair pos, StructureFeature<?, ?> configuredStructureFeature, boolean skipExistingChunk, long posLong) {
        NBTTagCompound compoundTag2;
        CollectFields collectFields = new CollectFields(new FieldSelector(NBTTagInt.a, "DataVersion"), new FieldSelector("Level", "Structures", NBTTagCompound.b, "Starts"), new FieldSelector("structures", NBTTagCompound.b, "starts"));
        try {
            this.c.a(pos, collectFields).join();
        }
        catch (Exception var13) {
            a.warn("Failed to read chunk {}", (Object)pos, (Object)var13);
            return StructureCheckResult.c;
        }
        NBTBase tag = collectFields.d();
        if (!(tag instanceof NBTTagCompound)) {
            return null;
        }
        NBTTagCompound compoundTag = (NBTTagCompound)tag;
        int i2 = IChunkLoader.a(compoundTag);
        if (i2 <= 1493) {
            return StructureCheckResult.c;
        }
        IChunkLoader.a(compoundTag, this.h, this.i.c());
        try {
            compoundTag2 = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, compoundTag, i2, SharedConstants.b().getWorldVersion());
        }
        catch (Exception var12) {
            a.warn("Failed to partially datafix chunk {}", (Object)pos, (Object)var12);
            return StructureCheckResult.c;
        }
        Object2IntMap<StructureFeature<?, ?>> object2IntMap = this.a(compoundTag2);
        if (object2IntMap == null) {
            return null;
        }
        this.a(posLong, object2IntMap);
        return this.a(object2IntMap, configuredStructureFeature, skipExistingChunk);
    }

    @Nullable
    private Object2IntMap<StructureFeature<?, ?>> a(NBTTagCompound nbt) {
        if (!nbt.b("structures", 10)) {
            return null;
        }
        NBTTagCompound compoundTag = nbt.p("structures");
        if (!compoundTag.b("starts", 10)) {
            return null;
        }
        NBTTagCompound compoundTag2 = compoundTag.p("starts");
        if (compoundTag2.f()) {
            return Object2IntMaps.emptyMap();
        }
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        IRegistry<StructureFeature<?, ?>> registry = this.d.d(IRegistry.aL);
        for (String string : compoundTag2.d()) {
            String string2;
            NBTTagCompound compoundTag3;
            StructureFeature<?, ?> configuredStructureFeature;
            MinecraftKey resourceLocation = MinecraftKey.a(string);
            if (resourceLocation == null || (configuredStructureFeature = registry.a(resourceLocation)) == null || (compoundTag3 = compoundTag2.p(string)).f() || "INVALID".equals(string2 = compoundTag3.l("id"))) continue;
            int i2 = compoundTag3.h("references");
            object2IntMap.put(configuredStructureFeature, i2);
        }
        return object2IntMap;
    }

    private static Object2IntMap<StructureFeature<?, ?>> a(Object2IntMap<StructureFeature<?, ?>> map) {
        return map.isEmpty() ? Object2IntMaps.emptyMap() : map;
    }

    private StructureCheckResult a(Object2IntMap<StructureFeature<?, ?>> referencesByStructure, StructureFeature<?, ?> configuredStructureFeature, boolean skipExistingChunk) {
        int i2 = referencesByStructure.getOrDefault(configuredStructureFeature, -1);
        return i2 == -1 || skipExistingChunk && i2 != 0 ? StructureCheckResult.b : StructureCheckResult.a;
    }

    public void a(ChunkCoordIntPair pos, Map<StructureFeature<?, ?>, StructureStart> structureStarts) {
        long l2 = pos.a();
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        structureStarts.forEach((arg_0, arg_1) -> StructureCheck.a((Object2IntMap)object2IntMap, arg_0, arg_1));
        this.a(l2, (Object2IntMap<StructureFeature<?, ?>>)object2IntMap);
    }

    private void a(long pos, Object2IntMap<StructureFeature<?, ?>> referencesByStructure) {
        this.n.put(pos, StructureCheck.a(referencesByStructure));
        this.o.values().forEach(generationPossibilityByChunkPos -> generationPossibilityByChunkPos.remove(pos));
    }

    public void a(ChunkCoordIntPair pos, StructureFeature<?, ?> configuredStructureFeature) {
        this.n.compute(pos.a(), (posx, referencesByStructure) -> {
            if (referencesByStructure == null || referencesByStructure.isEmpty()) {
                referencesByStructure = new Object2IntOpenHashMap();
            }
            referencesByStructure.computeInt((Object)configuredStructureFeature, (configuredStructureFeaturex, references) -> references == null ? 1 : references + 1);
            return referencesByStructure;
        });
    }

    private static /* synthetic */ void a(Object2IntMap object2IntMap, StructureFeature configuredStructureFeature, StructureStart structureStart) {
        if (structureStart.b()) {
            object2IntMap.put((Object)configuredStructureFeature, structureStart.f());
        }
    }
}

