/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.slf4j.Logger;

public abstract class DefinedStructurePiece
extends StructurePiece {
    private static final Logger e = LogUtils.getLogger();
    protected final String a;
    protected DefinedStructure b;
    protected DefinedStructureInfo c;
    protected BlockPosition d;

    public DefinedStructurePiece(WorldGenFeatureStructurePieceType type, int length, DefinedStructureManager structureManager, MinecraftKey id, String template, DefinedStructureInfo placementData, BlockPosition pos) {
        super(type, length, structureManager.a(id).b(placementData, pos));
        this.a(EnumDirection.c);
        this.a = template;
        this.d = pos;
        this.b = structureManager.a(id);
        this.c = placementData;
    }

    public DefinedStructurePiece(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt, DefinedStructureManager structureManager, Function<MinecraftKey, DefinedStructureInfo> placementDataGetter) {
        super(type, nbt);
        this.a(EnumDirection.c);
        this.a = nbt.l("Template");
        this.d = new BlockPosition(nbt.h("TPX"), nbt.h("TPY"), nbt.h("TPZ"));
        MinecraftKey resourceLocation = this.a();
        this.b = structureManager.a(resourceLocation);
        this.c = placementDataGetter.apply(resourceLocation);
        this.A = this.b.b(this.c, this.d);
    }

    protected MinecraftKey a() {
        return new MinecraftKey(this.a);
    }

    @Override
    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
        nbt.a("TPX", this.d.u());
        nbt.a("TPY", this.d.v());
        nbt.a("TPZ", this.d.w());
        nbt.a("Template", this.a);
    }

    @Override
    @Override
    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
        this.c.a(chunkBox);
        this.A = this.b.b(this.c, this.d);
        if (this.b.a(world, this.d, pos, this.c, random, 2)) {
            List<DefinedStructure.BlockInfo> list = this.b.a(this.d, this.c, Blocks.nm);
            for (DefinedStructure.BlockInfo structureBlockInfo : list) {
                BlockPropertyStructureMode structureMode;
                if (structureBlockInfo.c == null || (structureMode = BlockPropertyStructureMode.valueOf(structureBlockInfo.c.l("mode"))) != BlockPropertyStructureMode.d) continue;
                this.a(structureBlockInfo.c.l("metadata"), structureBlockInfo.a, world, random, chunkBox);
            }
            List<DefinedStructure.BlockInfo> list2 = this.b.a(this.d, this.c, Blocks.nn);
            for (DefinedStructure.BlockInfo structureBlockInfo2 : list2) {
                if (structureBlockInfo2.c == null) continue;
                String string = structureBlockInfo2.c.l("final_state");
                ArgumentBlock blockStateParser = new ArgumentBlock(new StringReader(string), false);
                IBlockData blockState = Blocks.a.n();
                try {
                    blockStateParser.a(true);
                    IBlockData blockState2 = blockStateParser.b();
                    if (blockState2 != null) {
                        blockState = blockState2;
                    } else {
                        e.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)string, (Object)structureBlockInfo2.a);
                    }
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    e.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)string, (Object)structureBlockInfo2.a);
                }
                world.a(structureBlockInfo2.a, blockState, 3);
            }
        }
    }

    protected abstract void a(String var1, BlockPosition var2, WorldAccess var3, Random var4, StructureBoundingBox var5);

    @Override
    @Deprecated
    @Override
    public void a(int x2, int y2, int z2) {
        super.a(x2, y2, z2);
        this.d = this.d.b(x2, y2, z2);
    }

    @Override
    @Override
    public EnumBlockRotation ad_() {
        return this.c.d();
    }
}

