/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.heightproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import org.slf4j.Logger;

public class UniformHeight
extends HeightProvider {
    public static final Codec<UniformHeight> a = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.a.fieldOf("min_inclusive").forGetter(provider -> provider.d), (App)VerticalAnchor.a.fieldOf("max_inclusive").forGetter(provider -> provider.e)).apply((Applicative)instance, UniformHeight::new));
    private static final Logger b = LogUtils.getLogger();
    private final VerticalAnchor d;
    private final VerticalAnchor e;
    private final LongSet f = new LongOpenHashSet();

    private UniformHeight(VerticalAnchor minOffset, VerticalAnchor maxOffset) {
        this.d = minOffset;
        this.e = maxOffset;
    }

    public static UniformHeight a(VerticalAnchor minOffset, VerticalAnchor maxOffset) {
        return new UniformHeight(minOffset, maxOffset);
    }

    @Override
    @Override
    public int a(Random random, WorldGenerationContext context) {
        int j2;
        int i2 = this.d.a(context);
        if (i2 > (j2 = this.e.a(context))) {
            if (this.f.add((long)i2 << 32 | (long)j2)) {
                b.warn("Empty height range: {}", (Object)this);
            }
            return i2;
        }
        return MathHelper.b(random, i2, j2);
    }

    @Override
    @Override
    public HeightProviderType<?> a() {
        return HeightProviderType.b;
    }

    @Override
    public String toString() {
        return "[" + this.d + "-" + this.e + "]";
    }
}

