/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.heightproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import org.slf4j.Logger;

public class BiasedToBottomHeight
extends HeightProvider {
    public static final Codec<BiasedToBottomHeight> a = RecordCodecBuilder.create(instance -> instance.group((App)VerticalAnchor.a.fieldOf("min_inclusive").forGetter(provider -> provider.d), (App)VerticalAnchor.a.fieldOf("max_inclusive").forGetter(provider -> provider.e), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("inner", (Object)1).forGetter(provider -> provider.f)).apply((Applicative)instance, BiasedToBottomHeight::new));
    private static final Logger b = LogUtils.getLogger();
    private final VerticalAnchor d;
    private final VerticalAnchor e;
    private final int f;

    private BiasedToBottomHeight(VerticalAnchor minOffset, VerticalAnchor maxOffset, int inner) {
        this.d = minOffset;
        this.e = maxOffset;
        this.f = inner;
    }

    public static BiasedToBottomHeight a(VerticalAnchor minOffset, VerticalAnchor maxOffset, int inner) {
        return new BiasedToBottomHeight(minOffset, maxOffset, inner);
    }

    @Override
    @Override
    public int a(Random random, WorldGenerationContext context) {
        int i2 = this.d.a(context);
        int j2 = this.e.a(context);
        if (j2 - i2 - this.f + 1 <= 0) {
            b.warn("Empty height range: {}", (Object)this);
            return i2;
        }
        int k2 = random.nextInt(j2 - i2 - this.f + 1);
        return random.nextInt(k2 + this.f) + i2;
    }

    @Override
    @Override
    public HeightProviderType<?> a() {
        return HeightProviderType.c;
    }

    @Override
    public String toString() {
        return "biased[" + this.d + "-" + this.e + " inner: " + this.f + "]";
    }
}

