/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.flat;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureFillConfiguration;
import net.minecraft.world.level.levelgen.flat.WorldGenFlatLayerInfo;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.slf4j.Logger;

public class GeneratorSettingsFlat {
    private static final Logger b = LogUtils.getLogger();
    public static final Codec<GeneratorSettingsFlat> a = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.b(IRegistry.aP).forGetter(flatLevelGeneratorSettings -> flatLevelGeneratorSettings.c), (App)RegistryCodecs.a(IRegistry.aM).optionalFieldOf("structure_overrides").forGetter(flatLevelGeneratorSettings -> flatLevelGeneratorSettings.d), (App)WorldGenFlatLayerInfo.a.listOf().fieldOf("layers").forGetter(GeneratorSettingsFlat::f), (App)Codec.BOOL.fieldOf("lakes").orElse((Object)false).forGetter(flatLevelGeneratorSettings -> flatLevelGeneratorSettings.j), (App)Codec.BOOL.fieldOf("features").orElse((Object)false).forGetter(flatLevelGeneratorSettings -> flatLevelGeneratorSettings.i), (App)BiomeBase.c.optionalFieldOf("biome").orElseGet(Optional::empty).forGetter(flatLevelGeneratorSettings -> Optional.of(flatLevelGeneratorSettings.f))).apply((Applicative)instance, GeneratorSettingsFlat::new)).comapFlatMap(GeneratorSettingsFlat::a, Function.identity()).stable();
    private final IRegistry<BiomeBase> c;
    private final Optional<HolderSet<StructureSet>> d;
    private final List<WorldGenFlatLayerInfo> e = Lists.newArrayList();
    private Holder<BiomeBase> f;
    private final List<IBlockData> g;
    private boolean h;
    private boolean i;
    private boolean j;

    private static DataResult<GeneratorSettingsFlat> a(GeneratorSettingsFlat config) {
        int i2 = config.e.stream().mapToInt(WorldGenFlatLayerInfo::a).sum();
        if (i2 > DimensionManager.c) {
            return DataResult.error((String)("Sum of layer heights is > " + DimensionManager.c), (Object)config);
        }
        return DataResult.success((Object)config);
    }

    private GeneratorSettingsFlat(IRegistry<BiomeBase> biomeRegistry, Optional<HolderSet<StructureSet>> optional, List<WorldGenFlatLayerInfo> layers, boolean hasLakes, boolean hasFeatures, Optional<Holder<BiomeBase>> biome) {
        this(optional, biomeRegistry);
        if (hasLakes) {
            this.b();
        }
        if (hasFeatures) {
            this.a();
        }
        this.e.addAll(layers);
        this.h();
        if (biome.isEmpty()) {
            b.error("Unknown biome, defaulting to plains");
            this.f = biomeRegistry.c(Biomes.b);
        } else {
            this.f = biome.get();
        }
    }

    public GeneratorSettingsFlat(Optional<HolderSet<StructureSet>> optional, IRegistry<BiomeBase> biomeRegistry) {
        this.c = biomeRegistry;
        this.d = optional;
        this.f = biomeRegistry.c(Biomes.b);
        this.g = Lists.newArrayList();
    }

    public GeneratorSettingsFlat a(List<WorldGenFlatLayerInfo> layers, Optional<HolderSet<StructureSet>> optional) {
        GeneratorSettingsFlat flatLevelGeneratorSettings = new GeneratorSettingsFlat(optional, this.c);
        for (WorldGenFlatLayerInfo flatLayerInfo : layers) {
            flatLevelGeneratorSettings.e.add(new WorldGenFlatLayerInfo(flatLayerInfo.a(), flatLayerInfo.b().b()));
            flatLevelGeneratorSettings.h();
        }
        flatLevelGeneratorSettings.a(this.f);
        if (this.i) {
            flatLevelGeneratorSettings.a();
        }
        if (this.j) {
            flatLevelGeneratorSettings.b();
        }
        return flatLevelGeneratorSettings;
    }

    public void a() {
        this.i = true;
    }

    public void b() {
        this.j = true;
    }

    public Holder<BiomeBase> c() {
        boolean bl;
        BiomeBase biome = this.e().a();
        BiomeSettingsGeneration biomeGenerationSettings = biome.e();
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a();
        if (this.j) {
            builder.a(WorldGenStage.Decoration.b, MiscOverworldPlacements.g);
            builder.a(WorldGenStage.Decoration.b, MiscOverworldPlacements.h);
        }
        boolean bl2 = bl = (!this.h || this.f.a(Biomes.a)) && this.i;
        if (bl) {
            List<HolderSet<PlacedFeature>> list = biomeGenerationSettings.b();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (i2 == WorldGenStage.Decoration.d.ordinal() || i2 == WorldGenStage.Decoration.e.ordinal()) continue;
                HolderSet<PlacedFeature> holderSet = list.get(i2);
                for (Holder holder : holderSet) {
                    builder.a(i2, (Holder<PlacedFeature>)holder);
                }
            }
        }
        List<IBlockData> list2 = this.g();
        for (int j2 = 0; j2 < list2.size(); ++j2) {
            IBlockData blockState = list2.get(j2);
            if (HeightMap.Type.e.e().test(blockState)) continue;
            list2.set(j2, null);
            builder.a(WorldGenStage.Decoration.k, PlacementUtils.a(WorldGenerator.ad, new WorldGenFeatureFillConfiguration(j2, blockState), new PlacementModifier[0]));
        }
        return Holder.a(BiomeBase.a.a(biome).a(builder.a()).a());
    }

    public Optional<HolderSet<StructureSet>> d() {
        return this.d;
    }

    public Holder<BiomeBase> e() {
        return this.f;
    }

    public void a(Holder<BiomeBase> holder) {
        this.f = holder;
    }

    public List<WorldGenFlatLayerInfo> f() {
        return this.e;
    }

    public List<IBlockData> g() {
        return this.g;
    }

    public void h() {
        this.g.clear();
        for (WorldGenFlatLayerInfo flatLayerInfo : this.e) {
            for (int i2 = 0; i2 < flatLayerInfo.a(); ++i2) {
                this.g.add(flatLayerInfo.b());
            }
        }
        this.h = this.g.stream().allMatch(state -> state.a(Blocks.a));
    }

    public static GeneratorSettingsFlat a(IRegistry<BiomeBase> biomeRegistry, IRegistry<StructureSet> registry) {
        HolderSet.a holderSet = HolderSet.a(registry.g(BuiltinStructureSets.q), registry.g(BuiltinStructureSets.a));
        GeneratorSettingsFlat flatLevelGeneratorSettings = new GeneratorSettingsFlat(Optional.of(holderSet), biomeRegistry);
        flatLevelGeneratorSettings.f = biomeRegistry.c(Biomes.b);
        flatLevelGeneratorSettings.f().add(new WorldGenFlatLayerInfo(1, Blocks.z));
        flatLevelGeneratorSettings.f().add(new WorldGenFlatLayerInfo(2, Blocks.j));
        flatLevelGeneratorSettings.f().add(new WorldGenFlatLayerInfo(1, Blocks.i));
        flatLevelGeneratorSettings.h();
        return flatLevelGeneratorSettings;
    }
}

