/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacers;

public abstract class WorldGenFoilagePlacer {
    public static final Codec<WorldGenFoilagePlacer> d = IRegistry.br.o().dispatch(WorldGenFoilagePlacer::a, WorldGenFoilagePlacers::a);
    protected final IntProvider e;
    protected final IntProvider f;

    protected static <P extends WorldGenFoilagePlacer> Products.P2<RecordCodecBuilder.Mu<P>, IntProvider, IntProvider> b(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)IntProvider.b(0, 16).fieldOf("radius").forGetter(placer -> placer.e), (App)IntProvider.b(0, 16).fieldOf("offset").forGetter(placer -> placer.f));
    }

    public WorldGenFoilagePlacer(IntProvider radius, IntProvider offset) {
        this.e = radius;
        this.f = offset;
    }

    protected abstract WorldGenFoilagePlacers<?> a();

    public void a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, Random random, WorldGenFeatureTreeConfiguration config, int trunkHeight, a treeNode, int foliageHeight, int radius) {
        this.a(world, replacer, random, config, trunkHeight, treeNode, foliageHeight, radius, this.a(random));
    }

    protected abstract void a(VirtualLevelReadable var1, BiConsumer<BlockPosition, IBlockData> var2, Random var3, WorldGenFeatureTreeConfiguration var4, int var5, a var6, int var7, int var8, int var9);

    public abstract int a(Random var1, int var2, WorldGenFeatureTreeConfiguration var3);

    public int a(Random random, int baseHeight) {
        return this.e.a(random);
    }

    private int a(Random random) {
        return this.f.a(random);
    }

    protected abstract boolean a(Random var1, int var2, int var3, int var4, int var5, boolean var6);

    protected boolean b(Random random, int dx, int y2, int dz, int radius, boolean giantTrunk) {
        int l2;
        int k2;
        if (giantTrunk) {
            int i2 = Math.min(Math.abs(dx), Math.abs(dx - 1));
            int j2 = Math.min(Math.abs(dz), Math.abs(dz - 1));
        } else {
            k2 = Math.abs(dx);
            l2 = Math.abs(dz);
        }
        return this.a(random, k2, y2, l2, radius, giantTrunk);
    }

    protected void a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, Random random, WorldGenFeatureTreeConfiguration config, BlockPosition centerPos, int radius, int y2, boolean giantTrunk) {
        int i2 = giantTrunk ? 1 : 0;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int j2 = -radius; j2 <= radius + i2; ++j2) {
            for (int k2 = -radius; k2 <= radius + i2; ++k2) {
                if (this.b(random, j2, y2, k2, radius, giantTrunk)) continue;
                mutableBlockPos.a(centerPos, j2, y2, k2);
                WorldGenFoilagePlacer.a(world, replacer, random, config, mutableBlockPos);
            }
        }
    }

    protected static void a(VirtualLevelReadable world, BiConsumer<BlockPosition, IBlockData> replacer, Random random, WorldGenFeatureTreeConfiguration config, BlockPosition pos) {
        if (WorldGenTrees.e(world, pos)) {
            replacer.accept(pos, config.e.a(random, pos));
        }
    }

    public static final class a {
        private final BlockPosition a;
        private final int b;
        private final boolean c;

        public a(BlockPosition center, int foliageRadius, boolean giantTrunk) {
            this.a = center;
            this.b = foliageRadius;
            this.c = giantTrunk;
        }

        public BlockPosition a() {
            return this.a;
        }

        public int b() {
            return this.b;
        }

        public boolean c() {
            return this.c;
        }
    }
}

