/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldWriter;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;

public class WorldGenTrees
extends WorldGenerator<WorldGenFeatureTreeConfiguration> {
    private static final int a = 19;

    public WorldGenTrees(Codec<WorldGenFeatureTreeConfiguration> configCodec) {
        super(configCodec);
    }

    public static boolean c(VirtualLevelReadable world, BlockPosition pos) {
        return WorldGenTrees.e(world, pos) || world.a(pos, (IBlockData state) -> state.a(TagsBlock.r));
    }

    private static boolean f(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> state.a(Blocks.dX));
    }

    private static boolean g(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> state.a(Blocks.A));
    }

    public static boolean d(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> state.g() || state.a(TagsBlock.H));
    }

    private static boolean h(VirtualLevelReadable world, BlockPosition pos) {
        return world.a(pos, (IBlockData state) -> {
            Material material = state.c();
            return material == Material.g;
        });
    }

    private static void b(IWorldWriter world, BlockPosition pos, IBlockData state) {
        world.a(pos, state, 19);
    }

    public static boolean e(VirtualLevelReadable world, BlockPosition pos) {
        return WorldGenTrees.d(world, pos) || WorldGenTrees.h(world, pos) || WorldGenTrees.g(world, pos);
    }

    private boolean a(GeneratorAccessSeed world, Random random, BlockPosition pos, BiConsumer<BlockPosition, IBlockData> trunkReplacer, BiConsumer<BlockPosition, IBlockData> foliageReplacer, WorldGenFeatureTreeConfiguration config) {
        int i2 = config.d.a(random);
        int j2 = config.f.a(random, i2, config);
        int k2 = i2 - j2;
        int l2 = config.f.a(random, k2);
        if (pos.v() < world.u_() + 1 || pos.v() + i2 + 1 > world.ag()) {
            return false;
        }
        OptionalInt optionalInt = config.g.c();
        int m2 = this.a((VirtualLevelReadable)world, i2, pos, config);
        if (!(m2 >= i2 || optionalInt.isPresent() && m2 >= optionalInt.getAsInt())) {
            return false;
        }
        List<WorldGenFoilagePlacer.a> list = config.d.a(world, trunkReplacer, random, m2, pos, config);
        list.forEach(node -> treeConfiguration.f.a((VirtualLevelReadable)world, foliageReplacer, random, config, m2, (WorldGenFoilagePlacer.a)node, j2, l2));
        return true;
    }

    private int a(VirtualLevelReadable world, int height, BlockPosition pos, WorldGenFeatureTreeConfiguration config) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 <= height + 1; ++i2) {
            int j2 = config.g.a(height, i2);
            for (int k2 = -j2; k2 <= j2; ++k2) {
                for (int l2 = -j2; l2 <= j2; ++l2) {
                    mutableBlockPos.a(pos, k2, i2, l2);
                    if (WorldGenTrees.c(world, mutableBlockPos) && (config.i || !WorldGenTrees.f(world, mutableBlockPos))) continue;
                    return i2 - 2;
                }
            }
        }
        return height;
    }

    @Override
    @Override
    protected void a(IWorldWriter world, BlockPosition pos, IBlockData state) {
        WorldGenTrees.b(world, pos, state);
    }

    @Override
    @Override
    public final boolean a(FeaturePlaceContext<WorldGenFeatureTreeConfiguration> context) {
        GeneratorAccessSeed worldGenLevel = context.b();
        Random random = context.d();
        BlockPosition blockPos = context.e();
        WorldGenFeatureTreeConfiguration treeConfiguration = context.f();
        HashSet set = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPosition, IBlockData> biConsumer = (pos, state) -> {
            set.add(pos.h());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        BiConsumer<BlockPosition, IBlockData> biConsumer2 = (pos, state) -> {
            set2.add(pos.h());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        BiConsumer<BlockPosition, IBlockData> biConsumer3 = (pos, state) -> {
            set3.add(pos.h());
            worldGenLevel.a((BlockPosition)pos, (IBlockData)state, 19);
        };
        boolean bl = this.a(worldGenLevel, random, blockPos, biConsumer, biConsumer2, treeConfiguration);
        if (!bl || set.isEmpty() && set2.isEmpty()) {
            return false;
        }
        if (!treeConfiguration.h.isEmpty()) {
            ArrayList list = Lists.newArrayList((Iterable)set);
            ArrayList list2 = Lists.newArrayList((Iterable)set2);
            list.sort(Comparator.comparingInt(BaseBlockPosition::v));
            list2.sort(Comparator.comparingInt(BaseBlockPosition::v));
            treeConfiguration.h.forEach(decorator -> decorator.a(worldGenLevel, biConsumer3, random, list, list2));
        }
        return StructureBoundingBox.a(Iterables.concat((Iterable)set, (Iterable)set2, (Iterable)set3)).map(box -> {
            VoxelShapeDiscrete discreteVoxelShape = WorldGenTrees.a((GeneratorAccess)worldGenLevel, box, (Set<BlockPosition>)set, set3);
            DefinedStructure.a(worldGenLevel, 3, discreteVoxelShape, box.g(), box.h(), box.i());
            return true;
        }).orElse(false);
    }

    private static VoxelShapeDiscrete a(GeneratorAccess world, StructureBoundingBox box, Set<BlockPosition> trunkPositions, Set<BlockPosition> decorationPositions) {
        ArrayList list = Lists.newArrayList();
        VoxelShapeBitSet discreteVoxelShape = new VoxelShapeBitSet(box.c(), box.d(), box.e());
        int i2 = 6;
        for (int j2 = 0; j2 < 6; ++j2) {
            list.add(Sets.newHashSet());
        }
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (BlockPosition blockPos : Lists.newArrayList(decorationPositions)) {
            if (!box.b(blockPos)) continue;
            ((VoxelShapeDiscrete)discreteVoxelShape).c(blockPos.u() - box.g(), blockPos.v() - box.h(), blockPos.w() - box.i());
        }
        for (BlockPosition blockPos2 : Lists.newArrayList(trunkPositions)) {
            if (box.b(blockPos2)) {
                ((VoxelShapeDiscrete)discreteVoxelShape).c(blockPos2.u() - box.g(), blockPos2.v() - box.h(), blockPos2.w() - box.i());
            }
            for (EnumDirection direction : EnumDirection.values()) {
                IBlockData blockState;
                mutableBlockPos.a((BaseBlockPosition)blockPos2, direction);
                if (trunkPositions.contains(mutableBlockPos) || !(blockState = world.a_(mutableBlockPos)).b(BlockProperties.ax)) continue;
                ((Set)list.get(0)).add(mutableBlockPos.h());
                WorldGenTrees.b(world, mutableBlockPos, (IBlockData)blockState.a(BlockProperties.ax, 1));
                if (!box.b(mutableBlockPos)) continue;
                ((VoxelShapeDiscrete)discreteVoxelShape).c(mutableBlockPos.u() - box.g(), mutableBlockPos.v() - box.h(), mutableBlockPos.w() - box.i());
            }
        }
        for (int k2 = 1; k2 < 6; ++k2) {
            Set set = (Set)list.get(k2 - 1);
            Set set2 = (Set)list.get(k2);
            for (BlockPosition blockPos3 : set) {
                if (box.b(blockPos3)) {
                    ((VoxelShapeDiscrete)discreteVoxelShape).c(blockPos3.u() - box.g(), blockPos3.v() - box.h(), blockPos3.w() - box.i());
                }
                for (EnumDirection direction2 : EnumDirection.values()) {
                    int l2;
                    IBlockData blockState2;
                    mutableBlockPos.a((BaseBlockPosition)blockPos3, direction2);
                    if (set.contains(mutableBlockPos) || set2.contains(mutableBlockPos) || !(blockState2 = world.a_(mutableBlockPos)).b(BlockProperties.ax) || (l2 = blockState2.c(BlockProperties.ax).intValue()) <= k2 + 1) continue;
                    IBlockData blockState3 = (IBlockData)blockState2.a(BlockProperties.ax, k2 + 1);
                    WorldGenTrees.b(world, mutableBlockPos, blockState3);
                    if (box.b(mutableBlockPos)) {
                        ((VoxelShapeDiscrete)discreteVoxelShape).c(mutableBlockPos.u() - box.g(), mutableBlockPos.v() - box.h(), mutableBlockPos.w() - box.i());
                    }
                    set2.add(mutableBlockPos.h());
                }
            }
        }
        return discreteVoxelShape;
    }
}

