/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.WorldGenMonumentPieces;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class WorldGenMonument
extends StructureGenerator<WorldGenFeatureEmptyConfiguration> {
    public WorldGenMonument(Codec<WorldGenFeatureEmptyConfiguration> configCodec) {
        super(configCodec, PieceGeneratorSupplier.simple(WorldGenMonument::a, WorldGenMonument::a));
    }

    private static boolean a(PieceGeneratorSupplier.a<WorldGenFeatureEmptyConfiguration> context) {
        int i2 = context.d().a(9);
        int j2 = context.d().b(9);
        Set<Holder<BiomeBase>> set = context.b().a(i2, context.a().g(), j2, 29, context.a().d());
        for (Holder<BiomeBase> holder : set) {
            if (BiomeBase.a(holder) == BiomeBase.Geography.l || BiomeBase.a(holder) == BiomeBase.Geography.n) continue;
            return false;
        }
        return context.a(HeightMap.Type.c);
    }

    private static StructurePiece a(ChunkCoordIntPair pos, SeededRandom random) {
        int i2 = pos.d() - 29;
        int j2 = pos.e() - 29;
        EnumDirection direction = EnumDirection.EnumDirectionLimit.a.a(random);
        return new WorldGenMonumentPieces.WorldGenMonumentPiece1(random, i2, j2, direction);
    }

    private static void a(StructurePiecesBuilder collector, PieceGenerator.a<WorldGenFeatureEmptyConfiguration> context) {
        collector.a(WorldGenMonument.a(context.d(), context.f()));
    }

    public static PiecesContainer a(ChunkCoordIntPair pos, long worldSeed, PiecesContainer pieces) {
        if (pieces.a()) {
            return pieces;
        }
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
        worldgenRandom.c(worldSeed, pos.c, pos.d);
        StructurePiece structurePiece = pieces.c().get(0);
        StructureBoundingBox boundingBox = structurePiece.f();
        int i2 = boundingBox.g();
        int j2 = boundingBox.i();
        EnumDirection direction = EnumDirection.EnumDirectionLimit.a.a(worldgenRandom);
        EnumDirection direction2 = Objects.requireNonNullElse(structurePiece.h(), direction);
        WorldGenMonumentPieces.WorldGenMonumentPiece1 structurePiece2 = new WorldGenMonumentPieces.WorldGenMonumentPiece1(worldgenRandom, i2, j2, direction2);
        StructurePiecesBuilder structurePiecesBuilder = new StructurePiecesBuilder();
        structurePiecesBuilder.a(structurePiece2);
        return structurePiecesBuilder.a();
    }
}

