/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.apache.commons.lang3.mutable.MutableInt;

public class WorldGenFossils
extends WorldGenerator<FossilFeatureConfiguration> {
    public WorldGenFossils(Codec<FossilFeatureConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(FeaturePlaceContext<FossilFeatureConfiguration> context) {
        Random random = context.d();
        GeneratorAccessSeed worldGenLevel = context.b();
        BlockPosition blockPos = context.e();
        EnumBlockRotation rotation = EnumBlockRotation.a(random);
        FossilFeatureConfiguration fossilFeatureConfiguration = context.f();
        int i2 = random.nextInt(fossilFeatureConfiguration.b.size());
        DefinedStructureManager structureManager = worldGenLevel.F().n().aS();
        DefinedStructure structureTemplate = structureManager.a(fossilFeatureConfiguration.b.get(i2));
        DefinedStructure structureTemplate2 = structureManager.a(fossilFeatureConfiguration.c.get(i2));
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(blockPos);
        StructureBoundingBox boundingBox = new StructureBoundingBox(chunkPos.d() - 16, worldGenLevel.u_(), chunkPos.e() - 16, chunkPos.f() + 16, worldGenLevel.ag(), chunkPos.g() + 16);
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(rotation).a(boundingBox).a(random);
        BaseBlockPosition vec3i = structureTemplate.a(rotation);
        BlockPosition blockPos2 = blockPos.b(-vec3i.u() / 2, 0, -vec3i.w() / 2);
        int j2 = blockPos.v();
        for (int k2 = 0; k2 < vec3i.u(); ++k2) {
            for (int l2 = 0; l2 < vec3i.w(); ++l2) {
                j2 = Math.min(j2, worldGenLevel.a(HeightMap.Type.c, blockPos2.u() + k2, blockPos2.w() + l2));
            }
        }
        int m2 = Math.max(j2 - 15 - random.nextInt(10), worldGenLevel.u_() + 10);
        BlockPosition blockPos3 = structureTemplate.a(blockPos2.h(m2), EnumBlockMirror.a, rotation);
        if (WorldGenFossils.a(worldGenLevel, structureTemplate.b(structurePlaceSettings, blockPos3)) > fossilFeatureConfiguration.f) {
            return false;
        }
        structurePlaceSettings.b();
        fossilFeatureConfiguration.d.a().a().forEach(structurePlaceSettings::a);
        structureTemplate.a(worldGenLevel, blockPos3, blockPos3, structurePlaceSettings, random, 4);
        structurePlaceSettings.b();
        fossilFeatureConfiguration.e.a().a().forEach(structurePlaceSettings::a);
        structureTemplate2.a(worldGenLevel, blockPos3, blockPos3, structurePlaceSettings, random, 4);
        return true;
    }

    private static int a(GeneratorAccessSeed world, StructureBoundingBox box) {
        MutableInt mutableInt = new MutableInt(0);
        box.a((BlockPosition pos) -> {
            IBlockData blockState = world.a_((BlockPosition)pos);
            if (blockState.g() || blockState.a(Blocks.B) || blockState.a(Blocks.A)) {
                mutableInt.add(1);
            }
        });
        return mutableInt.getValue();
    }
}

