/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootTables;
import org.slf4j.Logger;

public class WorldGenDungeons
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    private static final Logger a = LogUtils.getLogger();
    private static final EntityTypes<?>[] b = new EntityTypes[]{EntityTypes.aB, EntityTypes.be, EntityTypes.be, EntityTypes.aI};
    private static final IBlockData c = Blocks.lp.n();

    public WorldGenDungeons(Codec<WorldGenFeatureEmptyConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> context) {
        Predicate<IBlockData> predicate = WorldGenerator.a(TagsBlock.bp);
        BlockPosition blockPos = context.e();
        Random random = context.d();
        GeneratorAccessSeed worldGenLevel = context.b();
        int i2 = 3;
        int j2 = random.nextInt(2) + 2;
        int k2 = -j2 - 1;
        int l2 = j2 + 1;
        int m2 = -1;
        int n2 = 4;
        int o2 = random.nextInt(2) + 2;
        int p2 = -o2 - 1;
        int q2 = o2 + 1;
        int r2 = 0;
        for (int s2 = k2; s2 <= l2; ++s2) {
            for (int t2 = -1; t2 <= 4; ++t2) {
                for (int u2 = p2; u2 <= q2; ++u2) {
                    BlockPosition blockPos2 = blockPos.b(s2, t2, u2);
                    Material material = worldGenLevel.a_(blockPos2).c();
                    boolean bl = material.b();
                    if (t2 == -1 && !bl) {
                        return false;
                    }
                    if (t2 == 4 && !bl) {
                        return false;
                    }
                    if (s2 != k2 && s2 != l2 && u2 != p2 && u2 != q2 || t2 != 0 || !worldGenLevel.w(blockPos2) || !worldGenLevel.w(blockPos2.b())) continue;
                    ++r2;
                }
            }
        }
        if (r2 < 1 || r2 > 5) {
            return false;
        }
        for (int v2 = k2; v2 <= l2; ++v2) {
            for (int w2 = 3; w2 >= -1; --w2) {
                for (int x2 = p2; x2 <= q2; ++x2) {
                    BlockPosition blockPos3 = blockPos.b(v2, w2, x2);
                    IBlockData blockState = worldGenLevel.a_(blockPos3);
                    if (v2 == k2 || w2 == -1 || x2 == p2 || v2 == l2 || w2 == 4 || x2 == q2) {
                        if (blockPos3.v() >= worldGenLevel.u_() && !worldGenLevel.a_(blockPos3.c()).c().b()) {
                            worldGenLevel.a(blockPos3, c, 2);
                            continue;
                        }
                        if (!blockState.c().b() || blockState.a(Blocks.bX)) continue;
                        if (w2 == -1 && random.nextInt(4) != 0) {
                            this.a(worldGenLevel, blockPos3, Blocks.bP.n(), predicate);
                            continue;
                        }
                        this.a(worldGenLevel, blockPos3, Blocks.m.n(), predicate);
                        continue;
                    }
                    if (blockState.a(Blocks.bX) || blockState.a(Blocks.bV)) continue;
                    this.a(worldGenLevel, blockPos3, c, predicate);
                }
            }
        }
        block6: for (int y2 = 0; y2 < 2; ++y2) {
            for (int z2 = 0; z2 < 3; ++z2) {
                int ac2;
                int ab2;
                int aa2 = blockPos.u() + random.nextInt(j2 * 2 + 1) - j2;
                BlockPosition blockPos4 = new BlockPosition(aa2, ab2 = blockPos.v(), ac2 = blockPos.w() + random.nextInt(o2 * 2 + 1) - o2);
                if (!worldGenLevel.w(blockPos4)) continue;
                int ad = 0;
                for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                    if (!worldGenLevel.a_(blockPos4.a(direction)).c().b()) continue;
                    ++ad;
                }
                if (ad != 1) continue;
                this.a(worldGenLevel, blockPos4, StructurePiece.a(worldGenLevel, blockPos4, Blocks.bX.n()), predicate);
                TileEntityLootable.a(worldGenLevel, random, blockPos4, LootTables.d);
                continue block6;
            }
        }
        this.a(worldGenLevel, blockPos, Blocks.bV.n(), predicate);
        TileEntity blockEntity = worldGenLevel.c_(blockPos);
        if (blockEntity instanceof TileEntityMobSpawner) {
            ((TileEntityMobSpawner)blockEntity).d().a(this.a(random));
        } else {
            a.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{blockPos.u(), blockPos.v(), blockPos.w()});
        }
        return true;
    }

    private EntityTypes<?> a(Random random) {
        return SystemUtils.a(b, random);
    }
}

