/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.WorldGenBuriedTreasure;
import net.minecraft.world.level.levelgen.feature.WorldGenEndCity;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureBastionRemnant;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureDesertPyramid;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureIgloo;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureJunglePyramid;
import net.minecraft.world.level.levelgen.feature.WorldGenFeaturePillagerOutpost;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureRuinedPortal;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureShipwreck;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureSwampHut;
import net.minecraft.world.level.levelgen.feature.WorldGenMineshaft;
import net.minecraft.world.level.levelgen.feature.WorldGenMonument;
import net.minecraft.world.level.levelgen.feature.WorldGenNether;
import net.minecraft.world.level.levelgen.feature.WorldGenStronghold;
import net.minecraft.world.level.levelgen.feature.WorldGenVillage;
import net.minecraft.world.level.levelgen.feature.WorldGenWoodlandMansion;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfigurationChance;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureOceanRuinConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureRuinedPortalConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureShipwreckConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureVillageConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenMineshaftConfiguration;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureNetherFossil;
import net.minecraft.world.level.levelgen.structure.WorldGenFeatureOceanRuin;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.slf4j.Logger;

public class StructureGenerator<C extends WorldGenFeatureConfiguration> {
    private static final Map<StructureGenerator<?>, WorldGenStage.Decoration> a = Maps.newHashMap();
    private static final Logger u = LogUtils.getLogger();
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> b = StructureGenerator.a("pillager_outpost", new WorldGenFeaturePillagerOutpost(WorldGenFeatureVillageConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenMineshaftConfiguration> c = StructureGenerator.a("mineshaft", new WorldGenMineshaft(WorldGenMineshaftConfiguration.a), WorldGenStage.Decoration.d);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> d = StructureGenerator.a("mansion", new WorldGenWoodlandMansion(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> e = StructureGenerator.a("jungle_pyramid", new WorldGenFeatureJunglePyramid(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> f = StructureGenerator.a("desert_pyramid", new WorldGenFeatureDesertPyramid(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> g = StructureGenerator.a("igloo", new WorldGenFeatureIgloo(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureRuinedPortalConfiguration> h = StructureGenerator.a("ruined_portal", new WorldGenFeatureRuinedPortal(WorldGenFeatureRuinedPortalConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureShipwreckConfiguration> i = StructureGenerator.a("shipwreck", new WorldGenFeatureShipwreck(WorldGenFeatureShipwreckConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> j = StructureGenerator.a("swamp_hut", new WorldGenFeatureSwampHut(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> k = StructureGenerator.a("stronghold", new WorldGenStronghold(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.f);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> l = StructureGenerator.a("monument", new WorldGenMonument(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureOceanRuinConfiguration> m = StructureGenerator.a("ocean_ruin", new WorldGenFeatureOceanRuin(WorldGenFeatureOceanRuinConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> n = StructureGenerator.a("fortress", new WorldGenNether(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.h);
    public static final StructureGenerator<WorldGenFeatureEmptyConfiguration> o = StructureGenerator.a("endcity", new WorldGenEndCity(WorldGenFeatureEmptyConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<WorldGenFeatureConfigurationChance> p = StructureGenerator.a("buried_treasure", new WorldGenBuriedTreasure(WorldGenFeatureConfigurationChance.j), WorldGenStage.Decoration.d);
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> q = StructureGenerator.a("village", new WorldGenVillage(WorldGenFeatureVillageConfiguration.a), WorldGenStage.Decoration.e);
    public static final StructureGenerator<RangeConfiguration> r = StructureGenerator.a("nether_fossil", new WorldGenFeatureNetherFossil(RangeConfiguration.a), WorldGenStage.Decoration.h);
    public static final StructureGenerator<WorldGenFeatureVillageConfiguration> s = StructureGenerator.a("bastion_remnant", new WorldGenFeatureBastionRemnant(WorldGenFeatureVillageConfiguration.a), WorldGenStage.Decoration.e);
    public static final int t = 8;
    private final Codec<StructureFeature<C, StructureGenerator<C>>> v = RecordCodecBuilder.create(instance -> instance.group((App)configCodec.fieldOf("config").forGetter(configuredStructureFeature -> configuredStructureFeature.e), (App)RegistryCodecs.a(IRegistry.aP).fieldOf("biomes").forGetter(StructureFeature::a), (App)Codec.BOOL.optionalFieldOf("adapt_noise", (Object)false).forGetter(configuredStructureFeature -> configuredStructureFeature.h), (App)Codec.simpleMap(EnumCreatureType.i, StructureSpawnOverride.a, (Keyable)INamable.a(EnumCreatureType.values())).fieldOf("spawn_overrides").forGetter(configuredStructureFeature -> configuredStructureFeature.g)).apply((Applicative)instance, (featureConfiguration, holderSet, boolean_, map) -> new StructureFeature<WorldGenFeatureConfiguration, StructureGenerator>(this, (WorldGenFeatureConfiguration)featureConfiguration, (HolderSet<BiomeBase>)holderSet, (boolean)boolean_, (Map<EnumCreatureType, StructureSpawnOverride>)map)));
    private final PieceGeneratorSupplier<C> w;
    private final PostPlacementProcessor x;

    private static <F extends StructureGenerator<?>> F a(String name, F structureFeature, WorldGenStage.Decoration step) {
        a.put(structureFeature, step);
        return (F)IRegistry.a(IRegistry.aX, name, structureFeature);
    }

    public StructureGenerator(Codec<C> configCodec, PieceGeneratorSupplier<C> piecesGenerator) {
        this(configCodec, piecesGenerator, PostPlacementProcessor.a);
    }

    public StructureGenerator(Codec<C> configCodec, PieceGeneratorSupplier<C> piecesGenerator, PostPlacementProcessor postPlacementProcessor) {
        this.w = piecesGenerator;
        this.x = postPlacementProcessor;
    }

    public WorldGenStage.Decoration a() {
        return a.get(this);
    }

    public static void b() {
    }

    @Nullable
    public static StructureStart a(StructurePieceSerializationContext context, NBTTagCompound nbt, long worldSeed) {
        String string = nbt.l("id");
        if ("INVALID".equals(string)) {
            return StructureStart.b;
        }
        IRegistry<StructureFeature<?, ?>> registry = context.b().d(IRegistry.aL);
        StructureFeature<?, ?> configuredStructureFeature = registry.a(new MinecraftKey(string));
        if (configuredStructureFeature == null) {
            u.error("Unknown feature id: {}", (Object)string);
            return null;
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(nbt.h("ChunkX"), nbt.h("ChunkZ"));
        int i2 = nbt.h("references");
        NBTTagList listTag = nbt.c("Children", 10);
        try {
            PiecesContainer piecesContainer = PiecesContainer.a(listTag, context);
            if (configuredStructureFeature.d == l) {
                piecesContainer = WorldGenMonument.a(chunkPos, worldSeed, piecesContainer);
            }
            return new StructureStart(configuredStructureFeature, chunkPos, i2, piecesContainer);
        }
        catch (Exception exception) {
            u.error("Failed Start with id {}", (Object)string, (Object)exception);
            return null;
        }
    }

    public Codec<StructureFeature<C, StructureGenerator<C>>> c() {
        return this.v;
    }

    public StructureFeature<C, ? extends StructureGenerator<C>> a(C config, TagKey<BiomeBase> biomeTag) {
        return this.a(config, biomeTag, false);
    }

    public StructureFeature<C, ? extends StructureGenerator<C>> a(C config, TagKey<BiomeBase> biomeTag, boolean bl) {
        return new StructureFeature<C, StructureGenerator>(this, config, RegistryGeneration.i.b(biomeTag), bl, Map.of());
    }

    public StructureFeature<C, ? extends StructureGenerator<C>> a(C config, TagKey<BiomeBase> biomeTag, Map<EnumCreatureType, StructureSpawnOverride> map) {
        return new StructureFeature<C, StructureGenerator>(this, config, RegistryGeneration.i.b(biomeTag), false, map);
    }

    public StructureFeature<C, ? extends StructureGenerator<C>> a(C config, TagKey<BiomeBase> biomeTag, boolean bl, Map<EnumCreatureType, StructureSpawnOverride> map) {
        return new StructureFeature<C, StructureGenerator>(this, config, RegistryGeneration.i.b(biomeTag), bl, map);
    }

    public static BlockPosition a(RandomSpreadStructurePlacement placement, ChunkCoordIntPair chunkPos) {
        return new BlockPosition(chunkPos.d(), 0, chunkPos.e()).a(placement.f());
    }

    public boolean a(IRegistryCustom registryManager, ChunkGenerator chunkGenerator, WorldChunkManager biomeSource, DefinedStructureManager structureManager, long worldSeed, ChunkCoordIntPair pos, C config, LevelHeightAccessor world, Predicate<Holder<BiomeBase>> biomePredicate) {
        return this.w.createGenerator(new PieceGeneratorSupplier.a<C>(chunkGenerator, biomeSource, worldSeed, pos, config, world, biomePredicate, structureManager, registryManager)).isPresent();
    }

    public PieceGeneratorSupplier<C> d() {
        return this.w;
    }

    public PostPlacementProcessor e() {
        return this.x;
    }
}

