/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import io.papermc.paper.world.structure.PaperConfiguredStructure;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;

public class StructureFeature<FC extends WorldGenFeatureConfiguration, F extends StructureGenerator<FC>> {
    public static final Codec<StructureFeature<?, ?>> a = IRegistry.aX.o().dispatch(configuredStructureFeature -> configuredStructureFeature.d, StructureGenerator::c);
    public static final Codec<Holder<StructureFeature<?, ?>>> b = RegistryFileCodec.a(IRegistry.aL, a);
    public static final Codec<HolderSet<StructureFeature<?, ?>>> c = RegistryCodecs.a(IRegistry.aL, a);
    public final F d;
    public final FC e;
    public final HolderSet<BiomeBase> f;
    public final Map<EnumCreatureType, StructureSpawnOverride> g;
    public final boolean h;

    public StructureFeature(F feature, FC config, HolderSet<BiomeBase> biomes, boolean bl, Map<EnumCreatureType, StructureSpawnOverride> map) {
        this.d = feature;
        this.e = config;
        this.f = biomes;
        this.h = bl;
        this.g = map;
    }

    public StructureStart a(IRegistryCustom registryManager, ChunkGenerator chunkGenerator, WorldChunkManager biomeSource, DefinedStructureManager structureManager, long worldSeed, ChunkCoordIntPair chunkPos, int structureReferences, LevelHeightAccessor world, Predicate<Holder<BiomeBase>> biomePredicate) {
        Optional optional = ((StructureGenerator)this.d).d().createGenerator(new PieceGeneratorSupplier.a<FC>(chunkGenerator, biomeSource, worldSeed, chunkPos, this.e, world, biomePredicate, structureManager, registryManager));
        if (optional.isPresent()) {
            StructurePiecesBuilder structurePiecesBuilder = new StructurePiecesBuilder();
            SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
            worldgenRandom.c(worldSeed, chunkPos.c, chunkPos.d);
            optional.get().generatePieces(structurePiecesBuilder, new PieceGenerator.a<FC>(this.e, chunkGenerator, structureManager, chunkPos, world, worldgenRandom, worldSeed));
            StructureStart structureStart = new StructureStart(this, chunkPos, structureReferences, structurePiecesBuilder.a());
            if (structureStart.b()) {
                return structureStart;
            }
        }
        return StructureStart.b;
    }

    public HolderSet<BiomeBase> a() {
        return this.f;
    }

    public StructureBoundingBox a(StructureBoundingBox boundingBox) {
        return this.h ? boundingBox.a(12) : boundingBox;
    }

    static {
        PaperConfiguredStructure.init();
    }
}

