/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverAbstract;

public class WorldGenCaves
extends WorldGenCarverAbstract<CaveCarverConfiguration> {
    public WorldGenCaves(Codec<CaveCarverConfiguration> configCodec) {
        super(configCodec);
    }

    @Override
    @Override
    public boolean a(CaveCarverConfiguration config, Random random) {
        return random.nextFloat() <= config.k;
    }

    @Override
    @Override
    public boolean a(CarvingContext context2, CaveCarverConfiguration config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> posToBiome, Random random, Aquifer aquiferSampler, ChunkCoordIntPair pos, CarvingMask mask) {
        int i2 = SectionPosition.c(this.d() * 2 - 1);
        int j2 = random.nextInt(random.nextInt(random.nextInt(this.a()) + 1) + 1);
        for (int k2 = 0; k2 < j2; ++k2) {
            double d2 = pos.a(random.nextInt(16));
            double e2 = config.e.a(random, context2);
            double f2 = pos.b(random.nextInt(16));
            double g2 = config.b.a(random);
            double h2 = config.c.a(random);
            double l2 = config.i.a(random);
            WorldGenCarverAbstract.a carveSkipChecker = (context, scaledRelativeX, scaledRelativeY, scaledRelativeZ, y2) -> WorldGenCaves.a(scaledRelativeX, scaledRelativeY, scaledRelativeZ, l2);
            int m2 = 1;
            if (random.nextInt(4) == 0) {
                double n2 = config.f.a(random);
                float o2 = 1.0f + random.nextFloat() * 6.0f;
                this.a(context2, config, chunk, posToBiome, aquiferSampler, d2, e2, f2, o2, n2, mask, carveSkipChecker);
                m2 += random.nextInt(4);
            }
            for (int p2 = 0; p2 < m2; ++p2) {
                float q2 = random.nextFloat() * ((float)Math.PI * 2);
                float r2 = (random.nextFloat() - 0.5f) / 4.0f;
                float s2 = this.a(random);
                int t2 = i2 - random.nextInt(i2 / 4);
                boolean u2 = false;
                this.a(context2, config, chunk, posToBiome, random.nextLong(), aquiferSampler, d2, e2, f2, g2, h2, s2, q2, r2, 0, t2, this.b(), mask, carveSkipChecker);
            }
        }
        return true;
    }

    protected int a() {
        return 15;
    }

    protected float a(Random random) {
        float f2 = random.nextFloat() * 2.0f + random.nextFloat();
        if (random.nextInt(10) == 0) {
            f2 *= random.nextFloat() * random.nextFloat() * 3.0f + 1.0f;
        }
        return f2;
    }

    protected double b() {
        return 1.0;
    }

    protected void a(CarvingContext context, CaveCarverConfiguration config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> posToBiome, Aquifer aquiferSampler, double d2, double e2, double f2, float g2, double h2, CarvingMask mask, WorldGenCarverAbstract.a skipPredicate) {
        double i2 = 1.5 + (double)(MathHelper.a(1.5707964f) * g2);
        double j2 = i2 * h2;
        this.a(context, config, chunk, posToBiome, aquiferSampler, d2 + 1.0, e2, f2, i2, j2, mask, skipPredicate);
    }

    protected void a(CarvingContext context, CaveCarverConfiguration config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> posToBiome, long seed, Aquifer aquiferSampler, double x2, double y2, double z2, double horizontalScale, double verticalScale, float width, float yaw, float pitch, int branchStartIndex, int branchCount, double yawPitchRatio, CarvingMask mask, WorldGenCarverAbstract.a skipPredicate) {
        Random random = new Random(seed);
        int i2 = random.nextInt(branchCount / 2) + branchCount / 4;
        boolean bl = random.nextInt(6) == 0;
        float f2 = 0.0f;
        float g2 = 0.0f;
        for (int j2 = branchStartIndex; j2 < branchCount; ++j2) {
            double d2 = 1.5 + (double)(MathHelper.a((float)Math.PI * (float)j2 / (float)branchCount) * width);
            double e2 = d2 * yawPitchRatio;
            float h2 = MathHelper.b(pitch);
            x2 += (double)(MathHelper.b(yaw) * h2);
            y2 += (double)MathHelper.a(pitch);
            z2 += (double)(MathHelper.a(yaw) * h2);
            pitch *= bl ? 0.92f : 0.7f;
            pitch += g2 * 0.1f;
            yaw += f2 * 0.1f;
            g2 *= 0.9f;
            f2 *= 0.75f;
            g2 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f2 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (j2 == i2 && width > 1.0f) {
                this.a(context, config, chunk, posToBiome, random.nextLong(), aquiferSampler, x2, y2, z2, horizontalScale, verticalScale, random.nextFloat() * 0.5f + 0.5f, yaw - 1.5707964f, pitch / 3.0f, j2, branchCount, 1.0, mask, skipPredicate);
                this.a(context, config, chunk, posToBiome, random.nextLong(), aquiferSampler, x2, y2, z2, horizontalScale, verticalScale, random.nextFloat() * 0.5f + 0.5f, yaw + 1.5707964f, pitch / 3.0f, j2, branchCount, 1.0, mask, skipPredicate);
                return;
            }
            if (random.nextInt(4) == 0) continue;
            if (!WorldGenCaves.a(chunk.f(), x2, z2, j2, branchCount, width)) {
                return;
            }
            this.a(context, config, chunk, posToBiome, aquiferSampler, x2, y2, z2, d2 * horizontalScale, e2 * verticalScale, mask, skipPredicate);
        }
    }

    private static boolean a(double scaledRelativeX, double scaledRelativeY, double scaledRelativeZ, double floorY) {
        if (scaledRelativeY <= floorY) {
            return true;
        }
        return scaledRelativeX * scaledRelativeX + scaledRelativeY * scaledRelativeY + scaledRelativeZ * scaledRelativeZ >= 1.0;
    }
}

