/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.primitives.Doubles;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;

public class BlendingData {
    private static final double g = 0.1;
    protected static final LevelHeightAccessor a = new LevelHeightAccessor(){

        @Override
        @Override
        public int v_() {
            return 256;
        }

        @Override
        @Override
        public int u_() {
            return 0;
        }
    };
    protected static final int b = 4;
    protected static final int c = 8;
    protected static final int d = 2;
    private static final int h = 2;
    private static final int i = QuartPos.a(16);
    private static final int j = i - 1;
    private static final int k = i;
    private static final int l = 2 * j + 1;
    private static final int m = 2 * k + 1;
    private static final int n = l + m;
    private static final int o = i + 1;
    private static final List<Block> p = List.of(Blocks.l, Blocks.E, Blocks.i, Blocks.b, Blocks.k, Blocks.C, Blocks.D, Blocks.ec, Blocks.cM, Blocks.hf, Blocks.j);
    protected static final double e = Double.MAX_VALUE;
    private final boolean q;
    private boolean r;
    private final double[] s;
    private final List<Holder<BiomeBase>> t;
    private final transient double[][] u;
    private final transient double[] v;
    private static final Codec<double[]> w = Codec.DOUBLE.listOf().xmap(Doubles::toArray, Doubles::asList);
    public static final Codec<BlendingData> f = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("old_noise").forGetter(BlendingData::a), (App)w.optionalFieldOf("heights").forGetter(blendingData -> DoubleStream.of(blendingData.s).anyMatch(d2 -> d2 != Double.MAX_VALUE) ? Optional.of(blendingData.s) : Optional.empty())).apply((Applicative)instance, BlendingData::new)).comapFlatMap(BlendingData::a, Function.identity());

    private static DataResult<BlendingData> a(BlendingData blendingData) {
        if (blendingData.s.length != n) {
            return DataResult.error((String)("heights has to be of length " + n));
        }
        return DataResult.success((Object)blendingData);
    }

    private BlendingData(boolean oldNoise, Optional<double[]> optional) {
        this.q = oldNoise;
        this.s = optional.orElse(SystemUtils.a(new double[n], (T ds) -> Arrays.fill(ds, Double.MAX_VALUE)));
        this.u = new double[n][];
        this.v = new double[o * o];
        ObjectArrayList objectArrayList = new ObjectArrayList(n);
        objectArrayList.size(n);
        this.t = objectArrayList;
    }

    public boolean a() {
        return this.q;
    }

    @Nullable
    public static BlendingData a(RegionLimitedWorldAccess chunkRegion, int chunkX, int chunkZ) {
        IChunkAccess chunkAccess = chunkRegion.a(chunkX, chunkZ);
        BlendingData blendingData = chunkAccess.t();
        if (blendingData == null || !blendingData.a()) {
            return null;
        }
        blendingData.a(chunkAccess, BlendingData.a(chunkRegion, chunkX, chunkZ, false));
        return blendingData;
    }

    public static Set<EnumDirection8> a(GeneratorAccessSeed access, int chunkX, int chunkZ, boolean newNoise) {
        EnumSet<EnumDirection8> set = EnumSet.noneOf(EnumDirection8.class);
        for (EnumDirection8 direction8 : EnumDirection8.values()) {
            int i2 = chunkX;
            int j2 = chunkZ;
            for (EnumDirection direction : direction8.a()) {
                i2 += direction.i();
                j2 += direction.k();
            }
            if (access.a(i2, j2).s() != newNoise) continue;
            set.add(direction8);
        }
        return set;
    }

    private void a(IChunkAccess chunkAccess, Set<EnumDirection8> set) {
        if (this.r) {
            return;
        }
        Arrays.fill(this.v, 1.0);
        if (set.contains((Object)EnumDirection8.a) || set.contains((Object)EnumDirection8.g) || set.contains((Object)EnumDirection8.h)) {
            this.a(BlendingData.b(0, 0), chunkAccess, 0, 0);
        }
        if (set.contains((Object)EnumDirection8.a)) {
            for (int i2 = 1; i2 < i; ++i2) {
                this.a(BlendingData.b(i2, 0), chunkAccess, 4 * i2, 0);
            }
        }
        if (set.contains((Object)EnumDirection8.g)) {
            for (int j2 = 1; j2 < i; ++j2) {
                this.a(BlendingData.b(0, j2), chunkAccess, 0, 4 * j2);
            }
        }
        if (set.contains((Object)EnumDirection8.c)) {
            for (int k2 = 1; k2 < i; ++k2) {
                this.a(BlendingData.c(k, k2), chunkAccess, 15, 4 * k2);
            }
        }
        if (set.contains((Object)EnumDirection8.e)) {
            for (int l2 = 0; l2 < i; ++l2) {
                this.a(BlendingData.c(l2, k), chunkAccess, 4 * l2, 15);
            }
        }
        if (set.contains((Object)EnumDirection8.c) && set.contains((Object)EnumDirection8.b)) {
            this.a(BlendingData.c(k, 0), chunkAccess, 15, 0);
        }
        if (set.contains((Object)EnumDirection8.c) && set.contains((Object)EnumDirection8.e) && set.contains((Object)EnumDirection8.d)) {
            this.a(BlendingData.c(k, k), chunkAccess, 15, 15);
        }
        this.r = true;
    }

    private void a(int index, IChunkAccess chunk, int x2, int z2) {
        if (this.s[index] == Double.MAX_VALUE) {
            this.s[index] = BlendingData.a(chunk, x2, z2);
        }
        this.u[index] = BlendingData.a(chunk, x2, z2, MathHelper.b(this.s[index]));
        this.t.set(index, chunk.getNoiseBiome(QuartPos.a(x2), QuartPos.a(MathHelper.b(this.s[index])), QuartPos.a(z2)));
    }

    private static int a(IChunkAccess chunk, int x2, int z2) {
        int j2;
        if (chunk.b(HeightMap.Type.a)) {
            int i2 = Math.min(chunk.a(HeightMap.Type.a, x2, z2) + 1, a.ag());
        } else {
            j2 = a.ag();
        }
        int k2 = a.u_();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(x2, j2, z2);
        while (mutableBlockPos.v() > k2) {
            mutableBlockPos.c(EnumDirection.a);
            if (!p.contains(chunk.a_(mutableBlockPos).b())) continue;
            return mutableBlockPos.v();
        }
        return k2;
    }

    private static double a(IChunkAccess chunkAccess, BlockPosition.MutableBlockPosition mutableBlockPos) {
        return BlendingData.a(chunkAccess, (BlockPosition)mutableBlockPos.c(EnumDirection.a)) ? 1.0 : -1.0;
    }

    private static double b(IChunkAccess chunkAccess, BlockPosition.MutableBlockPosition mutableBlockPos) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < 7; ++i2) {
            d2 += BlendingData.a(chunkAccess, mutableBlockPos);
        }
        return d2;
    }

    private static double[] a(IChunkAccess chunk, int x2, int z2, int i2) {
        double[] ds = new double[BlendingData.b()];
        Arrays.fill(ds, -1.0);
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition(x2, a.ag(), z2);
        double d2 = BlendingData.b(chunk, mutableBlockPos);
        for (int j2 = ds.length - 2; j2 >= 0; --j2) {
            double e2 = BlendingData.a(chunk, mutableBlockPos);
            double f2 = BlendingData.b(chunk, mutableBlockPos);
            ds[j2] = (d2 + e2 + f2) / 15.0;
            d2 = f2;
        }
        int k2 = MathHelper.a(i2, 8);
        if (k2 >= 1 && k2 < ds.length) {
            double g2 = ((double)i2 + 0.5) % 8.0 / 8.0;
            double h2 = (1.0 - g2) / g2;
            double l2 = Math.max(h2, 1.0) * 0.25;
            ds[k2] = -h2 / l2;
            ds[k2 - 1] = 1.0 / l2;
        }
        return ds;
    }

    private static boolean a(IChunkAccess chunk, BlockPosition pos) {
        IBlockData blockState = chunk.a_(pos);
        if (blockState.g()) {
            return false;
        }
        if (blockState.a(TagsBlock.H)) {
            return false;
        }
        if (blockState.a(TagsBlock.r)) {
            return false;
        }
        if (blockState.a(Blocks.dM) || blockState.a(Blocks.dN)) {
            return false;
        }
        return !blockState.k(chunk, pos).b();
    }

    protected double a(int i2, int j2, int k2) {
        if (i2 == k || k2 == k) {
            return this.s[BlendingData.c(i2, k2)];
        }
        if (i2 == 0 || k2 == 0) {
            return this.s[BlendingData.b(i2, k2)];
        }
        return Double.MAX_VALUE;
    }

    private static double a(@Nullable double[] ds, int i2) {
        if (ds == null) {
            return Double.MAX_VALUE;
        }
        int j2 = i2 - BlendingData.c();
        if (j2 < 0 || j2 >= ds.length) {
            return Double.MAX_VALUE;
        }
        return ds[j2] * 0.1;
    }

    protected double b(int i2, int j2, int k2) {
        if (j2 == BlendingData.d()) {
            return this.v[this.a(i2, k2)] * 0.1;
        }
        if (i2 == k || k2 == k) {
            return BlendingData.a(this.u[BlendingData.c(i2, k2)], j2);
        }
        if (i2 == 0 || k2 == 0) {
            return BlendingData.a(this.u[BlendingData.b(i2, k2)], j2);
        }
        return Double.MAX_VALUE;
    }

    protected void a(int i2, int j2, a biomeConsumer) {
        for (int k2 = 0; k2 < this.t.size(); ++k2) {
            Holder<BiomeBase> holder = this.t.get(k2);
            if (holder == null) continue;
            biomeConsumer.consume(i2 + BlendingData.a(k2), j2 + BlendingData.b(k2), holder);
        }
    }

    protected void a(int i2, int j2, c heightConsumer) {
        for (int k2 = 0; k2 < this.s.length; ++k2) {
            double d2 = this.s[k2];
            if (d2 == Double.MAX_VALUE) continue;
            heightConsumer.consume(i2 + BlendingData.a(k2), j2 + BlendingData.b(k2), d2);
        }
    }

    protected void a(int i2, int j2, int k2, int l2, b densityConsumer) {
        int m2 = BlendingData.c();
        int n2 = Math.max(0, k2 - m2);
        int o2 = Math.min(BlendingData.b(), l2 - m2);
        for (int p2 = 0; p2 < this.u.length; ++p2) {
            double[] ds = this.u[p2];
            if (ds == null) continue;
            int q2 = i2 + BlendingData.a(p2);
            int r2 = j2 + BlendingData.b(p2);
            for (int s2 = n2; s2 < o2; ++s2) {
                densityConsumer.consume(q2, s2 + m2, r2, ds[s2] * 0.1);
            }
        }
    }

    private int a(int i2, int j2) {
        return i2 * o + j2;
    }

    private static int b() {
        return a.ah() * 2;
    }

    private static int c() {
        return BlendingData.d() + 1;
    }

    private static int d() {
        return a.ai() * 2;
    }

    private static int b(int i2, int j2) {
        return j - i2 + j2;
    }

    private static int c(int i2, int j2) {
        return l + i2 + k - j2;
    }

    private static int a(int i2) {
        if (i2 < l) {
            return BlendingData.c(j - i2);
        }
        int j2 = i2 - l;
        return k - BlendingData.c(k - j2);
    }

    private static int b(int i2) {
        if (i2 < l) {
            return BlendingData.c(i2 - j);
        }
        int j2 = i2 - l;
        return k - BlendingData.c(j2 - k);
    }

    private static int c(int i2) {
        return i2 & ~(i2 >> 31);
    }

    protected static interface a {
        public void consume(int var1, int var2, Holder<BiomeBase> var3);
    }

    protected static interface c {
        public void consume(int var1, int var2, double var3);
    }

    protected static interface b {
        public void consume(int var1, int var2, int var3, double var4);
    }
}

