/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class Blender {
    private static final Blender a = new Blender(new Long2ObjectOpenHashMap(), new Long2ObjectOpenHashMap()){

        @Override
        @Override
        public a a(int i2, int j2) {
            return new a(1.0, 0.0);
        }

        @Override
        @Override
        public double a(DensityFunction.b functionContext, double d2) {
            return d2;
        }

        @Override
        @Override
        public BiomeResolver a(BiomeResolver biomeSupplier) {
            return biomeSupplier;
        }
    };
    private static final NoiseGeneratorNormal b = NoiseGeneratorNormal.b(new XoroshiroRandomSource(42L), RegistryGeneration.j.f(Noises.j));
    private static final int c = QuartPos.d(7) - 1;
    private static final int d = QuartPos.e(c + 3);
    private static final int e = 2;
    private static final int f = QuartPos.e(5);
    private static final double g = (double)BlendingData.a.v_() / 2.0;
    private static final double h = (double)BlendingData.a.u_() + g;
    private static final double i = 8.0;
    private final Long2ObjectOpenHashMap<BlendingData> j;
    private final Long2ObjectOpenHashMap<BlendingData> k;

    public static Blender a() {
        return a;
    }

    public static Blender a(@Nullable RegionLimitedWorldAccess chunkRegion) {
        if (chunkRegion == null) {
            return a;
        }
        Long2ObjectOpenHashMap long2ObjectOpenHashMap = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap long2ObjectOpenHashMap2 = new Long2ObjectOpenHashMap();
        ChunkCoordIntPair chunkPos = chunkRegion.a();
        for (int i2 = -d; i2 <= d; ++i2) {
            for (int j2 = -d; j2 <= d; ++j2) {
                int k2 = chunkPos.c + i2;
                int l2 = chunkPos.d + j2;
                BlendingData blendingData = BlendingData.a(chunkRegion, k2, l2);
                if (blendingData == null) continue;
                long2ObjectOpenHashMap.put(ChunkCoordIntPair.a(k2, l2), (Object)blendingData);
                if (i2 < -f || i2 > f || j2 < -f || j2 > f) continue;
                long2ObjectOpenHashMap2.put(ChunkCoordIntPair.a(k2, l2), (Object)blendingData);
            }
        }
        if (long2ObjectOpenHashMap.isEmpty() && long2ObjectOpenHashMap2.isEmpty()) {
            return a;
        }
        return new Blender((Long2ObjectOpenHashMap<BlendingData>)long2ObjectOpenHashMap, (Long2ObjectOpenHashMap<BlendingData>)long2ObjectOpenHashMap2);
    }

    Blender(Long2ObjectOpenHashMap<BlendingData> long2ObjectOpenHashMap, Long2ObjectOpenHashMap<BlendingData> long2ObjectOpenHashMap2) {
        this.j = long2ObjectOpenHashMap;
        this.k = long2ObjectOpenHashMap2;
    }

    public a a(int i2, int j2) {
        int l2;
        int k2 = QuartPos.a(i2);
        double d2 = this.a(k2, 0, l2 = QuartPos.a(j2), BlendingData::a);
        if (d2 != Double.MAX_VALUE) {
            return new a(0.0, Blender.a(d2));
        }
        MutableDouble mutableDouble = new MutableDouble(0.0);
        MutableDouble mutableDouble2 = new MutableDouble(0.0);
        MutableDouble mutableDouble3 = new MutableDouble(Double.POSITIVE_INFINITY);
        this.j.forEach((long_, blendingData) -> blendingData.a(QuartPos.d(ChunkCoordIntPair.a(long_)), QuartPos.d(ChunkCoordIntPair.b(long_)), (k2, l2, d2) -> {
            double e2 = MathHelper.f(k2 - k2, l2 - l2);
            if (e2 > (double)c) {
                return;
            }
            if (e2 < mutableDouble3.doubleValue()) {
                mutableDouble3.setValue(e2);
            }
            double f2 = 1.0 / (e2 * e2 * e2 * e2);
            mutableDouble2.add(d2 * f2);
            mutableDouble.add(f2);
        }));
        if (mutableDouble3.doubleValue() == Double.POSITIVE_INFINITY) {
            return new a(1.0, 0.0);
        }
        double e2 = mutableDouble2.doubleValue() / mutableDouble.doubleValue();
        double f2 = MathHelper.a(mutableDouble3.doubleValue() / (double)(c + 1), 0.0, 1.0);
        f2 = 3.0 * f2 * f2 - 2.0 * f2 * f2 * f2;
        return new a(f2, Blender.a(e2));
    }

    private static double a(double d2) {
        double e2 = 1.0;
        double f2 = d2 + 0.5;
        double g2 = MathHelper.c(f2, 8.0);
        return 1.0 * (32.0 * (f2 - 128.0) - 3.0 * (f2 - 120.0) * g2 + 3.0 * g2 * g2) / (128.0 * (32.0 - 3.0 * g2));
    }

    public double a(DensityFunction.b functionContext, double d2) {
        int k2;
        int j2;
        int i2 = QuartPos.a(functionContext.a());
        double e2 = this.a(i2, j2 = functionContext.b() / 8, k2 = QuartPos.a(functionContext.c()), BlendingData::b);
        if (e2 != Double.MAX_VALUE) {
            return e2;
        }
        MutableDouble mutableDouble = new MutableDouble(0.0);
        MutableDouble mutableDouble2 = new MutableDouble(0.0);
        MutableDouble mutableDouble3 = new MutableDouble(Double.POSITIVE_INFINITY);
        this.k.forEach((long_, blendingData) -> blendingData.a(QuartPos.d(ChunkCoordIntPair.a(long_)), QuartPos.d(ChunkCoordIntPair.b(long_)), j2 - 1, j2 + 1, (int l2, int m2, int n2, double d2) -> {
            double e2 = MathHelper.f((double)(i2 - l2), (double)((j2 - m2) * 2), (double)(k2 - n2));
            if (e2 > 2.0) {
                return;
            }
            if (e2 < mutableDouble3.doubleValue()) {
                mutableDouble3.setValue(e2);
            }
            double f2 = 1.0 / (e2 * e2 * e2 * e2);
            mutableDouble2.add(d2 * f2);
            mutableDouble.add(f2);
        }));
        if (mutableDouble3.doubleValue() == Double.POSITIVE_INFINITY) {
            return d2;
        }
        double f2 = mutableDouble2.doubleValue() / mutableDouble.doubleValue();
        double g2 = MathHelper.a(mutableDouble3.doubleValue() / 3.0, 0.0, 1.0);
        return MathHelper.d(g2, f2, d2);
    }

    private double a(int i2, int j2, int k2, b cellValueGetter) {
        int l2 = QuartPos.e(i2);
        int m2 = QuartPos.e(k2);
        boolean bl = (i2 & 3) == 0;
        boolean bl2 = (k2 & 3) == 0;
        double d2 = this.a(cellValueGetter, l2, m2, i2, j2, k2);
        if (d2 == Double.MAX_VALUE) {
            if (bl && bl2) {
                d2 = this.a(cellValueGetter, l2 - 1, m2 - 1, i2, j2, k2);
            }
            if (d2 == Double.MAX_VALUE) {
                if (bl) {
                    d2 = this.a(cellValueGetter, l2 - 1, m2, i2, j2, k2);
                }
                if (d2 == Double.MAX_VALUE && bl2) {
                    d2 = this.a(cellValueGetter, l2, m2 - 1, i2, j2, k2);
                }
            }
        }
        return d2;
    }

    private double a(b cellValueGetter, int i2, int j2, int k2, int l2, int m2) {
        BlendingData blendingData = (BlendingData)this.j.get(ChunkCoordIntPair.a(i2, j2));
        if (blendingData != null) {
            return cellValueGetter.get(blendingData, k2 - QuartPos.d(i2), l2, m2 - QuartPos.d(j2));
        }
        return Double.MAX_VALUE;
    }

    public BiomeResolver a(BiomeResolver biomeSupplier) {
        return (x2, y2, z2, noise) -> {
            Holder<BiomeBase> holder = this.b(x2, z2);
            if (holder == null) {
                return biomeSupplier.getNoiseBiome(x2, y2, z2, noise);
            }
            return holder;
        };
    }

    @Nullable
    private Holder<BiomeBase> b(int x2, int y2) {
        double d2 = (double)x2 + b.a(x2, 0.0, y2) * 12.0;
        double e2 = (double)y2 + b.a(y2, x2, 0.0) * 12.0;
        MutableDouble mutableDouble = new MutableDouble(Double.POSITIVE_INFINITY);
        MutableObject mutableObject = new MutableObject();
        this.j.forEach((long_, blendingData) -> blendingData.a(QuartPos.d(ChunkCoordIntPair.a(long_)), QuartPos.d(ChunkCoordIntPair.b(long_)), (i2, j2, holder) -> {
            double f2 = MathHelper.f(d2 - (double)i2, e2 - (double)j2);
            if (f2 > (double)c) {
                return;
            }
            if (f2 < mutableDouble.doubleValue()) {
                mutableObject.setValue((Object)holder);
                mutableDouble.setValue(f2);
            }
        }));
        if (mutableDouble.doubleValue() == Double.POSITIVE_INFINITY) {
            return null;
        }
        double f2 = MathHelper.a(mutableDouble.doubleValue() / (double)(c + 1), 0.0, 1.0);
        if (f2 > 0.5) {
            return null;
        }
        return (Holder)mutableObject.getValue();
    }

    public static void a(RegionLimitedWorldAccess chunkRegion, IChunkAccess chunk) {
        ChunkCoordIntPair chunkPos = chunk.f();
        boolean bl = chunk.s();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        BlockPosition blockPos = new BlockPosition(chunkPos.d(), 0, chunkPos.e());
        int i2 = BlendingData.a.u_();
        int j2 = BlendingData.a.ag() - 1;
        if (bl) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int l2 = 0; l2 < 16; ++l2) {
                    Blender.a(chunk, mutableBlockPos.a(blockPos, k2, i2 - 1, l2));
                    Blender.a(chunk, mutableBlockPos.a(blockPos, k2, i2, l2));
                    Blender.a(chunk, mutableBlockPos.a(blockPos, k2, j2, l2));
                    Blender.a(chunk, mutableBlockPos.a(blockPos, k2, j2 + 1, l2));
                }
            }
        }
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            if (chunkRegion.a(chunkPos.c + direction.i(), chunkPos.d + direction.k()).s() == bl) continue;
            int m2 = direction == EnumDirection.f ? 15 : 0;
            int n2 = direction == EnumDirection.e ? 0 : 15;
            int o2 = direction == EnumDirection.d ? 15 : 0;
            int p2 = direction == EnumDirection.c ? 0 : 15;
            for (int q2 = m2; q2 <= n2; ++q2) {
                for (int r2 = o2; r2 <= p2; ++r2) {
                    int s2 = Math.min(j2, chunk.a(HeightMap.Type.e, q2, r2)) + 1;
                    for (int t2 = i2; t2 < s2; ++t2) {
                        Blender.a(chunk, mutableBlockPos.a(blockPos, q2, t2, r2));
                    }
                }
            }
        }
    }

    private static void a(IChunkAccess chunk, BlockPosition pos) {
        Fluid fluidState;
        IBlockData blockState = chunk.a_(pos);
        if (blockState.a(TagsBlock.H)) {
            chunk.e(pos);
        }
        if (!(fluidState = chunk.b_(pos)).c()) {
            chunk.e(pos);
        }
    }

    public static void a(GeneratorAccessSeed worldGenLevel, ProtoChunk protoChunk) {
        ChunkCoordIntPair chunkPos = protoChunk.f();
        c distanceGetter = Blender.a(protoChunk.s(), BlendingData.a(worldGenLevel, chunkPos.c, chunkPos.d, true));
        if (distanceGetter == null) {
            return;
        }
        CarvingMask.a mask = (i2, j2, k2) -> {
            double f2;
            double e2;
            double d2 = (double)i2 + 0.5 + b.a(i2, j2, k2) * 4.0;
            return distanceGetter.getDistance(d2, e2 = (double)j2 + 0.5 + b.a(j2, k2, i2) * 4.0, f2 = (double)k2 + 0.5 + b.a(k2, i2, j2) * 4.0) < 4.0;
        };
        Stream.of(WorldGenStage.Features.values()).map(protoChunk::b).forEach(carvingMask -> carvingMask.a(mask));
    }

    @Nullable
    public static c a(boolean bl, Set<EnumDirection8> set) {
        if (!bl && set.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        if (bl) {
            list.add(Blender.a(null));
        }
        set.forEach(direction8 -> list.add(Blender.a(direction8)));
        return (d2, e2, f2) -> {
            double g2 = Double.POSITIVE_INFINITY;
            for (c distanceGetter : list) {
                double h2 = distanceGetter.getDistance(d2, e2, f2);
                if (!(h2 < g2)) continue;
                g2 = h2;
            }
            return g2;
        };
    }

    private static c a(@Nullable EnumDirection8 direction8) {
        double d2 = 0.0;
        double e2 = 0.0;
        if (direction8 != null) {
            for (EnumDirection direction : direction8.a()) {
                d2 += (double)(direction.i() * 16);
                e2 += (double)(direction.k() * 16);
            }
        }
        double f3 = d2;
        double g3 = e2;
        return (f2, g2, h2) -> Blender.a(f2 - 8.0 - f3, g2 - h, h2 - 8.0 - g3, 8.0, g, 8.0);
    }

    private static double a(double d2, double e2, double f2, double g2, double h2, double i2) {
        double j2 = Math.abs(d2) - g2;
        double k2 = Math.abs(e2) - h2;
        double l2 = Math.abs(f2) - i2;
        return MathHelper.f(Math.max(0.0, j2), Math.max(0.0, k2), Math.max(0.0, l2));
    }

    static interface b {
        public double get(BlendingData var1, int var2, int var3, int var4);
    }

    public record a(double a, double b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "alpha;blendingOffset", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "alpha;blendingOffset", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "alpha;blendingOffset", "a", "b"}, this, object);
        }
    }

    public static interface c {
        public double getDistance(double var1, double var3, double var5);
    }
}

