/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Longs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.Xoroshiro128PlusPlus;

public class XoroshiroRandomSource
implements RandomSource {
    private static final float a = 5.9604645E-8f;
    private static final double b = (double)1.110223E-16f;
    private Xoroshiro128PlusPlus c;
    private final MarsagliaPolarGaussian d = new MarsagliaPolarGaussian(this);

    public XoroshiroRandomSource(long seed) {
        this.c = new Xoroshiro128PlusPlus(RandomSupport.b(seed));
    }

    public XoroshiroRandomSource(long seedLo, long seedHi) {
        this.c = new Xoroshiro128PlusPlus(seedLo, seedHi);
    }

    @Override
    @Override
    public RandomSource a() {
        return new XoroshiroRandomSource(this.c.a(), this.c.a());
    }

    @Override
    @Override
    public PositionalRandomFactory b() {
        return new a(this.c.a(), this.c.a());
    }

    @Override
    @Override
    public void setSeed(long seed) {
        this.c = new Xoroshiro128PlusPlus(RandomSupport.b(seed));
        this.d.a();
    }

    @Override
    @Override
    public int nextInt() {
        return (int)this.c.a();
    }

    @Override
    @Override
    public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("Bound must be positive");
        }
        long l2 = Integer.toUnsignedLong(this.nextInt());
        long m2 = l2 * (long)bound;
        long n2 = m2 & 0xFFFFFFFFL;
        if (n2 < (long)bound) {
            int i2 = Integer.remainderUnsigned(~bound + 1, bound);
            while (n2 < (long)i2) {
                l2 = Integer.toUnsignedLong(this.nextInt());
                m2 = l2 * (long)bound;
                n2 = m2 & 0xFFFFFFFFL;
            }
        }
        long o2 = m2 >> 32;
        return (int)o2;
    }

    @Override
    @Override
    public long nextLong() {
        return this.c.a();
    }

    @Override
    @Override
    public boolean nextBoolean() {
        return (this.c.a() & 1L) != 0L;
    }

    @Override
    @Override
    public float nextFloat() {
        return (float)this.a(24) * 5.9604645E-8f;
    }

    @Override
    @Override
    public double nextDouble() {
        return (double)this.a(53) * (double)1.110223E-16f;
    }

    @Override
    @Override
    public double nextGaussian() {
        return this.d.b();
    }

    @Override
    @Override
    public void b(int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            this.c.a();
        }
    }

    private long a(int bits) {
        return this.c.a() >>> 64 - bits;
    }

    public static class a
    implements PositionalRandomFactory {
        private static final HashFunction a = Hashing.md5();
        private final long b;
        private final long c;

        public a(long seedLo, long seedHi) {
            this.b = seedLo;
            this.c = seedHi;
        }

        @Override
        @Override
        public RandomSource a(int x2, int y2, int z2) {
            long l2 = MathHelper.c(x2, y2, z2);
            long m2 = l2 ^ this.b;
            return new XoroshiroRandomSource(m2, this.c);
        }

        @Override
        @Override
        public RandomSource a(String string) {
            byte[] bs = a.hashString((CharSequence)string, Charsets.UTF_8).asBytes();
            long l2 = Longs.fromBytes((byte)bs[0], (byte)bs[1], (byte)bs[2], (byte)bs[3], (byte)bs[4], (byte)bs[5], (byte)bs[6], (byte)bs[7]);
            long m2 = Longs.fromBytes((byte)bs[8], (byte)bs[9], (byte)bs[10], (byte)bs[11], (byte)bs[12], (byte)bs[13], (byte)bs[14], (byte)bs[15]);
            return new XoroshiroRandomSource(l2 ^ this.b, m2 ^ this.c);
        }

        @Override
        @VisibleForTesting
        @Override
        public void a(StringBuilder info) {
            info.append("seedLo: ").append(this.b).append(", seedHi: ").append(this.c);
        }
    }
}

