/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.core.QuartPos;
import net.minecraft.data.worldgen.TerrainProvider;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;

public final class NoiseSettings
extends Record {
    private final int f;
    private final int g;
    private final NoiseSamplingSettings h;
    private final NoiseSlider i;
    private final NoiseSlider j;
    private final int k;
    private final int l;
    private final TerrainShaper m;
    public static final Codec<NoiseSettings> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)DimensionManager.e, (int)DimensionManager.d).fieldOf("min_y").forGetter(NoiseSettings::e), (App)Codec.intRange((int)0, (int)DimensionManager.c).fieldOf("height").forGetter(NoiseSettings::f), (App)NoiseSamplingSettings.a.fieldOf("sampling").forGetter(NoiseSettings::g), (App)NoiseSlider.a.fieldOf("top_slide").forGetter(NoiseSettings::h), (App)NoiseSlider.a.fieldOf("bottom_slide").forGetter(NoiseSettings::i), (App)Codec.intRange((int)1, (int)4).fieldOf("size_horizontal").forGetter(NoiseSettings::j), (App)Codec.intRange((int)1, (int)4).fieldOf("size_vertical").forGetter(NoiseSettings::k), (App)TerrainShaper.b.fieldOf("terrain_shaper").forGetter(NoiseSettings::l)).apply((Applicative)instance, NoiseSettings::new)).comapFlatMap(NoiseSettings::a, Function.identity());
    static final NoiseSettings b = NoiseSettings.a(0, 128, new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), new NoiseSlider(0.9375, 3, 0), new NoiseSlider(2.5, 4, -1), 1, 2, TerrainProvider.c());
    static final NoiseSettings c = NoiseSettings.a(0, 128, new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), new NoiseSlider(-23.4375, 64, -46), new NoiseSlider(-0.234375, 7, 1), 2, 1, TerrainProvider.d());
    static final NoiseSettings d = NoiseSettings.a(-64, 192, new NoiseSamplingSettings(1.0, 3.0, 80.0, 60.0), new NoiseSlider(0.9375, 3, 0), new NoiseSlider(2.5, 4, -1), 1, 2, TerrainProvider.a());
    static final NoiseSettings e = NoiseSettings.a(0, 256, new NoiseSamplingSettings(2.0, 1.0, 80.0, 160.0), new NoiseSlider(-23.4375, 64, -46), new NoiseSlider(-0.234375, 7, 1), 2, 1, TerrainProvider.b());

    public NoiseSettings(int minimumY, int height, NoiseSamplingSettings sampling, NoiseSlider topSlide, NoiseSlider bottomSlide, int horizontalSize, int verticalSize, TerrainShaper terrainShaper) {
        this.f = minimumY;
        this.g = height;
        this.h = sampling;
        this.i = topSlide;
        this.j = bottomSlide;
        this.k = horizontalSize;
        this.l = verticalSize;
        this.m = terrainShaper;
    }

    private static DataResult<NoiseSettings> a(NoiseSettings config) {
        if (config.e() + config.f() > DimensionManager.d + 1) {
            return DataResult.error((String)("min_y + height cannot be higher than: " + (DimensionManager.d + 1)));
        }
        if (config.f() % 16 != 0) {
            return DataResult.error((String)"height has to be a multiple of 16");
        }
        if (config.e() % 16 != 0) {
            return DataResult.error((String)"min_y has to be a multiple of 16");
        }
        return DataResult.success((Object)config);
    }

    public static NoiseSettings a(int minimumY, int height, NoiseSamplingSettings sampling, NoiseSlider topSlide, NoiseSlider bottomSlide, int horizontalSize, int verticalSize, TerrainShaper terrainShaper) {
        NoiseSettings noiseSettings = new NoiseSettings(minimumY, height, sampling, topSlide, bottomSlide, horizontalSize, verticalSize, terrainShaper);
        NoiseSettings.a(noiseSettings).error().ifPresent(partialResult -> {
            throw new IllegalStateException(partialResult.message());
        });
        return noiseSettings;
    }

    static NoiseSettings a(boolean bl) {
        return NoiseSettings.a(-64, 384, new NoiseSamplingSettings(1.0, 1.0, 80.0, 160.0), new NoiseSlider(-0.078125, 2, bl ? 0 : 8), new NoiseSlider(bl ? 0.4 : 0.1171875, 3, 0), 1, 2, TerrainProvider.a(bl));
    }

    public int a() {
        return QuartPos.c(this.k());
    }

    public int b() {
        return QuartPos.c(this.j());
    }

    public int c() {
        return this.f() / this.a();
    }

    public int d() {
        return MathHelper.a(this.e(), this.a());
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;terrainShaper", "f", "g", "h", "i", "j", "k", "l", "m"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;terrainShaper", "f", "g", "h", "i", "j", "k", "l", "m"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NoiseSettings.class, "minY;height;noiseSamplingSettings;topSlideSettings;bottomSlideSettings;noiseSizeHorizontal;noiseSizeVertical;terrainShaper", "f", "g", "h", "i", "j", "k", "l", "m"}, this, object);
    }

    public int e() {
        return this.f;
    }

    public int f() {
        return this.g;
    }

    public NoiseSamplingSettings g() {
        return this.h;
    }

    public NoiseSlider h() {
        return this.i;
    }

    public NoiseSlider i() {
        return this.j;
    }

    public int j() {
        return this.k;
    }

    public int k() {
        return this.l;
    }

    public TerrainShaper l() {
        return this.m;
    }
}

