/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.OreVeinifier;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.material.MaterialRuleList;

public class NoiseChunk
implements DensityFunction.a,
DensityFunction.b {
    private final NoiseSettings a;
    final int b;
    final int c;
    final int d;
    private final int e;
    private final int f;
    final int g;
    final int h;
    final List<i> i;
    final List<e> j;
    private final Map<DensityFunction, DensityFunction> k = new HashMap<DensityFunction, DensityFunction>();
    private final Long2IntMap l = new Long2IntOpenHashMap();
    private final Aquifer m;
    private final DensityFunction n;
    private final c o;
    private final Blender p;
    private final g q;
    private final g r;
    private final DensityFunctions.c s;
    private long t = ChunkCoordIntPair.a;
    private Blender.a u = new Blender.a(1.0, 0.0);
    final int v;
    final int w;
    final int x;
    boolean y;
    boolean z;
    private int A;
    int B;
    private int C;
    int D;
    int E;
    int F;
    long G;
    long H;
    int I;
    private final DensityFunction.a J = new DensityFunction.a(){

        @Override
        @Override
        public DensityFunction.b a(int i2) {
            NoiseChunk.this.B = (i2 + NoiseChunk.this.d) * NoiseChunk.this.x;
            ++NoiseChunk.this.G;
            NoiseChunk.this.E = 0;
            NoiseChunk.this.I = i2;
            return NoiseChunk.this;
        }

        @Override
        @Override
        public void a(double[] ds, DensityFunction densityFunction) {
            for (int i2 = 0; i2 < NoiseChunk.this.c + 1; ++i2) {
                NoiseChunk.this.B = (i2 + NoiseChunk.this.d) * NoiseChunk.this.x;
                ++NoiseChunk.this.G;
                NoiseChunk.this.E = 0;
                NoiseChunk.this.I = i2;
                ds[i2] = densityFunction.a(NoiseChunk.this);
            }
        }
    };

    public static NoiseChunk a(IChunkAccess chunk, NoiseRouter noiseRouter, Supplier<DensityFunctions.c> noiseTypeSupplier, GeneratorSettingBase chunkGeneratorSettings, Aquifer.a fluidLevelSampler, Blender blender) {
        ChunkCoordIntPair chunkPos = chunk.f();
        NoiseSettings noiseSettings = chunkGeneratorSettings.f();
        int i2 = Math.max(noiseSettings.e(), chunk.u_());
        int j2 = Math.min(noiseSettings.e() + noiseSettings.f(), chunk.ag());
        int k2 = MathHelper.a(i2, noiseSettings.a());
        int l2 = MathHelper.a(j2 - i2, noiseSettings.a());
        return new NoiseChunk(16 / noiseSettings.b(), l2, k2, noiseRouter, chunkPos.d(), chunkPos.e(), noiseTypeSupplier.get(), chunkGeneratorSettings, fluidLevelSampler, blender);
    }

    public static NoiseChunk a(int x2, int z2, int minimumY, int height, NoiseRouter noiseRouter, GeneratorSettingBase chunkGeneratorSettings, Aquifer.a fluidLevelSampler) {
        return new NoiseChunk(1, height, minimumY, noiseRouter, x2, z2, DensityFunctions.b.a, chunkGeneratorSettings, fluidLevelSampler, Blender.a());
    }

    private NoiseChunk(int horizontalSize, int height, int minimumY, NoiseRouter noiseRouter, int x2, int z2, DensityFunctions.c noiseType, GeneratorSettingBase chunkGeneratorSettings, Aquifer.a fluidLevelSampler, Blender blender) {
        this.a = chunkGeneratorSettings.f();
        this.b = horizontalSize;
        this.c = height;
        this.d = minimumY;
        this.w = this.a.b();
        this.x = this.a.a();
        this.e = Math.floorDiv(x2, this.w);
        this.f = Math.floorDiv(z2, this.w);
        this.i = Lists.newArrayList();
        this.j = Lists.newArrayList();
        this.g = QuartPos.a(x2);
        this.h = QuartPos.a(z2);
        this.v = QuartPos.a(horizontalSize * this.w);
        this.p = blender;
        this.s = noiseType;
        this.q = new g(new a(), false);
        this.r = new g(new b(), false);
        for (int i2 = 0; i2 <= this.v; ++i2) {
            int j2 = this.g + i2;
            int k2 = QuartPos.c(j2);
            for (int l2 = 0; l2 <= this.v; ++l2) {
                int m2 = this.h + l2;
                int n2 = QuartPos.c(m2);
                Blender.a blendingOutput = blender.a(k2, n2);
                this.q.f[i2][l2] = blendingOutput.a();
                this.r.f[i2][l2] = blendingOutput.b();
            }
        }
        if (!chunkGeneratorSettings.b()) {
            this.m = Aquifer.a(fluidLevelSampler);
        } else {
            int o2 = SectionPosition.a(x2);
            int p2 = SectionPosition.a(z2);
            this.m = Aquifer.a(this, new ChunkCoordIntPair(o2, p2), noiseRouter.a(), noiseRouter.b(), noiseRouter.c(), noiseRouter.d(), noiseRouter.e(), minimumY * this.x, height * this.x, fluidLevelSampler);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        DensityFunction densityFunction = DensityFunctions.e(DensityFunctions.a(noiseRouter.n(), (DensityFunction)DensityFunctions.b.a)).a(this::a);
        builder.add(functionContext -> this.m.a(functionContext, densityFunction.a(functionContext)));
        if (chunkGeneratorSettings.c()) {
            builder.add((Object)OreVeinifier.a(noiseRouter.o().a(this::a), noiseRouter.p().a(this::a), noiseRouter.q().a(this::a), noiseRouter.f()));
        }
        this.o = new MaterialRuleList((List<c>)builder.build());
        this.n = noiseRouter.m().a(this::a);
    }

    protected Climate.Sampler a(NoiseRouter noiseRouter) {
        return new Climate.Sampler(noiseRouter.g().a(this::a), noiseRouter.h().a(this::a), noiseRouter.i().a(this::a), noiseRouter.j().a(this::a), noiseRouter.k().a(this::a), noiseRouter.l().a(this::a), noiseRouter.r());
    }

    @Nullable
    protected IBlockData e() {
        return this.o.calculate(this);
    }

    @Override
    @Override
    public int a() {
        return this.A + this.D;
    }

    @Override
    @Override
    public int b() {
        return this.B + this.E;
    }

    @Override
    @Override
    public int c() {
        return this.C + this.F;
    }

    public int a(int i2, int j2) {
        return this.l.computeIfAbsent(ChunkCoordIntPair.a(QuartPos.a(i2), QuartPos.a(j2)), this::a);
    }

    private int a(long l2) {
        int i2 = ChunkCoordIntPair.a(l2);
        int j2 = ChunkCoordIntPair.b(l2);
        return (int)NoiseRouterData.a(this.a, this.n, QuartPos.c(i2), QuartPos.c(j2));
    }

    @Override
    @Override
    public Blender d() {
        return this.p;
    }

    private void a(boolean bl, int i2) {
        this.A = i2 * this.w;
        this.D = 0;
        for (int j2 = 0; j2 < this.b + 1; ++j2) {
            int k2 = this.f + j2;
            this.C = k2 * this.w;
            this.F = 0;
            ++this.H;
            for (i noiseInterpolator : this.i) {
                double[] ds = (bl ? noiseInterpolator.e : noiseInterpolator.f)[j2];
                noiseInterpolator.a(ds, this.J);
            }
        }
        ++this.H;
    }

    public void f() {
        if (this.y) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.y = true;
        this.G = 0L;
        this.a(true, this.e);
    }

    public void b(int x2) {
        this.a(false, this.e + x2 + 1);
        this.A = (this.e + x2) * this.w;
    }

    @Override
    public NoiseChunk c(int i2) {
        int j2 = Math.floorMod(i2, this.w);
        int k2 = Math.floorDiv(i2, this.w);
        int l2 = Math.floorMod(k2, this.w);
        int m2 = this.x - 1 - Math.floorDiv(k2, this.w);
        this.D = l2;
        this.E = m2;
        this.F = j2;
        this.I = i2;
        return this;
    }

    @Override
    @Override
    public void a(double[] ds, DensityFunction densityFunction) {
        this.I = 0;
        for (int i2 = this.x - 1; i2 >= 0; --i2) {
            this.E = i2;
            for (int j2 = 0; j2 < this.w; ++j2) {
                this.D = j2;
                int k2 = 0;
                while (k2 < this.w) {
                    this.F = k2++;
                    ds[this.I++] = densityFunction.a(this);
                }
            }
        }
    }

    public void b(int noiseY, int noiseZ) {
        this.i.forEach(interpolator -> interpolator.b(noiseY, noiseZ));
        this.z = true;
        this.B = (noiseY + this.d) * this.x;
        this.C = (this.f + noiseZ) * this.w;
        ++this.H;
        for (e cacheAllInCell : this.j) {
            cacheAllInCell.e.a(cacheAllInCell.f, this);
        }
        ++this.H;
        this.z = false;
    }

    public void a(int i2, double d2) {
        this.E = i2 - this.B;
        this.i.forEach(interpolator -> interpolator.a(d2));
    }

    public void b(int i2, double d2) {
        this.D = i2 - this.A;
        this.i.forEach(interpolator -> interpolator.b(d2));
    }

    public void c(int i2, double d2) {
        this.F = i2 - this.C;
        ++this.G;
        this.i.forEach(interpolator -> interpolator.c(d2));
    }

    public void g() {
        if (!this.y) {
            throw new IllegalStateException("Staring interpolation twice");
        }
        this.y = false;
    }

    public void h() {
        this.i.forEach(i::l);
    }

    public Aquifer i() {
        return this.m;
    }

    Blender.a c(int i2, int j2) {
        Blender.a blendingOutput;
        long l2 = ChunkCoordIntPair.a(i2, j2);
        if (this.t == l2) {
            return this.u;
        }
        this.t = l2;
        this.u = blendingOutput = this.p.a(i2, j2);
        return blendingOutput;
    }

    protected DensityFunction a(DensityFunction densityFunction) {
        return this.k.computeIfAbsent(densityFunction, this::b);
    }

    private DensityFunction b(DensityFunction densityFunction) {
        if (densityFunction instanceof DensityFunctions.l) {
            DensityFunctions.l marker = (DensityFunctions.l)densityFunction;
            return switch (marker.j()) {
                default -> throw new IncompatibleClassChangeError();
                case DensityFunctions.l.a.a -> new i(marker.k());
                case DensityFunctions.l.a.b -> new g(marker.k(), true);
                case DensityFunctions.l.a.c -> new d(marker.k());
                case DensityFunctions.l.a.d -> new f(marker.k());
                case DensityFunctions.l.a.e -> new e(marker.k());
            };
        }
        if (this.p != Blender.a()) {
            if (densityFunction == DensityFunctions.d.a) {
                return this.q;
            }
            if (densityFunction == DensityFunctions.f.a) {
                return this.r;
            }
        }
        if (densityFunction == DensityFunctions.b.a) {
            return this.s;
        }
        if (densityFunction instanceof DensityFunctions.j) {
            DensityFunctions.j holderHolder = (DensityFunctions.j)densityFunction;
            return holderHolder.j().a();
        }
        return densityFunction;
    }

    @Override
    public /* synthetic */ DensityFunction.b a(int i2) {
        return this.c(i2);
    }

    class g
    implements DensityFunctions.m,
    h {
        private final DensityFunction e;
        final double[][] f;

        g(DensityFunction densityFunction, boolean bl) {
            this.e = densityFunction;
            this.f = new double[NoiseChunk.this.v + 1][NoiseChunk.this.v + 1];
            if (bl) {
                for (int i2 = 0; i2 <= NoiseChunk.this.v; ++i2) {
                    int j2 = NoiseChunk.this.g + i2;
                    int k2 = QuartPos.c(j2);
                    for (int l2 = 0; l2 <= NoiseChunk.this.v; ++l2) {
                        int m2 = NoiseChunk.this.h + l2;
                        int n2 = QuartPos.c(m2);
                        this.f[i2][l2] = densityFunction.a(new DensityFunction.d(k2, 0, n2));
                    }
                }
            }
        }

        @Override
        @Override
        public double a(DensityFunction.b pos) {
            int i2 = QuartPos.a(pos.a());
            int j2 = QuartPos.a(pos.c());
            int k2 = i2 - NoiseChunk.this.g;
            int l2 = j2 - NoiseChunk.this.h;
            int m2 = this.f.length;
            if (k2 >= 0 && l2 >= 0 && k2 < m2 && l2 < m2) {
                return this.f[k2][l2];
            }
            return this.e.a(pos);
        }

        @Override
        @Override
        public void a(double[] ds, DensityFunction.a contextProvider) {
            contextProvider.a(ds, this);
        }

        @Override
        @Override
        public DensityFunction k() {
            return this.e;
        }

        @Override
        @Override
        public DensityFunctions.l.a j() {
            return DensityFunctions.l.a.b;
        }
    }

    class a
    implements h {
        a() {
        }

        @Override
        @Override
        public DensityFunction k() {
            return DensityFunctions.d.a;
        }

        @Override
        @Override
        public double a(DensityFunction.b pos) {
            return NoiseChunk.this.c(pos.a(), pos.c()).a();
        }

        @Override
        @Override
        public void a(double[] ds, DensityFunction.a contextProvider) {
            contextProvider.a(ds, this);
        }

        @Override
        @Override
        public double a() {
            return 0.0;
        }

        @Override
        @Override
        public double b() {
            return 1.0;
        }

        @Override
        @Override
        public Codec<? extends DensityFunction> c() {
            return DensityFunctions.d.e;
        }
    }

    class b
    implements h {
        b() {
        }

        @Override
        @Override
        public DensityFunction k() {
            return DensityFunctions.f.a;
        }

        @Override
        @Override
        public double a(DensityFunction.b pos) {
            return NoiseChunk.this.c(pos.a(), pos.c()).b();
        }

        @Override
        @Override
        public void a(double[] ds, DensityFunction.a contextProvider) {
            contextProvider.a(ds, this);
        }

        @Override
        @Override
        public double a() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        @Override
        public double b() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        @Override
        public Codec<? extends DensityFunction> c() {
            return DensityFunctions.f.e;
        }
    }

    @FunctionalInterface
    public static interface c {
        @Nullable
        public IBlockData calculate(DensityFunction.b var1);
    }

    public class i
    implements DensityFunctions.m,
    h {
        double[][] e;
        double[][] f;
        private final DensityFunction g;
        private double h;
        private double i;
        private double j;
        private double k;
        private double l;
        private double m;
        private double n;
        private double o;
        private double p;
        private double q;
        private double r;
        private double s;
        private double t;
        private double u;
        private double v;

        i(DensityFunction columnSampler) {
            this.g = columnSampler;
            this.e = this.a(NoiseChunk.this.c, NoiseChunk.this.b);
            this.f = this.a(NoiseChunk.this.c, NoiseChunk.this.b);
            NoiseChunk.this.i.add(this);
        }

        private double[][] a(int sizeZ, int sizeX) {
            int i2 = sizeX + 1;
            int j2 = sizeZ + 1;
            double[][] ds = new double[i2][j2];
            for (int k2 = 0; k2 < i2; ++k2) {
                ds[k2] = new double[j2];
            }
            return ds;
        }

        void b(int noiseY, int noiseZ) {
            this.h = this.e[noiseZ][noiseY];
            this.i = this.e[noiseZ + 1][noiseY];
            this.j = this.f[noiseZ][noiseY];
            this.k = this.f[noiseZ + 1][noiseY];
            this.l = this.e[noiseZ][noiseY + 1];
            this.m = this.e[noiseZ + 1][noiseY + 1];
            this.n = this.f[noiseZ][noiseY + 1];
            this.o = this.f[noiseZ + 1][noiseY + 1];
        }

        void a(double deltaY) {
            this.p = MathHelper.d(deltaY, this.h, this.l);
            this.q = MathHelper.d(deltaY, this.j, this.n);
            this.r = MathHelper.d(deltaY, this.i, this.m);
            this.s = MathHelper.d(deltaY, this.k, this.o);
        }

        void b(double deltaX) {
            this.t = MathHelper.d(deltaX, this.p, this.q);
            this.u = MathHelper.d(deltaX, this.r, this.s);
        }

        void c(double deltaZ) {
            this.v = MathHelper.d(deltaZ, this.t, this.u);
        }

        @Override
        @Override
        public double a(DensityFunction.b pos) {
            if (pos != NoiseChunk.this) {
                return this.g.a(pos);
            }
            if (!NoiseChunk.this.y) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            if (NoiseChunk.this.z) {
                return MathHelper.a((double)NoiseChunk.this.D / (double)NoiseChunk.this.w, (double)NoiseChunk.this.E / (double)NoiseChunk.this.x, (double)NoiseChunk.this.F / (double)NoiseChunk.this.w, this.h, this.j, this.l, this.n, this.i, this.k, this.m, this.o);
            }
            return this.v;
        }

        @Override
        @Override
        public void a(double[] ds, DensityFunction.a contextProvider) {
            if (NoiseChunk.this.z) {
                contextProvider.a(ds, this);
                return;
            }
            this.k().a(ds, contextProvider);
        }

        @Override
        @Override
        public DensityFunction k() {
            return this.g;
        }

        private void l() {
            double[][] ds = this.e;
            this.e = this.f;
            this.f = ds;
        }

        @Override
        @Override
        public DensityFunctions.l.a j() {
            return DensityFunctions.l.a.a;
        }
    }

    class e
    implements DensityFunctions.m,
    h {
        final DensityFunction e;
        final double[] f;

        e(DensityFunction densityFunction) {
            this.e = densityFunction;
            this.f = new double[NoiseChunk.this.w * NoiseChunk.this.w * NoiseChunk.this.x];
            NoiseChunk.this.j.add(this);
        }

        @Override
        @Override
        public double a(DensityFunction.b pos) {
            if (pos != NoiseChunk.this) {
                return this.e.a(pos);
            }
            if (!NoiseChunk.this.y) {
                throw new IllegalStateException("Trying to sample interpolator outside the interpolation loop");
            }
            int i2 = NoiseChunk.this.D;
            int j2 = NoiseChunk.this.E;
            int k2 = NoiseChunk.this.F;
            if (i2 >= 0 && j2 >= 0 && k2 >= 0 && i2 < NoiseChunk.this.w && j2 < NoiseChunk.this.x && k2 < NoiseChunk.this.w) {
                return this.f[((NoiseChunk.this.x - 1 - j2) * NoiseChunk.this.w + i2) * NoiseChunk.this.w + k2];
            }
            return this.e.a(pos);
        }

        @Override
        @Override
        public void a(double[] ds, DensityFunction.a contextProvider) {
            contextProvider.a(ds, this);
        }

        @Override
        @Override
        public DensityFunction k() {
            return this.e;
        }

        @Override
        @Override
        public DensityFunctions.l.a j() {
            return DensityFunctions.l.a.e;
        }
    }

    static class d
    implements DensityFunctions.m,
    h {
        private final DensityFunction a;
        private long e = ChunkCoordIntPair.a;
        private double f;

        d(DensityFunction densityFunction) {
            this.a = densityFunction;
        }

        @Override
        @Override
        public double a(DensityFunction.b pos) {
            double d2;
            int j2;
            int i2 = pos.a();
            long l2 = ChunkCoordIntPair.a(i2, j2 = pos.c());
            if (this.e == l2) {
                return this.f;
            }
            this.e = l2;
            this.f = d2 = this.a.a(pos);
            return d2;
        }

        @Override
        @Override
        public void a(double[] ds, DensityFunction.a contextProvider) {
            this.a.a(ds, contextProvider);
        }

        @Override
        @Override
        public DensityFunction k() {
            return this.a;
        }

        @Override
        @Override
        public DensityFunctions.l.a j() {
            return DensityFunctions.l.a.c;
        }
    }

    class f
    implements DensityFunctions.m,
    h {
        private final DensityFunction e;
        private long f;
        private long g;
        private double h;
        @Nullable
        private double[] i;

        f(DensityFunction densityFunction) {
            this.e = densityFunction;
        }

        @Override
        @Override
        public double a(DensityFunction.b pos) {
            double d2;
            if (pos != NoiseChunk.this) {
                return this.e.a(pos);
            }
            if (this.i != null && this.g == NoiseChunk.this.H) {
                return this.i[NoiseChunk.this.I];
            }
            if (this.f == NoiseChunk.this.G) {
                return this.h;
            }
            this.f = NoiseChunk.this.G;
            this.h = d2 = this.e.a(pos);
            return d2;
        }

        @Override
        @Override
        public void a(double[] ds, DensityFunction.a contextProvider) {
            if (this.i != null && this.g == NoiseChunk.this.H) {
                System.arraycopy(this.i, 0, ds, 0, ds.length);
                return;
            }
            this.k().a(ds, contextProvider);
            if (this.i != null && this.i.length == ds.length) {
                System.arraycopy(ds, 0, this.i, 0, ds.length);
            } else {
                this.i = (double[])ds.clone();
            }
            this.g = NoiseChunk.this.H;
        }

        @Override
        @Override
        public DensityFunction k() {
            return this.e;
        }

        @Override
        @Override
        public DensityFunctions.l.a j() {
            return DensityFunctions.l.a.d;
        }
    }

    static interface h
    extends DensityFunction {
        public DensityFunction k();

        @Override
        @Override
        default public DensityFunction a(DensityFunction.e visitor) {
            return this.k().a(visitor);
        }

        @Override
        @Override
        default public double a() {
            return this.k().a();
        }

        @Override
        @Override
        default public double b() {
            return this.k().b();
        }
    }
}

