/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class GeneratorSettings {
    public static final Codec<GeneratorSettings> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(GeneratorSettings::a), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(GeneratorSettings::b), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(GeneratorSettings::c), (App)RegistryCodecs.b(IRegistry.P, Lifecycle.stable(), WorldDimension.a).xmap(WorldDimension::a, Function.identity()).fieldOf("dimensions").forGetter(GeneratorSettings::d), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(worldGenSettings -> worldGenSettings.g)).apply((Applicative)instance, instance.stable(GeneratorSettings::new))).comapFlatMap(GeneratorSettings::m, Function.identity());
    private static final Logger b = LogUtils.getLogger();
    private final long c;
    private final boolean d;
    private final boolean e;
    private final IRegistry<WorldDimension> f;
    private final Optional<String> g;

    private DataResult<GeneratorSettings> m() {
        WorldDimension levelStem = this.f.a(WorldDimension.b);
        if (levelStem == null) {
            return DataResult.error((String)"Overworld settings missing");
        }
        if (this.n()) {
            return DataResult.success((Object)this, (Lifecycle)Lifecycle.stable());
        }
        return DataResult.success((Object)this);
    }

    private boolean n() {
        return WorldDimension.a(this.c, this.f);
    }

    public GeneratorSettings(long seed, boolean generateStructures, boolean bonusChest, IRegistry<WorldDimension> options) {
        this(seed, generateStructures, bonusChest, options, Optional.empty());
        WorldDimension levelStem = options.a(WorldDimension.b);
        if (levelStem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    private GeneratorSettings(long seed, boolean generateStructures, boolean bonusChest, IRegistry<WorldDimension> options, Optional<String> legacyCustomOptions) {
        this.c = seed;
        this.d = generateStructures;
        this.e = bonusChest;
        this.f = options;
        this.g = legacyCustomOptions;
    }

    public static GeneratorSettings a(IRegistryCustom registryManager) {
        int i2 = "North Carolina".hashCode();
        return new GeneratorSettings(i2, true, true, GeneratorSettings.a(registryManager.d(IRegistry.N), DimensionManager.a(registryManager, i2), (ChunkGenerator)GeneratorSettings.a(registryManager, i2)));
    }

    public static GeneratorSettings b(IRegistryCustom registryManager) {
        long l2 = new Random().nextLong();
        return new GeneratorSettings(l2, true, false, GeneratorSettings.a(registryManager.d(IRegistry.N), DimensionManager.a(registryManager, l2), (ChunkGenerator)GeneratorSettings.a(registryManager, l2)));
    }

    public static ChunkGeneratorAbstract a(IRegistryCustom registryManager, long seed) {
        return GeneratorSettings.a(registryManager, seed, true);
    }

    public static ChunkGeneratorAbstract a(IRegistryCustom registryManager, long seed, boolean bl) {
        return GeneratorSettings.a(registryManager, seed, GeneratorSettingBase.c, bl);
    }

    public static ChunkGeneratorAbstract a(IRegistryCustom registryManager, long seed, ResourceKey<GeneratorSettingBase> settings) {
        return GeneratorSettings.a(registryManager, seed, settings, true);
    }

    public static ChunkGeneratorAbstract a(IRegistryCustom registryManager, long seed, ResourceKey<GeneratorSettingBase> settings, boolean bl) {
        IRegistry<BiomeBase> registry = registryManager.d(IRegistry.aP);
        IRegistry<StructureSet> registry2 = registryManager.d(IRegistry.aM);
        IRegistry<GeneratorSettingBase> registry3 = registryManager.d(IRegistry.aH);
        IRegistry<NoiseGeneratorNormal.a> registry4 = registryManager.d(IRegistry.aQ);
        return new ChunkGeneratorAbstract(registry2, registry4, (WorldChunkManager)WorldChunkManagerMultiNoise.a.b.a(registry, bl), seed, registry3.c(settings));
    }

    public long a() {
        return this.c;
    }

    public boolean b() {
        return this.d;
    }

    public boolean c() {
        return this.e;
    }

    public static IRegistry<WorldDimension> a(IRegistry<DimensionManager> dimensionTypeRegistry, IRegistry<WorldDimension> options, ChunkGenerator overworldGenerator) {
        WorldDimension levelStem = options.a(WorldDimension.b);
        Holder<DimensionManager> holder = levelStem == null ? dimensionTypeRegistry.c(DimensionManager.m) : levelStem.a();
        return GeneratorSettings.a(options, holder, overworldGenerator);
    }

    public static IRegistry<WorldDimension> a(IRegistry<WorldDimension> options, Holder<DimensionManager> dimensionType, ChunkGenerator overworldGenerator) {
        RegistryMaterials<WorldDimension> writableRegistry = new RegistryMaterials<WorldDimension>(IRegistry.P, Lifecycle.experimental(), null);
        ((IRegistryWritable)writableRegistry).a(WorldDimension.b, new WorldDimension(dimensionType, overworldGenerator), Lifecycle.stable());
        for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> entry : options.e()) {
            ResourceKey<WorldDimension> resourceKey = entry.getKey();
            if (resourceKey == WorldDimension.b) continue;
            ((IRegistryWritable)writableRegistry).a(resourceKey, entry.getValue(), options.d(entry.getValue()));
        }
        return writableRegistry;
    }

    public IRegistry<WorldDimension> d() {
        return this.f;
    }

    public ChunkGenerator e() {
        WorldDimension levelStem = this.f.a(WorldDimension.b);
        if (levelStem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return levelStem.b();
    }

    public ImmutableSet<ResourceKey<World>> f() {
        return (ImmutableSet)this.d().e().stream().map(Map.Entry::getKey).map(GeneratorSettings::a).collect(ImmutableSet.toImmutableSet());
    }

    public static ResourceKey<World> a(ResourceKey<WorldDimension> dimensionOptionsKey) {
        return ResourceKey.a(IRegistry.O, dimensionOptionsKey.a());
    }

    public static ResourceKey<WorldDimension> b(ResourceKey<World> worldKey) {
        return ResourceKey.a(IRegistry.P, worldKey.a());
    }

    public boolean g() {
        return this.e() instanceof ChunkProviderDebug;
    }

    public boolean h() {
        return this.e() instanceof ChunkProviderFlat;
    }

    public boolean i() {
        return this.g.isPresent();
    }

    public GeneratorSettings j() {
        return new GeneratorSettings(this.c, this.d, true, this.f, this.g);
    }

    public GeneratorSettings k() {
        return new GeneratorSettings(this.c, !this.d, this.e, this.f);
    }

    public GeneratorSettings l() {
        return new GeneratorSettings(this.c, this.d, !this.e, this.f);
    }

    public static GeneratorSettings a(IRegistryCustom registryManager, DedicatedServerProperties.a worldGenProperties) {
        long l2 = GeneratorSettings.a(worldGenProperties.a()).orElse(new Random().nextLong());
        IRegistry<DimensionManager> registry = registryManager.d(IRegistry.N);
        IRegistry<BiomeBase> registry2 = registryManager.d(IRegistry.aP);
        IRegistry<StructureSet> registry3 = registryManager.d(IRegistry.aM);
        IRegistry<WorldDimension> registry4 = DimensionManager.a(registryManager, l2);
        switch (worldGenProperties.d()) {
            case "flat": {
                Dynamic<JsonObject> dynamic = new Dynamic<JsonObject>((DynamicOps<JsonObject>)JsonOps.INSTANCE, worldGenProperties.b());
                return new GeneratorSettings(l2, worldGenProperties.c(), false, GeneratorSettings.a(registry, registry4, (ChunkGenerator)new ChunkProviderFlat(registry3, GeneratorSettingsFlat.a.parse(dynamic).resultOrPartial(arg_0 -> ((Logger)b).error(arg_0)).orElseGet(() -> GeneratorSettingsFlat.a(registry2, registry3)))));
            }
            case "debug_all_block_states": {
                return new GeneratorSettings(l2, worldGenProperties.c(), false, GeneratorSettings.a(registry, registry4, (ChunkGenerator)new ChunkProviderDebug(registry3, registry2)));
            }
            case "amplified": {
                return new GeneratorSettings(l2, worldGenProperties.c(), false, GeneratorSettings.a(registry, registry4, (ChunkGenerator)GeneratorSettings.a(registryManager, l2, GeneratorSettingBase.e)));
            }
            case "largebiomes": {
                return new GeneratorSettings(l2, worldGenProperties.c(), false, GeneratorSettings.a(registry, registry4, (ChunkGenerator)GeneratorSettings.a(registryManager, l2, GeneratorSettingBase.d)));
            }
        }
        return new GeneratorSettings(l2, worldGenProperties.c(), false, GeneratorSettings.a(registry, registry4, (ChunkGenerator)GeneratorSettings.a(registryManager, l2)));
    }

    public GeneratorSettings a(boolean hardcore, OptionalLong seed) {
        GeneratorSettings worldGenSettings2;
        IRegistry<WorldDimension> registry2;
        long l2 = seed.orElse(this.c);
        if (seed.isPresent()) {
            RegistryMaterials<WorldDimension> writableRegistry = new RegistryMaterials<WorldDimension>(IRegistry.P, Lifecycle.experimental(), null);
            long m2 = seed.getAsLong();
            for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> entry : this.f.e()) {
                ResourceKey<WorldDimension> resourceKey = entry.getKey();
                ((IRegistryWritable)writableRegistry).a(resourceKey, new WorldDimension(entry.getValue().a(), entry.getValue().b().a(m2)), this.f.d(entry.getValue()));
            }
            RegistryMaterials<WorldDimension> registry = writableRegistry;
        } else {
            registry2 = this.f;
        }
        if (this.g()) {
            GeneratorSettings worldGenSettings = new GeneratorSettings(l2, false, false, registry2);
        } else {
            worldGenSettings2 = new GeneratorSettings(l2, this.b(), this.c() && !hardcore, registry2);
        }
        return worldGenSettings2;
    }

    public static OptionalLong a(String seed) {
        if (StringUtils.isEmpty((CharSequence)(seed = seed.trim()))) {
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(Long.parseLong(seed));
        }
        catch (NumberFormatException numberFormatException) {
            return OptionalLong.of(seed.hashCode());
        }
    }
}

