/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public final class ChunkGeneratorAbstract
extends ChunkGenerator {
    public static final Codec<ChunkGeneratorAbstract> f = RecordCodecBuilder.create(instance -> ChunkGeneratorAbstract.a(instance).and(instance.group((App)RegistryOps.b(IRegistry.aQ).forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.k), (App)WorldChunkManager.a.fieldOf("biome_source").forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.c), (App)Codec.LONG.fieldOf("seed").stable().forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.l), (App)GeneratorSettingBase.b.fieldOf("settings").forGetter(chunkgeneratorabstract -> chunkgeneratorabstract.h))).apply((Applicative)instance, instance.stable(ChunkGeneratorAbstract::new)));
    private static final IBlockData i = Blocks.a.n();
    private static final IBlockData[] j = new IBlockData[0];
    protected final IBlockData g;
    public final IRegistry<NoiseGeneratorNormal.a> k;
    private final long l;
    public final Holder<GeneratorSettingBase> h;
    private final NoiseRouter m;
    private final Climate.Sampler n;
    private final SurfaceSystem o;
    private final Aquifer.a p;

    public ChunkGeneratorAbstract(IRegistry<StructureSet> noiseRegistry, IRegistry<NoiseGeneratorNormal.a> structuresRegistry, WorldChunkManager biomeSource, long seed, Holder<GeneratorSettingBase> settings) {
        this(noiseRegistry, structuresRegistry, biomeSource, biomeSource, seed, settings);
    }

    private ChunkGeneratorAbstract(IRegistry<StructureSet> noiseRegistry, IRegistry<NoiseGeneratorNormal.a> structuresRegistry, WorldChunkManager populationSource, WorldChunkManager biomeSource, long seed, Holder<GeneratorSettingBase> settings) {
        super(noiseRegistry, Optional.empty(), populationSource, biomeSource, seed);
        this.k = structuresRegistry;
        this.l = seed;
        this.h = settings;
        GeneratorSettingBase generatorsettingbase = this.h.a();
        this.g = generatorsettingbase.g();
        NoiseSettings noisesettings = generatorsettingbase.f();
        this.m = generatorsettingbase.a(structuresRegistry, seed);
        this.n = new Climate.Sampler(this.m.g(), this.m.h(), this.m.i(), this.m.j(), this.m.k(), this.m.l(), this.m.r());
        Aquifer.b aquifer_b = new Aquifer.b(-54, Blocks.B.n());
        int j2 = generatorsettingbase.k();
        Aquifer.b aquifer_b1 = new Aquifer.b(j2, generatorsettingbase.h());
        Aquifer.b aquifer_b2 = new Aquifer.b(noisesettings.e() - 1, Blocks.a.n());
        this.p = (k2, l2, i1) -> l2 < Math.min(-54, j2) ? aquifer_b : aquifer_b1;
        this.o = new SurfaceSystem(structuresRegistry, this.g, j2, seed, generatorsettingbase.d());
    }

    @Override
    public CompletableFuture<IChunkAccess> a(IRegistry<BiomeBase> biomeRegistry, Executor executor, Blender blender, StructureManager structureAccessor, IChunkAccess chunk) {
        return CompletableFuture.supplyAsync(SystemUtils.a("init_biomes", () -> {
            this.a(blender, structureAccessor, chunk);
            return chunk;
        }), SystemUtils.f());
    }

    private void a(Blender blender, StructureManager structureAccessor, IChunkAccess chunk) {
        NoiseChunk noisechunk = chunk.a(this.m, () -> new Beardifier(structureAccessor, chunk), this.h.a(), this.p, blender);
        BiomeResolver biomeresolver = BelowZeroRetrogen.a(blender.a(this.d), chunk);
        chunk.a(biomeresolver, noisechunk.a(this.m));
    }

    @VisibleForDebug
    public NoiseRouter j() {
        return this.m;
    }

    @Override
    public Climate.Sampler d() {
        return this.n;
    }

    @Override
    protected Codec<? extends ChunkGenerator> b() {
        return f;
    }

    @Override
    public ChunkGenerator a(long seed) {
        return new ChunkGeneratorAbstract(this.b, this.k, this.c.a(seed), seed, this.h);
    }

    public boolean a(long seed, ResourceKey<GeneratorSettingBase> settingsKey) {
        return this.l == seed && this.h.a(settingsKey);
    }

    @Override
    public int a(int x2, int z2, HeightMap.Type heightmap, LevelHeightAccessor world) {
        NoiseSettings noisesettings = this.h.a().f();
        int k2 = Math.max(noisesettings.e(), world.u_());
        int l2 = Math.min(noisesettings.e() + noisesettings.f(), world.ag());
        int i1 = MathHelper.a(k2, noisesettings.a());
        int j1 = MathHelper.a(l2 - k2, noisesettings.a());
        return j1 <= 0 ? world.u_() : this.a(x2, z2, (IBlockData[])null, heightmap.e(), i1, j1).orElse(world.u_());
    }

    @Override
    public BlockColumn a(int x2, int z2, LevelHeightAccessor world) {
        NoiseSettings noisesettings = this.h.a().f();
        int k2 = Math.max(noisesettings.e(), world.u_());
        int l2 = Math.min(noisesettings.e() + noisesettings.f(), world.ag());
        int i1 = MathHelper.a(k2, noisesettings.a());
        int j1 = MathHelper.a(l2 - k2, noisesettings.a());
        if (j1 <= 0) {
            return new BlockColumn(k2, j);
        }
        IBlockData[] aiblockdata = new IBlockData[j1 * noisesettings.a()];
        this.a(x2, z2, aiblockdata, (Predicate<IBlockData>)null, i1, j1);
        return new BlockColumn(k2, aiblockdata);
    }

    @Override
    public void a(List<String> text, BlockPosition pos) {
        DecimalFormat decimalformat = new DecimalFormat("0.000");
        DensityFunction.d densityfunction_d = new DensityFunction.d(pos.u(), pos.v(), pos.w());
        double d0 = this.m.l().a(densityfunction_d);
        String s2 = decimalformat.format(this.m.g().a(densityfunction_d));
        text.add("NoiseRouter T: " + s2 + " H: " + decimalformat.format(this.m.h().a(densityfunction_d)) + " C: " + decimalformat.format(this.m.i().a(densityfunction_d)) + " E: " + decimalformat.format(this.m.j().a(densityfunction_d)) + " D: " + decimalformat.format(this.m.k().a(densityfunction_d)) + " W: " + decimalformat.format(d0) + " PV: " + decimalformat.format(TerrainShaper.a((float)d0)) + " AS: " + decimalformat.format(this.m.m().a(densityfunction_d)) + " N: " + decimalformat.format(this.m.n().a(densityfunction_d)));
    }

    private OptionalInt a(int i2, int j2, @Nullable IBlockData[] states, @Nullable Predicate<IBlockData> predicate, int k2, int l2) {
        NoiseSettings noisesettings = this.h.a().f();
        int i1 = noisesettings.b();
        int j1 = noisesettings.a();
        int k1 = Math.floorDiv(i2, i1);
        int l1 = Math.floorDiv(j2, i1);
        int i22 = Math.floorMod(i2, i1);
        int j22 = Math.floorMod(j2, i1);
        int k22 = k1 * i1;
        int l22 = l1 * i1;
        double d0 = (double)i22 / (double)i1;
        double d1 = (double)j22 / (double)i1;
        NoiseChunk noisechunk = NoiseChunk.a(k22, l22, k2, l2, this.m, this.h.a(), this.p);
        noisechunk.f();
        noisechunk.b(0);
        for (int i3 = l2 - 1; i3 >= 0; --i3) {
            noisechunk.b(i3, 0);
            for (int j3 = j1 - 1; j3 >= 0; --j3) {
                IBlockData iblockdata1;
                int k3 = (k2 + i3) * j1 + j3;
                double d2 = (double)j3 / (double)j1;
                noisechunk.a(k3, d2);
                noisechunk.b(i2, d0);
                noisechunk.c(j2, d1);
                IBlockData iblockdata = noisechunk.e();
                IBlockData iBlockData = iblockdata1 = iblockdata == null ? this.g : iblockdata;
                if (states != null) {
                    int l3 = i3 * j1 + j3;
                    states[l3] = iblockdata1;
                }
                if (predicate == null || !predicate.test(iblockdata1)) continue;
                noisechunk.g();
                return OptionalInt.of(k3 + 1);
            }
        }
        noisechunk.g();
        return OptionalInt.empty();
    }

    @Override
    public void a(RegionLimitedWorldAccess region, StructureManager structures, IChunkAccess chunk) {
        if (!SharedConstants.a(chunk.f())) {
            WorldGenerationContext worldgenerationcontext = new WorldGenerationContext(this, region, region.getMinecraftWorld());
            GeneratorSettingBase generatorsettingbase = this.h.a();
            NoiseChunk noisechunk = chunk.a(this.m, () -> new Beardifier(structures, chunk), generatorsettingbase, this.p, Blender.a(region));
            this.o.a(region.s_(), region.s().d(IRegistry.aP), generatorsettingbase.m(), worldgenerationcontext, chunk, noisechunk, generatorsettingbase.j());
        }
    }

    @Override
    public void a(RegionLimitedWorldAccess chunkRegion, long seed, BiomeManager biomeAccess, StructureManager structureAccessor, IChunkAccess chunk, WorldGenStage.Features generationStep) {
        BiomeManager biomemanager1 = biomeAccess.a((int j2, int k2, int l2) -> this.c.getNoiseBiome(j2, k2, l2, this.d()));
        SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
        boolean flag = true;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        NoiseChunk noisechunk = chunk.a(this.m, () -> new Beardifier(structureAccessor, chunk), this.h.a(), this.p, Blender.a(chunkRegion));
        Aquifer aquifer = noisechunk.i();
        CarvingContext carvingcontext = new CarvingContext(this, chunkRegion.s(), chunk.z(), noisechunk, chunkRegion.getMinecraftWorld());
        CarvingMask carvingmask = ((ProtoChunk)chunk).b(generationStep);
        for (int j3 = -8; j3 <= 8; ++j3) {
            for (int k3 = -8; k3 <= 8; ++k3) {
                ChunkCoordIntPair chunkcoordintpair1 = new ChunkCoordIntPair(chunkcoordintpair.c + j3, chunkcoordintpair.d + k3);
                IChunkAccess ichunkaccess1 = chunkRegion.a(chunkcoordintpair1.c, chunkcoordintpair1.d);
                BiomeSettingsGeneration biomesettingsgeneration = ichunkaccess1.a(() -> this.c.getNoiseBiome(QuartPos.a(chunkcoordintpair1.d()), 0, QuartPos.a(chunkcoordintpair1.e()), this.d())).a().e();
                Iterable<Holder<WorldGenCarverWrapper<?>>> iterable = biomesettingsgeneration.a(generationStep);
                int l3 = 0;
                for (Holder<WorldGenCarverWrapper<?>> holder : iterable) {
                    WorldGenCarverWrapper<?> worldgencarverwrapper = holder.a();
                    seededrandom.c(seed + (long)l3, chunkcoordintpair1.c, chunkcoordintpair1.d);
                    if (worldgencarverwrapper.a(seededrandom)) {
                        Objects.requireNonNull(biomemanager1);
                        worldgencarverwrapper.a(carvingcontext, chunk, biomemanager1::a, seededrandom, aquifer, chunkcoordintpair1, carvingmask);
                    }
                    ++l3;
                }
            }
        }
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Executor executor, Blender blender, StructureManager structureAccessor, IChunkAccess chunk) {
        NoiseSettings noisesettings = this.h.a().f();
        LevelHeightAccessor levelheightaccessor = chunk.z();
        int i2 = Math.max(noisesettings.e(), levelheightaccessor.u_());
        int j2 = Math.min(noisesettings.e() + noisesettings.f(), levelheightaccessor.ag());
        int k2 = MathHelper.a(i2, noisesettings.a());
        int l2 = MathHelper.a(j2 - i2, noisesettings.a());
        if (l2 <= 0) {
            return CompletableFuture.completedFuture(chunk);
        }
        int i1 = chunk.e(l2 * noisesettings.a() - 1 + i2);
        int j1 = chunk.e(i2);
        HashSet set = Sets.newHashSet();
        for (int k1 = i1; k1 >= j1; --k1) {
            ChunkSection chunksection = chunk.b(k1);
            chunksection.a();
            set.add(chunksection);
        }
        return CompletableFuture.supplyAsync(SystemUtils.a("wgen_fill_noise", () -> this.a(blender, structureAccessor, chunk, k2, l2)), SystemUtils.f()).whenCompleteAsync((ichunkaccess1, throwable) -> {
            for (ChunkSection chunksection1 : set) {
                chunksection1.b();
            }
        }, executor);
    }

    private IChunkAccess a(Blender blender, StructureManager structureAccessor, IChunkAccess chunk, int i2, int j2) {
        GeneratorSettingBase generatorsettingbase = this.h.a();
        NoiseChunk noisechunk = chunk.a(this.m, () -> new Beardifier(structureAccessor, chunk), generatorsettingbase, this.p, blender);
        HeightMap heightmap = chunk.a(HeightMap.Type.c);
        HeightMap heightmap1 = chunk.a(HeightMap.Type.a);
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int k2 = chunkcoordintpair.d();
        int l2 = chunkcoordintpair.e();
        Aquifer aquifer = noisechunk.i();
        noisechunk.f();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        NoiseSettings noisesettings = generatorsettingbase.f();
        int i1 = noisesettings.b();
        int j1 = noisesettings.a();
        int k1 = 16 / i1;
        int l1 = 16 / i1;
        for (int i22 = 0; i22 < k1; ++i22) {
            noisechunk.b(i22);
            for (int j22 = 0; j22 < l1; ++j22) {
                ChunkSection chunksection = chunk.b(chunk.ah() - 1);
                for (int k22 = j2 - 1; k22 >= 0; --k22) {
                    noisechunk.b(k22, j22);
                    for (int l22 = j1 - 1; l22 >= 0; --l22) {
                        int i3 = (i2 + k22) * j1 + l22;
                        int j3 = i3 & 0xF;
                        int k3 = chunk.e(i3);
                        if (chunk.e(chunksection.g()) != k3) {
                            chunksection = chunk.b(k3);
                        }
                        double d0 = (double)l22 / (double)j1;
                        noisechunk.a(i3, d0);
                        for (int l3 = 0; l3 < i1; ++l3) {
                            int i4 = k2 + i22 * i1 + l3;
                            int j4 = i4 & 0xF;
                            double d1 = (double)l3 / (double)i1;
                            noisechunk.b(i4, d1);
                            for (int k4 = 0; k4 < i1; ++k4) {
                                int l4 = l2 + j22 * i1 + k4;
                                int i5 = l4 & 0xF;
                                double d2 = (double)k4 / (double)i1;
                                noisechunk.c(l4, d2);
                                IBlockData iblockdata = noisechunk.e();
                                if (iblockdata == null) {
                                    iblockdata = this.g;
                                }
                                if ((iblockdata = this.a(noisechunk, i4, i3, l4, iblockdata)) == i || SharedConstants.a(chunk.f())) continue;
                                if (iblockdata.f() != 0 && chunk instanceof ProtoChunk) {
                                    blockposition_mutableblockposition.d(i4, i3, l4);
                                    ((ProtoChunk)chunk).j(blockposition_mutableblockposition);
                                }
                                chunksection.a(j4, j3, i5, iblockdata, false);
                                heightmap.a(j4, i3, i5, iblockdata);
                                heightmap1.a(j4, i3, i5, iblockdata);
                                if (!aquifer.a() || iblockdata.o().c()) continue;
                                blockposition_mutableblockposition.d(i4, i3, l4);
                                chunk.e(blockposition_mutableblockposition);
                            }
                        }
                    }
                }
            }
            noisechunk.h();
        }
        noisechunk.g();
        return chunk;
    }

    private IBlockData a(NoiseChunk chunkNoiseSampler, int x2, int y2, int z2, IBlockData state) {
        return state;
    }

    @Override
    public int f() {
        return this.h.a().f().f();
    }

    @Override
    public int g() {
        return this.h.a().k();
    }

    @Override
    public int h() {
        return this.h.a().f().e();
    }

    @Override
    public void a(RegionLimitedWorldAccess region) {
        if (!this.h.a().a()) {
            ChunkCoordIntPair chunkcoordintpair = region.a();
            Holder<BiomeBase> holder = region.v(chunkcoordintpair.l().h(region.ag() - 1));
            SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
            seededrandom.a(region.D(), chunkcoordintpair.d(), chunkcoordintpair.e());
            SpawnerCreature.a(region, holder, chunkcoordintpair, seededrandom);
        }
    }

    @Deprecated
    public Optional<IBlockData> a(CarvingContext context, Function<BlockPosition, Holder<BiomeBase>> posToBiome, IChunkAccess chunk, NoiseChunk chunkNoiseSampler, BlockPosition pos, boolean hasFluid) {
        return this.o.a(this.h.a().j(), context, posToBiome, chunk, chunkNoiseSampler, pos, hasFluid);
    }
}

