/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import io.papermc.paper.event.block.DragonEggFormEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.BossBattle;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBuilder;
import net.minecraft.world.level.block.state.predicate.BlockPredicate;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.levelgen.feature.WorldGenEnder;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_18_R2.boss.CraftDragonBattle;
import org.slf4j.Logger;

public class EnderDragonBattle {
    private static final Logger c = LogUtils.getLogger();
    private static final int d = 1200;
    private static final int e = 100;
    private static final int f = 20;
    private static final int g = 8;
    public static final int a = 9;
    private static final int h = 20;
    private static final int i = 96;
    public static final int b = 128;
    private static final Predicate<Entity> j = IEntitySelector.a.and(IEntitySelector.a(0.0, 128.0, 0.0, 192.0));
    public final BossBattleServer k = (BossBattleServer)new BossBattleServer(new ChatMessage("entity.minecraft.ender_dragon"), BossBattle.BarColor.a, BossBattle.BarStyle.a).b(true).c(true);
    public final WorldServer l;
    private final List<Integer> m = Lists.newArrayList();
    private final ShapeDetector n;
    private int o;
    private int p;
    private int q;
    private int r;
    private boolean s;
    private boolean t;
    @Nullable
    public UUID u;
    private boolean v = true;
    @Nullable
    public BlockPosition w;
    @Nullable
    public EnumDragonRespawn x;
    private int y;
    @Nullable
    private List<EntityEnderCrystal> z;

    public EnderDragonBattle(WorldServer world, long gatewaysSeed, NBTTagCompound nbt) {
        this.v = world.paperConfig.scanForLegacyEnderDragon;
        if (!this.v) {
            this.s = true;
        }
        this.l = world;
        if (nbt.e("NeedsStateScanning")) {
            this.v = nbt.q("NeedsStateScanning");
        }
        if (nbt.b("DragonKilled", 99)) {
            if (nbt.b("Dragon")) {
                this.u = nbt.a("Dragon");
            }
            this.s = nbt.q("DragonKilled");
            this.t = nbt.q("PreviouslyKilled");
            if (nbt.q("IsRespawning")) {
                this.x = EnumDragonRespawn.a;
            }
            if (nbt.b("ExitPortalLocation", 10)) {
                this.w = GameProfileSerializer.b(nbt.p("ExitPortalLocation"));
            }
        } else {
            this.s = true;
            this.t = true;
        }
        if (nbt.b("Gateways", 9)) {
            NBTTagList listTag = nbt.c("Gateways", 3);
            for (int i2 = 0; i2 < listTag.size(); ++i2) {
                this.m.add(listTag.e(i2));
            }
        } else {
            this.m.addAll((Collection<Integer>)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Collections.shuffle(this.m, new Random(gatewaysSeed));
        }
        this.n = ShapeDetectorBuilder.a().a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").a("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").a("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").a('#', ShapeDetectorBlock.a(BlockPredicate.a(Blocks.z))).b();
    }

    public NBTTagCompound a() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("NeedsStateScanning", this.v);
        if (this.u != null) {
            compoundTag.a("Dragon", this.u);
        }
        compoundTag.a("DragonKilled", this.s);
        compoundTag.a("PreviouslyKilled", this.t);
        if (this.w != null) {
            compoundTag.a("ExitPortalLocation", GameProfileSerializer.a(this.w));
        }
        NBTTagList listTag = new NBTTagList();
        for (int i2 : this.m) {
            listTag.add(NBTTagInt.a(i2));
        }
        compoundTag.a("Gateways", listTag);
        return compoundTag;
    }

    public void b() {
        this.k.d(!this.s);
        if (++this.r >= 20) {
            this.l();
            this.r = 0;
        }
        if (!this.k.h().isEmpty()) {
            this.l.k().a(TicketType.b, new ChunkCoordIntPair(0, 0), 9, Unit.a);
            boolean bl = this.k();
            if (this.v && bl) {
                this.g();
                this.v = false;
            }
            if (this.x != null) {
                if (this.z == null && bl) {
                    this.x = null;
                    this.e();
                }
                this.x.a(this.l, this, this.z, this.y++, this.w);
            }
            if (!this.s) {
                if ((this.u == null || ++this.o >= 1200) && bl) {
                    this.h();
                    this.o = 0;
                }
                if (++this.q >= 100 && bl) {
                    this.m();
                    this.q = 0;
                }
            }
        } else {
            this.l.k().b(TicketType.b, new ChunkCoordIntPair(0, 0), 9, Unit.a);
        }
    }

    private void g() {
        c.info("Scanning for legacy world dragon fight...");
        boolean bl = this.i();
        if (bl) {
            c.info("Found that the dragon has been killed in this world already.");
            this.t = true;
        } else {
            c.info("Found that the dragon has not yet been killed in this world.");
            this.t = false;
            if (this.j() == null) {
                this.a(false);
            }
        }
        List<? extends EntityEnderDragon> list = this.l.h();
        if (list.isEmpty()) {
            this.s = true;
        } else {
            EntityEnderDragon enderDragon = list.get(0);
            this.u = enderDragon.cm();
            c.info("Found that there's a dragon still alive ({})", (Object)enderDragon);
            this.s = false;
            if (!bl && this.l.paperConfig.shouldRemoveDragon) {
                c.info("But we didn't have a portal, let's remove it.");
                enderDragon.ah();
                this.u = null;
            }
        }
        if (!this.t && this.s) {
            this.s = false;
        }
    }

    private void h() {
        List<? extends EntityEnderDragon> list = this.l.h();
        if (list.isEmpty()) {
            c.debug("Haven't seen the dragon, respawning it");
            this.o();
        } else {
            c.debug("Haven't seen our dragon, but found another one to use.");
            this.u = list.get(0).cm();
        }
    }

    public void a(EnumDragonRespawn spawnState) {
        if (this.x == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.y = 0;
        if (spawnState == EnumDragonRespawn.e) {
            this.x = null;
            this.s = false;
            EntityEnderDragon enderDragon = this.o();
            for (EntityPlayer serverPlayer : this.k.h()) {
                CriterionTriggers.n.a(serverPlayer, enderDragon);
            }
        } else {
            this.x = spawnState;
        }
    }

    private boolean i() {
        for (int i2 = -8; i2 <= 8; ++i2) {
            for (int j2 = -8; j2 <= 8; ++j2) {
                Chunk levelChunk = this.l.d(i2, j2);
                for (TileEntity blockEntity : levelChunk.E().values()) {
                    if (!(blockEntity instanceof TileEntityEnderPortal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public ShapeDetector.ShapeDetectorCollection j() {
        int k2;
        for (int i2 = -8; i2 <= 8; ++i2) {
            for (int j2 = -8; j2 <= 8; ++j2) {
                Chunk levelChunk = this.l.d(i2, j2);
                for (TileEntity blockEntity : levelChunk.E().values()) {
                    ShapeDetector.ShapeDetectorCollection blockPatternMatch;
                    if (!(blockEntity instanceof TileEntityEnderPortal) || (blockPatternMatch = this.n.a(this.l, blockEntity.p())) == null) continue;
                    BlockPosition blockPos = blockPatternMatch.a(3, 3, 3).d();
                    if (this.w == null) {
                        this.w = blockPos;
                    }
                    return blockPatternMatch;
                }
            }
        }
        for (int l2 = k2 = this.l.a(HeightMap.Type.e, WorldGenEndTrophy.e).v(); l2 >= this.l.u_(); --l2) {
            ShapeDetector.ShapeDetectorCollection blockPatternMatch2 = this.n.a(this.l, new BlockPosition(WorldGenEndTrophy.e.u(), l2, WorldGenEndTrophy.e.w()));
            if (blockPatternMatch2 == null) continue;
            if (this.w == null) {
                this.w = blockPatternMatch2.a(3, 3, 3).d();
            }
            return blockPatternMatch2;
        }
        return null;
    }

    private boolean k() {
        for (int i2 = -8; i2 <= 8; ++i2) {
            for (int j2 = 8; j2 <= 8; ++j2) {
                IChunkAccess chunkAccess = this.l.a(i2, j2, ChunkStatus.o, false);
                if (!(chunkAccess instanceof Chunk)) {
                    return false;
                }
                PlayerChunk.State fullChunkStatus = ((Chunk)chunkAccess).B();
                if (fullChunkStatus.a(PlayerChunk.State.c)) continue;
                return false;
            }
        }
        return true;
    }

    private void l() {
        HashSet set = Sets.newHashSet();
        for (EntityPlayer serverPlayer : this.l.a(j)) {
            this.k.a(serverPlayer);
            set.add(serverPlayer);
        }
        HashSet set2 = Sets.newHashSet(this.k.h());
        set2.removeAll(set);
        for (EntityPlayer serverPlayer2 : set2) {
            this.k.b(serverPlayer2);
        }
    }

    private void m() {
        this.q = 0;
        this.p = 0;
        for (WorldGenEnder.Spike endSpike : WorldGenEnder.a(this.l)) {
            this.p += this.l.a(EntityEnderCrystal.class, endSpike.f()).size();
        }
        c.debug("Found {} end crystals still alive", (Object)this.p);
    }

    public void a(EntityEnderDragon dragon) {
        if (dragon.cm().equals(this.u)) {
            this.k.a(0.0f);
            this.k.d(false);
            this.a(true);
            this.n();
            BlockPosition eggPosition = this.l.a(HeightMap.Type.e, WorldGenEndTrophy.e);
            CraftBlockState eggState = CraftBlockStates.getBlockState(this.l, eggPosition);
            eggState.setData(Blocks.er.n());
            DragonEggFormEvent eggEvent = new DragonEggFormEvent((Block)CraftBlock.at(this.l, eggPosition), (BlockState)eggState, (DragonBattle)new CraftDragonBattle(this));
            if (!this.l.paperConfig.enderDragonsDeathAlwaysPlacesDragonEgg && this.t) {
                eggEvent.setCancelled(true);
            }
            if (eggEvent.callEvent()) {
                eggEvent.getNewState().update(true);
            }
            this.t = true;
            this.s = true;
        }
    }

    private void n() {
        if (!this.m.isEmpty()) {
            int i2 = this.m.remove(this.m.size() - 1);
            int j2 = MathHelper.b(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i2)));
            int k2 = MathHelper.b(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i2)));
            this.a(new BlockPosition(j2, 75, k2));
        }
    }

    private void a(BlockPosition pos) {
        this.l.c(3000, pos, 0);
        EndFeatures.c.a().a(this.l, this.l.k().g(), new Random(), pos);
    }

    public void a(boolean previouslyKilled) {
        WorldGenEndTrophy endPodiumFeature = new WorldGenEndTrophy(previouslyKilled);
        if (this.w == null) {
            this.w = this.l.a(HeightMap.Type.f, WorldGenEndTrophy.e).c();
            while (this.l.a_(this.w).a(Blocks.z) && this.w.v() > this.l.m_()) {
                this.w = this.w.c();
            }
        }
        if (this.w.v() <= this.l.u_()) {
            this.w = this.w.h(this.l.u_() + 1);
        }
        endPodiumFeature.a(WorldGenFeatureConfiguration.m, this.l, this.l.k().g(), new Random(), this.w);
    }

    private EntityEnderDragon o() {
        this.l.l(new BlockPosition(0, 128, 0));
        EntityEnderDragon enderDragon = EntityTypes.v.a(this.l);
        enderDragon.fx().a(DragonControllerPhase.a);
        enderDragon.b(0.0, 128.0, 0.0, this.l.v.nextFloat() * 360.0f, 0.0f);
        this.l.b(enderDragon);
        this.u = enderDragon.cm();
        this.f();
        return enderDragon;
    }

    public void b(EntityEnderDragon dragon) {
        if (dragon.cm().equals(this.u)) {
            this.k.a(dragon.ea() / dragon.em());
            this.o = 0;
            if (dragon.Y()) {
                this.k.a(dragon.C_());
            }
        }
    }

    public int c() {
        return this.p;
    }

    public void a(EntityEnderCrystal enderCrystal, DamageSource source) {
        if (this.x != null && this.z.contains(enderCrystal)) {
            c.debug("Aborting respawn sequence");
            this.x = null;
            this.y = 0;
            this.f();
            this.a(true);
        } else {
            this.m();
            Entity entity = this.l.a(this.u);
            if (entity instanceof EntityEnderDragon) {
                ((EntityEnderDragon)entity).a(enderCrystal, enderCrystal.cW(), source);
            }
        }
    }

    public boolean d() {
        return this.t;
    }

    public void e() {
        if (this.s && this.x == null) {
            BlockPosition blockPos = this.w;
            if (blockPos == null) {
                c.debug("Tried to respawn, but need to find the portal first.");
                ShapeDetector.ShapeDetectorCollection blockPatternMatch = this.j();
                if (blockPatternMatch == null) {
                    c.debug("Couldn't find a portal, so we made one.");
                    this.a(true);
                } else {
                    c.debug("Found the exit portal & saved its location for next time.");
                }
                blockPos = this.w;
            }
            ArrayList list = Lists.newArrayList();
            BlockPosition blockPos2 = blockPos.b(1);
            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                List<EntityEnderCrystal> list2 = this.l.a(EntityEnderCrystal.class, new AxisAlignedBB(blockPos2.a(direction, 2)));
                if (list2.isEmpty()) {
                    return;
                }
                list.addAll(list2);
            }
            c.debug("Found all crystals, respawning dragon.");
            this.a(list);
        }
    }

    private void a(List<EntityEnderCrystal> crystals) {
        if (this.s && this.x == null) {
            ShapeDetector.ShapeDetectorCollection blockPatternMatch = this.j();
            while (blockPatternMatch != null) {
                for (int i2 = 0; i2 < this.n.c(); ++i2) {
                    for (int j2 = 0; j2 < this.n.b(); ++j2) {
                        for (int k2 = 0; k2 < this.n.a(); ++k2) {
                            ShapeDetectorBlock blockInWorld = blockPatternMatch.a(i2, j2, k2);
                            if (!blockInWorld.a().a(Blocks.z) && !blockInWorld.a().a(Blocks.eo)) continue;
                            this.l.b(blockInWorld.d(), Blocks.eq.n());
                        }
                    }
                }
                blockPatternMatch = this.j();
            }
            this.x = EnumDragonRespawn.a;
            this.y = 0;
            this.a(false);
            this.z = crystals;
        }
    }

    public void f() {
        for (WorldGenEnder.Spike endSpike : WorldGenEnder.a(this.l)) {
            for (EntityEnderCrystal endCrystal : this.l.a(EntityEnderCrystal.class, endSpike.f())) {
                endCrystal.m(false);
                endCrystal.a((BlockPosition)null);
            }
        }
    }
}

