/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;

public final class WorldDimension {
    public static final Codec<WorldDimension> a = RecordCodecBuilder.create(instance -> instance.group((App)DimensionManager.u.fieldOf("type").forGetter(WorldDimension::a), (App)ChunkGenerator.a.fieldOf("generator").forGetter(WorldDimension::b)).apply((Applicative)instance, instance.stable(WorldDimension::new)));
    public static final ResourceKey<WorldDimension> b = ResourceKey.a(IRegistry.P, new MinecraftKey("overworld"));
    public static final ResourceKey<WorldDimension> c = ResourceKey.a(IRegistry.P, new MinecraftKey("the_nether"));
    public static final ResourceKey<WorldDimension> d = ResourceKey.a(IRegistry.P, new MinecraftKey("the_end"));
    private static final Set<ResourceKey<WorldDimension>> e = ImmutableSet.of(b, c, d);
    private final Holder<DimensionManager> f;
    private final ChunkGenerator g;

    public WorldDimension(Holder<DimensionManager> holder, ChunkGenerator chunkGenerator) {
        this.f = holder;
        this.g = chunkGenerator;
    }

    public Holder<DimensionManager> a() {
        return this.f;
    }

    public ChunkGenerator b() {
        return this.g;
    }

    public static IRegistry<WorldDimension> a(IRegistry<WorldDimension> registry) {
        RegistryMaterials<WorldDimension> writableRegistry = new RegistryMaterials<WorldDimension>(IRegistry.P, Lifecycle.experimental(), null);
        for (ResourceKey<WorldDimension> resourceKey : e) {
            WorldDimension levelStem = registry.a(resourceKey);
            if (levelStem == null) continue;
            ((IRegistryWritable)writableRegistry).a(resourceKey, levelStem, registry.d(levelStem));
        }
        for (Map.Entry entry : registry.e()) {
            ResourceKey resourceKey2 = (ResourceKey)entry.getKey();
            if (e.contains(resourceKey2)) continue;
            ((IRegistryWritable)writableRegistry).a(resourceKey2, (WorldDimension)entry.getValue(), registry.d((WorldDimension)entry.getValue()));
        }
        return writableRegistry;
    }

    public static boolean a(long seed, IRegistry<WorldDimension> registry) {
        if (registry.b() != e.size()) {
            return false;
        }
        Optional<WorldDimension> optional = registry.e(b);
        Optional<WorldDimension> optional2 = registry.e(c);
        Optional<WorldDimension> optional3 = registry.e(d);
        if (optional.isEmpty() || optional2.isEmpty() || optional3.isEmpty()) {
            return false;
        }
        if (!optional.get().a().a(DimensionManager.m) && !optional.get().a().a(DimensionManager.s)) {
            return false;
        }
        if (!optional2.get().a().a(DimensionManager.n)) {
            return false;
        }
        if (!optional3.get().a().a(DimensionManager.o)) {
            return false;
        }
        if (!(optional2.get().b() instanceof ChunkGeneratorAbstract) || !(optional3.get().b() instanceof ChunkGeneratorAbstract)) {
            return false;
        }
        ChunkGeneratorAbstract noiseBasedChunkGenerator = (ChunkGeneratorAbstract)optional2.get().b();
        ChunkGeneratorAbstract noiseBasedChunkGenerator2 = (ChunkGeneratorAbstract)optional3.get().b();
        if (!noiseBasedChunkGenerator.a(seed, GeneratorSettingBase.f)) {
            return false;
        }
        if (!noiseBasedChunkGenerator2.a(seed, GeneratorSettingBase.g)) {
            return false;
        }
        if (!(noiseBasedChunkGenerator.e() instanceof WorldChunkManagerMultiNoise)) {
            return false;
        }
        WorldChunkManagerMultiNoise multiNoiseBiomeSource = (WorldChunkManagerMultiNoise)noiseBasedChunkGenerator.e();
        if (!multiNoiseBiomeSource.a(WorldChunkManagerMultiNoise.a.a)) {
            return false;
        }
        WorldChunkManager biomeSource = optional.get().b().e();
        if (biomeSource instanceof WorldChunkManagerMultiNoise && !((WorldChunkManagerMultiNoise)biomeSource).a(WorldChunkManagerMultiNoise.a.b)) {
            return false;
        }
        if (!(noiseBasedChunkGenerator2.e() instanceof WorldChunkManagerTheEnd)) {
            return false;
        }
        WorldChunkManagerTheEnd theEndBiomeSource = (WorldChunkManagerTheEnd)noiseBasedChunkGenerator2.e();
        return theEndBiomeSource.b(seed);
    }
}

