/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.destroystokyo.paper.io.PaperFileIOThread;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.RegionFileCache;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentStructureLegacy;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.spigotmc.SpigotConfig;

public class IChunkLoader
implements AutoCloseable {
    public static final int d = 1493;
    protected final DataFixer e;
    @Nullable
    private volatile PersistentStructureLegacy b;
    private final Object persistentDataLock = new Object();
    public final RegionFileCache regionFileCache;

    public IChunkLoader(Path directory, DataFixer dataFixer, boolean dsync) {
        this.e = dataFixer;
        this.regionFileCache = new RegionFileCache(directory, dsync, true);
    }

    private boolean check(ChunkProviderServer cps, int x2, int z2) throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTTagCompound upgradeChunkTag(ResourceKey<WorldDimension> resourcekey, Supplier<WorldPersistentData> supplier, NBTTagCompound nbttagcompound, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> optional, ChunkCoordIntPair pos, @Nullable GeneratorAccess generatoraccess) throws IOException {
        boolean belowZeroGenerationInExistingChunks;
        int i2 = IChunkLoader.a(nbttagcompound = nbttagcompound.g());
        if (i2 < 1493) {
            MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbttagcompound, i2, 1493);
            if (nbttagcompound.p("Level").q("hasLegacyStructureData")) {
                Object object = this.persistentDataLock;
                synchronized (object) {
                    if (this.b == null) {
                        this.b = PersistentStructureLegacy.a(resourcekey, supplier.get());
                    }
                    nbttagcompound = this.b.a(nbttagcompound);
                }
            }
        }
        boolean stopBelowZero = false;
        boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((WorldServer)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
        if (i2 <= 2730 && !belowZeroGenerationInExistingChunks) {
            stopBelowZero = ChunkStatus.o.d().equals(nbttagcompound.p("Level").l("Status"));
        }
        IChunkLoader.a(nbttagcompound, resourcekey, optional);
        nbttagcompound = MCDataConverter.convertTag(MCTypeRegistry.CHUNK, nbttagcompound, Math.max(1493, i2), SharedConstants.b().getWorldVersion());
        if (i2 < SharedConstants.b().getWorldVersion()) {
            nbttagcompound.a("DataVersion", SharedConstants.b().getWorldVersion());
        }
        if (stopBelowZero) {
            nbttagcompound.a("Status", ChunkStatus.n.d());
        }
        nbttagcompound.r("__context");
        return nbttagcompound;
    }

    public static void a(NBTTagCompound nbt, ResourceKey<WorldDimension> worldKey, Optional<ResourceKey<Codec<? extends ChunkGenerator>>> generatorCodecKey) {
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.a("dimension", worldKey.a().toString());
        generatorCodecKey.ifPresent(resourcekey1 -> nbttagcompound1.a("generator", resourcekey1.a().toString()));
        nbt.a("__context", nbttagcompound1);
    }

    public static int a(NBTTagCompound nbt) {
        return nbt.b("DataVersion", 99) ? nbt.h("DataVersion") : -1;
    }

    @Nullable
    public NBTTagCompound f(ChunkCoordIntPair chunkPos) throws IOException {
        return this.regionFileCache.a(chunkPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(ChunkCoordIntPair chunkPos, NBTTagCompound nbt) throws IOException {
        if (!chunkPos.equals(ChunkRegionLoader.getChunkCoordinate(nbt))) {
            String world = this instanceof PlayerChunkMap ? ((PlayerChunkMap)this).r.getWorld().getName() : null;
            throw new IllegalArgumentException("Chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + chunkPos.toString() + " but compound says coordinate is " + ChunkRegionLoader.getChunkCoordinate(nbt).toString() + (String)(world == null ? " for an unknown world" : " for world: " + world));
        }
        this.regionFileCache.a(chunkPos, nbt);
        if (this.b != null) {
            Object object = this.persistentDataLock;
            synchronized (object) {
                this.b.a(chunkPos.a());
            }
        }
    }

    public void m() {
        PaperFileIOThread.Holder.INSTANCE.flush();
    }

    @Override
    public void close() throws IOException {
        this.regionFileCache.close();
    }

    public ChunkScanAccess n() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.regionFileCache.a(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        };
    }
}

