/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.thread.ThreadedMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import org.slf4j.Logger;

public class EntityStorage
implements EntityPersistentStorage<Entity> {
    private static final Logger b = LogUtils.getLogger();
    private static final String c = "Entities";
    private static final String d = "Position";
    public final WorldServer e;
    private final IOWorker f;
    private final LongSet g = new LongOpenHashSet();
    public final ThreadedMailbox<Runnable> h;
    protected final DataFixer a;

    public EntityStorage(WorldServer world, Path path, DataFixer dataFixer, boolean dsync, Executor executor) {
        this.e = world;
        this.a = dataFixer;
        this.h = ThreadedMailbox.a(executor, "entity-deserializer");
        this.f = new IOWorker(path, dsync, "entities");
    }

    @Override
    public CompletableFuture<ChunkEntities<Entity>> a(ChunkCoordIntPair pos) {
        return this.g.contains(pos.a()) ? CompletableFuture.completedFuture(EntityStorage.b(pos)) : this.f.b(pos).thenApplyAsync(compound -> {
            if (compound == null) {
                this.g.add(pos.a());
                return EntityStorage.b(pos);
            }
            try {
                ChunkCoordIntPair chunkPos2 = EntityStorage.b(compound);
                if (!Objects.equals(pos, chunkPos2)) {
                    b.error("Chunk file at {} is in the wrong location. (Expected {}, got {})", new Object[]{pos, pos, chunkPos2});
                }
            }
            catch (Exception var6) {
                b.warn("Failed to parse chunk {} position info", (Object)pos, (Object)var6);
            }
            NBTTagCompound compoundTag = this.c((NBTTagCompound)compound);
            NBTTagList listTag = compoundTag.c(c, 10);
            List list = (List)EntityTypes.a(listTag, (World)this.e).collect(ImmutableList.toImmutableList());
            return new ChunkEntities(pos, list);
        }, this.h::a);
    }

    private static ChunkCoordIntPair b(NBTTagCompound chunkNbt) {
        int[] is = chunkNbt.n(d);
        return new ChunkCoordIntPair(is[0], is[1]);
    }

    private static void a(NBTTagCompound chunkNbt, ChunkCoordIntPair pos) {
        chunkNbt.a(d, new NBTTagIntArray(new int[]{pos.c, pos.d}));
    }

    private static ChunkEntities<Entity> b(ChunkCoordIntPair pos) {
        return new ChunkEntities<Entity>(pos, (List<Entity>)ImmutableList.of());
    }

    @Override
    public void a(ChunkEntities<Entity> dataList) {
        ChunkCoordIntPair chunkPos = dataList.a();
        if (dataList.c()) {
            if (this.g.add(chunkPos.a())) {
                this.f.a(chunkPos, (NBTTagCompound)null);
            }
        } else {
            NBTTagList listTag = new NBTTagList();
            HashMap savedEntityCounts = new HashMap();
            dataList.b().forEach(entity -> {
                NBTTagCompound compoundTag;
                EntityTypes<?> entityType = entity.ad();
                int saveLimit = this.e.paperConfig.entityPerChunkSaveLimits.getOrDefault(entityType, -1);
                if (saveLimit > -1) {
                    if (savedEntityCounts.getOrDefault(entityType, 0) >= saveLimit) {
                        return;
                    }
                    savedEntityCounts.merge(entityType, 1, Integer::sum);
                }
                if (entity.e(compoundTag = new NBTTagCompound())) {
                    listTag.add(compoundTag);
                }
            });
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a("DataVersion", SharedConstants.b().getWorldVersion());
            compoundTag.a(c, listTag);
            EntityStorage.a(compoundTag, chunkPos);
            this.f.a(chunkPos, compoundTag).exceptionally(ex -> {
                b.error("Failed to store chunk {}", (Object)chunkPos, ex);
                return null;
            });
            this.g.remove(chunkPos.a());
        }
    }

    @Override
    public void a(boolean sync) {
        this.f.a(sync).join();
        this.h.a();
    }

    private NBTTagCompound c(NBTTagCompound chunkNbt) {
        int i2 = EntityStorage.a(chunkNbt);
        return MCDataConverter.convertTag(MCTypeRegistry.ENTITY_CHUNK, chunkNbt, i2, SharedConstants.b().getWorldVersion());
    }

    public static int a(NBTTagCompound chunkNbt) {
        return chunkNbt.b("DataVersion", 99) ? chunkNbt.h("DataVersion") : -1;
    }

    @Override
    public void close() throws IOException {
        this.f.close();
    }
}

