/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.VisibleForDebug;

public final class NibbleArray {
    public static final int a = 16;
    public static final int b = 128;
    public static final int c = 2048;
    private static final int e = 4;
    @Nullable
    protected byte[] d;

    public NibbleArray() {
    }

    public NibbleArray(byte[] bytes) {
        this.d = bytes;
        if (bytes.length != 2048) {
            throw SystemUtils.c(new IllegalArgumentException("DataLayer should be 2048 bytes not: " + bytes.length));
        }
    }

    protected NibbleArray(int size) {
        this.d = new byte[size];
    }

    public int a(int x2, int y2, int z2) {
        return this.b(NibbleArray.b(x2, y2, z2));
    }

    public void a(int x2, int y2, int z2, int value) {
        this.a(NibbleArray.b(x2, y2, z2), value);
    }

    private static int b(int i2, int x2, int y2) {
        return x2 << 8 | y2 << 4 | i2;
    }

    private int b(int index) {
        if (this.d == null) {
            return 0;
        }
        int j2 = NibbleArray.d(index);
        int k2 = NibbleArray.c(index);
        return this.d[j2] >> 4 * k2 & 0xF;
    }

    private void a(int index, int value) {
        if (this.d == null) {
            this.d = new byte[2048];
        }
        int k2 = NibbleArray.d(index);
        int l2 = NibbleArray.c(index);
        int i1 = ~(15 << 4 * l2);
        int j1 = (value & 0xF) << 4 * l2;
        this.d[k2] = (byte)(this.d[k2] & i1 | j1);
    }

    private static int c(int i2) {
        return i2 & 1;
    }

    private static int d(int i2) {
        return i2 >> 1;
    }

    public byte[] a() {
        if (this.d == null) {
            this.d = new byte[2048];
        }
        return this.d;
    }

    public NibbleArray b() {
        return this.d == null ? new NibbleArray() : new NibbleArray((byte[])this.d.clone());
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        for (int i2 = 0; i2 < 4096; ++i2) {
            stringbuilder.append(Integer.toHexString(this.b(i2)));
            if ((i2 & 0xF) == 15) {
                stringbuilder.append("\n");
            }
            if ((i2 & 0xFF) != 255) continue;
            stringbuilder.append("\n");
        }
        return stringbuilder.toString();
    }

    @VisibleForDebug
    public String a(int unused) {
        StringBuilder stringbuilder = new StringBuilder();
        for (int j2 = 0; j2 < 256; ++j2) {
            stringbuilder.append(Integer.toHexString(this.b(j2)));
            if ((j2 & 0xF) != 15) continue;
            stringbuilder.append("\n");
        }
        return stringbuilder.toString();
    }

    public boolean c() {
        return this.d == null;
    }
}

