/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.world.StructuresLocateEvent;
import io.papermc.paper.registry.PaperRegistry;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.world.structure.ConfiguredStructure;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MCUtil;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IStructureAccess;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.generator.CraftLimitedRegion;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.slf4j.Logger;
import org.spigotmc.SpigotWorldConfig;

public abstract class ChunkGenerator
implements BiomeManager.Provider {
    private static final Logger f;
    public static final Codec<ChunkGenerator> a;
    public final IRegistry<StructureSet> b;
    protected final WorldChunkManager c;
    protected final WorldChunkManager d;
    public final Optional<HolderSet<StructureSet>> e;
    private final Map<StructureFeature<?, ?>, List<StructurePlacement>> g = new Object2ObjectOpenHashMap();
    private final Map<ConcentricRingsStructurePlacement, CompletableFuture<List<ChunkCoordIntPair>>> h = new Object2ObjectArrayMap();
    private boolean i;
    @Deprecated
    public final long j;
    public SpigotWorldConfig conf;

    protected static final <T extends ChunkGenerator> Products.P1<RecordCodecBuilder.Mu<T>, IRegistry<StructureSet>> a(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)RegistryOps.b(IRegistry.aM).forGetter(chunkgenerator -> chunkgenerator.b));
    }

    public ChunkGenerator(IRegistry<StructureSet> iregistry, Optional<HolderSet<StructureSet>> optional, WorldChunkManager worldchunkmanager) {
        this(iregistry, optional, worldchunkmanager, worldchunkmanager, 0L);
    }

    public ChunkGenerator(IRegistry<StructureSet> iregistry, Optional<HolderSet<StructureSet>> optional, WorldChunkManager worldchunkmanager, WorldChunkManager worldchunkmanager1, long i2) {
        this.b = iregistry;
        this.c = worldchunkmanager;
        this.d = worldchunkmanager1;
        this.e = optional;
        this.j = i2;
    }

    public Stream<Holder<StructureSet>> a() {
        return this.e.isPresent() ? this.e.get().a() : this.b.f().map(Holder::a);
    }

    private void j() {
        Set<Holder<BiomeBase>> set = this.d.b();
        this.a().forEach(holder -> {
            StructureSet structureset = (StructureSet)holder.a();
            StructurePlacement patt6576$temp = structureset.b();
            if (patt6576$temp instanceof RandomSpreadStructurePlacement) {
                RandomSpreadStructurePlacement randomConfig = (RandomSpreadStructurePlacement)patt6576$temp;
                String name = this.b.b(structureset).a();
                int seed = randomConfig.e();
                switch (name) {
                    case "desert_pyramids": {
                        seed = this.conf.desertSeed;
                        break;
                    }
                    case "end_cities": {
                        seed = this.conf.endCitySeed;
                        break;
                    }
                    case "nether_complexes": {
                        seed = this.conf.netherSeed;
                        break;
                    }
                    case "igloos": {
                        seed = this.conf.iglooSeed;
                        break;
                    }
                    case "jungle_temples": {
                        seed = this.conf.jungleSeed;
                        break;
                    }
                    case "woodland_mansions": {
                        seed = this.conf.mansionSeed;
                        break;
                    }
                    case "ocean_monuments": {
                        seed = this.conf.monumentSeed;
                        break;
                    }
                    case "nether_fossils": {
                        seed = this.conf.fossilSeed;
                        break;
                    }
                    case "ocean_ruins": {
                        seed = this.conf.oceanSeed;
                        break;
                    }
                    case "pillager_outposts": {
                        seed = this.conf.outpostSeed;
                        break;
                    }
                    case "ruined_portals": {
                        seed = this.conf.portalSeed;
                        break;
                    }
                    case "shipwrecks": {
                        seed = this.conf.shipwreckSeed;
                        break;
                    }
                    case "swamp_huts": {
                        seed = this.conf.swampSeed;
                        break;
                    }
                    case "villages": {
                        seed = this.conf.villageSeed;
                    }
                }
                structureset = new StructureSet(structureset.a(), (StructurePlacement)new RandomSpreadStructurePlacement(randomConfig.b(), randomConfig.c(), randomConfig.d(), seed, randomConfig.f()));
            }
            for (StructureSet.a structureset_a : structureset.a()) {
                this.g.computeIfAbsent(structureset_a.a().a(), structurefeature -> new ArrayList()).add(structureset.b());
            }
            StructurePlacement structureplacement = structureset.b();
            if (structureplacement instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement;
                if (structureset.a().stream().anyMatch(structureset_a1 -> {
                    Objects.requireNonNull(set);
                    return structureset_a1.a(set::contains);
                })) {
                    this.h.put(concentricringsstructureplacement, this.a((Holder<StructureSet>)holder, concentricringsstructureplacement));
                }
            }
        });
    }

    private CompletableFuture<List<ChunkCoordIntPair>> a(Holder<StructureSet> strongholdSet, ConcentricRingsStructurePlacement placement) {
        return placement.d() == 0 ? CompletableFuture.completedFuture(List.of()) : CompletableFuture.supplyAsync(SystemUtils.a("placement calculation", () -> {
            Stopwatch stopwatch = Stopwatch.createStarted((Ticker)SystemUtils.b);
            ArrayList<ChunkCoordIntPair> list = new ArrayList<ChunkCoordIntPair>();
            Set set = ((StructureSet)strongholdSet.a()).a().stream().flatMap(structureset_a -> structureset_a.a().a().a().a()).collect(Collectors.toSet());
            int i2 = placement.b();
            int j2 = placement.d();
            int k2 = placement.c();
            Random random = new Random();
            if (strongholdSet.a(BuiltinStructureSets.q) && this.conf.strongholdSeed != null) {
                random.setSeed(this.conf.strongholdSeed);
            } else {
                random.setSeed(this.j);
            }
            double d0 = random.nextDouble() * Math.PI * 2.0;
            int l2 = 0;
            int i1 = 0;
            for (int j1 = 0; j1 < j2; ++j1) {
                double d1 = (double)(4 * i2 + i2 * i1 * 6) + (random.nextDouble() - 0.5) * (double)i2 * 2.5;
                int k1 = (int)Math.round(Math.cos(d0) * d1);
                int l1 = (int)Math.round(Math.sin(d0) * d1);
                WorldChunkManager worldchunkmanager = this.c;
                int i22 = SectionPosition.a(k1, 8);
                int j22 = SectionPosition.a(l1, 8);
                Objects.requireNonNull(set);
                Pair<BlockPosition, Holder<BiomeBase>> pair = worldchunkmanager.a(i22, 0, j22, 112, set::contains, random, this.d());
                if (pair != null) {
                    BlockPosition blockposition = (BlockPosition)pair.getFirst();
                    k1 = SectionPosition.a(blockposition.u());
                    l1 = SectionPosition.a(blockposition.w());
                }
                list.add(new ChunkCoordIntPair(k1, l1));
                d0 += Math.PI * 2 / (double)k2;
                if (++l2 != k2) continue;
                l2 = 0;
                k2 += 2 * k2 / (++i1 + 1);
                k2 = Math.min(k2, j2 - j1);
                d0 += random.nextDouble() * Math.PI * 2.0;
            }
            double d2 = (double)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            f.debug("Calculation for {} took {}s", (Object)strongholdSet, (Object)d2);
            return list;
        }), SystemUtils.f());
    }

    protected abstract Codec<? extends ChunkGenerator> b();

    public Optional<ResourceKey<Codec<? extends ChunkGenerator>>> c() {
        return IRegistry.bw.c(this.b());
    }

    public abstract ChunkGenerator a(long var1);

    public CompletableFuture<IChunkAccess> a(IRegistry<BiomeBase> biomeRegistry, Executor executor, Blender blender, StructureManager structureAccessor, IChunkAccess chunk) {
        return CompletableFuture.supplyAsync(SystemUtils.a("init_biomes", () -> {
            WorldChunkManager worldchunkmanager = this.d;
            Objects.requireNonNull(this.d);
            chunk.a(worldchunkmanager::getNoiseBiome, this.d());
            return chunk;
        }), SystemUtils.f());
    }

    public abstract Climate.Sampler d();

    @Override
    public Holder<BiomeBase> getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        return this.e().getNoiseBiome(biomeX, biomeY, biomeZ, this.d());
    }

    public abstract void a(RegionLimitedWorldAccess var1, long var2, BiomeManager var4, StructureManager var5, IChunkAccess var6, WorldGenStage.Features var7);

    @Nullable
    public Pair<BlockPosition, Holder<StructureFeature<?, ?>>> a(WorldServer worldserver, HolderSet<StructureFeature<?, ?>> holderset, BlockPosition center, int radius, boolean skipExistingChunks) {
        CraftWorld world = worldserver.getWorld();
        Location origin = MCUtil.toLocation(worldserver, center);
        PaperRegistry<ConfiguredStructure, StructureFeature<?, ?>> paperRegistry = PaperRegistry.getRegistry(RegistryKey.CONFIGURED_STRUCTURE_REGISTRY);
        ArrayList<ConfiguredStructure> configuredStructures = new ArrayList<ConfiguredStructure>();
        for (Holder holder2 : holderset) {
            configuredStructures.add(paperRegistry.convertToApi(holder2));
        }
        StructuresLocateEvent event = new StructuresLocateEvent((World)world, origin, configuredStructures, radius, skipExistingChunks);
        if (!event.callEvent()) {
            return null;
        }
        if (event.getResult() != null) {
            return Pair.of((Object)MCUtil.toBlockPosition(event.getResult().position()), paperRegistry.getMinecraftHolder(event.getResult().configuredStructure()));
        }
        center = MCUtil.toBlockPosition(event.getOrigin());
        radius = event.getRadius();
        skipExistingChunks = event.shouldFindUnexplored();
        holderset = HolderSet.a(paperRegistry::getMinecraftHolder, event.getConfiguredStructures());
        Set set = holderset.a().flatMap(holder -> ((StructureFeature)holder.a()).a().a()).collect(Collectors.toSet());
        if (set.isEmpty()) {
            return null;
        }
        Set<Holder<BiomeBase>> set1 = this.d.b();
        if (Collections.disjoint(set1, set)) {
            return null;
        }
        Pair<BlockPosition, Holder<StructureFeature<?, ?>>> pair = null;
        double d0 = Double.MAX_VALUE;
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Holder holder3 : holderset) {
            Stream stream = set1.stream();
            HolderSet<BiomeBase> holderset1 = ((StructureFeature)holder3.a()).a();
            Objects.requireNonNull(holderset1);
            if (stream.noneMatch(holderset1::a)) continue;
            for (StructurePlacement structureplacement : this.b(holder3)) {
                map.computeIfAbsent(structureplacement, structureplacement1 -> new ObjectArraySet()).add(holder3);
            }
        }
        ArrayList arrayList = new ArrayList(map.size());
        for (Map.Entry entry : map.entrySet()) {
            StructurePlacement structureplacement;
            structureplacement = (StructurePlacement)entry.getKey();
            if (structureplacement instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement;
                BlockPosition blockposition1 = this.a(center, concentricringsstructureplacement);
                double d1 = center.j(blockposition1);
                if (!(d1 < d0)) continue;
                d0 = d1;
                pair = Pair.of((Object)blockposition1, (Object)((Holder)((Set)entry.getValue()).iterator().next()));
                continue;
            }
            if (!(structureplacement instanceof RandomSpreadStructurePlacement)) continue;
            arrayList.add(entry);
        }
        if (!arrayList.isEmpty()) {
            int j2 = SectionPosition.a(center.u());
            int k2 = SectionPosition.a(center.w());
            for (int l2 = 0; l2 <= radius; ++l2) {
                boolean flag1 = false;
                for (Map.Entry entry : arrayList) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPosition, Holder<StructureFeature<?, ?>>> pair1 = ChunkGenerator.a((Set)entry.getValue(), worldserver, worldserver.a(), j2, k2, l2, skipExistingChunks, worldserver.D(), randomspreadstructureplacement);
                    if (pair1 == null) continue;
                    flag1 = true;
                    double d2 = center.j((BaseBlockPosition)pair1.getFirst());
                    if (!(d2 < d0)) continue;
                    d0 = d2;
                    pair = pair1;
                }
                if (!flag1) continue;
                return pair;
            }
        }
        return pair;
    }

    @Nullable
    private BlockPosition a(BlockPosition blockposition, ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        List<ChunkCoordIntPair> list = this.a(concentricringsstructureplacement);
        if (list == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        BlockPosition blockposition1 = null;
        double d0 = Double.MAX_VALUE;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (ChunkCoordIntPair chunkcoordintpair : list) {
            blockposition_mutableblockposition.d(SectionPosition.a(chunkcoordintpair.c, 8), 32, SectionPosition.a(chunkcoordintpair.d, 8));
            double d1 = blockposition_mutableblockposition.j(blockposition);
            if (blockposition1 == null) {
                blockposition1 = new BlockPosition(blockposition_mutableblockposition);
                d0 = d1;
                continue;
            }
            if (!(d1 < d0)) continue;
            blockposition1 = new BlockPosition(blockposition_mutableblockposition);
            d0 = d1;
        }
        return blockposition1;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<StructureFeature<?, ?>>> a(Set<Holder<StructureFeature<?, ?>>> set, IWorldReader iworldreader, StructureManager structuremanager, int i2, int j2, int k2, boolean flag, long l2, RandomSpreadStructurePlacement randomspreadstructureplacement) {
        int i1 = randomspreadstructureplacement.b();
        for (int j1 = -k2; j1 <= k2; ++j1) {
            boolean flag1 = j1 == -k2 || j1 == k2;
            for (int k1 = -k2; k1 <= k2; ++k1) {
                boolean flag2;
                boolean bl = flag2 = k1 == -k2 || k1 == k2;
                if (!flag1 && !flag2) continue;
                int l1 = i2 + i1 * j1;
                int i22 = j2 + i1 * k1;
                ChunkCoordIntPair chunkcoordintpair = randomspreadstructureplacement.a(l2, l1, i22);
                if (!iworldreader.p_().isChunkInBounds(chunkcoordintpair.c, chunkcoordintpair.d)) continue;
                for (Holder<StructureFeature<?, ?>> holder : set) {
                    StructureCheckResult structurecheckresult = structuremanager.a(chunkcoordintpair, holder.a(), flag);
                    if (structurecheckresult == StructureCheckResult.b) continue;
                    if (!flag && structurecheckresult == StructureCheckResult.a) {
                        return Pair.of((Object)StructureGenerator.a(randomspreadstructureplacement, chunkcoordintpair), holder);
                    }
                    IChunkAccess ichunkaccess = iworldreader.a(chunkcoordintpair.c, chunkcoordintpair.d, ChunkStatus.d);
                    StructureStart structurestart = structuremanager.a(SectionPosition.a(ichunkaccess), holder.a(), ichunkaccess);
                    if (structurestart == null || !structurestart.b()) continue;
                    if (flag && structurestart.d()) {
                        structuremanager.a(structurestart);
                        return Pair.of((Object)StructureGenerator.a(randomspreadstructureplacement, structurestart.c()), holder);
                    }
                    if (flag) continue;
                    return Pair.of((Object)StructureGenerator.a(randomspreadstructureplacement, structurestart.c()), holder);
                }
            }
        }
        return null;
    }

    public void addVanillaDecorations(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        if (!SharedConstants.a(chunkcoordintpair)) {
            SectionPosition sectionposition = SectionPosition.a(chunkcoordintpair, generatoraccessseed.ai());
            BlockPosition blockposition = sectionposition.p();
            IRegistry<StructureFeature<?, ?>> iregistry = generatoraccessseed.s().d(IRegistry.aL);
            Map<Integer, List<StructureFeature>> map = iregistry.q().collect(Collectors.groupingBy(structurefeature -> ((StructureGenerator)structurefeature.d).a().ordinal()));
            List<WorldChunkManager.b> list = this.c.c();
            SeededRandom seededrandom = new SeededRandom(new XoroshiroRandomSource(RandomSupport.a()));
            long i2 = seededrandom.a(generatoraccessseed.D(), blockposition.u(), blockposition.w());
            ObjectArraySet set = new ObjectArraySet();
            if (this instanceof ChunkProviderFlat) {
                Stream<BiomeBase> stream = this.c.b().stream().map(Holder::a);
                Objects.requireNonNull(set);
                stream.forEach(((Set)set)::add);
            } else {
                ChunkCoordIntPair.a(sectionposition.r(), 1).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$11(generatoraccessseed, (Set)set, arg_0));
                set.retainAll(this.c.b().stream().map(Holder::a).collect(Collectors.toSet()));
            }
            int j2 = list.size();
            try {
                IRegistry<PlacedFeature> iregistry1 = generatoraccessseed.s().d(IRegistry.aK);
                int k2 = Math.max(WorldGenStage.Decoration.values().length, j2);
                for (int l2 = 0; l2 < k2; ++l2) {
                    int i1 = 0;
                    if (structuremanager.a()) {
                        List list1 = map.getOrDefault(l2, Collections.emptyList());
                        for (StructureFeature structurefeature2 : list1) {
                            seededrandom.b(i2, i1, l2);
                            Supplier<String> supplier = () -> {
                                Optional<String> optional = iregistry.c(structurefeature2).map(Object::toString);
                                Objects.requireNonNull(structurefeature2);
                                return (String)optional.orElseGet(structurefeature2::toString);
                            };
                            try {
                                generatoraccessseed.a(supplier);
                                structuremanager.a(sectionposition, structurefeature2).forEach(structurestart -> structurestart.a(generatoraccessseed, structuremanager, this, seededrandom, ChunkGenerator.a(ichunkaccess), chunkcoordintpair));
                            }
                            catch (Exception exception) {
                                CrashReport crashreport = CrashReport.a(exception, "Feature placement");
                                CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Feature");
                                Objects.requireNonNull(supplier);
                                crashreportsystemdetails.a("Description", supplier::get);
                                throw new ReportedException(crashreport);
                            }
                            ++i1;
                        }
                    }
                    if (l2 >= j2) continue;
                    IntArraySet intarrayset = new IntArraySet();
                    for (BiomeBase biomebase : set) {
                        List<HolderSet<PlacedFeature>> list2 = biomebase.e().b();
                        if (l2 >= list2.size()) continue;
                        HolderSet<PlacedFeature> holderset = list2.get(l2);
                        WorldChunkManager.b worldchunkmanager_b = list.get(l2);
                        holderset.a().map(Holder::a).forEach(placedfeature -> intarrayset.add(worldchunkmanager_b.b().applyAsInt((PlacedFeature)placedfeature)));
                    }
                    int j1 = intarrayset.size();
                    int[] aint = intarrayset.toIntArray();
                    Arrays.sort(aint);
                    WorldChunkManager.b worldchunkmanager_b1 = list.get(l2);
                    for (int k1 = 0; k1 < j1; ++k1) {
                        int l1 = aint[k1];
                        PlacedFeature placedfeature2 = worldchunkmanager_b1.a().get(l1);
                        Supplier<String> supplier1 = () -> {
                            Optional<String> optional = iregistry1.c(placedfeature2).map(Object::toString);
                            Objects.requireNonNull(placedfeature2);
                            return (String)optional.orElseGet(placedfeature2::toString);
                        };
                        long featurePopulationSeed = i2;
                        MinecraftKey location = iregistry1.b(placedfeature2);
                        long configFeatureSeed = generatoraccessseed.getMinecraftWorld().paperConfig.featureSeeds.getLong((Object)location);
                        if (configFeatureSeed != -1L) {
                            featurePopulationSeed = seededrandom.a(configFeatureSeed, blockposition.u(), blockposition.w());
                        }
                        seededrandom.b(featurePopulationSeed, l1, l2);
                        try {
                            generatoraccessseed.a(supplier1);
                            placedfeature2.b(generatoraccessseed, this, seededrandom, blockposition);
                            continue;
                        }
                        catch (Exception exception1) {
                            CrashReport crashreport1 = CrashReport.a(exception1, "Feature placement");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport1.a("Feature");
                            Objects.requireNonNull(supplier1);
                            crashreportsystemdetails.a("Description", supplier1::get);
                            throw new ReportedException(crashreport1);
                        }
                    }
                }
                generatoraccessseed.a((Supplier<String>)null);
            }
            catch (Exception exception2) {
                CrashReport crashreport2 = CrashReport.a(exception2, "Biome decoration");
                crashreport2.a("Generation").a("CenterX", chunkcoordintpair.c).a("CenterZ", chunkcoordintpair.d).a("Seed", i2);
                throw new ReportedException(crashreport2);
            }
        }
    }

    public void a(GeneratorAccessSeed world, IChunkAccess chunk, StructureManager structureAccessor) {
        this.applyBiomeDecoration(world, chunk, structureAccessor, true);
    }

    public void applyBiomeDecoration(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager, boolean vanilla) {
        CraftWorld world;
        if (vanilla) {
            this.addVanillaDecorations(generatoraccessseed, ichunkaccess, structuremanager);
        }
        if (!(world = generatoraccessseed.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(generatoraccessseed, ichunkaccess.f());
            int x2 = ichunkaccess.f().c;
            int z2 = ichunkaccess.f().d;
            for (BlockPopulator populator : world.getPopulators()) {
                SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(generatoraccessseed.D()));
                seededrandom.a(generatoraccessseed.D(), x2, z2);
                populator.populate((WorldInfo)world, (Random)seededrandom, x2, z2, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    public boolean a(ResourceKey<StructureSet> resourcekey, long i2, int j2, int k2, int l2) {
        StructureSet structureset = this.b.a(resourcekey);
        if (structureset == null) {
            return false;
        }
        StructurePlacement structureplacement = structureset.b();
        for (int i1 = j2 - l2; i1 <= j2 + l2; ++i1) {
            for (int j1 = k2 - l2; j1 <= k2 + l2; ++j1) {
                if (!structureplacement.a(this, i2, i1, j1)) continue;
                return true;
            }
        }
        return false;
    }

    private static StructureBoundingBox a(IChunkAccess chunk) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int i2 = chunkcoordintpair.d();
        int j2 = chunkcoordintpair.e();
        LevelHeightAccessor levelheightaccessor = chunk.z();
        int k2 = levelheightaccessor.u_() + 1;
        int l2 = levelheightaccessor.ag() - 1;
        return new StructureBoundingBox(i2, k2, j2, i2 + 15, l2, j2 + 15);
    }

    public abstract void a(RegionLimitedWorldAccess var1, StructureManager var2, IChunkAccess var3);

    public abstract void a(RegionLimitedWorldAccess var1);

    public int a(LevelHeightAccessor world) {
        return 64;
    }

    public WorldChunkManager e() {
        return this.d;
    }

    public abstract int f();

    public WeightedRandomList<BiomeSettingsMobs.c> a(Holder<BiomeBase> biome, StructureManager accessor, EnumCreatureType group, BlockPosition pos) {
        Map<StructureFeature<?, ?>, LongSet> map = accessor.b(pos);
        for (Map.Entry<StructureFeature<?, ?>, LongSet> entry : map.entrySet()) {
            StructureFeature<?, ?> structurefeature = entry.getKey();
            StructureSpawnOverride structurespawnoverride = structurefeature.g.get(group);
            if (structurespawnoverride == null) continue;
            MutableBoolean mutableboolean = new MutableBoolean(false);
            Predicate<StructureStart> predicate = structurespawnoverride.a() == StructureSpawnOverride.a.a ? structurestart -> accessor.a(pos, (StructureStart)structurestart) : structurestart -> structurestart.a().b(pos);
            accessor.a(structurefeature, entry.getValue(), (StructureStart structurestart) -> {
                if (mutableboolean.isFalse() && predicate.test((StructureStart)structurestart)) {
                    mutableboolean.setTrue();
                }
            });
            if (!mutableboolean.isTrue()) continue;
            return structurespawnoverride.b();
        }
        return biome.a().b().a(group);
    }

    public static Stream<StructureFeature<?, ?>> a(IRegistry<StructureFeature<?, ?>> iregistry, StructureGenerator<?> structuregenerator) {
        return iregistry.q().filter(structurefeature -> structurefeature.d == structuregenerator);
    }

    public void a(IRegistryCustom registryManager, StructureManager world, IChunkAccess chunk, DefinedStructureManager structureManager, long worldSeed) {
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        SectionPosition sectionposition = SectionPosition.a(chunk);
        this.a().forEach(holder -> {
            StructurePlacement structureplacement = ((StructureSet)holder.a()).b();
            List<StructureSet.a> list = ((StructureSet)holder.a()).a();
            for (StructureSet.a structureset_a : list) {
                StructureStart structurestart = world.a(sectionposition, structureset_a.a().a(), chunk);
                if (structurestart == null || !structurestart.b()) continue;
                return;
            }
            if (structureplacement.a(this, worldSeed, chunkcoordintpair.c, chunkcoordintpair.d)) {
                if (list.size() == 1) {
                    this.a(list.get(0), world, registryManager, structureManager, worldSeed, chunk, chunkcoordintpair, sectionposition);
                } else {
                    ArrayList<StructureSet.a> arraylist = new ArrayList<StructureSet.a>(list.size());
                    arraylist.addAll(list);
                    SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(0L));
                    seededrandom.c(worldSeed, chunkcoordintpair.c, chunkcoordintpair.d);
                    int j2 = 0;
                    for (StructureSet.a structureset_a1 : arraylist) {
                        j2 += structureset_a1.b();
                    }
                    while (!arraylist.isEmpty()) {
                        StructureSet.a structureset_a2;
                        int k2 = seededrandom.nextInt(j2);
                        int l2 = 0;
                        Iterator iterator2 = arraylist.iterator();
                        while (iterator2.hasNext() && (k2 -= (structureset_a2 = (StructureSet.a)iterator2.next()).b()) >= 0) {
                            ++l2;
                        }
                        StructureSet.a structureset_a3 = (StructureSet.a)arraylist.get(l2);
                        if (this.a(structureset_a3, world, registryManager, structureManager, worldSeed, chunk, chunkcoordintpair, sectionposition)) {
                            return;
                        }
                        arraylist.remove(l2);
                        j2 -= structureset_a3.b();
                    }
                }
            }
        });
    }

    private boolean a(StructureSet.a structureset_a, StructureManager structuremanager, IRegistryCustom iregistrycustom, DefinedStructureManager definedstructuremanager, long i2, IChunkAccess ichunkaccess, ChunkCoordIntPair chunkcoordintpair, SectionPosition sectionposition) {
        HolderSet<BiomeBase> holderset;
        Predicate<Holder<BiomeBase>> predicate;
        int j2;
        StructureFeature<?, ?> structurefeature = structureset_a.a().a();
        StructureStart structurestart = structurefeature.a(iregistrycustom, this, this.c, definedstructuremanager, i2, chunkcoordintpair, j2 = ChunkGenerator.a(structuremanager, ichunkaccess, sectionposition, structurefeature), ichunkaccess, predicate = arg_0 -> this.lambda$tryGenerateStructure$21(holderset = structurefeature.a(), arg_0));
        if (structurestart.b()) {
            structuremanager.a(sectionposition, structurefeature, structurestart, (IStructureAccess)ichunkaccess);
            return true;
        }
        return false;
    }

    private static int a(StructureManager structureAccessor, IChunkAccess chunk, SectionPosition sectionPos, StructureFeature<?, ?> structurefeature) {
        StructureStart structurestart = structureAccessor.a(sectionPos, structurefeature, chunk);
        return structurestart != null ? structurestart.f() : 0;
    }

    protected Holder<BiomeBase> a(Holder<BiomeBase> biome) {
        return biome;
    }

    public void a(GeneratorAccessSeed world, StructureManager structureAccessor, IChunkAccess chunk) {
        boolean flag = true;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        int i2 = chunkcoordintpair.c;
        int j2 = chunkcoordintpair.d;
        int k2 = chunkcoordintpair.d();
        int l2 = chunkcoordintpair.e();
        SectionPosition sectionposition = SectionPosition.a(chunk);
        for (int i1 = i2 - 8; i1 <= i2 + 8; ++i1) {
            for (int j1 = j2 - 8; j1 <= j2 + 8; ++j1) {
                long k1 = ChunkCoordIntPair.a(i1, j1);
                for (StructureStart structurestart : world.a(i1, j1).g().values()) {
                    try {
                        if (!structurestart.b() || !structurestart.a().a(k2, l2, k2 + 15, l2 + 15)) continue;
                        structureAccessor.a(sectionposition, structurestart.h(), k1, (IStructureAccess)chunk);
                        PacketDebug.a(world, structurestart);
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.a(exception, "Generating structure reference");
                        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Structure");
                        Optional<IRegistry<StructureFeature<?, ?>>> optional = world.s().c(IRegistry.aL);
                        crashreportsystemdetails.a("Id", () -> optional.map(iregistry -> iregistry.b(structurestart.h()).toString()).orElse("UNKNOWN"));
                        crashreportsystemdetails.a("Name", () -> IRegistry.aX.b((StructureGenerator<?>)structurestart.h().d).toString());
                        crashreportsystemdetails.a("Class", () -> structurestart.h().getClass().getCanonicalName());
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<IChunkAccess> a(Executor var1, Blender var2, StructureManager var3, IChunkAccess var4);

    public abstract int g();

    public abstract int h();

    public abstract int a(int var1, int var2, HeightMap.Type var3, LevelHeightAccessor var4);

    public abstract BlockColumn a(int var1, int var2, LevelHeightAccessor var3);

    public int b(int x2, int z2, HeightMap.Type heightmap, LevelHeightAccessor world) {
        return this.a(x2, z2, heightmap, world);
    }

    public int c(int x2, int z2, HeightMap.Type heightmap, LevelHeightAccessor world) {
        return this.a(x2, z2, heightmap, world) - 1;
    }

    public void i() {
        if (!this.i) {
            this.j();
            this.i = true;
        }
    }

    @Nullable
    public List<ChunkCoordIntPair> a(ConcentricRingsStructurePlacement structurePlacement) {
        this.i();
        CompletableFuture<List<ChunkCoordIntPair>> completablefuture = this.h.get(structurePlacement);
        return completablefuture != null ? completablefuture.join() : null;
    }

    private List<StructurePlacement> b(Holder<StructureFeature<?, ?>> holder) {
        this.i();
        return this.g.getOrDefault(holder.a(), List.of());
    }

    public abstract void a(List<String> var1, BlockPosition var2);

    private /* synthetic */ boolean lambda$tryGenerateStructure$21(HolderSet holderset, Holder holder) {
        return holderset.a(this.a(holder));
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$11(GeneratorAccessSeed generatoraccessseed, Set set, ChunkCoordIntPair chunkcoordintpair1) {
        IChunkAccess ichunkaccess1 = generatoraccessseed.a(chunkcoordintpair1.c, chunkcoordintpair1.d);
        for (ChunkSection chunksection : ichunkaccess1.d()) {
            chunksection.j().a((T holder) -> set.add((BiomeBase)holder.a()));
        }
    }

    static {
        IRegistry.a(IRegistry.bw, "noise", ChunkGeneratorAbstract.f);
        IRegistry.a(IRegistry.bw, "flat", ChunkProviderFlat.f);
        IRegistry.a(IRegistry.bw, "debug", ChunkProviderDebug.f);
        f = LogUtils.getLogger();
        a = IRegistry.bw.o().dispatchStable(ChunkGenerator::b, Function.identity());
    }
}

