/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class BlockStateInteger
extends IBlockState<Integer> {
    private final ImmutableSet<Integer> a;
    public final int min;
    public final int max;

    @Override
    public final int getIdFor(Integer value) {
        int val = value;
        int ret = val - this.min;
        return ret | this.max - ret >> 31;
    }

    protected BlockStateInteger(String name, int min, int max) {
        super(name, Integer.class);
        this.min = min;
        this.max = max;
        if (min < 0) {
            throw new IllegalArgumentException("Min value of " + name + " must be 0 or greater");
        }
        if (max <= min) {
            throw new IllegalArgumentException("Max value of " + name + " must be greater than min (" + min + ")");
        }
        HashSet set = Sets.newHashSet();
        for (int k2 = min; k2 <= max; ++k2) {
            set.add(k2);
        }
        this.a = ImmutableSet.copyOf((Collection)set);
    }

    @Override
    public Collection<Integer> a() {
        return this.a;
    }

    public boolean equals_unused(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BlockStateInteger && super.equals(object)) {
            BlockStateInteger blockstateinteger = (BlockStateInteger)object;
            return this.a.equals(blockstateinteger.a);
        }
        return false;
    }

    @Override
    public int b() {
        return 31 * super.b() + this.a.hashCode();
    }

    public static BlockStateInteger a(String name, int min, int max) {
        return new BlockStateInteger(name, min, max);
    }

    @Override
    public Optional<Integer> b(String name) {
        try {
            Integer integer = Integer.valueOf(name);
            return this.a.contains((Object)integer) ? Optional.of(integer) : Optional.empty();
        }
        catch (NumberFormatException numberformatexception) {
            return Optional.empty();
        }
    }

    @Override
    public String a(Integer value) {
        return value.toString();
    }
}

