/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import net.minecraft.world.level.block.entity.TileEntityBarrel;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import net.minecraft.world.level.block.entity.TileEntityBed;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityCampfire;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityChestTrapped;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.entity.TileEntityConduit;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityEnchantTable;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.entity.TileEntityFurnaceFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLightDetector;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class TileEntityTypes<T extends TileEntity> {
    private static final Logger I = LogUtils.getLogger();
    public static final TileEntityTypes<TileEntityFurnaceFurnace> a = TileEntityTypes.a("furnace", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityFurnaceFurnace::new, Blocks.cf));
    public static final TileEntityTypes<TileEntityChest> b = TileEntityTypes.a("chest", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityChest::new, Blocks.bX));
    public static final TileEntityTypes<TileEntityChestTrapped> c = TileEntityTypes.a("trapped_chest", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityChestTrapped::new, Blocks.fE));
    public static final TileEntityTypes<TileEntityEnderChest> d = TileEntityTypes.a("ender_chest", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityEnderChest::new, Blocks.ex));
    public static final TileEntityTypes<TileEntityJukeBox> e = TileEntityTypes.a("jukebox", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityJukeBox::new, Blocks.cQ));
    public static final TileEntityTypes<TileEntityDispenser> f = TileEntityTypes.a("dispenser", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityDispenser::new, Blocks.ay));
    public static final TileEntityTypes<TileEntityDropper> g = TileEntityTypes.a("dropper", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityDropper::new, Blocks.fR));
    public static final TileEntityTypes<TileEntitySign> h = TileEntityTypes.a("sign", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntitySign::new, Blocks.cg, Blocks.ch, Blocks.ci, Blocks.cj, Blocks.ck, Blocks.cl, Blocks.cq, Blocks.cr, Blocks.cs, Blocks.ct, Blocks.cu, Blocks.cv, Blocks.ni, Blocks.nk, Blocks.nj, Blocks.nl));
    public static final TileEntityTypes<TileEntityMobSpawner> i = TileEntityTypes.a("mob_spawner", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityMobSpawner::new, Blocks.bV));
    public static final TileEntityTypes<TileEntityPiston> j = TileEntityTypes.a("piston", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityPiston::new, Blocks.bu));
    public static final TileEntityTypes<TileEntityBrewingStand> k = TileEntityTypes.a("brewing_stand", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBrewingStand::new, Blocks.ej));
    public static final TileEntityTypes<TileEntityEnchantTable> l = TileEntityTypes.a("enchanting_table", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityEnchantTable::new, Blocks.ei));
    public static final TileEntityTypes<TileEntityEnderPortal> m = TileEntityTypes.a("end_portal", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityEnderPortal::new, Blocks.eo));
    public static final TileEntityTypes<TileEntityBeacon> n = TileEntityTypes.a("beacon", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBeacon::new, Blocks.eF));
    public static final TileEntityTypes<TileEntitySkull> o = TileEntityTypes.a("skull", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntitySkull::new, Blocks.fp, Blocks.fq, Blocks.fx, Blocks.fy, Blocks.fz, Blocks.fA, Blocks.ft, Blocks.fu, Blocks.fr, Blocks.fs, Blocks.fv, Blocks.fw));
    public static final TileEntityTypes<TileEntityLightDetector> p = TileEntityTypes.a("daylight_detector", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityLightDetector::new, Blocks.fI));
    public static final TileEntityTypes<TileEntityHopper> q = TileEntityTypes.a("hopper", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityHopper::new, Blocks.fL));
    public static final TileEntityTypes<TileEntityComparator> r = TileEntityTypes.a("comparator", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityComparator::new, Blocks.fH));
    public static final TileEntityTypes<TileEntityBanner> s = TileEntityTypes.a("banner", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBanner::new, Blocks.ho, Blocks.hp, Blocks.hq, Blocks.hr, Blocks.hs, Blocks.ht, Blocks.hu, Blocks.hv, Blocks.hw, Blocks.hx, Blocks.hy, Blocks.hz, Blocks.hA, Blocks.hB, Blocks.hC, Blocks.hD, Blocks.hE, Blocks.hF, Blocks.hG, Blocks.hH, Blocks.hI, Blocks.hJ, Blocks.hK, Blocks.hL, Blocks.hM, Blocks.hN, Blocks.hO, Blocks.hP, Blocks.hQ, Blocks.hR, Blocks.hS, Blocks.hT));
    public static final TileEntityTypes<TileEntityStructure> t = TileEntityTypes.a("structure_block", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityStructure::new, Blocks.nm));
    public static final TileEntityTypes<TileEntityEndGateway> u = TileEntityTypes.a("end_gateway", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityEndGateway::new, Blocks.iT));
    public static final TileEntityTypes<TileEntityCommand> v = TileEntityTypes.a("command_block", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityCommand::new, Blocks.eE, Blocks.iV, Blocks.iU));
    public static final TileEntityTypes<TileEntityShulkerBox> w = TileEntityTypes.a("shulker_box", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityShulkerBox::new, Blocks.jd, Blocks.jt, Blocks.jp, Blocks.jq, Blocks.jn, Blocks.jl, Blocks.jr, Blocks.jh, Blocks.jm, Blocks.jj, Blocks.jg, Blocks.jf, Blocks.jk, Blocks.jo, Blocks.js, Blocks.je, Blocks.ji));
    public static final TileEntityTypes<TileEntityBed> x = TileEntityTypes.a("bed", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBed::new, Blocks.aR, Blocks.aS, Blocks.aO, Blocks.aP, Blocks.aM, Blocks.aK, Blocks.aQ, Blocks.aG, Blocks.aL, Blocks.aI, Blocks.aF, Blocks.aE, Blocks.aJ, Blocks.aN, Blocks.aD, Blocks.aH));
    public static final TileEntityTypes<TileEntityConduit> y = TileEntityTypes.a("conduit", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityConduit::new, Blocks.lk));
    public static final TileEntityTypes<TileEntityBarrel> z = TileEntityTypes.a("barrel", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBarrel::new, Blocks.mg));
    public static final TileEntityTypes<TileEntitySmoker> A = TileEntityTypes.a("smoker", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntitySmoker::new, Blocks.mh));
    public static final TileEntityTypes<TileEntityBlastFurnace> B = TileEntityTypes.a("blast_furnace", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBlastFurnace::new, Blocks.mi));
    public static final TileEntityTypes<TileEntityLectern> C = TileEntityTypes.a("lectern", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityLectern::new, Blocks.mm));
    public static final TileEntityTypes<TileEntityBell> D = TileEntityTypes.a("bell", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBell::new, Blocks.mp));
    public static final TileEntityTypes<TileEntityJigsaw> E = TileEntityTypes.a("jigsaw", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityJigsaw::new, Blocks.nn));
    public static final TileEntityTypes<TileEntityCampfire> F = TileEntityTypes.a("campfire", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityCampfire::new, Blocks.ms, Blocks.mt));
    public static final TileEntityTypes<TileEntityBeehive> G = TileEntityTypes.a("beehive", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(TileEntityBeehive::new, Blocks.nq, Blocks.nr));
    public static final TileEntityTypes<SculkSensorBlockEntity> H = TileEntityTypes.a("sculk_sensor", net.minecraft.world.level.block.entity.TileEntityTypes$b.a(SculkSensorBlockEntity::new, Blocks.oP));
    private final a<? extends T> J;
    public final Set<Block> K;
    private final Type<?> L;

    @Nullable
    public static MinecraftKey a(TileEntityTypes<?> type) {
        return IRegistry.aa.b(type);
    }

    private static <T extends TileEntity> TileEntityTypes<T> a(String id, b<T> builder) {
        if (builder.b.isEmpty()) {
            I.warn("Block entity type {} requires at least one valid block to be defined!", (Object)id);
        }
        Type<?> type = SystemUtils.a(DataConverterTypes.l, id);
        return IRegistry.a(IRegistry.aa, id, builder.a(type));
    }

    public TileEntityTypes(a<? extends T> factory, Set<Block> blocks, Type<?> type) {
        this.J = factory;
        this.K = blocks;
        this.L = type;
    }

    @Nullable
    public T a(BlockPosition pos, IBlockData state) {
        return this.J.create(pos, state);
    }

    public boolean a(IBlockData state) {
        return this.K.contains(state.b());
    }

    @Nullable
    public T a(IBlockAccess world, BlockPosition pos) {
        TileEntity blockEntity = world.c_(pos);
        if (blockEntity == null || blockEntity.u() != this) {
            return null;
        }
        return (T)blockEntity;
    }

    public static final class b<T extends TileEntity> {
        private final a<? extends T> a;
        final Set<Block> b;

        private b(a<? extends T> factory, Set<Block> blocks) {
            this.a = factory;
            this.b = blocks;
        }

        public static <T extends TileEntity> b<T> a(a<? extends T> factory, Block ... blocks) {
            return new b<T>(factory, (Set<Block>)ImmutableSet.copyOf((Object[])blocks));
        }

        public TileEntityTypes<T> a(Type<?> type) {
            return new TileEntityTypes<T>(this.a, this.b, type);
        }
    }

    @FunctionalInterface
    static interface a<T extends TileEntity> {
        public T create(BlockPosition var1, IBlockData var2);
    }
}

