/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.players.UserCache;
import net.minecraft.util.UtilColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntitySkull
extends TileEntity {
    public static final String a = "SkullOwner";
    @Nullable
    private static UserCache b;
    @Nullable
    private static MinecraftSessionService c;
    @Nullable
    private static Executor d;
    @Nullable
    public GameProfile e;
    private int f;
    private boolean g;
    private static final boolean DEBUG_INVALID_SKULL_PROFILES;

    public TileEntitySkull(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.o, pos, state);
    }

    public static void a(UserCache userCache, MinecraftSessionService sessionService, Executor executor) {
        b = userCache;
        c = sessionService;
        d = executor;
    }

    public static void c() {
        b = null;
        c = null;
        d = null;
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.e != null) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            GameProfileSerializer.a(compoundTag, this.e);
            nbt.a(a, compoundTag);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        String string;
        super.a(nbt);
        if (nbt.b(a, 10)) {
            this.a(GameProfileSerializer.a(nbt.p(a)));
        } else if (nbt.b("ExtraType", 8) && !UtilColor.b(string = nbt.l("ExtraType"))) {
            this.a(new GameProfile((UUID)null, string));
        }
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntitySkull blockEntity) {
        if (world.q(pos)) {
            blockEntity.g = true;
            ++blockEntity.f;
        } else {
            blockEntity.g = false;
        }
    }

    public float a(float tickDelta) {
        return this.g ? (float)this.f + tickDelta : (float)this.f;
    }

    @Nullable
    public GameProfile d() {
        return this.e;
    }

    public PacketPlayOutTileEntityData f() {
        return PacketPlayOutTileEntityData.a(this, (TileEntity e2) -> TileEntitySkull.sanitizeTileEntityUUID(e2.aa_()));
    }

    public static NBTTagCompound sanitizeTileEntityUUID(NBTTagCompound cmp) {
        NBTTagCompound owner = cmp.p("Owner");
        if (!owner.f()) {
            TileEntitySkull.sanitizeUUID(owner);
        }
        return cmp;
    }

    public static void sanitizeUUID(NBTTagCompound owner) {
        String textures;
        NBTTagCompound properties = owner.p("Properties");
        NBTTagList list = null;
        if (!properties.f()) {
            list = properties.c("textures", 10);
        }
        if (list != null && !list.isEmpty() && (textures = ((NBTTagCompound)list.k(0)).l("Value")) != null && textures.length() > 3) {
            UUID uuid = UUID.nameUUIDFromBytes(textures.getBytes());
            owner.a("Id", uuid);
            return;
        }
        owner.a("Id", UUID.randomUUID());
    }

    @Override
    public NBTTagCompound aa_() {
        return this.o();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(@Nullable GameProfile owner) {
        TileEntitySkull tileEntitySkull = this;
        synchronized (tileEntitySkull) {
            this.e = owner;
        }
        this.g();
    }

    private void g() {
        TileEntitySkull.updateGameprofile(this.e, owner -> {
            this.e = owner;
            this.e();
        }, () -> {
            World level = this.k();
            return "SkullBlockEntity at " + this.p() + (String)(level == null ? "" : " in level: " + level.aa().a());
        });
    }

    public static void a(@Nullable GameProfile owner, Consumer<GameProfile> callback) {
        TileEntitySkull.updateGameprofile(owner, callback, null);
    }

    public static void updateGameprofile(@Nullable GameProfile owner, Consumer<GameProfile> callback, @Nullable Supplier<String> debugInfo) {
        if (!(owner == null || UtilColor.b(owner.getName()) || owner.isComplete() && owner.getProperties().containsKey((Object)"textures") || b == null || c == null)) {
            Throwable trace = DEBUG_INVALID_SKULL_PROFILES ? new Throwable("updateGameprofile caller debug trace") : null;
            b.a(owner.getName(), profile -> SystemUtils.PROFILE_EXECUTOR.execute(() -> TileEntitySkull.lambda$updateGameprofile$7(profile, callback, owner, trace, (Supplier)debugInfo)));
        } else {
            callback.accept(owner);
        }
    }

    private static /* synthetic */ void lambda$updateGameprofile$7(Optional profile, Consumer callback, GameProfile owner, Throwable trace, Supplier debugInfo) {
        try {
            SystemUtils.a(profile, (T profilex) -> {
                Property property = (Property)Iterables.getFirst((Iterable)profilex.getProperties().get((Object)"textures"), (Object)null);
                if (property == null) {
                    profilex = c.fillProfileProperties(profilex, true);
                }
                GameProfile gameProfile = profilex;
                d.execute(() -> {
                    b.a(gameProfile);
                    callback.accept(gameProfile);
                });
            }, () -> d.execute(() -> callback.accept(owner)));
        }
        catch (Exception ex) {
            if (trace != null) {
                ex.addSuppressed(trace);
            }
            String ownerMessage = "Original profile: '" + owner + "'";
            String debugMessage = " Run with -DPaper.debugInvalidSkullProfiles=true for further debug information.";
            String message = ownerMessage + (trace == null ? " Run with -DPaper.debugInvalidSkullProfiles=true for further debug information." : "");
            if (debugInfo == null) {
                throw new RuntimeException(message, ex);
            }
            throw new RuntimeException((String)debugInfo.get() + " " + message, ex);
        }
    }

    static {
        DEBUG_INVALID_SKULL_PROFILES = Boolean.getBoolean("Paper.debugInvalidSkullProfiles");
    }
}

