/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeHolder,
AutoRecipeOutput {
    protected static final int b = 0;
    protected static final int c = 1;
    protected static final int d = 2;
    public static final int e = 0;
    private static final int[] q = new int[]{0};
    private static final int[] r = new int[]{2, 1};
    private static final int[] s = new int[]{1};
    public static final int f = 1;
    public static final int g = 2;
    public static final int h = 3;
    public static final int i = 4;
    public static final int j = 200;
    public static final int k = 2;
    protected NonNullList<net.minecraft.world.item.ItemStack> l;
    public int t;
    int u;
    public double cookSpeedMultiplier = 1.0;
    public int v;
    public int w;
    protected final IContainerProperties m;
    private final Object2IntOpenHashMap<MinecraftKey> x;
    public final Recipes<? extends RecipeCooking> y;
    private static Map<Item, Integer> cachedBurnDurations = null;
    private int maxStack = 64;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected TileEntityFurnace(TileEntityTypes<?> blockEntityType, BlockPosition pos, IBlockData state, Recipes<? extends RecipeCooking> recipeType) {
        super(blockEntityType, pos, state);
        this.l = NonNullList.a(3, net.minecraft.world.item.ItemStack.b);
        this.m = new IContainerProperties(){

            @Override
            public int a(int index) {
                switch (index) {
                    case 0: {
                        return TileEntityFurnace.this.t;
                    }
                    case 1: {
                        return TileEntityFurnace.this.u;
                    }
                    case 2: {
                        return TileEntityFurnace.this.v;
                    }
                    case 3: {
                        return TileEntityFurnace.this.w;
                    }
                }
                return 0;
            }

            @Override
            public void a(int index, int value) {
                switch (index) {
                    case 0: {
                        TileEntityFurnace.this.t = value;
                        break;
                    }
                    case 1: {
                        TileEntityFurnace.this.u = value;
                        break;
                    }
                    case 2: {
                        TileEntityFurnace.this.v = value;
                        break;
                    }
                    case 3: {
                        TileEntityFurnace.this.w = value;
                    }
                }
            }

            @Override
            public int a() {
                return 4;
            }
        };
        this.x = new Object2IntOpenHashMap();
        this.y = recipeType;
    }

    public static Map<Item, Integer> f() {
        if (cachedBurnDurations != null) {
            return cachedBurnDurations;
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.nY, 20000);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.hg, 16000);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.pB, 2400);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.mi, 1600);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.mj, 1600);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.p, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.b, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.h, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.i, 150);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.l, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.k, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cR, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.iB, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.iA, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.iC, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.iE, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.iD, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.dZ, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.iw, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.iv, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.ix, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.iz, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.iy, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.aC, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.bO, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.mm, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cQ, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.bX, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.fE, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cc, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.fI, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.y, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.mg, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.or, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.cn, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.ag, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.my, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.mx, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.mB, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.mA, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.mz, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.g, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.ae, 1200);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.a, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.d, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.nb, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.n, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.nc, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, TagsItem.f, 67);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.ks, 4001);
        TileEntityFurnace.a((Map<Item, Integer>)map, Items.sT, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.lm, 50);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.aZ, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.me, 400);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.mf, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.mg, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.mj, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.mk, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.mn, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.no, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.pE, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map, Blocks.pF, 100);
        cachedBurnDurations = ImmutableMap.copyOf((Map)map);
        return cachedBurnDurations;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.l;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int N_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public Object2IntOpenHashMap<MinecraftKey> getRecipesUsed() {
        return this.x;
    }

    private static boolean b(Item item) {
        return item.k().a(TagsItem.Z);
    }

    private static void a(Map<Item, Integer> fuelTimes, TagKey<Item> tag, int fuelTime) {
        for (Holder<Item> holder : IRegistry.X.d(tag)) {
            if (TileEntityFurnace.b(holder.a())) continue;
            fuelTimes.put(holder.a(), fuelTime);
        }
    }

    private static void a(Map<Item, Integer> fuelTimes, IMaterial item, int fuelTime) {
        Item item1 = item.l();
        if (TileEntityFurnace.b(item1)) {
            if (SharedConstants.aI) {
                throw SystemUtils.c(new IllegalStateException("A developer tried to explicitly make fire resistant item " + item1.m(null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            fuelTimes.put(item1, fuelTime);
        }
    }

    private boolean i() {
        return this.t > 0;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.l = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.b);
        ContainerUtil.b(nbt, this.l);
        this.t = nbt.g("BurnTime");
        this.v = nbt.g("CookTime");
        this.w = nbt.g("CookTimeTotal");
        this.u = this.a(this.l.get(1));
        NBTTagCompound nbttagcompound1 = nbt.p("RecipesUsed");
        for (String s2 : nbttagcompound1.d()) {
            this.x.put((Object)new MinecraftKey(s2), nbttagcompound1.h(s2));
        }
        if (nbt.e("Paper.CookSpeedMultiplier")) {
            this.cookSpeedMultiplier = nbt.k("Paper.CookSpeedMultiplier");
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("BurnTime", (short)this.t);
        nbt.a("CookTime", (short)this.v);
        nbt.a("CookTimeTotal", (short)this.w);
        nbt.a("Paper.CookSpeedMultiplier", this.cookSpeedMultiplier);
        ContainerUtil.a(nbt, this.l);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.x.forEach((minecraftkey, integer) -> nbttagcompound1.a(minecraftkey.toString(), (int)integer));
        nbt.a("RecipesUsed", nbttagcompound1);
    }

    public static void a(World world, BlockPosition pos, IBlockData state, TileEntityFurnace blockEntity) {
        boolean flag = blockEntity.i();
        boolean flag1 = false;
        if (blockEntity.i()) {
            --blockEntity.t;
        }
        net.minecraft.world.item.ItemStack itemstack = blockEntity.l.get(1);
        if (!blockEntity.i() && (itemstack.b() || blockEntity.l.get(0).b())) {
            if (!blockEntity.i() && blockEntity.v > 0) {
                blockEntity.v = MathHelper.a(blockEntity.v - 2, 0, blockEntity.w);
            }
        } else {
            IRecipe irecipe = world.q().a(blockEntity.y, blockEntity, world).orElse(null);
            int i2 = blockEntity.N_();
            if (!blockEntity.i() && TileEntityFurnace.a(irecipe, blockEntity.l, i2)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemstack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(world, pos), (ItemStack)fuel, blockEntity.a(itemstack));
                world.getCraftServer().getPluginManager().callEvent((Event)furnaceBurnEvent);
                if (furnaceBurnEvent.isCancelled()) {
                    return;
                }
                blockEntity.u = blockEntity.t = furnaceBurnEvent.getBurnTime();
                if (blockEntity.i() && furnaceBurnEvent.isBurning()) {
                    flag1 = true;
                    if (!itemstack.b() && furnaceBurnEvent.willConsumeFuel()) {
                        Item item = itemstack.c();
                        itemstack.g(1);
                        if (itemstack.b()) {
                            Item item1 = item.s();
                            blockEntity.l.set(1, item1 == null ? net.minecraft.world.item.ItemStack.b : new net.minecraft.world.item.ItemStack(item1));
                        }
                    }
                }
            }
            if (blockEntity.i() && TileEntityFurnace.a(irecipe, blockEntity.l, i2)) {
                if (irecipe != null && blockEntity.v == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(blockEntity.l.get(0));
                    CookingRecipe recipe = (CookingRecipe)irecipe.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(world, pos), (ItemStack)source, recipe, TileEntityFurnace.getTotalCookTime(world, blockEntity.y, blockEntity, blockEntity.cookSpeedMultiplier));
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    blockEntity.w = event.getTotalCookTime();
                }
                ++blockEntity.v;
                if (blockEntity.v >= blockEntity.w) {
                    blockEntity.v = 0;
                    blockEntity.w = TileEntityFurnace.getTotalCookTime(world, blockEntity.y, blockEntity, blockEntity.cookSpeedMultiplier);
                    if (TileEntityFurnace.burn(blockEntity.n, blockEntity.o, irecipe, blockEntity.l, i2)) {
                        blockEntity.a(irecipe);
                    }
                    flag1 = true;
                }
            } else {
                blockEntity.v = 0;
            }
        }
        if (flag != blockEntity.i()) {
            flag1 = true;
            state = (IBlockData)state.a(BlockFurnace.b, blockEntity.i());
            world.a(pos, state, 3);
        }
        if (flag1) {
            TileEntityFurnace.a(world, pos, state);
        }
    }

    private static boolean a(@Nullable IRecipe<?> recipe, NonNullList<net.minecraft.world.item.ItemStack> slots, int count) {
        if (!slots.get(0).b() && recipe != null) {
            net.minecraft.world.item.ItemStack itemstack = recipe.c();
            if (itemstack.b()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = slots.get(2);
            return itemstack1.b() ? true : (!itemstack1.a(itemstack) ? false : (itemstack1.J() < count && itemstack1.J() < itemstack1.e() ? true : itemstack1.J() < itemstack.e()));
        }
        return false;
    }

    private static boolean burn(World world, BlockPosition blockposition, @Nullable IRecipe<?> irecipe, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (irecipe != null && TileEntityFurnace.a(irecipe, nonnulllist, i2)) {
            net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(0);
            net.minecraft.world.item.ItemStack itemstack1 = irecipe.c();
            net.minecraft.world.item.ItemStack itemstack2 = nonnulllist.get(2);
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, result, (CookingRecipe)irecipe.toBukkitRecipe());
            world.getCraftServer().getPluginManager().callEvent((Event)furnaceSmeltEvent);
            if (furnaceSmeltEvent.isCancelled()) {
                return false;
            }
            result = furnaceSmeltEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            if (!itemstack1.b()) {
                if (itemstack2.b()) {
                    nonnulllist.set(2, itemstack1.n());
                } else if (CraftItemStack.asCraftMirror(itemstack2).isSimilar(result)) {
                    itemstack2.f(itemstack1.J());
                } else {
                    return false;
                }
            }
            if (itemstack.a(Blocks.at.l()) && !nonnulllist.get(1).b() && nonnulllist.get(1).a(Items.nW)) {
                nonnulllist.set(1, new net.minecraft.world.item.ItemStack(Items.nX));
            }
            itemstack.g(1);
            return true;
        }
        return false;
    }

    protected int a(net.minecraft.world.item.ItemStack fuel) {
        if (fuel.b()) {
            return 0;
        }
        Item item = fuel.c();
        return TileEntityFurnace.f().getOrDefault(item, 0);
    }

    public static int getTotalCookTime(@Nullable World world, Recipes<? extends RecipeCooking> recipeType, IInventory inventory, double cookSpeedMultiplier) {
        int cookTime = (world != null ? world.q() : MinecraftServer.getServer().aC()).a(recipeType, inventory, world).map(RecipeCooking::e).orElse(200);
        return (int)Math.ceil((double)cookTime / cookSpeedMultiplier);
    }

    public static boolean b(net.minecraft.world.item.ItemStack stack) {
        return TileEntityFurnace.f().containsKey(stack.c());
    }

    @Override
    public int[] a(EnumDirection side) {
        return side == EnumDirection.a ? r : (side == EnumDirection.b ? q : s);
    }

    @Override
    public boolean a(int slot, net.minecraft.world.item.ItemStack stack, @Nullable EnumDirection dir) {
        return this.b(slot, stack);
    }

    @Override
    public boolean b(int slot, net.minecraft.world.item.ItemStack stack, EnumDirection dir) {
        return dir == EnumDirection.a && slot == 1 ? stack.a(Items.nX) || stack.a(Items.nW) : true;
    }

    @Override
    public int b() {
        return this.l.size();
    }

    @Override
    public boolean c() {
        net.minecraft.world.item.ItemStack itemstack;
        Iterator iterator = this.l.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (net.minecraft.world.item.ItemStack)iterator.next()).b());
        return false;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(int slot) {
        return this.l.get(slot);
    }

    @Override
    public net.minecraft.world.item.ItemStack a(int slot, int amount) {
        return ContainerUtil.a(this.l, slot, amount);
    }

    @Override
    public net.minecraft.world.item.ItemStack b(int slot) {
        return ContainerUtil.a(this.l, slot);
    }

    @Override
    public void a(int slot, net.minecraft.world.item.ItemStack stack) {
        net.minecraft.world.item.ItemStack itemstack1 = this.l.get(slot);
        boolean flag = !stack.b() && stack.a(itemstack1) && net.minecraft.world.item.ItemStack.a(stack, itemstack1);
        this.l.set(slot, stack);
        if (stack.J() > this.N_()) {
            stack.e(this.N_());
        }
        if (slot == 0 && !flag) {
            this.w = TileEntityFurnace.getTotalCookTime(this.n, this.y, this, this.cookSpeedMultiplier);
            this.v = 0;
            this.e();
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return this.n.c_(this.o) != this ? false : player.h((double)this.o.u() + 0.5, (double)this.o.v() + 0.5, (double)this.o.w() + 0.5) <= 64.0;
    }

    @Override
    public boolean b(int slot, net.minecraft.world.item.ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.l.get(1);
        return TileEntityFurnace.b(stack) || stack.a(Items.nW) && !itemstack1.a(Items.nW);
    }

    @Override
    public void a() {
        this.l.clear();
    }

    @Override
    public void a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            MinecraftKey minecraftkey = recipe.f();
            this.x.addTo((Object)minecraftkey, 1);
        }
    }

    @Override
    @Nullable
    public IRecipe<?> d() {
        return null;
    }

    @Override
    public void b(EntityHuman player) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<IRecipe<?>> list = this.getRecipesToAwardAndPopExperience(entityplayer.x(), entityplayer.cV(), this.o, entityplayer, itemstack, amount);
        entityplayer.a(list);
        this.x.clear();
    }

    public List<IRecipe<?>> a(WorldServer world, Vec3D pos) {
        return this.getRecipesToAwardAndPopExperience(world, pos, this.o, null, null, 0);
    }

    public List<IRecipe<?>> getRecipesToAwardAndPopExperience(WorldServer worldserver, Vec3D vec3d, BlockPosition blockposition, EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.x.object2IntEntrySet()) {
            worldserver.q().a((MinecraftKey)entry.getKey()).ifPresent(irecipe -> {
                list.add(irecipe);
                TileEntityFurnace.createExperience(worldserver, vec3d, entry.getIntValue(), ((RecipeCooking)irecipe).b(), blockposition, entityplayer, itemstack, amount);
            });
        }
        return list;
    }

    private static void createExperience(WorldServer worldserver, Vec3D vec3d, int i2, float f2, BlockPosition blockposition, EntityHuman entityhuman, net.minecraft.world.item.ItemStack itemstack, int amount) {
        int j2 = MathHelper.d((float)i2 * f2);
        float f1 = MathHelper.h((float)i2 * f2);
        if (f1 != 0.0f && Math.random() < (double)f1) {
            ++j2;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((Player)entityhuman.getBukkitEntity(), (Block)CraftBlock.at(worldserver, blockposition), CraftMagicNumbers.getMaterial(itemstack.c()), amount, j2) : new BlockExpEvent((Block)CraftBlock.at(worldserver, blockposition), j2);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        j2 = event.getExpToDrop();
        EntityExperienceOrb.award(worldserver, vec3d, j2, ExperienceOrb.SpawnReason.FURNACE, entityhuman);
    }

    @Override
    public void a(AutoRecipeStackManager finder) {
        for (net.minecraft.world.item.ItemStack itemstack : this.l) {
            finder.b(itemstack);
        }
    }
}

