/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.KeyedObject;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_18_R2.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_18_R2.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;

public abstract class TileEntity
implements KeyedObject {
    public Timing tickTimer = MinecraftTimings.getTileEntityTimings(this);
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer;
    public boolean isLoadingStructure = false;
    private static final Logger b = LogUtils.getLogger();
    private final TileEntityTypes<?> c;
    @Nullable
    protected World n;
    protected final BlockPosition o;
    protected boolean p;
    private IBlockData d;
    private String tileEntityKeyString = null;
    private MinecraftKey tileEntityKey = null;
    static boolean IGNORE_TILE_UPDATES = false;

    public TileEntity(TileEntityTypes<?> type, BlockPosition pos, IBlockData state) {
        this.c = type;
        this.o = pos.h();
        this.d = state;
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    }

    public static BlockPosition c(NBTTagCompound nbt) {
        return new BlockPosition(nbt.h("x"), nbt.h("y"), nbt.h("z"));
    }

    @Override
    public MinecraftKey getMinecraftKey() {
        if (this.tileEntityKey == null) {
            this.tileEntityKey = TileEntityTypes.a(this.c);
            this.tileEntityKeyString = this.tileEntityKey != null ? this.tileEntityKey.toString() : null;
        }
        return this.tileEntityKey;
    }

    @Override
    public String getMinecraftKeyString() {
        this.getMinecraftKey();
        return this.tileEntityKeyString;
    }

    @Nullable
    public World k() {
        return this.n;
    }

    public void a(World world) {
        this.n = world;
    }

    public boolean l() {
        return this.n != null;
    }

    public void a(NBTTagCompound nbt) {
        this.persistentDataContainer.clear();
        NBTBase persistentDataTag = nbt.c("PublicBukkitValues");
        if (persistentDataTag instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)persistentDataTag);
        }
    }

    protected void b(NBTTagCompound nbt) {
    }

    public final NBTTagCompound m() {
        NBTTagCompound nbttagcompound = this.o();
        this.e(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound n() {
        NBTTagCompound nbttagcompound = this.o();
        this.d(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound o() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.b(nbttagcompound);
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    private void d(NBTTagCompound nbt) {
        MinecraftKey minecraftkey = TileEntityTypes.a(this.u());
        if (minecraftkey == null) {
            throw new RuntimeException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        nbt.a("id", minecraftkey.toString());
    }

    public static void a(NBTTagCompound nbt, TileEntityTypes<?> type) {
        nbt.a("id", TileEntityTypes.a(type).toString());
    }

    public void e(ItemStack stack) {
        ItemBlock.a(stack, this.u(), this.o());
    }

    private void e(NBTTagCompound nbt) {
        this.d(nbt);
        nbt.a("x", this.o.u());
        nbt.a("y", this.o.v());
        nbt.a("z", this.o.w());
    }

    @Nullable
    public static TileEntity a(BlockPosition pos, IBlockData state, NBTTagCompound nbt) {
        String s2 = nbt.l("id");
        MinecraftKey minecraftkey = MinecraftKey.a(s2);
        if (minecraftkey == null) {
            b.error("Block entity has invalid type: {}", (Object)s2);
            return null;
        }
        return IRegistry.aa.b(minecraftkey).map(tileentitytypes -> {
            try {
                return tileentitytypes.a(pos, state);
            }
            catch (Throwable throwable) {
                b.error("Failed to create block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).map(tileentity -> {
            try {
                tileentity.a(nbt);
                return tileentity;
            }
            catch (Throwable throwable) {
                b.error("Failed to load data for block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).orElseGet(() -> {
            b.warn("Skipping BlockEntity with id {}", (Object)s2);
            return null;
        });
    }

    public void e() {
        if (this.n != null) {
            if (IGNORE_TILE_UPDATES) {
                return;
            }
            TileEntity.a(this.n, this.o, this.d);
        }
    }

    protected static void a(World world, BlockPosition pos, IBlockData state) {
        world.o(pos);
        if (!state.g()) {
            world.c(pos, state.b());
        }
    }

    public BlockPosition p() {
        return this.o;
    }

    public IBlockData q() {
        return this.d;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> h() {
        return null;
    }

    public NBTTagCompound aa_() {
        return new NBTTagCompound();
    }

    public boolean r() {
        return this.p;
    }

    public void ab_() {
        this.p = true;
    }

    public void s() {
        this.p = false;
    }

    public boolean a_(int type, int data) {
        return false;
    }

    public void a(CrashReportSystemDetails crashReportSection) {
        crashReportSection.a("Name", () -> {
            MinecraftKey minecraftkey = IRegistry.aa.b(this.u());
            return minecraftkey + " // " + this.getClass().getCanonicalName();
        });
        if (this.n != null) {
            IBlockData block = this.q();
            if (block != null) {
                CrashReportSystemDetails.a(crashReportSection, this.n, this.o, block);
            }
            CrashReportSystemDetails.a(crashReportSection, this.n, this.o, this.n.a_(this.o));
        }
    }

    public boolean t() {
        return false;
    }

    public TileEntityTypes<?> u() {
        return this.c;
    }

    @Deprecated
    public void b(IBlockData state) {
        this.d = state;
    }

    public InventoryHolder getOwner() {
        return this.getOwner(true);
    }

    public InventoryHolder getOwner(boolean useSnapshot) {
        if (this.n == null) {
            return null;
        }
        Block block = this.n.getWorld().getBlockAt(this.o.u(), this.o.v(), this.o.w());
        BlockState state = block.getState(useSnapshot);
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }
}

