/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;

public class PointedDripstoneBlock
extends Block
implements Fallable,
IBlockWaterlogged {
    public static final BlockStateDirection a = BlockProperties.bi;
    public static final BlockStateEnum<DripstoneThickness> b = BlockProperties.bj;
    public static final BlockStateBoolean c = BlockProperties.C;
    private static final int d = 11;
    private static final int e = 2;
    private static final float f = 0.02f;
    private static final float g = 0.12f;
    private static final int h = 11;
    private static final float i = 0.17578125f;
    private static final float j = 0.05859375f;
    private static final double k = 0.6;
    private static final float l = 1.0f;
    private static final int m = 40;
    private static final int n = 6;
    private static final float E = 2.0f;
    private static final int F = 2;
    private static final float G = 5.0f;
    private static final float H = 0.011377778f;
    private static final int I = 7;
    private static final int J = 10;
    private static final float K = 0.6875f;
    private static final VoxelShape L = Block.a(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape M = Block.a(5.0, 0.0, 5.0, 11.0, 11.0, 11.0);
    private static final VoxelShape N = Block.a(5.0, 5.0, 5.0, 11.0, 16.0, 11.0);
    private static final VoxelShape O = Block.a(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
    private static final VoxelShape P = Block.a(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    private static final VoxelShape Q = Block.a(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);
    private static final float R = 0.125f;
    private static final VoxelShape S = Block.a(6.0, 0.0, 6.0, 10.0, 16.0, 10.0);

    public PointedDripstoneBlock(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.D.b().a(a, EnumDirection.b)).a(b, DripstoneThickness.b)).a(c, false));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, b, c);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return PointedDripstoneBlock.c(world, pos, state.c(a));
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(c).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        if (direction != EnumDirection.b && direction != EnumDirection.a) {
            return state;
        }
        EnumDirection enumdirection1 = state.c(a);
        if (enumdirection1 == EnumDirection.a && world.M().a(pos, this)) {
            return state;
        }
        if (direction == enumdirection1.f() && !this.a(state, world, pos)) {
            if (enumdirection1 == EnumDirection.a) {
                world.a(pos, this, 2);
            } else {
                world.a(pos, this, 1);
            }
            return state;
        }
        boolean flag = state.c(b) == DripstoneThickness.a;
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.a(world, pos, enumdirection1, flag);
        return (IBlockData)state.a(b, dripstonethickness);
    }

    @Override
    public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        BlockPosition blockposition = hit.a();
        if (!world.x && projectile.a(world, blockposition) && projectile instanceof EntityThrownTrident && projectile.da().f() > 0.6) {
            if (CraftEventFactory.callEntityChangeBlockEvent(projectile, blockposition, Blocks.a.n()).isCancelled()) {
                return;
            }
            world.b(blockposition, true);
        }
    }

    @Override
    public void a(World world, IBlockData state, BlockPosition pos, Entity entity, float fallDistance) {
        if (state.c(a) == EnumDirection.b && state.c(b) == DripstoneThickness.b) {
            CraftEventFactory.blockDamage = CraftBlock.at(world, pos);
            entity.a(fallDistance + 2.0f, 2.0f, DamageSource.x);
            CraftEventFactory.blockDamage = null;
        } else {
            super.a(world, state, pos, entity, fallDistance);
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Random random) {
        float f2;
        if (PointedDripstoneBlock.h(state) && (f2 = random.nextFloat()) <= 0.12f) {
            PointedDripstoneBlock.b(world, pos, state).filter(fluidtype -> f2 < 0.02f || PointedDripstoneBlock.a(fluidtype)).ifPresent(fluidtype -> PointedDripstoneBlock.a(world, pos, state, fluidtype));
        }
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        if (PointedDripstoneBlock.o(state) && !this.a(state, (IWorldReader)world, pos)) {
            world.b(pos, true);
        } else {
            PointedDripstoneBlock.a(state, world, pos);
        }
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        PointedDripstoneBlock.a(state, world, pos, random.nextFloat());
        if (random.nextFloat() < 0.011377778f && PointedDripstoneBlock.b(state, (IWorldReader)world, pos)) {
            PointedDripstoneBlock.c(state, world, pos, random);
        }
    }

    @VisibleForTesting
    public static void a(IBlockData state, WorldServer world, BlockPosition pos, float dripChance) {
        if ((dripChance <= 0.17578125f || dripChance <= 0.05859375f) && PointedDripstoneBlock.b(state, (IWorldReader)world, pos)) {
            BlockPosition blockposition2;
            BlockPosition blockposition1;
            float f1;
            FluidType fluidtype = PointedDripstoneBlock.b(world, pos);
            if (fluidtype == FluidTypes.c) {
                f1 = 0.17578125f;
            } else {
                if (fluidtype != FluidTypes.e) {
                    return;
                }
                f1 = 0.05859375f;
            }
            if (dripChance < f1 && (blockposition1 = PointedDripstoneBlock.a(state, world, pos, 11, false)) != null && (blockposition2 = PointedDripstoneBlock.a((World)world, blockposition1, fluidtype)) != null) {
                world.c(1504, blockposition1, 0);
                int i2 = blockposition1.v() - blockposition2.v();
                int j2 = 50 + i2;
                IBlockData iblockdata1 = world.a_(blockposition2);
                world.a(blockposition2, iblockdata1.b(), j2);
            }
        }
    }

    @Override
    public EnumPistonReaction d(IBlockData state) {
        return EnumPistonReaction.b;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        EnumDirection enumdirection;
        BlockPosition blockposition;
        World world = ctx.q();
        EnumDirection enumdirection1 = PointedDripstoneBlock.b((IWorldReader)world, blockposition = ctx.a(), enumdirection = ctx.e().f());
        if (enumdirection1 == null) {
            return null;
        }
        boolean flag = !ctx.h();
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.a((IWorldReader)world, blockposition, enumdirection1, flag);
        return dripstonethickness == null ? null : (IBlockData)((IBlockData)((IBlockData)this.n().a(a, enumdirection1)).a(b, dripstonethickness)).a(c, world.b_(blockposition).a() == FluidTypes.c);
    }

    @Override
    public Fluid c_(IBlockData state) {
        return state.c(c) != false ? FluidTypes.c.a(false) : super.c_(state);
    }

    @Override
    public VoxelShape b_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return VoxelShapes.a();
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        DripstoneThickness dripstonethickness = state.c(b);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.a ? L : (dripstonethickness == DripstoneThickness.b ? (state.c(a) == EnumDirection.a ? N : M) : (dripstonethickness == DripstoneThickness.c ? O : (dripstonethickness == DripstoneThickness.d ? P : Q)));
        Vec3D vec3d = state.n(world, pos);
        return voxelshape.a(vec3d.b, 0.0, vec3d.d);
    }

    @Override
    public boolean a_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return false;
    }

    @Override
    public BlockBase.EnumRandomOffset U_() {
        return BlockBase.EnumRandomOffset.b;
    }

    @Override
    public float W_() {
        return 0.125f;
    }

    @Override
    public void a(World world, BlockPosition pos, EntityFallingBlock fallingBlockEntity) {
        if (!fallingBlockEntity.aL()) {
            world.c(1045, pos, 0);
        }
    }

    @Override
    public DamageSource b() {
        return DamageSource.w;
    }

    @Override
    public Predicate<Entity> V_() {
        return IEntitySelector.e.and(IEntitySelector.b);
    }

    private static void a(IBlockData state, WorldServer world, BlockPosition pos) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.i();
        IBlockData iblockdata1 = state;
        while (PointedDripstoneBlock.n(iblockdata1)) {
            EntityFallingBlock entityfallingblock = EntityFallingBlock.a(world, blockposition_mutableblockposition, iblockdata1);
            if (PointedDripstoneBlock.a(iblockdata1, true)) {
                int i2 = Math.max(1 + pos.v() - blockposition_mutableblockposition.v(), 6);
                float f2 = 1.0f * (float)i2;
                entityfallingblock.b(f2, 40);
                break;
            }
            blockposition_mutableblockposition.c(EnumDirection.a);
            iblockdata1 = world.a_(blockposition_mutableblockposition);
        }
    }

    @VisibleForTesting
    public static void c(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        IBlockData iblockdata3;
        BlockPosition blockposition1;
        IBlockData iblockdata2;
        IBlockData iblockdata1 = world.a_(pos.b(1));
        if (PointedDripstoneBlock.a(iblockdata1, iblockdata2 = world.a_(pos.b(2))) && (blockposition1 = PointedDripstoneBlock.a(state, world, pos, 7, false)) != null && PointedDripstoneBlock.h(iblockdata3 = world.a_(blockposition1)) && PointedDripstoneBlock.b(iblockdata3, world, blockposition1)) {
            if (random.nextBoolean()) {
                PointedDripstoneBlock.a(world, blockposition1, EnumDirection.a);
            } else {
                PointedDripstoneBlock.a(world, blockposition1);
            }
        }
    }

    private static void a(WorldServer world, BlockPosition pos) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.i();
        for (int i2 = 0; i2 < 10; ++i2) {
            blockposition_mutableblockposition.c(EnumDirection.a);
            IBlockData iblockdata = world.a_(blockposition_mutableblockposition);
            if (!iblockdata.o().c()) {
                return;
            }
            if (PointedDripstoneBlock.a(iblockdata, EnumDirection.b) && PointedDripstoneBlock.b(iblockdata, world, (BlockPosition)blockposition_mutableblockposition)) {
                PointedDripstoneBlock.a(world, (BlockPosition)blockposition_mutableblockposition, EnumDirection.b);
                return;
            }
            if (PointedDripstoneBlock.c(world, blockposition_mutableblockposition, EnumDirection.b) && !world.A(blockposition_mutableblockposition.c())) {
                PointedDripstoneBlock.a(world, blockposition_mutableblockposition.c(), EnumDirection.b);
                return;
            }
            if (PointedDripstoneBlock.b((IBlockAccess)world, (BlockPosition)blockposition_mutableblockposition, iblockdata)) continue;
            return;
        }
    }

    private static void a(WorldServer world, BlockPosition pos, EnumDirection direction) {
        BlockPosition blockposition1 = pos.a(direction);
        IBlockData iblockdata = world.a_(blockposition1);
        if (PointedDripstoneBlock.a(iblockdata, direction.f())) {
            PointedDripstoneBlock.a(iblockdata, (GeneratorAccess)world, blockposition1);
        } else if (iblockdata.g() || iblockdata.a(Blocks.A)) {
            PointedDripstoneBlock.createDripstone(world, blockposition1, direction, DripstoneThickness.b, pos);
        }
    }

    private static void createDripstone(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection enumdirection, DripstoneThickness dripstonethickness, BlockPosition source) {
        IBlockData iblockdata = (IBlockData)((IBlockData)((IBlockData)Blocks.pz.n().a(a, enumdirection)).a(b, dripstonethickness)).a(c, generatoraccess.b_(blockposition).a() == FluidTypes.c);
        CraftEventFactory.handleBlockSpreadEvent(generatoraccess, source, blockposition, iblockdata, 3);
    }

    private static void a(IBlockData state, GeneratorAccess world, BlockPosition pos) {
        BlockPosition blockposition2;
        BlockPosition blockposition1;
        if (state.c(a) == EnumDirection.b) {
            blockposition1 = pos;
            blockposition2 = pos.b();
        } else {
            blockposition2 = pos;
            blockposition1 = pos.c();
        }
        PointedDripstoneBlock.createDripstone(world, blockposition2, EnumDirection.a, DripstoneThickness.a, pos);
        PointedDripstoneBlock.createDripstone(world, blockposition1, EnumDirection.b, DripstoneThickness.a, pos);
    }

    public static void a(World world, BlockPosition pos, IBlockData state) {
        PointedDripstoneBlock.b(world, pos, state).ifPresent(fluidtype -> PointedDripstoneBlock.a(world, pos, state, fluidtype));
    }

    private static void a(World world, BlockPosition pos, IBlockData state, FluidType fluid) {
        Vec3D vec3d = state.n(world, pos);
        double d0 = 0.0625;
        double d1 = (double)pos.u() + 0.5 + vec3d.b;
        double d2 = (double)((float)(pos.v() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)pos.w() + 0.5 + vec3d.d;
        FluidType fluidtype1 = PointedDripstoneBlock.a(world, fluid);
        ParticleType particletype = fluidtype1.a(TagsFluid.b) ? Particles.aA : Particles.aC;
        world.a(particletype, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPosition a(IBlockData state, GeneratorAccess world, BlockPosition pos, int range, boolean allowMerged) {
        if (PointedDripstoneBlock.a(state, allowMerged)) {
            return pos;
        }
        EnumDirection enumdirection = state.c(a);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.a(Blocks.pz) && iblockdata1.c(a) == enumdirection;
        return PointedDripstoneBlock.a(world, pos, enumdirection.e(), bipredicate, (IBlockData iblockdata1) -> PointedDripstoneBlock.a(iblockdata1, allowMerged), range).orElse(null);
    }

    @Nullable
    private static EnumDirection b(IWorldReader world, BlockPosition pos, EnumDirection direction) {
        EnumDirection enumdirection1;
        if (PointedDripstoneBlock.c(world, pos, direction)) {
            enumdirection1 = direction;
        } else {
            if (!PointedDripstoneBlock.c(world, pos, direction.f())) {
                return null;
            }
            enumdirection1 = direction.f();
        }
        return enumdirection1;
    }

    private static DripstoneThickness a(IWorldReader world, BlockPosition pos, EnumDirection direction, boolean tryMerge) {
        EnumDirection enumdirection1 = direction.f();
        IBlockData iblockdata = world.a_(pos.a(direction));
        if (PointedDripstoneBlock.b(iblockdata, enumdirection1)) {
            return !tryMerge && iblockdata.c(b) != DripstoneThickness.a ? DripstoneThickness.b : DripstoneThickness.a;
        }
        if (!PointedDripstoneBlock.b(iblockdata, direction)) {
            return DripstoneThickness.b;
        }
        DripstoneThickness dripstonethickness = iblockdata.c(b);
        if (dripstonethickness != DripstoneThickness.b && dripstonethickness != DripstoneThickness.a) {
            IBlockData iblockdata1 = world.a_(pos.a(enumdirection1));
            return !PointedDripstoneBlock.b(iblockdata1, direction) ? DripstoneThickness.e : DripstoneThickness.d;
        }
        return DripstoneThickness.c;
    }

    public static boolean h(IBlockData state) {
        return PointedDripstoneBlock.n(state) && state.c(b) == DripstoneThickness.b && state.c(c) == false;
    }

    private static boolean b(IBlockData state, WorldServer world, BlockPosition pos) {
        EnumDirection enumdirection = state.c(a);
        BlockPosition blockposition1 = pos.a(enumdirection);
        IBlockData iblockdata1 = world.a_(blockposition1);
        return !iblockdata1.o().c() ? false : (iblockdata1.g() ? true : PointedDripstoneBlock.a(iblockdata1, enumdirection.f()));
    }

    private static Optional<BlockPosition> a(World world, BlockPosition pos, IBlockData state, int range) {
        EnumDirection enumdirection = state.c(a);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.a(Blocks.pz) && iblockdata1.c(a) == enumdirection;
        return PointedDripstoneBlock.a(world, pos, enumdirection.f().e(), bipredicate, (IBlockData iblockdata1) -> !iblockdata1.a(Blocks.pz), range);
    }

    private static boolean c(IWorldReader world, BlockPosition pos, EnumDirection direction) {
        BlockPosition blockposition1 = pos.a(direction.f());
        IBlockData iblockdata = world.a_(blockposition1);
        return iblockdata.d(world, blockposition1, direction) || PointedDripstoneBlock.b(iblockdata, direction);
    }

    private static boolean a(IBlockData state, boolean allowMerged) {
        if (!state.a(Blocks.pz)) {
            return false;
        }
        DripstoneThickness dripstonethickness = state.c(b);
        return dripstonethickness == DripstoneThickness.b || allowMerged && dripstonethickness == DripstoneThickness.a;
    }

    private static boolean a(IBlockData state, EnumDirection direction) {
        return PointedDripstoneBlock.a(state, false) && state.c(a) == direction;
    }

    private static boolean n(IBlockData state) {
        return PointedDripstoneBlock.b(state, EnumDirection.a);
    }

    private static boolean o(IBlockData state) {
        return PointedDripstoneBlock.b(state, EnumDirection.b);
    }

    private static boolean b(IBlockData state, IWorldReader world, BlockPosition pos) {
        return PointedDripstoneBlock.n(state) && !world.a_(pos.b()).a(Blocks.pz);
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    private static boolean b(IBlockData state, EnumDirection direction) {
        return state.a(Blocks.pz) && state.c(a) == direction;
    }

    @Nullable
    private static BlockPosition a(World world, BlockPosition pos, FluidType fluid) {
        Predicate<IBlockData> predicate = iblockdata -> iblockdata.b() instanceof AbstractCauldronBlock && ((AbstractCauldronBlock)iblockdata.b()).a(fluid);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.b((IBlockAccess)world, blockposition1, iblockdata);
        return PointedDripstoneBlock.a(world, pos, EnumDirection.a.e(), bipredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPosition a(World world, BlockPosition pos) {
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.b((IBlockAccess)world, blockposition1, iblockdata);
        return PointedDripstoneBlock.a(world, pos, EnumDirection.b.e(), bipredicate, PointedDripstoneBlock::h, 11).orElse(null);
    }

    public static FluidType b(World world, BlockPosition pos) {
        return PointedDripstoneBlock.b(world, pos, world.a_(pos)).filter(PointedDripstoneBlock::a).orElse(FluidTypes.a);
    }

    private static Optional<FluidType> b(World world, BlockPosition pos, IBlockData state) {
        return !PointedDripstoneBlock.n(state) ? Optional.empty() : PointedDripstoneBlock.a(world, pos, state, 11).map(blockposition1 -> world.b_(blockposition1.b()).a());
    }

    private static boolean a(FluidType fluid) {
        return fluid == FluidTypes.e || fluid == FluidTypes.c;
    }

    private static boolean a(IBlockData dripstoneBlockState, IBlockData waterState) {
        return dripstoneBlockState.a(Blocks.pA) && waterState.a(Blocks.A) && waterState.o().b();
    }

    private static FluidType a(World world, FluidType fluid) {
        return fluid.a(FluidTypes.a) ? (world.q_().c() ? FluidTypes.e : FluidTypes.c) : fluid;
    }

    private static Optional<BlockPosition> a(GeneratorAccess world, BlockPosition pos, EnumDirection.EnumAxisDirection direction, BiPredicate<BlockPosition, IBlockData> continuePredicate, Predicate<IBlockData> stopPredicate, int range) {
        EnumDirection enumdirection = EnumDirection.a(direction, EnumDirection.EnumAxis.b);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = pos.i();
        for (int j2 = 1; j2 < range; ++j2) {
            blockposition_mutableblockposition.c(enumdirection);
            IBlockData iblockdata = world.a_(blockposition_mutableblockposition);
            if (stopPredicate.test(iblockdata)) {
                return Optional.of(blockposition_mutableblockposition.h());
            }
            if (!world.d(blockposition_mutableblockposition.v()) && continuePredicate.test(blockposition_mutableblockposition, iblockdata)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean b(IBlockAccess world, BlockPosition pos, IBlockData state) {
        if (state.g()) {
            return true;
        }
        if (state.i(world, pos)) {
            return false;
        }
        if (!state.o().c()) {
            return false;
        }
        VoxelShape voxelshape = state.k(world, pos);
        return !VoxelShapes.c(S, voxelshape, OperatorBoolean.i);
    }
}

