/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;

public class MultifaceBlock
extends Block {
    private static final float b = 1.0f;
    private static final VoxelShape c = Block.a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape d = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape e = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape f = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape g = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape h = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, BlockStateBoolean> i = BlockSprawling.g;
    private static final Map<EnumDirection, VoxelShape> j = SystemUtils.a(Maps.newEnumMap(EnumDirection.class), (T enummap) -> {
        enummap.put(EnumDirection.c, g);
        enummap.put(EnumDirection.f, f);
        enummap.put(EnumDirection.d, h);
        enummap.put(EnumDirection.e, e);
        enummap.put(EnumDirection.b, c);
        enummap.put(EnumDirection.a, d);
    });
    protected static final EnumDirection[] a = EnumDirection.values();
    private final ImmutableMap<IBlockData, VoxelShape> k;
    private final boolean l;
    private final boolean m;
    private final boolean n;

    public MultifaceBlock(BlockBase.Info settings) {
        super(settings);
        this.k(MultifaceBlock.a(this.D));
        this.k = this.a(MultifaceBlock::o);
        this.l = EnumDirection.EnumDirectionLimit.a.a().allMatch(this::a);
        this.m = EnumDirection.EnumDirectionLimit.a.a().filter(EnumDirection.EnumAxis.a).filter(this::a).count() % 2L == 0L;
        this.n = EnumDirection.EnumDirectionLimit.a.a().filter(EnumDirection.EnumAxis.c).filter(this::a).count() % 2L == 0L;
    }

    protected boolean a(EnumDirection direction) {
        return true;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        for (EnumDirection enumdirection : a) {
            if (!this.a(enumdirection)) continue;
            builder.a(new IBlockState[]{MultifaceBlock.b(enumdirection)});
        }
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        return !MultifaceBlock.h(state) ? Blocks.a.n() : (MultifaceBlock.a(state, direction) && !MultifaceBlock.a(world, direction, neighborPos, neighborState) ? MultifaceBlock.a(state, MultifaceBlock.b(direction)) : state);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return (VoxelShape)this.k.get((Object)state);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        boolean flag = false;
        for (EnumDirection enumdirection : a) {
            if (!MultifaceBlock.a(state, enumdirection)) continue;
            BlockPosition blockposition1 = pos.a(enumdirection);
            if (!MultifaceBlock.a(world, enumdirection, blockposition1, world.a_(blockposition1))) {
                return false;
            }
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean a(IBlockData state, BlockActionContext context) {
        return MultifaceBlock.p(state);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        World world = ctx.q();
        BlockPosition blockposition = ctx.a();
        IBlockData iblockdata = world.a_(blockposition);
        return Arrays.stream(ctx.f()).map(enumdirection -> this.c(iblockdata, (IBlockAccess)world, blockposition, (EnumDirection)enumdirection)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    public IBlockData c(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        IBlockData iblockdata1;
        if (!this.a(direction)) {
            return null;
        }
        if (state.a(this)) {
            if (MultifaceBlock.a(state, direction)) {
                return null;
            }
            iblockdata1 = state;
        } else {
            iblockdata1 = this.r() && state.o().a(FluidTypes.c) ? (IBlockData)this.n().a(BlockProperties.C, true) : this.n();
        }
        BlockPosition blockposition1 = pos.a(direction);
        return MultifaceBlock.a(world, direction, blockposition1, world.a_(blockposition1)) ? (IBlockData)iblockdata1.a(MultifaceBlock.b(direction), true) : null;
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        if (!this.l) {
            return state;
        }
        Objects.requireNonNull(rotation);
        return this.a(state, rotation::a);
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        if (mirror == EnumBlockMirror.c && !this.m) {
            return state;
        }
        if (mirror == EnumBlockMirror.b && !this.n) {
            return state;
        }
        Objects.requireNonNull(mirror);
        return this.a(state, mirror::b);
    }

    private IBlockData a(IBlockData state, Function<EnumDirection, EnumDirection> mirror) {
        IBlockData iblockdata1 = state;
        for (EnumDirection enumdirection : a) {
            if (!this.a(enumdirection)) continue;
            iblockdata1 = (IBlockData)iblockdata1.a(MultifaceBlock.b(mirror.apply(enumdirection)), state.c(MultifaceBlock.b(enumdirection)));
        }
        return iblockdata1;
    }

    public boolean c(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        ArrayList list = Lists.newArrayList((Object[])a);
        Collections.shuffle(list);
        return list.stream().filter(enumdirection -> MultifaceBlock.a(state, enumdirection)).anyMatch(enumdirection -> this.a(state, (GeneratorAccess)world, pos, (EnumDirection)enumdirection, random, false));
    }

    public boolean a(IBlockData state, GeneratorAccess world, BlockPosition pos, EnumDirection from, Random random, boolean postProcess) {
        List<EnumDirection> list = Arrays.asList(a);
        Collections.shuffle(list, random);
        return list.stream().anyMatch(enumdirection1 -> this.a(state, world, pos, from, (EnumDirection)enumdirection1, postProcess));
    }

    public boolean a(IBlockData state, GeneratorAccess world, BlockPosition pos, EnumDirection from, EnumDirection to, boolean postProcess) {
        Optional<Pair<BlockPosition, EnumDirection>> optional = this.a(state, (IBlockAccess)world, pos, from, to);
        if (optional.isPresent()) {
            Pair<BlockPosition, EnumDirection> pair = optional.get();
            return this.spreadToFace(world, (BlockPosition)pair.getFirst(), (EnumDirection)pair.getSecond(), postProcess, pos);
        }
        return false;
    }

    protected boolean d(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection from) {
        return Stream.of(a).anyMatch(enumdirection1 -> this.a(state, world, pos, from, (EnumDirection)enumdirection1).isPresent());
    }

    private Optional<Pair<BlockPosition, EnumDirection>> a(IBlockData state, IBlockAccess world, BlockPosition pos, EnumDirection from, EnumDirection to) {
        if (to.n() != from.n() && MultifaceBlock.a(state, from) && !MultifaceBlock.a(state, to)) {
            EnumDirection enumdirection2;
            if (this.a(world, pos, to)) {
                return Optional.of(Pair.of((Object)pos, (Object)to));
            }
            BlockPosition blockposition1 = pos.a(to);
            if (this.a(world, blockposition1, from)) {
                return Optional.of(Pair.of((Object)blockposition1, (Object)from));
            }
            BlockPosition blockposition2 = blockposition1.a(from);
            return this.a(world, blockposition2, enumdirection2 = to.f()) ? Optional.of(Pair.of((Object)blockposition2, (Object)enumdirection2)) : Optional.empty();
        }
        return Optional.empty();
    }

    private boolean a(IBlockAccess world, BlockPosition pos, EnumDirection direction) {
        IBlockData iblockdata = world.a_(pos);
        if (!this.n(iblockdata)) {
            return false;
        }
        IBlockData iblockdata1 = this.c(iblockdata, world, pos, direction);
        return iblockdata1 != null;
    }

    private boolean spreadToFace(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection enumdirection, boolean flag, BlockPosition source) {
        IBlockData iblockdata = generatoraccess.a_(blockposition);
        IBlockData iblockdata1 = this.c(iblockdata, (IBlockAccess)generatoraccess, blockposition, enumdirection);
        if (iblockdata1 != null) {
            if (flag) {
                generatoraccess.z(blockposition).e(blockposition);
            }
            return CraftEventFactory.handleBlockSpreadEvent(generatoraccess, source, blockposition, iblockdata1, 2);
        }
        return false;
    }

    private boolean n(IBlockData state) {
        return state.g() || state.a(this) || state.a(Blocks.A) && state.o().b();
    }

    private static boolean a(IBlockData state, EnumDirection direction) {
        BlockStateBoolean blockstateboolean = MultifaceBlock.b(direction);
        return state.b(blockstateboolean) && state.c(blockstateboolean) != false;
    }

    private static boolean a(IBlockAccess world, EnumDirection direction, BlockPosition pos, IBlockData state) {
        return Block.a(state.k(world, pos), direction.f());
    }

    private boolean r() {
        return this.D.d().contains(BlockProperties.C);
    }

    private static IBlockData a(IBlockData state, BlockStateBoolean direction) {
        IBlockData iblockdata1 = (IBlockData)state.a(direction, false);
        return MultifaceBlock.h(iblockdata1) ? iblockdata1 : Blocks.a.n();
    }

    public static BlockStateBoolean b(EnumDirection direction) {
        return i.get(direction);
    }

    private static IBlockData a(BlockStateList<Block, IBlockData> stateManager) {
        IBlockData iblockdata = stateManager.b();
        for (BlockStateBoolean blockstateboolean : i.values()) {
            if (!iblockdata.b(blockstateboolean)) continue;
            iblockdata = (IBlockData)iblockdata.a(blockstateboolean, false);
        }
        return iblockdata;
    }

    private static VoxelShape o(IBlockData state) {
        VoxelShape voxelshape = VoxelShapes.a();
        for (EnumDirection enumdirection : a) {
            if (!MultifaceBlock.a(state, enumdirection)) continue;
            voxelshape = VoxelShapes.a(voxelshape, j.get(enumdirection));
        }
        return voxelshape.b() ? VoxelShapes.b() : voxelshape;
    }

    protected static boolean h(IBlockData state) {
        return Arrays.stream(a).anyMatch(enumdirection -> MultifaceBlock.a(state, enumdirection));
    }

    private static boolean p(IBlockData state) {
        return Arrays.stream(a).anyMatch(enumdirection -> !MultifaceBlock.a(state, enumdirection));
    }
}

