/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.event.block.NotePlayEvent;

public class BlockNote
extends Block {
    public static final BlockStateEnum<BlockPropertyInstrument> a = BlockProperties.bb;
    public static final BlockStateBoolean b = BlockProperties.w;
    public static final BlockStateInteger c = BlockProperties.aM;

    public BlockNote(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.D.b().a(a, BlockPropertyInstrument.a)).a(c, 0)).a(b, false));
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        return (IBlockData)this.n().a(a, BlockPropertyInstrument.a(ctx.q().a_(ctx.a().c())));
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        return direction == EnumDirection.a ? (IBlockData)state.a(a, BlockPropertyInstrument.a(neighborState)) : super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block block, BlockPosition fromPos, boolean notify) {
        boolean flag1 = world.q(pos);
        if (flag1 != state.c(b)) {
            if (flag1) {
                this.playNote(world, pos, state);
                state = world.a_(pos);
            }
            world.a(pos, (IBlockData)state.a(b, flag1), 3);
        }
    }

    private void playNote(World world, BlockPosition blockposition, IBlockData data) {
        if (world.a_(blockposition.b()).g()) {
            world.a(blockposition, (Block)this, 0, 0);
        }
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (world.x) {
            return EnumInteractionResult.a;
        }
        state = (IBlockData)state.a(c);
        world.a(pos, state, 3);
        this.playNote(world, pos, state);
        player.a(StatisticList.ag);
        return EnumInteractionResult.b;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, EntityHuman player) {
        if (!world.x) {
            this.playNote(world, pos, state);
            player.a(StatisticList.af);
        }
    }

    @Override
    public boolean a(IBlockData state, World world, BlockPosition pos, int type, int data) {
        NotePlayEvent event = CraftEventFactory.callNotePlayEvent(world, pos, state.c(a), state.c(c));
        if (event.isCancelled()) {
            return false;
        }
        byte k2 = event.getNote().getId();
        float f2 = (float)Math.pow(2.0, (double)(k2 - 12) / 12.0);
        world.a(null, pos, CraftBlockData.toNMS(event.getInstrument(), BlockPropertyInstrument.class).a(), SoundCategory.c, 3.0f, f2);
        world.a(Particles.Q, (double)pos.u() + 0.5, (double)pos.v() + 1.2, (double)pos.w() + 0.5, (double)k2 / 24.0, 0.0, 0.0);
        return true;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, b, c);
    }
}

