/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.TreeType;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;

public class BlockMushroom
extends BlockPlant
implements IBlockFragilePlantElement {
    protected static final float a = 3.0f;
    protected static final VoxelShape b = Block.a(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final Supplier<Holder<? extends WorldGenFeatureConfigured<?, ?>>> c;

    public BlockMushroom(BlockBase.Info settings, Supplier<Holder<? extends WorldGenFeatureConfigured<?, ?>>> feature) {
        super(settings);
        this.c = feature;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        if (random.nextInt(Math.max(1, (int)(100.0f / (float)world.spigotConfig.mushroomModifier) * 25)) == 0) {
            int i2 = 5;
            boolean flag = true;
            for (BlockPosition blockposition1 : BlockPosition.a(pos.b(-4, -1, -4), pos.b(4, 1, 4))) {
                if (!world.a_(blockposition1).a(this) || --i2 > 0) continue;
                return;
            }
            BlockPosition blockposition2 = pos.b(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            for (int j2 = 0; j2 < 4; ++j2) {
                if (world.w(blockposition2) && state.a((IWorldReader)world, blockposition2)) {
                    pos = blockposition2;
                }
                blockposition2 = pos.b(random.nextInt(3) - 1, random.nextInt(2) - random.nextInt(2), random.nextInt(3) - 1);
            }
            if (world.w(blockposition2) && state.a((IWorldReader)world, blockposition2)) {
                CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition2, state, 2);
            }
        }
    }

    @Override
    protected boolean d(IBlockData floor, IBlockAccess world, BlockPosition pos) {
        return floor.i(world, pos);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.c();
        IBlockData iblockdata1 = world.a_(blockposition1);
        return iblockdata1.a(TagsBlock.aN) ? true : world.b(pos, 0) < 13 && this.d(iblockdata1, world, blockposition1);
    }

    public boolean a(WorldServer world, BlockPosition pos, IBlockData state, Random random) {
        world.a(pos, false);
        TreeType treeType = BlockSapling.treeType = this == Blocks.bI ? TreeType.BROWN_MUSHROOM : TreeType.BROWN_MUSHROOM;
        if (this.c.get().a().a(world, world.k().g(), random, pos)) {
            return true;
        }
        world.a(pos, state, 3);
        return false;
    }

    @Override
    public boolean a(IBlockAccess world, BlockPosition pos, IBlockData state, boolean isClient) {
        return true;
    }

    @Override
    public boolean a(World world, Random random, BlockPosition pos, IBlockData state) {
        return (double)random.nextFloat() < 0.4;
    }

    @Override
    public void a(WorldServer world, Random random, BlockPosition pos, IBlockData state) {
        this.a(world, pos, state, random);
    }
}

