/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;

public abstract class BlockGrowingTop
extends BlockGrowingAbstract
implements IBlockFragilePlantElement {
    public static final BlockStateInteger d = BlockProperties.as;
    public static final int e = 25;
    private final double f;

    protected BlockGrowingTop(BlockBase.Info settings, EnumDirection growthDirection, VoxelShape outlineShape, boolean tickWater, double growthChance) {
        super(settings, growthDirection, outlineShape, tickWater);
        this.f = growthChance;
        this.k((IBlockData)this.D.b().a(d, 0));
    }

    @Override
    public IBlockData a(GeneratorAccess world) {
        return (IBlockData)this.n().a(d, world.r_().nextInt(25));
    }

    @Override
    public boolean e_(IBlockData state) {
        return state.c(d) < 25;
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        BlockPosition blockposition1;
        int modifier = state.a(Blocks.mN) || state.a(Blocks.mO) ? world.spigotConfig.twistingVinesModifier : (state.a(Blocks.mL) || state.a(Blocks.mM) ? world.spigotConfig.weepingVinesModifier : (state.a(Blocks.pB) || state.a(Blocks.pC) ? world.spigotConfig.caveVinesModifier : (state.a(Blocks.kq) || state.a(Blocks.kr) ? world.spigotConfig.kelpModifier : 100)));
        if (state.c(d) < 25 && random.nextDouble() < (double)modifier / 100.0 * this.f && this.g(world.a_(blockposition1 = pos.a(this.a)))) {
            CraftEventFactory.handleBlockSpreadEvent(world, pos, blockposition1, this.getGrowIntoState(state, world.v, world));
        }
    }

    protected IBlockData getGrowIntoState(IBlockData state, Random random, World level) {
        return this.a(state, random);
    }

    protected IBlockData a(IBlockData state, Random random) {
        return (IBlockData)state.a(d);
    }

    public IBlockData n(IBlockData state) {
        return (IBlockData)state.a(d, 25);
    }

    public boolean o(IBlockData state) {
        return state.c(d) == 25;
    }

    protected IBlockData a(IBlockData from, IBlockData to) {
        return to;
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (direction == this.a.f() && !state.a(world, pos)) {
            world.a(pos, this, 1);
        }
        if (direction == this.a && (neighborState.a(this) || neighborState.a(this.c()))) {
            return this.a(state, this.c().n());
        }
        if (this.b) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{d});
    }

    @Override
    public boolean a(IBlockAccess world, BlockPosition pos, IBlockData state, boolean isClient) {
        return this.g(world.a_(pos.a(this.a)));
    }

    @Override
    public boolean a(World world, Random random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, Random random, BlockPosition pos, IBlockData state) {
        BlockPosition blockposition1 = pos.a(this.a);
        int i2 = Math.min(state.c(d) + 1, 25);
        int j2 = this.a(random);
        for (int k2 = 0; k2 < j2 && this.g(world.a_(blockposition1)); ++k2) {
            world.b(blockposition1, (IBlockData)state.a(d, i2));
            blockposition1 = blockposition1.a(this.a);
            i2 = Math.min(i2 + 1, 25);
        }
    }

    protected abstract int a(Random var1);

    protected abstract boolean g(IBlockData var1);

    @Override
    protected BlockGrowingTop d() {
        return this;
    }
}

