/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Random;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.entity.Entity;

public class BlockEnderPortal
extends BlockTileEntity {
    protected static final VoxelShape a = Block.a(0.0, 6.0, 0.0, 16.0, 12.0, 16.0);

    protected BlockEnderPortal(BlockBase.Info settings) {
        super(settings);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityEnderPortal(pos, state);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return a;
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(world, pos)).callEvent()) {
            return;
        }
        if (world instanceof WorldServer && !entity.bF() && !entity.bG() && entity.ci() && VoxelShapes.c(VoxelShapes.a(entity.cw().d(-pos.u(), -pos.v(), -pos.w())), state.j(world, pos), OperatorBoolean.i)) {
            ResourceKey<World> resourcekey = world.getTypeKey() == WorldDimension.d ? World.e : World.g;
            WorldServer worldserver = ((WorldServer)world).n().a(resourcekey);
            if (worldserver == null) {
                // empty if block
            }
            entity.portalWorld = (WorldServer)world;
            entity.portalBlock = pos.h();
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Random random) {
        double d0 = (double)pos.u() + random.nextDouble();
        double d1 = (double)pos.v() + 0.8;
        double d2 = (double)pos.w() + random.nextDouble();
        world.a(Particles.U, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @Override
    public ItemStack a(IBlockAccess world, BlockPosition pos, IBlockData state) {
        return ItemStack.b;
    }

    @Override
    public boolean a(IBlockData state, FluidType fluid) {
        return false;
    }
}

