/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.ChatMessage;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChestAbstract;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.DoubleBlockFinder;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockChest
extends BlockChestAbstract<TileEntityChest>
implements IBlockWaterlogged {
    public static final BlockStateDirection b = BlockFacingHorizontal.aD;
    public static final BlockStateEnum<BlockPropertyChestType> c = BlockProperties.aY;
    public static final BlockStateBoolean d = BlockProperties.C;
    public static final int e = 1;
    protected static final int f = 1;
    protected static final int g = 14;
    protected static final VoxelShape h = Block.a(1.0, 0.0, 0.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape i = Block.a(1.0, 0.0, 1.0, 15.0, 14.0, 16.0);
    protected static final VoxelShape j = Block.a(0.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    protected static final VoxelShape k = Block.a(1.0, 0.0, 1.0, 16.0, 14.0, 15.0);
    protected static final VoxelShape l = Block.a(1.0, 0.0, 1.0, 15.0, 14.0, 15.0);
    private static final DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>> m = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<IInventory>>(){

        @Override
        public Optional<IInventory> a(TileEntityChest first, TileEntityChest second) {
            return Optional.of(new InventoryLargeChest(first, second));
        }

        @Override
        public Optional<IInventory> a(TileEntityChest single) {
            return Optional.of(single);
        }

        public Optional<IInventory> a() {
            return Optional.empty();
        }
    };
    private static final DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>> n = new DoubleBlockFinder.Combiner<TileEntityChest, Optional<ITileInventory>>(){

        @Override
        public Optional<ITileInventory> a(TileEntityChest first, TileEntityChest second) {
            InventoryLargeChest inventorylargechest = new InventoryLargeChest(first, second);
            return Optional.of(new DoubleInventory(first, second, inventorylargechest));
        }

        @Override
        public Optional<ITileInventory> a(TileEntityChest single) {
            return Optional.of(single);
        }

        public Optional<ITileInventory> a() {
            return Optional.empty();
        }
    };

    protected BlockChest(BlockBase.Info settings, Supplier<TileEntityTypes<? extends TileEntityChest>> entityTypeSupplier) {
        super(settings, entityTypeSupplier);
        this.k((IBlockData)((IBlockData)((IBlockData)this.D.b().a(b, EnumDirection.c)).a(c, BlockPropertyChestType.a)).a(d, false));
    }

    public static DoubleBlockFinder.BlockType g(IBlockData state) {
        BlockPropertyChestType blockpropertychesttype = state.c(c);
        return blockpropertychesttype == BlockPropertyChestType.a ? DoubleBlockFinder.BlockType.a : (blockpropertychesttype == BlockPropertyChestType.c ? DoubleBlockFinder.BlockType.b : DoubleBlockFinder.BlockType.c);
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.b;
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(d).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        if (neighborState.a(this) && direction.n().d()) {
            BlockPropertyChestType blockpropertychesttype = neighborState.c(c);
            if (state.c(c) == BlockPropertyChestType.a && blockpropertychesttype != BlockPropertyChestType.a && state.c(b) == neighborState.c(b) && BlockChest.h(neighborState) == direction.f()) {
                return (IBlockData)state.a(c, blockpropertychesttype.a());
            }
        } else if (BlockChest.h(state) == direction) {
            return (IBlockData)state.a(c, BlockPropertyChestType.a);
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        if (state.c(c) == BlockPropertyChestType.a) {
            return l;
        }
        switch (BlockChest.h(state)) {
            default: {
                return h;
            }
            case d: {
                return i;
            }
            case e: {
                return j;
            }
            case f: 
        }
        return k;
    }

    public static EnumDirection h(IBlockData state) {
        EnumDirection enumdirection = state.c(b);
        return state.c(c) == BlockPropertyChestType.b ? enumdirection.g() : enumdirection.h();
    }

    @Override
    public IBlockData a(BlockActionContext ctx) {
        EnumDirection enumdirection2;
        BlockPropertyChestType blockpropertychesttype = BlockPropertyChestType.a;
        EnumDirection enumdirection = ctx.g().f();
        Fluid fluid = ctx.q().b_(ctx.a());
        boolean flag = ctx.h();
        EnumDirection enumdirection1 = ctx.k();
        if (enumdirection1.n().d() && flag && (enumdirection2 = this.a(ctx, enumdirection1.f())) != null && enumdirection2.n() != enumdirection1.n()) {
            enumdirection = enumdirection2;
            BlockPropertyChestType blockPropertyChestType = blockpropertychesttype = enumdirection2.h() == enumdirection1.f() ? BlockPropertyChestType.c : BlockPropertyChestType.b;
        }
        if (blockpropertychesttype == BlockPropertyChestType.a && !flag) {
            if (enumdirection == this.a(ctx, enumdirection.g())) {
                blockpropertychesttype = BlockPropertyChestType.b;
            } else if (enumdirection == this.a(ctx, enumdirection.h())) {
                blockpropertychesttype = BlockPropertyChestType.c;
            }
        }
        return (IBlockData)((IBlockData)((IBlockData)this.n().a(b, enumdirection)).a(c, blockpropertychesttype)).a(d, fluid.a() == FluidTypes.c);
    }

    @Override
    public Fluid c_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.c_(state);
    }

    @Nullable
    private EnumDirection a(BlockActionContext ctx, EnumDirection dir) {
        IBlockData iblockdata = ctx.q().a_(ctx.a().a(dir));
        return iblockdata.a(this) && iblockdata.c(c) == BlockPropertyChestType.a ? iblockdata.c(b) : null;
    }

    @Override
    public void a(World world, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack itemStack) {
        TileEntity tileentity;
        if (itemStack.y() && (tileentity = world.c_(pos)) instanceof TileEntityChest) {
            ((TileEntityChest)tileentity).a(itemStack.w());
        }
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, IBlockData newState, boolean moved) {
        if (!state.a(newState.b())) {
            TileEntity tileentity = world.c_(pos);
            if (tileentity instanceof IInventory) {
                InventoryUtils.a(world, pos, (IInventory)((Object)tileentity));
                world.c(pos, this);
            }
            super.a(state, world, pos, newState, moved);
        }
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        if (world.x) {
            return EnumInteractionResult.a;
        }
        ITileInventory itileinventory = this.b(state, world, pos);
        if (itileinventory != null) {
            player.a(itileinventory);
            player.b(this.d());
            PiglinAI.a(player, true);
        }
        return EnumInteractionResult.b;
    }

    protected Statistic<MinecraftKey> d() {
        return StatisticList.i.b(StatisticList.ao);
    }

    public TileEntityTypes<? extends TileEntityChest> e() {
        return this.a.get();
    }

    @Nullable
    public static IInventory a(BlockChest block, IBlockData state, World world, BlockPosition pos, boolean ignoreBlocked) {
        return block.a(state, world, pos, ignoreBlocked).apply(m).orElse(null);
    }

    @Override
    public DoubleBlockFinder.Result<? extends TileEntityChest> a(IBlockData state, World world, BlockPosition pos, boolean ignoreBlocked) {
        BiPredicate<GeneratorAccess, BlockPosition> bipredicate = ignoreBlocked ? (generatoraccess, blockposition1) -> false : BlockChest::a;
        return DoubleBlockFinder.a(this.a.get(), BlockChest::g, BlockChest::h, b, state, world, pos, bipredicate);
    }

    @Override
    @Nullable
    public ITileInventory b(IBlockData state, World world, BlockPosition pos) {
        return this.getMenuProvider(state, world, pos, false);
    }

    @Nullable
    public ITileInventory getMenuProvider(IBlockData iblockdata, World world, BlockPosition blockposition, boolean ignoreObstructions) {
        return this.a(iblockdata, world, blockposition, ignoreObstructions).apply(n).orElse(null);
    }

    public static DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction> a(final LidBlockEntity progress) {
        return new DoubleBlockFinder.Combiner<TileEntityChest, Float2FloatFunction>(){

            @Override
            public Float2FloatFunction a(TileEntityChest first, TileEntityChest second) {
                return f2 -> Math.max(first.a(f2), second.a(f2));
            }

            @Override
            public Float2FloatFunction a(TileEntityChest single) {
                Objects.requireNonNull(single);
                return single::a;
            }

            public Float2FloatFunction a() {
                LidBlockEntity lidblockentity1 = progress;
                Objects.requireNonNull(progress);
                return lidblockentity1::a;
            }
        };
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityChest(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return world.x ? BlockChest.a(type, this.e(), TileEntityChest::a) : null;
    }

    public static boolean a(GeneratorAccess world, BlockPosition pos) {
        return BlockChest.a((IBlockAccess)world, pos) || BlockChest.b(world, pos);
    }

    private static boolean a(IBlockAccess world, BlockPosition pos) {
        BlockPosition blockposition1 = pos.b();
        return world.a_(blockposition1).g(world, blockposition1);
    }

    private static boolean b(GeneratorAccess world, BlockPosition pos) {
        if (((World)world).paperConfig.disableChestCatDetection) {
            return false;
        }
        List<EntityCat> list = world.a(EntityCat.class, new AxisAlignedBB(pos.u(), pos.v() + 1, pos.w(), pos.u() + 1, pos.v() + 2, pos.w() + 1));
        if (!list.isEmpty()) {
            for (EntityCat entitycat : list) {
                if (!entitycat.fz()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean d_(IBlockData state) {
        return true;
    }

    @Override
    public int a(IBlockData state, World world, BlockPosition pos) {
        return Container.b(BlockChest.a(this, state, world, pos, false));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(b, rotation.a(state.c(b)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        TileEntity tileentity = world.c_(pos);
        if (tileentity instanceof TileEntityChest) {
            ((TileEntityChest)tileentity).i();
        }
    }

    public static class DoubleInventory
    implements ITileInventory {
        private final TileEntityChest tileentitychest;
        private final TileEntityChest tileentitychest1;
        public final InventoryLargeChest inventorylargechest;

        public DoubleInventory(TileEntityChest tileentitychest, TileEntityChest tileentitychest1, InventoryLargeChest inventorylargechest) {
            this.tileentitychest = tileentitychest;
            this.tileentitychest1 = tileentitychest1;
            this.inventorylargechest = inventorylargechest;
        }

        @Override
        @Nullable
        public Container createMenu(int syncId, PlayerInventory inv, EntityHuman player) {
            if (this.tileentitychest.d(player) && this.tileentitychest1.d(player)) {
                this.tileentitychest.e(inv.l);
                this.tileentitychest1.e(inv.l);
                return ContainerChest.b(syncId, inv, this.inventorylargechest);
            }
            return null;
        }

        @Override
        public IChatBaseComponent C_() {
            return this.tileentitychest.Y() ? this.tileentitychest.C_() : (this.tileentitychest1.Y() ? this.tileentitychest1.C_() : new ChatMessage("container.chestDouble"));
        }
    }
}

