/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import io.papermc.paper.event.block.BellRingEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.MCUtil;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBell;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBellAttach;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.entity.Entity;

public class BlockBell
extends BlockTileEntity {
    public static final BlockStateDirection a = BlockFacingHorizontal.aD;
    public static final BlockStateEnum<BlockPropertyBellAttach> b = BlockProperties.S;
    public static final BlockStateBoolean c = BlockProperties.w;
    private static final VoxelShape e = Block.a(0.0, 0.0, 4.0, 16.0, 16.0, 12.0);
    private static final VoxelShape f = Block.a(4.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    private static final VoxelShape g = Block.a(5.0, 6.0, 5.0, 11.0, 13.0, 11.0);
    private static final VoxelShape h = Block.a(4.0, 4.0, 4.0, 12.0, 6.0, 12.0);
    private static final VoxelShape i = VoxelShapes.a(h, g);
    private static final VoxelShape j = VoxelShapes.a(i, Block.a(7.0, 13.0, 0.0, 9.0, 15.0, 16.0));
    private static final VoxelShape k = VoxelShapes.a(i, Block.a(0.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape l = VoxelShapes.a(i, Block.a(0.0, 13.0, 7.0, 13.0, 15.0, 9.0));
    private static final VoxelShape m = VoxelShapes.a(i, Block.a(3.0, 13.0, 7.0, 16.0, 15.0, 9.0));
    private static final VoxelShape n = VoxelShapes.a(i, Block.a(7.0, 13.0, 0.0, 9.0, 15.0, 13.0));
    private static final VoxelShape E = VoxelShapes.a(i, Block.a(7.0, 13.0, 3.0, 9.0, 15.0, 16.0));
    private static final VoxelShape F = VoxelShapes.a(i, Block.a(7.0, 13.0, 7.0, 9.0, 16.0, 9.0));
    public static final int d = 1;

    public BlockBell(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.D.b().a(a, EnumDirection.c)).a(b, BlockPropertyBellAttach.a)).a(c, false));
    }

    @Override
    public void a(IBlockData state, World world, BlockPosition pos, Block block, BlockPosition fromPos, boolean notify) {
        boolean bl = world.q(pos);
        if (bl != state.c(c)) {
            if (bl) {
                this.a(world, pos, (EnumDirection)null);
            }
            world.a(pos, (IBlockData)state.a(c, bl), 3);
        }
    }

    @Override
    public void a(World world, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        net.minecraft.world.entity.Entity entity = projectile.x();
        EntityHuman player = entity instanceof EntityHuman ? (EntityHuman)entity : null;
        this.a(world, state, hit, player, true);
    }

    @Override
    public EnumInteractionResult a(IBlockData state, World world, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hit) {
        return this.a(world, state, hit, player, true) ? EnumInteractionResult.a(world.x) : EnumInteractionResult.d;
    }

    public boolean a(World world, IBlockData state, MovingObjectPositionBlock hitResult, @Nullable EntityHuman player, boolean bl) {
        boolean bl2;
        EnumDirection direction = hitResult.b();
        BlockPosition blockPos = hitResult.a();
        boolean bl3 = bl2 = !bl || this.a(state, direction, hitResult.e().c - (double)blockPos.v());
        if (bl2) {
            boolean bl32 = this.a(player, world, blockPos, direction);
            if (bl32 && player != null) {
                player.a(StatisticList.az);
            }
            return true;
        }
        return false;
    }

    private boolean a(IBlockData state, EnumDirection side, double y2) {
        if (side.n() != EnumDirection.EnumAxis.b && !(y2 > (double)0.8124f)) {
            EnumDirection direction = state.c(a);
            BlockPropertyBellAttach bellAttachType = state.c(b);
            switch (bellAttachType) {
                case a: {
                    return direction.n() == side.n();
                }
                case c: 
                case d: {
                    return direction.n() != side.n();
                }
                case b: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean a(World world, BlockPosition pos, @Nullable EnumDirection direction) {
        return this.a((net.minecraft.world.entity.Entity)null, world, pos, direction);
    }

    public boolean a(@Nullable net.minecraft.world.entity.Entity entity, World world, BlockPosition pos, @Nullable EnumDirection direction) {
        TileEntity blockEntity = world.c_(pos);
        if (!world.x && blockEntity instanceof TileEntityBell) {
            if (direction == null) {
                direction = world.a_(pos).c(a);
            }
            if (!new BellRingEvent(world.getWorld().getBlockAt(MCUtil.toLocation(world, pos)), (Entity)(entity == null ? null : entity.getBukkitEntity())).callEvent()) {
                return false;
            }
            ((TileEntityBell)blockEntity).a(direction);
            world.a((EntityHuman)null, pos, SoundEffects.bn, SoundCategory.e, 2.0f, 1.0f);
            world.a(entity, GameEvent.L, pos);
            return true;
        }
        return false;
    }

    private VoxelShape h(IBlockData state) {
        EnumDirection direction = state.c(a);
        BlockPropertyBellAttach bellAttachType = state.c(b);
        if (bellAttachType == BlockPropertyBellAttach.a) {
            return direction != EnumDirection.c && direction != EnumDirection.d ? f : e;
        }
        if (bellAttachType == BlockPropertyBellAttach.b) {
            return F;
        }
        if (bellAttachType == BlockPropertyBellAttach.d) {
            return direction != EnumDirection.c && direction != EnumDirection.d ? k : j;
        }
        if (direction == EnumDirection.c) {
            return n;
        }
        if (direction == EnumDirection.d) {
            return E;
        }
        return direction == EnumDirection.f ? m : l;
    }

    @Override
    public VoxelShape c(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.h(state);
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        return this.h(state);
    }

    @Override
    public EnumRenderType b_(IBlockData state) {
        return EnumRenderType.c;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        EnumDirection direction = ctx.k();
        BlockPosition blockPos = ctx.a();
        World level = ctx.q();
        EnumDirection.EnumAxis axis = direction.n();
        if (axis == EnumDirection.EnumAxis.b) {
            IBlockData blockState = (IBlockData)((IBlockData)this.n().a(b, direction == EnumDirection.a ? BlockPropertyBellAttach.b : BlockPropertyBellAttach.a)).a(a, ctx.g());
            if (blockState.a((IWorldReader)ctx.q(), blockPos)) {
                return blockState;
            }
        } else {
            boolean bl = axis == EnumDirection.EnumAxis.a && level.a_(blockPos.f()).d(level, blockPos.f(), EnumDirection.f) && level.a_(blockPos.g()).d(level, blockPos.g(), EnumDirection.e) || axis == EnumDirection.EnumAxis.c && level.a_(blockPos.d()).d(level, blockPos.d(), EnumDirection.d) && level.a_(blockPos.e()).d(level, blockPos.e(), EnumDirection.c);
            IBlockData blockState2 = (IBlockData)((IBlockData)this.n().a(a, direction.f())).a(b, bl ? BlockPropertyBellAttach.d : BlockPropertyBellAttach.c);
            if (blockState2.a((IWorldReader)ctx.q(), ctx.a())) {
                return blockState2;
            }
            boolean bl2 = level.a_(blockPos.c()).d(level, blockPos.c(), EnumDirection.b);
            if ((blockState2 = (IBlockData)blockState2.a(b, bl2 ? BlockPropertyBellAttach.a : BlockPropertyBellAttach.b)).a((IWorldReader)ctx.q(), ctx.a())) {
                return blockState2;
            }
        }
        return null;
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        BlockPropertyBellAttach bellAttachType = state.c(b);
        EnumDirection direction2 = BlockBell.n(state).f();
        if (direction2 == direction && !state.a(world, pos) && bellAttachType != BlockPropertyBellAttach.d) {
            return Blocks.a.n();
        }
        if (direction.n() == state.c(a).n()) {
            if (bellAttachType == BlockPropertyBellAttach.d && !neighborState.d(world, neighborPos, direction)) {
                return (IBlockData)((IBlockData)state.a(b, BlockPropertyBellAttach.c)).a(a, direction.f());
            }
            if (bellAttachType == BlockPropertyBellAttach.c && direction2.f() == direction && neighborState.d(world, neighborPos, state.c(a))) {
                return (IBlockData)state.a(b, BlockPropertyBellAttach.d);
            }
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        EnumDirection direction = BlockBell.n(state).f();
        return direction == EnumDirection.b ? Block.a(world, pos.b(), EnumDirection.a) : BlockAttachable.b(world, pos, direction);
    }

    private static EnumDirection n(IBlockData state) {
        switch (state.c(b)) {
            case a: {
                return EnumDirection.b;
            }
            case b: {
                return EnumDirection.a;
            }
        }
        return state.c(a).f();
    }

    @Override
    public EnumPistonReaction d(IBlockData state) {
        return EnumPistonReaction.b;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, b, c);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityBell(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData state, TileEntityTypes<T> type) {
        return BlockBell.a(type, TileEntityTypes.D, world.x ? TileEntityBell::a : TileEntityBell::b);
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }
}

