/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;

public class BlockBamboo
extends Block
implements IBlockFragilePlantElement {
    protected static final float a = 3.0f;
    protected static final float b = 5.0f;
    protected static final float c = 1.5f;
    protected static final VoxelShape d = Block.a(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    protected static final VoxelShape e = Block.a(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    protected static final VoxelShape f = Block.a(6.5, 0.0, 6.5, 9.5, 16.0, 9.5);
    public static final BlockStateInteger g = BlockProperties.am;
    public static final BlockStateEnum<BlockPropertyBambooSize> h = BlockProperties.bg;
    public static final BlockStateInteger i = BlockProperties.aP;
    public static final int j = 16;
    public static final int k = 0;
    public static final int l = 1;
    public static final int m = 0;
    public static final int n = 1;

    public BlockBamboo(BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)((IBlockData)this.D.b().a(g, 0)).a(h, BlockPropertyBambooSize.a)).a(i, 0));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(g, h, i);
    }

    @Override
    public BlockBase.EnumRandomOffset U_() {
        return BlockBase.EnumRandomOffset.b;
    }

    @Override
    public boolean c(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return true;
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        VoxelShape voxelshape = state.c(h) == BlockPropertyBambooSize.c ? e : d;
        Vec3D vec3d = state.n(world, pos);
        return voxelshape.a(vec3d.b, vec3d.c, vec3d.d);
    }

    @Override
    public boolean a(IBlockData state, IBlockAccess world, BlockPosition pos, PathMode type) {
        return false;
    }

    @Override
    public VoxelShape c(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        Vec3D vec3d = state.n(world, pos);
        return f.a(vec3d.b, vec3d.c, vec3d.d);
    }

    @Override
    public boolean a_(IBlockData state, IBlockAccess world, BlockPosition pos) {
        return false;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext ctx) {
        Fluid fluid = ctx.q().b_(ctx.a());
        if (!fluid.c()) {
            return null;
        }
        IBlockData iblockdata = ctx.q().a_(ctx.a().c());
        if (iblockdata.a(TagsBlock.al)) {
            if (iblockdata.a(Blocks.ll)) {
                return (IBlockData)this.n().a(g, 0);
            }
            if (iblockdata.a(Blocks.lm)) {
                int i2 = iblockdata.c(g) > 0 ? 1 : 0;
                return (IBlockData)this.n().a(g, i2);
            }
            IBlockData iblockdata1 = ctx.q().a_(ctx.a().b());
            return iblockdata1.a(Blocks.lm) ? (IBlockData)this.n().a(g, iblockdata1.c(g)) : Blocks.ll.n();
        }
        return null;
    }

    @Override
    public void a(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        if (!state.a((IWorldReader)world, pos)) {
            world.b(pos, true);
        }
    }

    @Override
    public boolean e_(IBlockData state) {
        return state.c(i) == 0;
    }

    @Override
    public void b(IBlockData state, WorldServer world, BlockPosition pos, Random random) {
        int i2;
        if (state.c(i) == 0 && random.nextInt(Math.max(1, (int)(100.0f / (float)world.spigotConfig.bambooModifier) * 3)) == 0 && world.w(pos.b()) && world.b(pos.b(), 0) >= 9 && (i2 = this.b(world, pos) + 1) < world.paperConfig.bambooMaxHeight) {
            this.a(state, (World)world, pos, random, i2);
        }
    }

    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        return world.a_(pos.c()).a(TagsBlock.al);
    }

    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (!state.a(world, pos)) {
            world.a(pos, this, 1);
        }
        if (direction == EnumDirection.b && neighborState.a(Blocks.lm) && neighborState.c(g) > state.c(g)) {
            world.a(pos, (IBlockData)state.a(g), 2);
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    public boolean a(IBlockAccess world, BlockPosition pos, IBlockData state, boolean isClient) {
        int j2;
        int i2 = this.a(world, pos);
        return i2 + (j2 = this.b(world, pos)) + 1 < ((World)world).paperConfig.bambooMaxHeight && world.a_(pos.b(i2)).c(i) != 1;
    }

    @Override
    public boolean a(World world, Random random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer world, Random random, BlockPosition pos, IBlockData state) {
        int i2 = this.a((IBlockAccess)world, pos);
        int j2 = this.b(world, pos);
        int k2 = i2 + j2 + 1;
        int l2 = 1 + random.nextInt(2);
        for (int i1 = 0; i1 < l2; ++i1) {
            BlockPosition blockposition1 = pos.b(i2);
            IBlockData iblockdata1 = world.a_(blockposition1);
            if (k2 >= world.paperConfig.bambooMaxHeight || !iblockdata1.a(Blocks.lm) || iblockdata1.c(i) == 1 || !world.w(blockposition1.b())) {
                return;
            }
            this.a(iblockdata1, (World)world, blockposition1, random, k2);
            ++i2;
            ++k2;
        }
    }

    @Override
    public float a(IBlockData state, EntityHuman player, IBlockAccess world, BlockPosition pos) {
        return player.es().c() instanceof ItemSword ? 1.0f : super.a(state, player, world, pos);
    }

    protected void a(IBlockData state, World world, BlockPosition pos, Random random, int height) {
        int k2;
        IBlockData iblockdata1 = world.a_(pos.c());
        BlockPosition blockposition1 = pos.c(2);
        IBlockData iblockdata2 = world.a_(blockposition1);
        BlockPropertyBambooSize blockpropertybamboosize = BlockPropertyBambooSize.a;
        boolean shouldUpdateOthers = false;
        if (height >= 1) {
            if (iblockdata1.a(Blocks.lm) && iblockdata1.c(h) != BlockPropertyBambooSize.a) {
                if (iblockdata1.a(Blocks.lm) && iblockdata1.c(h) != BlockPropertyBambooSize.a) {
                    blockpropertybamboosize = BlockPropertyBambooSize.c;
                    if (iblockdata2.a(Blocks.lm)) {
                        shouldUpdateOthers = true;
                    }
                }
            } else {
                blockpropertybamboosize = BlockPropertyBambooSize.b;
            }
        }
        int j2 = state.c(g) != 1 && !iblockdata2.a(Blocks.lm) ? 0 : 1;
        int n2 = k2 = (height < world.paperConfig.bambooMinHeight || random.nextFloat() >= 0.25f) && height != world.paperConfig.bambooMaxHeight - 1 ? 0 : 1;
        if (CraftEventFactory.handleBlockSpreadEvent(world, pos, pos.b(), (IBlockData)((IBlockData)((IBlockData)this.n().a(g, j2)).a(h, blockpropertybamboosize)).a(i, k2), 3) && shouldUpdateOthers) {
            world.a(pos.c(), (IBlockData)iblockdata1.a(h, BlockPropertyBambooSize.b), 3);
            world.a(blockposition1, (IBlockData)iblockdata2.a(h, BlockPropertyBambooSize.a), 3);
        }
    }

    protected int a(IBlockAccess world, BlockPosition pos) {
        int i2;
        for (i2 = 0; i2 < ((World)world).paperConfig.bambooMaxHeight && world.a_(pos.b(i2 + 1)).a(Blocks.lm); ++i2) {
        }
        return i2;
    }

    protected int b(IBlockAccess world, BlockPosition pos) {
        int i2;
        for (i2 = 0; i2 < ((World)world).paperConfig.bambooMaxHeight && world.a_(pos.c(i2 + 1)).a(Blocks.lm); ++i2) {
        }
        return i2;
    }
}

