/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class AmethystClusterBlock
extends AmethystBlock
implements IBlockWaterlogged {
    public static final BlockStateBoolean a = BlockProperties.C;
    public static final BlockStateDirection b = BlockProperties.N;
    protected final VoxelShape c;
    protected final VoxelShape d;
    protected final VoxelShape e;
    protected final VoxelShape f;
    protected final VoxelShape g;
    protected final VoxelShape h;

    public AmethystClusterBlock(int height, int xzOffset, BlockBase.Info settings) {
        super(settings);
        this.k((IBlockData)((IBlockData)this.n().a(a, false)).a(b, EnumDirection.b));
        this.g = Block.a(xzOffset, 0.0, xzOffset, 16 - xzOffset, (double)height, (double)(16 - xzOffset));
        this.h = Block.a(xzOffset, 16 - height, xzOffset, 16 - xzOffset, 16.0, (double)(16 - xzOffset));
        this.c = Block.a(xzOffset, xzOffset, 16 - height, 16 - xzOffset, (double)(16 - xzOffset), 16.0);
        this.d = Block.a(xzOffset, xzOffset, 0.0, 16 - xzOffset, (double)(16 - xzOffset), (double)height);
        this.e = Block.a(0.0, xzOffset, xzOffset, height, (double)(16 - xzOffset), (double)(16 - xzOffset));
        this.f = Block.a(16 - height, xzOffset, xzOffset, 16.0, (double)(16 - xzOffset), (double)(16 - xzOffset));
    }

    @Override
    @Override
    public VoxelShape a(IBlockData state, IBlockAccess world, BlockPosition pos, VoxelShapeCollision context) {
        EnumDirection direction = state.c(b);
        switch (direction) {
            case c: {
                return this.c;
            }
            case d: {
                return this.d;
            }
            case f: {
                return this.e;
            }
            case e: {
                return this.f;
            }
            case a: {
                return this.h;
            }
        }
        return this.g;
    }

    @Override
    @Override
    public boolean a(IBlockData state, IWorldReader world, BlockPosition pos) {
        EnumDirection direction = state.c(b);
        BlockPosition blockPos = pos.a(direction.f());
        return world.a_(blockPos).d(world, blockPos, direction);
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumDirection direction, IBlockData neighborState, GeneratorAccess world, BlockPosition pos, BlockPosition neighborPos) {
        if (state.c(a).booleanValue()) {
            world.a(pos, FluidTypes.c, FluidTypes.c.a(world));
        }
        if (direction == state.c(b).f() && !state.a(world, pos)) {
            return Blocks.a.n();
        }
        return super.a(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    @Nullable
    @Override
    public IBlockData a(BlockActionContext ctx) {
        World levelAccessor = ctx.q();
        BlockPosition blockPos = ctx.a();
        return (IBlockData)((IBlockData)this.n().a(a, levelAccessor.b_(blockPos).a() == FluidTypes.c)).a(b, ctx.k());
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.a(b, rotation.a(state.c(b)));
    }

    @Override
    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    @Override
    public Fluid c_(IBlockData state) {
        if (state.c(a).booleanValue()) {
            return FluidTypes.c.a(false);
        }
        return super.c_(state);
    }

    @Override
    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(a, b);
    }

    @Override
    @Override
    public EnumPistonReaction d(IBlockData state) {
        return EnumPistonReaction.b;
    }
}

