/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManager;

public class WorldChunkManagerHell
extends WorldChunkManager
implements BiomeManager.Provider {
    public static final Codec<WorldChunkManagerHell> b = BiomeBase.c.fieldOf("biome").xmap(WorldChunkManagerHell::new, fixedBiomeSource -> fixedBiomeSource.c).stable().codec();
    private final Holder<BiomeBase> c;

    public WorldChunkManagerHell(Holder<BiomeBase> biomes) {
        super((List<Holder<BiomeBase>>)ImmutableList.of(biomes));
        this.c = biomes;
    }

    @Override
    @Override
    protected Codec<? extends WorldChunkManager> a() {
        return b;
    }

    @Override
    @Override
    public WorldChunkManager a(long seed) {
        return this;
    }

    @Override
    @Override
    public Holder<BiomeBase> getNoiseBiome(int x2, int y2, int z2, Climate.Sampler noise) {
        return this.c;
    }

    @Override
    @Override
    public Holder<BiomeBase> getNoiseBiome(int biomeX, int biomeY, int biomeZ) {
        return this.c;
    }

    @Override
    @Nullable
    @Override
    public Pair<BlockPosition, Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, int blockCheckInterval, Predicate<Holder<BiomeBase>> predicate, Random random, boolean bl, Climate.Sampler noiseSampler) {
        if (predicate.test(this.c)) {
            if (bl) {
                return Pair.of((Object)new BlockPosition(x2, y2, z2), this.c);
            }
            return Pair.of((Object)new BlockPosition(x2 - radius + random.nextInt(radius * 2 + 1), y2, z2 - radius + random.nextInt(radius * 2 + 1)), this.c);
        }
        return null;
    }

    @Override
    @Override
    public Set<Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, Climate.Sampler sampler) {
        return Sets.newHashSet(Set.of(this.c));
    }
}

