/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Graph;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.WorldChunkManagerCheckerBoard;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class WorldChunkManager
implements BiomeResolver {
    public static final Codec<WorldChunkManager> a;
    private final Set<Holder<BiomeBase>> b;
    private final Supplier<List<b>> c;

    protected WorldChunkManager(Stream<Holder<BiomeBase>> biomeStream) {
        this(biomeStream.distinct().toList());
    }

    protected WorldChunkManager(List<Holder<BiomeBase>> biomes) {
        this.b = new ObjectLinkedOpenHashSet(biomes);
        this.c = Suppliers.memoize(() -> this.a(biomes, true));
    }

    private List<b> a(List<Holder<BiomeBase>> biomes, boolean bl) {
        Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
        MutableInt mutableInt = new MutableInt(0);
        record A(int a, int b, PlacedFeature c) {
            @Override
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "featureIndex;step;feature", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "featureIndex;step;feature", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "featureIndex;step;feature", "a", "b", "c"}, this, object);
            }
        }
        Comparator<A> comparator = Comparator.comparingInt(A::b).thenComparingInt(A::a);
        TreeMap<A, Set> map = new TreeMap<A, Set>(comparator);
        int i2 = 0;
        for (Holder<BiomeBase> holder : biomes) {
            BiomeBase biome = holder.a();
            ArrayList list = Lists.newArrayList();
            List<HolderSet<PlacedFeature>> list2 = biome.e().b();
            i2 = Math.max(i2, list2.size());
            for (int j2 = 0; j2 < list2.size(); ++j2) {
                for (Holder holder2 : list2.get(j2)) {
                    PlacedFeature placedFeature = (PlacedFeature)holder2.a();
                    list.add(new A(object2IntMap.computeIfAbsent((Object)placedFeature, object -> mutableInt.getAndIncrement()), j2, placedFeature));
                }
            }
            for (int k2 = 0; k2 < list.size(); ++k2) {
                Set set = map.computeIfAbsent((A)list.get(k2), arg -> new TreeSet(comparator));
                if (k2 >= list.size() - 1) continue;
                set.add((A)list.get(k2 + 1));
            }
        }
        TreeSet<A> set2 = new TreeSet<A>(comparator);
        TreeSet<A> set3 = new TreeSet<A>(comparator);
        ArrayList list3 = Lists.newArrayList();
        for (A lv : map.keySet()) {
            if (!set3.isEmpty()) {
                throw new IllegalStateException("You somehow broke the universe; DFS bork (iteration finished with non-empty in-progress vertex set");
            }
            if (set2.contains(lv) || !Graph.a(map, set2, set3, list3::add, lv)) continue;
            if (bl) {
                int l2;
                ArrayList<Holder<BiomeBase>> list4 = new ArrayList<Holder<BiomeBase>>(biomes);
                do {
                    l2 = list4.size();
                    ListIterator<Holder> listIterator = list4.listIterator();
                    while (listIterator.hasNext()) {
                        Holder holder3 = (Holder)listIterator.next();
                        listIterator.remove();
                        try {
                            this.a(list4, false);
                        }
                        catch (IllegalStateException illegalStateException) {
                            continue;
                        }
                        listIterator.add(holder3);
                    }
                } while (l2 != list4.size());
                throw new IllegalStateException("Feature order cycle found, involved biomes: " + list4);
            }
            throw new IllegalStateException("Feature order cycle found");
        }
        Collections.reverse(list3);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int m2 = 0; m2 < i2; ++m2) {
            int n2 = m2;
            List<PlacedFeature> list5 = list3.stream().filter(arg -> arg.b() == n2).map(A::c).collect(Collectors.toList());
            int n3 = list5.size();
            Object2IntOpenCustomHashMap object2IntMap2 = new Object2IntOpenCustomHashMap(n3, SystemUtils.k());
            for (int p2 = 0; p2 < n3; ++p2) {
                object2IntMap2.put((Object)((PlacedFeature)list5.get(p2)), p2);
            }
            builder.add((Object)new b(list5, (ToIntFunction<PlacedFeature>)object2IntMap2));
        }
        return builder.build();
    }

    protected abstract Codec<? extends WorldChunkManager> a();

    public abstract WorldChunkManager a(long var1);

    public Set<Holder<BiomeBase>> b() {
        return this.b;
    }

    public Set<Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, Climate.Sampler sampler) {
        int i2 = QuartPos.a(x2 - radius);
        int j2 = QuartPos.a(y2 - radius);
        int k2 = QuartPos.a(z2 - radius);
        int l2 = QuartPos.a(x2 + radius);
        int m2 = QuartPos.a(y2 + radius);
        int n2 = QuartPos.a(z2 + radius);
        int o2 = l2 - i2 + 1;
        int p2 = m2 - j2 + 1;
        int q2 = n2 - k2 + 1;
        HashSet set = Sets.newHashSet();
        for (int r2 = 0; r2 < q2; ++r2) {
            for (int s2 = 0; s2 < o2; ++s2) {
                for (int t2 = 0; t2 < p2; ++t2) {
                    int u2 = i2 + s2;
                    int v2 = j2 + t2;
                    int w2 = k2 + r2;
                    set.add(this.getNoiseBiome(u2, v2, w2, sampler));
                }
            }
        }
        return set;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, Predicate<Holder<BiomeBase>> predicate, Random random, Climate.Sampler noiseSampler) {
        return this.a(x2, y2, z2, radius, 1, predicate, random, false, noiseSampler);
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(int x2, int y2, int z2, int radius, int blockCheckInterval, Predicate<Holder<BiomeBase>> predicate, Random random, boolean bl, Climate.Sampler noiseSampler) {
        int n2;
        int i2 = QuartPos.a(x2);
        int j2 = QuartPos.a(z2);
        int k2 = QuartPos.a(radius);
        int l2 = QuartPos.a(y2);
        Pair pair = null;
        int m2 = 0;
        for (int o2 = n2 = bl ? 0 : k2; o2 <= k2; o2 += blockCheckInterval) {
            int p2;
            int n3 = p2 = SharedConstants.aj ? 0 : -o2;
            while (p2 <= o2) {
                boolean bl2 = Math.abs(p2) == o2;
                for (int q2 = -o2; q2 <= o2; q2 += blockCheckInterval) {
                    int s2;
                    int r2;
                    Holder<BiomeBase> holder;
                    if (bl) {
                        boolean bl3;
                        boolean bl4 = bl3 = Math.abs(q2) == o2;
                        if (!bl3 && !bl2) continue;
                    }
                    if (!predicate.test(holder = this.getNoiseBiome(r2 = i2 + q2, l2, s2 = j2 + p2, noiseSampler))) continue;
                    if (pair == null || random.nextInt(m2 + 1) == 0) {
                        BlockPosition blockPos = new BlockPosition(QuartPos.c(r2), y2, QuartPos.c(s2));
                        if (bl) {
                            return Pair.of((Object)blockPos, holder);
                        }
                        pair = Pair.of((Object)blockPos, holder);
                    }
                    ++m2;
                }
                p2 += blockCheckInterval;
            }
        }
        return pair;
    }

    @Override
    @Override
    public abstract Holder<BiomeBase> getNoiseBiome(int var1, int var2, int var3, Climate.Sampler var4);

    public void a(List<String> info, BlockPosition pos, Climate.Sampler noiseSampler) {
    }

    public List<b> c() {
        return this.c.get();
    }

    static {
        IRegistry.a(IRegistry.bv, "fixed", WorldChunkManagerHell.b);
        IRegistry.a(IRegistry.bv, "multi_noise", WorldChunkManagerMultiNoise.c);
        IRegistry.a(IRegistry.bv, "checkerboard", WorldChunkManagerCheckerBoard.b);
        IRegistry.a(IRegistry.bv, "the_end", WorldChunkManagerTheEnd.b);
        a = IRegistry.bv.o().dispatchStable(WorldChunkManager::a, Function.identity());
    }

    public record b(List<PlacedFeature> a, ToIntFunction<PlacedFeature> b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "features;indexMapping", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "features;indexMapping", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "features;indexMapping", "a", "b"}, this, object);
        }
    }
}

