/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.jetbrains.annotations.VisibleForTesting;

public final class TerrainShaper
extends Record {
    private final CubicSpline<c> c;
    private final CubicSpline<c> d;
    private final CubicSpline<c> e;
    private static final Codec<CubicSpline<c>> f = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.g);
    public static final Codec<CubicSpline<d>> a = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$b.b);
    public static final Codec<TerrainShaper> b = RecordCodecBuilder.create(instance -> instance.group((App)f.fieldOf("offset").forGetter(TerrainShaper::a), (App)f.fieldOf("factor").forGetter(TerrainShaper::b), (App)f.fieldOf("jaggedness").forGetter(terrainShaper -> terrainShaper.e)).apply((Applicative)instance, TerrainShaper::new));
    private static final float g = -0.50375f;
    private static final ToFloatFunction<Float> h = float_ -> float_.floatValue();

    public TerrainShaper(CubicSpline<c> offsetSpline, CubicSpline<c> factorSpline, CubicSpline<c> peakSpline) {
        this.c = offsetSpline;
        this.d = factorSpline;
        this.e = peakSpline;
    }

    private static float b(float f2) {
        return f2 < 0.0f ? f2 : f2 * 2.0f;
    }

    private static float c(float f2) {
        return 1.25f - 6.25f / (f2 + 5.0f);
    }

    private static float d(float f2) {
        return f2 * 2.0f;
    }

    public static TerrainShaper a(boolean amplified) {
        ToFloatFunction<Float> toFloatFunction = amplified ? TerrainShaper::b : h;
        ToFloatFunction<Float> toFloatFunction2 = amplified ? TerrainShaper::c : h;
        ToFloatFunction<Float> toFloatFunction3 = amplified ? TerrainShaper::d : h;
        CubicSpline<c> cubicSpline = TerrainShaper.a(-0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, toFloatFunction);
        CubicSpline<c> cubicSpline2 = TerrainShaper.a(-0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, toFloatFunction);
        CubicSpline<c> cubicSpline3 = TerrainShaper.a(-0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, toFloatFunction);
        CubicSpline<c> cubicSpline4 = TerrainShaper.a(-0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, toFloatFunction);
        float f2 = -0.51f;
        float g2 = -0.4f;
        float h2 = 0.1f;
        float i2 = -0.15f;
        CubicSpline<c> cubicSpline5 = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.a, toFloatFunction).a(-1.1f, 0.044f, 0.0f).a(-1.02f, -0.2222f, 0.0f).a(-0.51f, -0.2222f, 0.0f).a(-0.44f, -0.12f, 0.0f).a(-0.18f, -0.12f, 0.0f).a(-0.16f, cubicSpline, 0.0f).a(-0.15f, cubicSpline, 0.0f).a(-0.1f, cubicSpline2, 0.0f).a(0.25f, cubicSpline3, 0.0f).a(1.0f, cubicSpline4, 0.0f).a();
        CubicSpline<c> cubicSpline6 = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.a, h).a(-0.19f, 3.95f, 0.0f).a(-0.15f, TerrainShaper.a(6.25f, true, h), 0.0f).a(-0.1f, TerrainShaper.a(5.47f, true, toFloatFunction2), 0.0f).a(0.03f, TerrainShaper.a(5.08f, true, toFloatFunction2), 0.0f).a(0.06f, TerrainShaper.a(4.69f, false, toFloatFunction2), 0.0f).a();
        float j2 = 0.65f;
        CubicSpline<c> cubicSpline7 = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.a, toFloatFunction3).a(-0.11f, 0.0f, 0.0f).a(0.03f, TerrainShaper.a(1.0f, 0.5f, 0.0f, 0.0f, toFloatFunction3), 0.0f).a(0.65f, TerrainShaper.a(1.0f, 1.0f, 1.0f, 0.0f, toFloatFunction3), 0.0f).a();
        return new TerrainShaper(cubicSpline5, cubicSpline6, cubicSpline7);
    }

    private static CubicSpline<c> a(float f2, float g2, float h2, float i2, ToFloatFunction<Float> toFloatFunction) {
        float j2 = -0.5775f;
        CubicSpline<c> cubicSpline = TerrainShaper.a(f2, h2, toFloatFunction);
        CubicSpline<c> cubicSpline2 = TerrainShaper.a(g2, i2, toFloatFunction);
        return CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.b, toFloatFunction).a(-1.0f, cubicSpline, 0.0f).a(-0.78f, cubicSpline2, 0.0f).a(-0.5775f, cubicSpline2, 0.0f).a(-0.375f, 0.0f, 0.0f).a();
    }

    private static CubicSpline<c> a(float f2, float g2, ToFloatFunction<Float> toFloatFunction) {
        float h2 = TerrainShaper.a(0.4f);
        float i2 = TerrainShaper.a(0.56666666f);
        float j2 = (h2 + i2) / 2.0f;
        CubicSpline.b<c> builder = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.d, toFloatFunction);
        builder.a(h2, 0.0f, 0.0f);
        if (g2 > 0.0f) {
            builder.a(j2, TerrainShaper.a(g2, toFloatFunction), 0.0f);
        } else {
            builder.a(j2, 0.0f, 0.0f);
        }
        if (f2 > 0.0f) {
            builder.a(1.0f, TerrainShaper.a(f2, toFloatFunction), 0.0f);
        } else {
            builder.a(1.0f, 0.0f, 0.0f);
        }
        return builder.a();
    }

    private static CubicSpline<c> a(float f2, ToFloatFunction<Float> toFloatFunction) {
        float g2 = 0.63f * f2;
        float h2 = 0.3f * f2;
        return CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.c, toFloatFunction).a(-0.01f, g2, 0.0f).a(0.01f, h2, 0.0f).a();
    }

    private static CubicSpline<c> a(float value, boolean bl, ToFloatFunction<Float> toFloatFunction) {
        CubicSpline<c> cubicSpline = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.c, toFloatFunction).a(-0.2f, 6.3f, 0.0f).a(0.2f, value, 0.0f).a();
        CubicSpline.b<c> builder = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.b, toFloatFunction).a(-0.6f, cubicSpline, 0.0f).a(-0.5f, CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.c, toFloatFunction).a(-0.05f, 6.3f, 0.0f).a(0.05f, 2.67f, 0.0f).a(), 0.0f).a(-0.35f, cubicSpline, 0.0f).a(-0.25f, cubicSpline, 0.0f).a(-0.1f, CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.c, toFloatFunction).a(-0.05f, 2.67f, 0.0f).a(0.05f, 6.3f, 0.0f).a(), 0.0f).a(0.03f, cubicSpline, 0.0f);
        if (bl) {
            CubicSpline<c> cubicSpline2 = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.c, toFloatFunction).a(0.0f, value, 0.0f).a(0.1f, 0.625f, 0.0f).a();
            CubicSpline<c> cubicSpline3 = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.d, toFloatFunction).a(-0.9f, value, 0.0f).a(-0.69f, cubicSpline2, 0.0f).a();
            builder.a(0.35f, value, 0.0f).a(0.45f, cubicSpline3, 0.0f).a(0.55f, cubicSpline3, 0.0f).a(0.62f, value, 0.0f);
        } else {
            CubicSpline<c> cubicSpline4 = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.d, toFloatFunction).a(-0.7f, cubicSpline, 0.0f).a(-0.15f, 1.37f, 0.0f).a();
            CubicSpline<c> cubicSpline5 = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.d, toFloatFunction).a(0.45f, cubicSpline, 0.0f).a(0.7f, 1.56f, 0.0f).a();
            builder.a(0.05f, cubicSpline5, 0.0f).a(0.4f, cubicSpline5, 0.0f).a(0.45f, cubicSpline4, 0.0f).a(0.55f, cubicSpline4, 0.0f).a(0.58f, value, 0.0f);
        }
        return builder.a();
    }

    private static float a(float f2, float g2, float h2, float i2) {
        return (g2 - f2) / (i2 - h2);
    }

    private static CubicSpline<c> b(float f2, boolean bl, ToFloatFunction<Float> toFloatFunction) {
        CubicSpline.b<c> builder = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.d, toFloatFunction);
        float g2 = -0.7f;
        float h2 = -1.0f;
        float i2 = TerrainShaper.b(-1.0f, f2, -0.7f);
        float j2 = 1.0f;
        float k2 = TerrainShaper.b(1.0f, f2, -0.7f);
        float l2 = TerrainShaper.e(f2);
        float m2 = -0.65f;
        if (-0.65f < l2 && l2 < 1.0f) {
            float n2 = TerrainShaper.b(-0.65f, f2, -0.7f);
            float o2 = -0.75f;
            float p2 = TerrainShaper.b(-0.75f, f2, -0.7f);
            float q2 = TerrainShaper.a(i2, p2, -1.0f, -0.75f);
            builder.a(-1.0f, i2, q2);
            builder.a(-0.75f, p2, 0.0f);
            builder.a(-0.65f, n2, 0.0f);
            float r2 = TerrainShaper.b(l2, f2, -0.7f);
            float s2 = TerrainShaper.a(r2, k2, l2, 1.0f);
            float t2 = 0.01f;
            builder.a(l2 - 0.01f, r2, 0.0f);
            builder.a(l2, r2, s2);
            builder.a(1.0f, k2, s2);
        } else {
            float u2 = TerrainShaper.a(i2, k2, -1.0f, 1.0f);
            if (bl) {
                builder.a(-1.0f, Math.max(0.2f, i2), 0.0f);
                builder.a(0.0f, MathHelper.i(0.5f, i2, k2), u2);
            } else {
                builder.a(-1.0f, i2, u2);
            }
            builder.a(1.0f, k2, u2);
        }
        return builder.a();
    }

    private static float b(float weirdness, float continentalness, float weirdnessThreshold) {
        float f2 = 1.17f;
        float g2 = 0.46082947f;
        float h2 = 1.0f - (1.0f - continentalness) * 0.5f;
        float i2 = 0.5f * (1.0f - continentalness);
        float j2 = (weirdness + 1.17f) * 0.46082947f;
        float k2 = j2 * h2 - i2;
        if (weirdness < weirdnessThreshold) {
            return Math.max(k2, -0.2222f);
        }
        return Math.max(k2, 0.0f);
    }

    private static float e(float continentalness) {
        float f2 = 1.17f;
        float g2 = 0.46082947f;
        float h2 = 1.0f - (1.0f - continentalness) * 0.5f;
        float i2 = 0.5f * (1.0f - continentalness);
        return i2 / (0.46082947f * h2) - 1.17f;
    }

    private static CubicSpline<c> a(float f2, float g2, float h2, float i2, float j2, float k2, boolean bl, boolean bl2, ToFloatFunction<Float> toFloatFunction) {
        float l2 = 0.6f;
        float m2 = 0.5f;
        float n2 = 0.5f;
        CubicSpline<c> cubicSpline = TerrainShaper.b(MathHelper.i(i2, 0.6f, 1.5f), bl2, toFloatFunction);
        CubicSpline<c> cubicSpline2 = TerrainShaper.b(MathHelper.i(i2, 0.6f, 1.0f), bl2, toFloatFunction);
        CubicSpline<c> cubicSpline3 = TerrainShaper.b(i2, bl2, toFloatFunction);
        CubicSpline<c> cubicSpline4 = TerrainShaper.a(f2 - 0.15f, 0.5f * i2, MathHelper.i(0.5f, 0.5f, 0.5f) * i2, 0.5f * i2, 0.6f * i2, 0.5f, toFloatFunction);
        CubicSpline<c> cubicSpline5 = TerrainShaper.a(f2, j2 * i2, g2 * i2, 0.5f * i2, 0.6f * i2, 0.5f, toFloatFunction);
        CubicSpline<c> cubicSpline6 = TerrainShaper.a(f2, j2, j2, g2, h2, 0.5f, toFloatFunction);
        CubicSpline<c> cubicSpline7 = TerrainShaper.a(f2, j2, j2, g2, h2, 0.5f, toFloatFunction);
        CubicSpline<c> cubicSpline8 = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.d, toFloatFunction).a(-1.0f, f2, 0.0f).a(-0.4f, cubicSpline6, 0.0f).a(0.0f, h2 + 0.07f, 0.0f).a();
        CubicSpline<c> cubicSpline9 = TerrainShaper.a(-0.02f, k2, k2, g2, h2, 0.0f, toFloatFunction);
        CubicSpline.b<c> builder = CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.b, toFloatFunction).a(-0.85f, cubicSpline, 0.0f).a(-0.7f, cubicSpline2, 0.0f).a(-0.4f, cubicSpline3, 0.0f).a(-0.35f, cubicSpline4, 0.0f).a(-0.1f, cubicSpline5, 0.0f).a(0.2f, cubicSpline6, 0.0f);
        if (bl) {
            builder.a(0.4f, cubicSpline7, 0.0f).a(0.45f, cubicSpline8, 0.0f).a(0.55f, cubicSpline8, 0.0f).a(0.58f, cubicSpline7, 0.0f);
        }
        builder.a(0.7f, cubicSpline9, 0.0f);
        return builder.a();
    }

    private static CubicSpline<c> a(float f2, float g2, float h2, float i2, float j2, float k2, ToFloatFunction<Float> toFloatFunction) {
        float l2 = Math.max(0.5f * (g2 - f2), k2);
        float m2 = 5.0f * (h2 - g2);
        return CubicSpline.a(net.minecraft.world.level.biome.TerrainShaper$a.d, toFloatFunction).a(-1.0f, f2, l2).a(-0.4f, g2, Math.min(l2, m2)).a(0.0f, h2, m2).a(0.4f, i2, 2.0f * (i2 - h2)).a(1.0f, j2, 0.7f * (j2 - i2)).a();
    }

    public void a(Consumer<Pair<Climate.d, ResourceKey<BiomeBase>>> parameters) {
        int n2;
        Climate.b parameter = Climate.b.a(-1.0f, 1.0f);
        parameters.accept((Pair<Climate.d, ResourceKey<BiomeBase>>)Pair.of((Object)Climate.a(parameter, parameter, parameter, parameter, Climate.b.a(0.0f), parameter, 0.01f), Biomes.b));
        CubicSpline.e multipoint = (CubicSpline.e)TerrainShaper.a(-0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, h);
        ResourceKey<BiomeBase> resourceKey = Biomes.f;
        float[] fArray = multipoint.e();
        int n3 = fArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            Float float_ = Float.valueOf(fArray[n2]);
            parameters.accept((Pair<Climate.d, ResourceKey<BiomeBase>>)Pair.of((Object)Climate.a(parameter, parameter, parameter, Climate.b.a(float_.floatValue()), Climate.b.a(0.0f), parameter, 0.0f), resourceKey));
            resourceKey = resourceKey == Biomes.f ? Biomes.z : Biomes.f;
        }
        fArray = ((CubicSpline.e)this.c).e();
        n3 = fArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            Float float2 = Float.valueOf(fArray[n2]);
            parameters.accept((Pair<Climate.d, ResourceKey<BiomeBase>>)Pair.of((Object)Climate.a(parameter, parameter, Climate.b.a(float2.floatValue()), parameter, Climate.b.a(0.0f), parameter, 0.0f), Biomes.p));
        }
    }

    @VisibleForDebug
    public CubicSpline<c> a() {
        return this.c;
    }

    @VisibleForDebug
    public CubicSpline<c> b() {
        return this.d;
    }

    @VisibleForDebug
    public CubicSpline<c> c() {
        return this.e;
    }

    public float a(c point) {
        return this.c.apply(point) + -0.50375f;
    }

    public float b(c point) {
        return this.d.apply(point);
    }

    public float c(c point) {
        return this.e.apply(point);
    }

    public static c a(float f2, float g2, float h2) {
        return new c(f2, g2, TerrainShaper.a(h2), h2);
    }

    public static d a(DensityFunction.b functionContext) {
        return new d(functionContext);
    }

    public static float a(float weirdness) {
        return -(Math.abs(Math.abs(weirdness) - 0.6666667f) - 0.33333334f) * 3.0f;
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TerrainShaper.class, "offsetSampler;factorSampler;jaggednessSampler", "c", "d", "e"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TerrainShaper.class, "offsetSampler;factorSampler;jaggednessSampler", "c", "d", "e"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TerrainShaper.class, "offsetSampler;factorSampler;jaggednessSampler", "c", "d", "e"}, this, object);
    }

    @VisibleForTesting
    protected static final class a
    extends Enum<a>
    implements INamable,
    ToFloatFunction<c> {
        public static final /* enum */ a a = new a(c::a, "continents");
        public static final /* enum */ a b = new a(c::b, "erosion");
        public static final /* enum */ a c = new a(c::d, "weirdness");
        @Deprecated
        public static final /* enum */ a d = new a(c::c, "ridges");
        private static final Map<String, a> e;
        private static final Codec<a> f;
        static final Codec<ToFloatFunction<c>> g;
        private final ToFloatFunction<c> h;
        private final String i;
        private static final /* synthetic */ a[] j;

        public static a[] values() {
            return (a[])j.clone();
        }

        public static a valueOf(String string) {
            return Enum.valueOf(a.class, string);
        }

        private a(ToFloatFunction<c> noiseFunction, String id) {
            this.h = noiseFunction;
            this.i = id;
        }

        @Override
        @Override
        public String c() {
            return this.i;
        }

        @Override
        public String toString() {
            return this.i;
        }

        @Override
        public float a(c point) {
            return this.h.apply(point);
        }

        @Override
        public /* synthetic */ float apply(Object x2) {
            return this.a((c)x2);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c, d};
        }

        static {
            j = net.minecraft.world.level.biome.TerrainShaper$a.a();
            e = Arrays.stream(net.minecraft.world.level.biome.TerrainShaper$a.values()).collect(Collectors.toMap(a::c, coordinate -> coordinate));
            f = INamable.a(a::values, e::get);
            g = f.flatComapMap(coordinate -> coordinate, toFloatFunction -> {
                DataResult dataResult;
                if (toFloatFunction instanceof a) {
                    a coordinate = (a)toFloatFunction;
                    dataResult = DataResult.success((Object)coordinate);
                } else {
                    dataResult = DataResult.error((String)("Not a coordinate resolver: " + toFloatFunction));
                }
                return dataResult;
            });
        }
    }

    public record c(float a, float b, float c, float d) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "continents;erosion;ridges;weirdness", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "continents;erosion;ridges;weirdness", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "continents;erosion;ridges;weirdness", "a", "b", "c", "d"}, this, object);
        }
    }

    public record d(DensityFunction.b a) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "context", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "context", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "context", "a"}, this, object);
        }
    }

    public record b(Holder<DensityFunction> a) implements ToFloatFunction<d>
    {
        static final Codec<ToFloatFunction<d>> b = DensityFunction.c.flatComapMap(b::new, toFloatFunction -> {
            DataResult dataResult;
            if (toFloatFunction instanceof b) {
                b coordinateCustom = (b)toFloatFunction;
                dataResult = DataResult.success(coordinateCustom.a());
            } else {
                dataResult = DataResult.error((String)("Not a coordinate resolver: " + toFloatFunction));
            }
            return dataResult;
        });

        @Override
        public float a(d pointCustom) {
            return (float)this.a.a().a(pointCustom.a());
        }

        public b a(DensityFunction.e visitor) {
            return new b(new Holder.a<DensityFunction>(this.a.a().a(visitor)));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "function", "a"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "function", "a"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "function", "a"}, this, object);
        }

        @Override
        public /* synthetic */ float apply(Object x2) {
            return this.a((d)x2);
        }
    }
}

