/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.util.INamable;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import org.slf4j.Logger;

public class BiomeSettingsMobs {
    private static final Logger d = LogUtils.getLogger();
    private static final float e = 0.1f;
    public static final WeightedRandomList<c> a = WeightedRandomList.c();
    public static final BiomeSettingsMobs b = new a().a();
    public static final MapCodec<BiomeSettingsMobs> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)0.9999999f).optionalFieldOf("creature_spawn_probability", (Object)Float.valueOf(0.1f)).forGetter(mobSpawnSettings -> Float.valueOf(mobSpawnSettings.f)), (App)Codec.simpleMap(EnumCreatureType.i, (Codec)WeightedRandomList.c(net.minecraft.world.level.biome.BiomeSettingsMobs$c.a).promotePartial(SystemUtils.a("Spawn data: ", arg_0 -> ((Logger)d).error(arg_0))), (Keyable)INamable.a(EnumCreatureType.values())).fieldOf("spawners").forGetter(mobSpawnSettings -> mobSpawnSettings.g), (App)Codec.simpleMap(IRegistry.W.o(), net.minecraft.world.level.biome.BiomeSettingsMobs$b.a, IRegistry.W).fieldOf("spawn_costs").forGetter(mobSpawnSettings -> mobSpawnSettings.h)).apply((Applicative)instance, BiomeSettingsMobs::new));
    private final float f;
    private final Map<EnumCreatureType, WeightedRandomList<c>> g;
    private final Map<EntityTypes<?>, b> h;

    BiomeSettingsMobs(float creatureSpawnProbability, Map<EnumCreatureType, WeightedRandomList<c>> spawners, Map<EntityTypes<?>, b> spawnCosts) {
        this.f = creatureSpawnProbability;
        this.g = ImmutableMap.copyOf(spawners);
        this.h = ImmutableMap.copyOf(spawnCosts);
    }

    public WeightedRandomList<c> a(EnumCreatureType spawnGroup) {
        return this.g.getOrDefault(spawnGroup, a);
    }

    @Nullable
    public b a(EntityTypes<?> entityType) {
        return this.h.get(entityType);
    }

    public float a() {
        return this.f;
    }

    public static class b {
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(mobSpawnCost -> mobSpawnCost.b), (App)Codec.DOUBLE.fieldOf("charge").forGetter(mobSpawnCost -> mobSpawnCost.c)).apply((Applicative)instance, b::new));
        private final double b;
        private final double c;

        b(double gravityLimit, double mass) {
            this.b = gravityLimit;
            this.c = mass;
        }

        public double a() {
            return this.b;
        }

        public double b() {
            return this.c;
        }
    }

    public static class c
    extends WeightedEntry.a {
        public static final Codec<c> a = RecordCodecBuilder.create(instance -> instance.group((App)IRegistry.W.o().fieldOf("type").forGetter(spawnerData -> spawnerData.b), (App)Weight.a.fieldOf("weight").forGetter(WeightedEntry.a::a), (App)Codec.INT.fieldOf("minCount").forGetter(spawnerData -> spawnerData.c), (App)Codec.INT.fieldOf("maxCount").forGetter(spawnerData -> spawnerData.d)).apply((Applicative)instance, c::new));
        public final EntityTypes<?> b;
        public final int c;
        public final int d;

        public c(EntityTypes<?> type, int weight, int minGroupSize, int maxGroupSize) {
            this(type, Weight.a(weight), minGroupSize, maxGroupSize);
        }

        public c(EntityTypes<?> type, Weight weight, int minGroupSize, int maxGroupSize) {
            super(weight);
            this.b = type.f() == EnumCreatureType.h ? EntityTypes.an : type;
            this.c = minGroupSize;
            this.d = maxGroupSize;
        }

        public String toString() {
            return EntityTypes.a(this.b) + "*(" + this.c + "-" + this.d + "):" + this.a();
        }
    }

    public static class a {
        private final Map<EnumCreatureType, List<c>> a = (Map)Stream.of(EnumCreatureType.values()).collect(Maps.toImmutableEnumMap(mobCategory -> mobCategory, mobCategory -> new MobList()));
        private final Map<EntityTypes<?>, b> b = Maps.newLinkedHashMap();
        private float c = 0.1f;

        public a a(EnumCreatureType spawnGroup, c spawnEntry) {
            this.a.get(spawnGroup).add(spawnEntry);
            return this;
        }

        public a a(EntityTypes<?> entityType, double mass, double gravityLimit) {
            this.b.put(entityType, new b(gravityLimit, mass));
            return this;
        }

        public a a(float probability) {
            this.c = probability;
            return this;
        }

        public BiomeSettingsMobs a() {
            return new BiomeSettingsMobs(this.c, (Map)this.a.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> WeightedRandomList.a((List)entry.getValue()))), (Map<EntityTypes<?>, b>)ImmutableMap.copyOf(this.b));
        }

        public static class MobList
        extends ArrayList<c> {
            Set<c> biomes = new HashSet<c>();

            @Override
            public boolean contains(Object o2) {
                return this.biomes.contains(o2);
            }

            @Override
            public boolean add(c BiomeSettingsMobs2) {
                this.biomes.add(BiomeSettingsMobs2);
                return super.add(BiomeSettingsMobs2);
            }

            @Override
            public c remove(int index) {
                c removed = (c)super.remove(index);
                if (removed != null) {
                    this.biomes.remove(removed);
                }
                return removed;
            }

            @Override
            public void clear() {
                this.biomes.clear();
                super.clear();
            }
        }
    }
}

