/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import co.aikar.timings.TimingHistory;
import co.aikar.timings.WorldTimingsHandler;
import com.destroystokyo.paper.PaperWorldConfig;
import com.destroystokyo.paper.antixray.ChunkPacketBlockController;
import com.destroystokyo.paper.antixray.ChunkPacketBlockControllerAntiXray;
import com.destroystokyo.paper.event.block.BlockDestroyEvent;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.papermc.paper.world.ChunkEntitySlices;
import io.papermc.paper.world.EntitySliceManager;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MCUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataMutable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftSpawnCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.world.GenericGameEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TickLimiter;

public abstract class World
implements GeneratorAccess,
AutoCloseable {
    public static final Codec<ResourceKey<World>> d = MinecraftKey.a.xmap(ResourceKey.d(IRegistry.O), ResourceKey::a);
    public static final ResourceKey<World> e = ResourceKey.a(IRegistry.O, new MinecraftKey("overworld"));
    public static final ResourceKey<World> f = ResourceKey.a(IRegistry.O, new MinecraftKey("the_nether"));
    public static final ResourceKey<World> g = ResourceKey.a(IRegistry.O, new MinecraftKey("the_end"));
    public static final int h = 30000000;
    public static final int i = 512;
    public static final int j = 32;
    private static final EnumDirection[] a = EnumDirection.values();
    public static final int k = 15;
    public static final int l = 24000;
    public static final int m = 20000000;
    public static final int n = -20000000;
    protected final List<TickingBlockEntity> o = Lists.newArrayList();
    private final List<TickingBlockEntity> b = Lists.newArrayList();
    private boolean c;
    public final Thread y;
    private final boolean z;
    private int A;
    protected int p = new Random().nextInt();
    protected final int q = 1013904223;
    protected float r;
    public float s;
    protected float t;
    public float u;
    public final Random v = new Random();
    final DimensionManager B;
    private final Holder<DimensionManager> C;
    public final WorldDataMutable w;
    private final Supplier<GameProfilerFiller> D;
    public final boolean x;
    private final WorldBorder E;
    private final BiomeManager F;
    private final ResourceKey<World> G;
    private long H;
    private final CraftWorld world;
    public boolean pvpMode;
    public boolean keepSpawnInMemory = true;
    public ChunkGenerator generator;
    public static final boolean DEBUG_ENTITIES = Boolean.getBoolean("debug.entities");
    public boolean preventPoiUpdated = false;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public Map<BlockPosition, CraftBlockState> capturedBlockStates = new LinkedHashMap<BlockPosition, CraftBlockState>();
    public Map<BlockPosition, TileEntity> capturedTileEntities = new LinkedHashMap<BlockPosition, TileEntity>();
    public List<EntityItem> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public int wakeupInactiveRemainingAnimals;
    public int wakeupInactiveRemainingFlying;
    public int wakeupInactiveRemainingMonsters;
    public int wakeupInactiveRemainingVillagers;
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    public final PaperWorldConfig paperConfig;
    public final ChunkPacketBlockController chunkPacketBlockController;
    public final WorldTimingsHandler timings;
    public static BlockPosition lastPhysicsProblem;
    private TickLimiter entityLimiter;
    private TickLimiter tileLimiter;
    private int tileTickPosition;
    public final Map<Explosion.CacheKey, Float> explosionDensityCache = new HashMap<Explosion.CacheKey, Float>();
    public ArrayDeque<BlockRedstoneTorch.RedstoneUpdateInfo> redstoneUpdateInfos;
    protected final EntitySliceManager entitySliceManager;

    public final int getTotalTileEntityTickers() {
        return this.o.size();
    }

    public static ResourceKey<DimensionManager> getDimensionKey(DimensionManager manager) {
        return ((CraftServer)Bukkit.getServer()).getHandle().b().Q.b(IRegistry.N).c(manager).orElseThrow(() -> new IllegalStateException("Unregistered dimension type: " + manager));
    }

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.getChunkIfLoaded(chunkX, chunkZ) != null;
    }

    public final List<EntityPlayer> getNearbyPlayers(@Nullable net.minecraft.world.entity.Entity source, double sourceX, double sourceY, double sourceZ, double maxRange, @Nullable Predicate<net.minecraft.world.entity.Entity> predicate) {
        Chunk chunk;
        if (maxRange < 0.0 || maxRange >= 624.0 || (chunk = (Chunk)this.getChunkIfLoadedImmediately(MathHelper.b(sourceX) >> 4, MathHelper.b(sourceZ) >> 4)) == null) {
            return this.getNearbyPlayersSlow(source, sourceX, sourceY, sourceZ, maxRange, predicate);
        }
        ArrayList<EntityPlayer> ret = new ArrayList<EntityPlayer>();
        chunk.getNearestPlayers(sourceX, sourceY, sourceZ, predicate, maxRange, ret);
        return ret;
    }

    private List<EntityPlayer> getNearbyPlayersSlow(@Nullable net.minecraft.world.entity.Entity source, double sourceX, double sourceY, double sourceZ, double maxRange, @Nullable Predicate<net.minecraft.world.entity.Entity> predicate) {
        ArrayList<EntityPlayer> ret = new ArrayList<EntityPlayer>();
        double maxRangeSquared = maxRange * maxRange;
        for (EntityPlayer entityPlayer : this.y()) {
            if (!(maxRange < 0.0) && !(entityPlayer.h(sourceX, sourceY, sourceZ) < maxRangeSquared) || predicate != null && !predicate.test(entityPlayer)) continue;
            ret.add(entityPlayer);
        }
        return ret;
    }

    private EntityPlayer getNearestPlayerSlow(@Nullable net.minecraft.world.entity.Entity source, double sourceX, double sourceY, double sourceZ, double maxRange, @Nullable Predicate<net.minecraft.world.entity.Entity> predicate) {
        EntityPlayer closest = null;
        double closestRangeSquared = maxRange < 0.0 ? Double.MAX_VALUE : maxRange * maxRange;
        for (EntityPlayer entityPlayer : this.y()) {
            double distanceSquared = entityPlayer.h(sourceX, sourceY, sourceZ);
            if (!(distanceSquared < closestRangeSquared) || predicate != null && !predicate.test(entityPlayer)) continue;
            closest = entityPlayer;
            closestRangeSquared = distanceSquared;
        }
        return closest;
    }

    public final EntityPlayer getNearestPlayer(@Nullable net.minecraft.world.entity.Entity source, double sourceX, double sourceY, double sourceZ, double maxRange, @Nullable Predicate<net.minecraft.world.entity.Entity> predicate) {
        Chunk chunk;
        if (maxRange < 0.0 || maxRange >= 624.0 || (chunk = (Chunk)this.getChunkIfLoadedImmediately(MathHelper.b(sourceX) >> 4, MathHelper.b(sourceZ) >> 4)) == null) {
            return this.getNearestPlayerSlow(source, sourceX, sourceY, sourceZ, maxRange, predicate);
        }
        return chunk.findNearestPlayer(sourceX, sourceY, sourceZ, maxRange, predicate);
    }

    @Override
    @Nullable
    public EntityHuman a(double d0, double d1, double d2, double d3, @Nullable Predicate<net.minecraft.world.entity.Entity> predicate) {
        return this.getNearestPlayer(null, d0, d1, d2, d3, predicate);
    }

    public abstract ResourceKey<WorldDimension> getTypeKey();

    protected World(WorldDataMutable worlddatamutable, ResourceKey<World> resourcekey, Holder<DimensionManager> holder, Supplier<GameProfilerFiller> supplier, boolean flag, boolean flag1, long i2, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env, Executor executor) {
        this.spigotConfig = new SpigotWorldConfig(((WorldDataServer)worlddatamutable).g());
        this.paperConfig = new PaperWorldConfig(((WorldDataServer)worlddatamutable).g(), this.spigotConfig);
        this.generator = gen;
        this.world = new CraftWorld((WorldServer)this, gen, biomeProvider, env);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getCraftServer().getTicksPerSpawns(spawnCategory));
        }
        this.D = supplier;
        this.w = worlddatamutable;
        this.C = holder;
        this.B = holder.a();
        this.G = resourcekey;
        this.x = flag;
        this.E = this.B.e() != 1.0 ? new WorldBorder(){

            @Override
            public double a() {
                return super.a();
            }

            @Override
            public double b() {
                return super.b();
            }
        } : new WorldBorder();
        this.y = Thread.currentThread();
        this.F = new BiomeManager(this, i2);
        this.z = flag1;
        this.p_().world = (WorldServer)this;
        this.p_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder border, double size) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double fromSize, double toSize, long time) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, double centerX, double centerZ) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderCenterPacket(border), border.world);
            }

            @Override
            public void a(WorldBorder border, int warningTime) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, int warningBlockDistance) {
                World.this.getCraftServer().getHandle().broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(border), border.world);
            }

            @Override
            public void b(WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void c(WorldBorder border, double safeZoneRadius) {
            }
        });
        this.timings = new WorldTimingsHandler(this);
        this.keepSpawnInMemory = this.paperConfig.keepSpawnInMemory;
        this.entityLimiter = new TickLimiter(this.spigotConfig.entityMaxTickTime);
        this.tileLimiter = new TickLimiter(this.spigotConfig.tileMaxTickTime);
        this.chunkPacketBlockController = this.paperConfig.antiXray ? new ChunkPacketBlockControllerAntiXray(this, executor) : ChunkPacketBlockController.NO_OPERATION_INSTANCE;
        this.entitySliceManager = new EntitySliceManager((WorldServer)this);
    }

    public final boolean checkEntityCollision(IBlockData data, net.minecraft.world.entity.Entity source, VoxelShapeCollision voxelshapedcollision, BlockPosition position, boolean checkCanSee) {
        VoxelShape voxelshape = data.b((IBlockAccess)this, position, voxelshapedcollision);
        if (voxelshape.b()) {
            return true;
        }
        if ((voxelshape = voxelshape.a((double)position.u(), (double)position.v(), (double)position.w())).b()) {
            return true;
        }
        List<net.minecraft.world.entity.Entity> entities = this.a_(null, voxelshape.a());
        int len = entities.size();
        for (int i2 = 0; i2 < len; ++i2) {
            net.minecraft.world.entity.Entity entity = entities.get(i2);
            if (checkCanSee && source instanceof EntityPlayer && entity instanceof EntityPlayer && !((EntityPlayer)source).getBukkitEntity().canSee(((EntityPlayer)entity).getBukkitEntity()) || entity.dp() || !entity.q || !VoxelShapes.c(voxelshape, VoxelShapes.a(entity.cw()), OperatorBoolean.i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean k_() {
        return this.x;
    }

    @Override
    @Nullable
    public MinecraftServer n() {
        return null;
    }

    public boolean j(BlockPosition pos) {
        return pos.isInsideBuildHeightAndWorldBoundsHorizontal(this);
    }

    public static boolean k(BlockPosition pos) {
        return !World.b(pos.v()) && World.D(pos);
    }

    private static boolean D(BlockPosition pos) {
        return pos.u() >= -30000000 && pos.w() >= -30000000 && pos.u() < 30000000 && pos.w() < 30000000;
    }

    private static boolean b(int y2) {
        return y2 < -20000000 || y2 >= 20000000;
    }

    public final Chunk l(BlockPosition pos) {
        return this.d(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    public final Chunk d(int chunkX, int chunkZ) {
        Chunk ifLoaded;
        ChunkProviderServer cps = ((WorldServer)this).k();
        if (cps.e == Thread.currentThread() && (ifLoaded = cps.getChunkAtIfLoadedMainThread(chunkX, chunkZ)) != null) {
            return ifLoaded;
        }
        return (Chunk)this.a(chunkX, chunkZ, ChunkStatus.o, true);
    }

    @Override
    @Nullable
    public final IChunkAccess getChunkIfLoadedImmediately(int x2, int z2) {
        return ((WorldServer)this).K.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    @Nullable
    public final IBlockData getBlockStateIfLoaded(BlockPosition blockposition) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(blockposition)) != null) {
            return previous.getHandle();
        }
        if (!this.j(blockposition)) {
            return Blocks.a.n();
        }
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.a_(blockposition);
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.b_(blockposition);
    }

    @Override
    public final boolean C(BlockPosition pos) {
        return this.getChunkIfLoaded(pos.u() >> 4, pos.w() >> 4) != null;
    }

    public final boolean isLoadedAndInBounds(BlockPosition blockposition) {
        return this.p_().a(blockposition) && this.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4) != null;
    }

    @Nullable
    public Chunk getChunkIfLoaded(int x2, int z2) {
        return ((WorldServer)this).k().getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Nullable
    public final Chunk getChunkIfLoaded(BlockPosition blockposition) {
        return ((WorldServer)this).k().getChunkAtIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4);
    }

    @Nullable
    public final IBlockData getBlockStateIfLoadedAndInBounds(BlockPosition blockposition) {
        return this.p_().a(blockposition) ? this.getBlockStateIfLoaded(blockposition) : null;
    }

    @Override
    public final IChunkAccess a(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        IChunkAccess ichunkaccess = this.K().a(chunkX, chunkZ, leastStatus, create);
        if (ichunkaccess == null && create) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return ichunkaccess;
    }

    @Override
    public final boolean a(BlockPosition pos, IBlockData state, int flags) {
        return this.a(pos, state, flags, 512);
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags, int maxUpdateDepth) {
        if (this.captureTreeGeneration) {
            IBlockData type = this.a_(pos);
            if (!type.isDestroyable()) {
                return false;
            }
            CraftBlockState blockstate = this.capturedBlockStates.get(pos);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, pos, flags);
                this.capturedBlockStates.put(pos.h(), blockstate);
            }
            blockstate.setData(state);
            return true;
        }
        if (this.u(pos)) {
            return false;
        }
        if (!this.x && this.ad()) {
            return false;
        }
        Chunk chunk = this.l(pos);
        Block block = state.b();
        boolean captured = false;
        if (this.captureBlockStates && !this.capturedBlockStates.containsKey(pos)) {
            CraftBlockState blockstate = (CraftBlockState)this.world.getBlockAt(pos.u(), pos.v(), pos.w()).getState();
            blockstate.setFlag(flags);
            this.capturedBlockStates.put(pos.h(), blockstate);
            captured = true;
        }
        IBlockData iblockdata1 = chunk.setBlockState(pos, state, (flags & 0x40) != 0, (flags & 0x400) == 0);
        this.chunkPacketBlockController.onBlockChange(this, pos, state, iblockdata1, flags, maxUpdateDepth);
        if (iblockdata1 == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(pos);
            }
            return false;
        }
        IBlockData iblockdata2 = this.a_(pos);
        if ((flags & 0x80) == 0 && iblockdata2 != iblockdata1 && (iblockdata2.b((IBlockAccess)this, pos) != iblockdata1.b((IBlockAccess)this, pos) || iblockdata2.f() != iblockdata1.f() || iblockdata2.e() || iblockdata1.e())) {
            this.ab().a("queueCheckLight");
            this.K().n().a(pos);
            this.ab().c();
        }
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(pos, chunk, iblockdata1, state, iblockdata2, flags, maxUpdateDepth);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = new BlockPosition(pos);
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPosition blockposition, Chunk chunk, IBlockData oldBlock, IBlockData newBlock, IBlockData actualBlock, int i2, int j2) {
        IBlockData iblockdata = newBlock;
        IBlockData iblockdata1 = oldBlock;
        IBlockData iblockdata2 = actualBlock;
        if (iblockdata2 == iblockdata) {
            if (iblockdata1 != iblockdata2) {
                this.b(blockposition, iblockdata1, iblockdata2);
            }
            if ((i2 & 2) != 0 && (!this.x || (i2 & 4) == 0) && (this.x || chunk == null || chunk.B() != null && chunk.B().a(PlayerChunk.State.c))) {
                this.a(blockposition, iblockdata1, iblockdata, i2);
            } else if (!((i2 & 2) == 0 || this.x && (i2 & 4) != 0 || !this.x && chunk != null && ((WorldServer)this).k().a.playerChunkManager.broadcastMap.getObjectsInRange(MCUtil.getCoordinateKey(blockposition)) == null)) {
                ((WorldServer)this).k().a(blockposition);
            }
            if ((i2 & 1) != 0) {
                this.a(blockposition, iblockdata1.b());
                if (!this.x && iblockdata.j()) {
                    this.c(blockposition, newBlock.b());
                }
            }
            if ((i2 & 0x10) == 0 && j2 > 0) {
                int k2 = i2 & 0xFFFFFFDE;
                iblockdata1.b((GeneratorAccess)this, blockposition, k2, j2 - 1);
                CraftWorld world = ((WorldServer)this).getWorld();
                if (world != null && ((WorldServer)this).hasPhysicsEvent) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()), (BlockData)CraftBlockData.fromData(iblockdata));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                iblockdata.a((GeneratorAccess)this, blockposition, k2, j2 - 1);
                iblockdata.b((GeneratorAccess)this, blockposition, k2, j2 - 1);
            }
            if (!this.preventPoiUpdated) {
                this.a(blockposition, iblockdata1, iblockdata2);
            }
        }
    }

    public void a(BlockPosition pos, IBlockData oldBlock, IBlockData newBlock) {
    }

    @Override
    public boolean a(BlockPosition pos, boolean move) {
        Fluid fluid = this.b_(pos);
        return this.a(pos, fluid.g(), 3 | (move ? 64 : 0));
    }

    @Override
    public boolean a(BlockPosition pos, boolean drop, @Nullable net.minecraft.world.entity.Entity breakingEntity, int maxUpdateDepth) {
        boolean flag1;
        IBlockData iblockdata = this.a_(pos);
        if (iblockdata.g()) {
            return false;
        }
        Fluid fluid = this.b_(pos);
        boolean playEffect = true;
        if (BlockDestroyEvent.getHandlerList().getRegisteredListeners().length > 0) {
            BlockDestroyEvent event = new BlockDestroyEvent(MCUtil.toBukkitBlock(this, pos), (BlockData)fluid.g().createCraftBlockData(), drop);
            if (!event.callEvent()) {
                return false;
            }
            playEffect = event.playEffect();
        }
        if (playEffect && !(iblockdata.b() instanceof BlockFireAbstract)) {
            this.c(2001, pos, Block.i(iblockdata));
        }
        if (drop) {
            TileEntity tileentity = iblockdata.n() ? this.c_(pos) : null;
            Block.a(iblockdata, this, pos, tileentity, breakingEntity, ItemStack.b);
        }
        if (flag1 = this.a(pos, fluid.g(), 3, maxUpdateDepth)) {
            this.a(breakingEntity, GameEvent.d, pos);
        }
        return flag1;
    }

    public void a(BlockPosition pos, IBlockData state) {
    }

    public boolean b(BlockPosition pos, IBlockData state) {
        return this.a(pos, state, 3);
    }

    public abstract void a(BlockPosition var1, IBlockData var2, IBlockData var3, int var4);

    public void b(BlockPosition pos, IBlockData old, IBlockData updated) {
    }

    public void b(BlockPosition pos, Block block) {
        if (this.captureBlockStates) {
            return;
        }
        this.a(pos.f(), block, pos);
        this.a(pos.g(), block, pos);
        this.a(pos.c(), block, pos);
        this.a(pos.b(), block, pos);
        this.a(pos.d(), block, pos);
        this.a(pos.e(), block, pos);
    }

    public void a(BlockPosition pos, Block sourceBlock, EnumDirection direction) {
        if (direction != EnumDirection.e) {
            this.a(pos.f(), sourceBlock, pos);
        }
        if (direction != EnumDirection.f) {
            this.a(pos.g(), sourceBlock, pos);
        }
        if (direction != EnumDirection.a) {
            this.a(pos.c(), sourceBlock, pos);
        }
        if (direction != EnumDirection.b) {
            this.a(pos.b(), sourceBlock, pos);
        }
        if (direction != EnumDirection.c) {
            this.a(pos.d(), sourceBlock, pos);
        }
        if (direction != EnumDirection.d) {
            this.a(pos.e(), sourceBlock, pos);
        }
    }

    public void a(BlockPosition pos, Block sourceBlock, BlockPosition neighborPos) {
        if (!this.x) {
            IBlockData iblockdata = this.a_(pos);
            try {
                CraftWorld world = ((WorldServer)this).getWorld();
                if (world != null && ((WorldServer)this).hasPhysicsEvent) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent(world.getBlockAt(pos.u(), pos.v(), pos.w()), (BlockData)CraftBlockData.fromData(iblockdata), world.getBlockAt(neighborPos.u(), neighborPos.v(), neighborPos.w()));
                    this.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                iblockdata.a(this, pos, sourceBlock, neighborPos, false);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = new BlockPosition(pos);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a(throwable, "Exception while updating neighbours");
                CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being updated");
                crashreportsystemdetails.a("Source block type", () -> {
                    try {
                        return String.format("ID #%s (%s // %s)", IRegistry.U.b(sourceBlock), sourceBlock.h(), sourceBlock.getClass().getCanonicalName());
                    }
                    catch (Throwable throwable1) {
                        return "ID #" + IRegistry.U.b(sourceBlock);
                    }
                });
                CrashReportSystemDetails.a(crashreportsystemdetails, this, pos, iblockdata);
                throw new ReportedException(crashreport);
            }
        }
    }

    @Override
    public int a(HeightMap.Type heightmap, int x2, int z2) {
        int k2 = x2 >= -30000000 && z2 >= -30000000 && x2 < 30000000 && z2 < 30000000 ? (this.b(SectionPosition.a(x2), SectionPosition.a(z2)) ? this.d(SectionPosition.a(x2), SectionPosition.a(z2)).a(heightmap, x2 & 0xF, z2 & 0xF) + 1 : this.u_()) : this.m_() + 1;
        return k2;
    }

    @Override
    public LightEngine l_() {
        return this.K().n();
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(pos)) != null) {
            return previous.getHandle();
        }
        if (this.u(pos)) {
            return Blocks.lo.n();
        }
        IChunkAccess chunk = this.a(pos.u() >> 4, pos.w() >> 4, ChunkStatus.o, true);
        return chunk.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        if (this.u(pos)) {
            return FluidTypes.a.h();
        }
        Chunk chunk = this.l(pos);
        return chunk.b_(pos);
    }

    public boolean O() {
        return !this.q_().n() && this.A < 4;
    }

    public boolean P() {
        return !this.q_().n() && !this.O();
    }

    @Override
    public void a(@Nullable EntityHuman player, BlockPosition pos, SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.a(player, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, sound, category, volume, pitch);
    }

    public abstract void a(@Nullable EntityHuman var1, double var2, double var4, double var6, SoundEffect var8, SoundCategory var9, float var10, float var11);

    public abstract void a(@Nullable EntityHuman var1, net.minecraft.world.entity.Entity var2, SoundEffect var3, SoundCategory var4, float var5, float var6);

    public void a(double x2, double y2, double z2, SoundEffect sound, SoundCategory category, float volume, float pitch, boolean useDistance) {
    }

    @Override
    public void a(ParticleParam parameters, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public void a(ParticleParam parameters, boolean alwaysSpawn, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public void b(ParticleParam parameters, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public void b(ParticleParam parameters, boolean alwaysSpawn, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    public float a(float tickDelta) {
        float f1 = this.f(tickDelta);
        return f1 * ((float)Math.PI * 2);
    }

    public void a(TickingBlockEntity ticker) {
        (this.c ? this.b : this.o).add(ticker);
    }

    protected void Q() {
        GameProfilerFiller gameprofilerfiller = this.ab();
        gameprofilerfiller.a("blockEntities");
        this.timings.tileEntityPending.startTiming();
        this.c = true;
        if (!this.b.isEmpty()) {
            this.o.addAll(this.b);
            this.b.clear();
        }
        this.timings.tileEntityPending.stopTiming();
        this.timings.tileEntityTick.startTiming();
        int tilesThisCycle = 0;
        ObjectOpenCustomHashSet toRemove = new ObjectOpenCustomHashSet(SystemUtils.k());
        toRemove.add(null);
        this.tileTickPosition = 0;
        while (this.tileTickPosition < this.o.size()) {
            this.tileTickPosition = this.tileTickPosition < this.o.size() ? this.tileTickPosition : 0;
            TickingBlockEntity tickingblockentity = this.o.get(this.tileTickPosition);
            if (tickingblockentity == null) {
                this.getCraftServer().getLogger().severe("Spigot has detected a null entity and has removed it, preventing a crash");
                --tilesThisCycle;
            } else if (tickingblockentity.b()) {
                --tilesThisCycle;
                toRemove.add((Object)tickingblockentity);
            } else if (this.a(ChunkCoordIntPair.a(tickingblockentity.c()))) {
                tickingblockentity.a();
                if ((this.tileTickPosition & 7) == 0) {
                    MinecraftServer.getServer().executeMidTickTasks();
                }
            }
            ++this.tileTickPosition;
        }
        this.o.removeAll((Collection<?>)toRemove);
        this.timings.tileEntityTick.stopTiming();
        this.c = false;
        TimingHistory.tileEntityTicks += (long)this.o.size();
        gameprofilerfiller.c();
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(Consumer<T> tickConsumer, T entity) {
        try {
            tickConsumer.accept(entity);
            MinecraftServer.getServer().executeMidTickTasks();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw throwable;
            }
            String msg = String.format("Entity threw exception at %s:%s,%s,%s", entity.s.getWorld().getName(), entity.dc(), entity.de(), entity.di());
            MinecraftServer.q.error(msg, throwable);
            this.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, throwable)));
            entity.ah();
        }
    }

    @Override
    public boolean a(@Nullable net.minecraft.world.entity.Entity entity, AxisAlignedBB box) {
        if (entity instanceof EntityArmorStand && !entity.s.paperConfig.armorStandEntityLookups) {
            return false;
        }
        return GeneratorAccess.super.a(entity, box);
    }

    public boolean h(net.minecraft.world.entity.Entity entity) {
        return true;
    }

    public boolean a(long chunkPos) {
        return true;
    }

    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, Explosion.Effect destructionType) {
        return this.a(entity, null, null, x2, y2, z2, power, false, destructionType);
    }

    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, double x2, double y2, double z2, float power, boolean createFire, Explosion.Effect destructionType) {
        return this.a(entity, null, null, x2, y2, z2, power, createFire, destructionType);
    }

    public Explosion a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, Explosion.Effect destructionType) {
        Explosion explosion = new Explosion(this, entity, damageSource, behavior, x2, y2, z2, power, createFire, destructionType);
        explosion.a();
        explosion.a(true);
        return explosion;
    }

    public abstract String I();

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        return this.getBlockEntity(pos, true);
    }

    @Nullable
    public TileEntity getBlockEntity(BlockPosition blockposition, boolean validate) {
        TileEntity blockEntity;
        if (!this.capturedTileEntities.isEmpty() && (blockEntity = this.capturedTileEntities.get(blockposition)) != null) {
            return blockEntity;
        }
        return this.u(blockposition) ? null : (!this.x && Thread.currentThread() != this.y ? null : this.l(blockposition).a(blockposition, Chunk.EnumTileEntityState.a));
    }

    public void a(TileEntity blockEntity) {
        BlockPosition blockposition = blockEntity.p();
        if (!this.u(blockposition)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockposition.h(), blockEntity);
                return;
            }
            this.l(blockposition).b(blockEntity);
        }
    }

    public void m(BlockPosition pos) {
        if (!this.u(pos)) {
            this.l(pos).d(pos);
        }
    }

    public boolean n(BlockPosition pos) {
        return this.u(pos) ? false : this.K().b(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()));
    }

    public boolean a(BlockPosition pos, net.minecraft.world.entity.Entity entity, EnumDirection direction) {
        if (this.u(pos)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()), ChunkStatus.o, false);
        return ichunkaccess == null ? false : ichunkaccess.a_(pos).a((IBlockAccess)this, pos, entity, direction);
    }

    public boolean a(BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        return this.a(pos, entity, EnumDirection.b);
    }

    public void R() {
        double d0 = 1.0 - (double)(this.d(1.0f) * 5.0f) / 16.0;
        double d1 = 1.0 - (double)(this.b(1.0f) * 5.0f) / 16.0;
        double d2 = 0.5 + 2.0 * MathHelper.a((double)MathHelper.b(this.f(1.0f) * ((float)Math.PI * 2)), -0.25, 0.25);
        this.A = (int)((1.0 - d2 * d0 * d1) * 11.0);
    }

    public void b(boolean spawnMonsters, boolean spawnAnimals) {
        this.K().a(spawnMonsters, spawnAnimals);
    }

    protected void S() {
        if (this.w.k()) {
            this.s = 1.0f;
            if (this.w.i()) {
                this.u = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.K().close();
    }

    @Override
    @Nullable
    public IBlockAccess c(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.o, false);
    }

    @Override
    public List<net.minecraft.world.entity.Entity> a(@Nullable net.minecraft.world.entity.Entity except, AxisAlignedBB box, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        this.ab().d("getEntities");
        ArrayList list = Lists.newArrayList();
        this.entitySliceManager.getEntities(except, box, list, predicate);
        return list;
    }

    @Override
    public <T extends net.minecraft.world.entity.Entity> List<T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, AxisAlignedBB box, Predicate<? super T> predicate) {
        this.ab().d("getEntities");
        ArrayList list = Lists.newArrayList();
        if (filter instanceof EntityTypes) {
            this.entitySliceManager.getEntities((EntityTypes)filter, box, list, predicate);
        } else {
            Class<net.minecraft.world.entity.Entity> base;
            Predicate<net.minecraft.world.entity.Entity> test = obj -> filter.a((net.minecraft.world.entity.Entity)obj) != null;
            Predicate<net.minecraft.world.entity.Entity> predicate2 = predicate = predicate == null ? test : test.and(predicate);
            if (filter == null || (base = filter.a()) == null || base == net.minecraft.world.entity.Entity.class) {
                this.entitySliceManager.getEntities((net.minecraft.world.entity.Entity)null, box, list, predicate);
            } else {
                this.entitySliceManager.getEntities(base, null, box, list, predicate);
            }
        }
        return list;
    }

    @Nullable
    public abstract net.minecraft.world.entity.Entity a(int var1);

    public void o(BlockPosition pos) {
        if (this.C(pos)) {
            this.l(pos).a(true);
        }
    }

    @Override
    public int m_() {
        return 63;
    }

    public int p(BlockPosition pos) {
        int b0 = 0;
        int i2 = Math.max(b0, this.c(pos.c(), EnumDirection.a));
        if (i2 >= 15) {
            return i2;
        }
        if ((i2 = Math.max(i2, this.c(pos.b(), EnumDirection.b))) >= 15) {
            return i2;
        }
        if ((i2 = Math.max(i2, this.c(pos.d(), EnumDirection.c))) >= 15) {
            return i2;
        }
        if ((i2 = Math.max(i2, this.c(pos.e(), EnumDirection.d))) >= 15) {
            return i2;
        }
        if ((i2 = Math.max(i2, this.c(pos.f(), EnumDirection.e))) >= 15) {
            return i2;
        }
        return (i2 = Math.max(i2, this.c(pos.g(), EnumDirection.f))) >= 15 ? i2 : i2;
    }

    public boolean a(BlockPosition pos, EnumDirection direction) {
        return this.b(pos, direction) > 0;
    }

    public int b(BlockPosition pos, EnumDirection direction) {
        IBlockData iblockdata = this.a_(pos);
        int i2 = iblockdata.b((IBlockAccess)this, pos, direction);
        return iblockdata.g(this, pos) ? Math.max(i2, this.p(pos)) : i2;
    }

    public boolean q(BlockPosition pos) {
        return this.b(pos.c(), EnumDirection.a) > 0 ? true : (this.b(pos.b(), EnumDirection.b) > 0 ? true : (this.b(pos.d(), EnumDirection.c) > 0 ? true : (this.b(pos.e(), EnumDirection.d) > 0 ? true : (this.b(pos.f(), EnumDirection.e) > 0 ? true : this.b(pos.g(), EnumDirection.f) > 0))));
    }

    public int r(BlockPosition pos) {
        int i2 = 0;
        for (EnumDirection enumdirection : a) {
            int l2 = this.b(pos.a(enumdirection), enumdirection);
            if (l2 >= 15) {
                return 15;
            }
            if (l2 <= i2) continue;
            i2 = l2;
        }
        return i2;
    }

    public void T() {
    }

    public long U() {
        return this.w.e();
    }

    public long V() {
        return this.w.f();
    }

    public boolean a(EntityHuman player, BlockPosition pos) {
        return true;
    }

    public void a(net.minecraft.world.entity.Entity entity, byte status) {
    }

    public void a(BlockPosition pos, Block block, int type, int data) {
        this.a_(pos).a(this, pos, type, data);
    }

    @Override
    public WorldData n_() {
        return this.w;
    }

    public GameRules W() {
        return this.w.q();
    }

    public float b(float delta) {
        return MathHelper.i(delta, this.t, this.u) * this.d(delta);
    }

    public void c(float thunderGradient) {
        float f1;
        this.t = f1 = MathHelper.a(thunderGradient, 0.0f, 1.0f);
        this.u = f1;
    }

    public float d(float delta) {
        return MathHelper.i(delta, this.r, this.s);
    }

    public void e(float rainGradient) {
        float f1;
        this.r = f1 = MathHelper.a(rainGradient, 0.0f, 1.0f);
        this.s = f1;
    }

    public boolean X() {
        return this.q_().a() && !this.q_().b() ? (double)this.b(1.0f) > 0.9 : false;
    }

    public boolean Y() {
        return (double)this.d(1.0f) > 0.2;
    }

    public boolean s(BlockPosition pos) {
        if (!this.Y()) {
            return false;
        }
        if (!this.g(pos)) {
            return false;
        }
        if (this.a(HeightMap.Type.e, pos).v() > pos.v()) {
            return false;
        }
        BiomeBase biomebase = this.v(pos).a();
        return biomebase.c() == BiomeBase.Precipitation.b && biomebase.b(pos);
    }

    public boolean t(BlockPosition pos) {
        BiomeBase biomebase = this.v(pos).a();
        return biomebase.d();
    }

    @Nullable
    public abstract WorldMap a(String var1);

    public abstract void a(String var1, WorldMap var2);

    public abstract int u();

    public void b(int eventId, BlockPosition pos, int data) {
    }

    public CrashReportSystemDetails a(CrashReport report) {
        CrashReportSystemDetails crashreportsystemdetails = report.a("Affected level", 1);
        crashreportsystemdetails.a("All players", () -> {
            int i2 = this.y().size();
            return i2 + " total; " + this.y();
        });
        IChunkProvider ichunkprovider = this.K();
        Objects.requireNonNull(ichunkprovider);
        crashreportsystemdetails.a("Chunk stats", ichunkprovider::e);
        crashreportsystemdetails.a("Level dimension", () -> this.aa().a().toString());
        try {
            this.w.a(crashreportsystemdetails, this);
        }
        catch (Throwable throwable) {
            crashreportsystemdetails.a("Level Data Unobtainable", throwable);
        }
        return crashreportsystemdetails;
    }

    public abstract void a(int var1, BlockPosition var2, int var3);

    public void a(double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ, @Nullable NBTTagCompound nbt) {
    }

    public abstract Scoreboard J();

    public void c(BlockPosition pos, Block block) {
        for (EnumDirection enumdirection : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = pos.a(enumdirection);
            if (!this.C(blockposition1)) continue;
            IBlockData iblockdata = this.a_(blockposition1);
            if (iblockdata.a(Blocks.fH)) {
                iblockdata.a(this, blockposition1, block, pos, false);
                continue;
            }
            if (!iblockdata.g(this, blockposition1) || !(iblockdata = this.a_(blockposition1 = blockposition1.a(enumdirection))).a(Blocks.fH)) continue;
            iblockdata.a(this, blockposition1, block, pos, false);
        }
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition pos) {
        long i2 = 0L;
        float f2 = 0.0f;
        if (this.C(pos)) {
            f2 = this.ak();
            i2 = this.l(pos).u();
        }
        return new DifficultyDamageScaler(this.af(), this.V(), i2, f2);
    }

    @Override
    public int o_() {
        return this.A;
    }

    public void c(int lightningTicksLeft) {
    }

    @Override
    public WorldBorder p_() {
        return this.E;
    }

    public void a(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionManager q_() {
        return this.B;
    }

    public Holder<DimensionManager> Z() {
        return this.C;
    }

    public ResourceKey<World> aa() {
        return this.G;
    }

    @Override
    public Random r_() {
        return this.v;
    }

    @Override
    public boolean a(BlockPosition pos, Predicate<IBlockData> state) {
        return state.test(this.a_(pos));
    }

    @Override
    public boolean b(BlockPosition pos, Predicate<Fluid> state) {
        return state.test(this.b_(pos));
    }

    public abstract CraftingManager q();

    public BlockPosition a(int x2, int y2, int z2, int l2) {
        BlockPosition.MutableBlockPosition ret = new BlockPosition.MutableBlockPosition();
        this.getRandomBlockPosition(x2, y2, z2, l2, ret);
        return ret.h();
    }

    public final BlockPosition.MutableBlockPosition getRandomBlockPosition(int x2, int y2, int z2, int l2, BlockPosition.MutableBlockPosition out) {
        this.p = this.p * 3 + 1013904223;
        int i1 = this.p >> 2;
        out.d(x2 + (i1 & 0xF), y2 + (i1 >> 16 & l2), z2 + (i1 >> 8 & 0xF));
        return out;
    }

    public boolean r() {
        return false;
    }

    public GameProfilerFiller ab() {
        return this.D.get();
    }

    public Supplier<GameProfilerFiller> ac() {
        return this.D;
    }

    @Override
    public BiomeManager s_() {
        return this.F;
    }

    public final boolean ad() {
        return this.z;
    }

    public abstract LevelEntityGetter<net.minecraft.world.entity.Entity> H();

    protected void a(@Nullable net.minecraft.world.entity.Entity entity, GameEvent gameEvent, BlockPosition pos, int range) {
        GenericGameEvent event = new GenericGameEvent(org.bukkit.GameEvent.getByKey((NamespacedKey)CraftNamespacedKey.fromMinecraft(IRegistry.Q.b(gameEvent))), new Location((org.bukkit.World)this.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w()), (Entity)(entity == null ? null : entity.getBukkitEntity()), range);
        this.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        range = event.getRadius();
        int j2 = SectionPosition.a(pos.u() - range);
        int k2 = SectionPosition.a(pos.w() - range);
        int l2 = SectionPosition.a(pos.u() + range);
        int i1 = SectionPosition.a(pos.w() + range);
        int j1 = SectionPosition.a(pos.v() - range);
        int k1 = SectionPosition.a(pos.v() + range);
        for (int l1 = j2; l1 <= l2; ++l1) {
            for (int i2 = k2; i2 <= i1; ++i2) {
                Chunk chunk = (Chunk)this.getChunkIfLoadedImmediately(l1, i2);
                if (chunk == null) continue;
                for (int j22 = j1; j22 <= k1; ++j22) {
                    chunk.a(j22).a(gameEvent, entity, pos);
                }
            }
        }
    }

    @Override
    public long t_() {
        return this.H++;
    }

    public Entity[] getChunkEntities(int chunkX, int chunkZ) {
        ChunkEntitySlices slices = this.entitySliceManager.getChunk(chunkX, chunkZ);
        if (slices == null) {
            return new Entity[0];
        }
        return slices.getChunkEntities();
    }

    @Override
    public List<net.minecraft.world.entity.Entity> getHardCollidingEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        ArrayList<net.minecraft.world.entity.Entity> ret = new ArrayList<net.minecraft.world.entity.Entity>();
        this.entitySliceManager.getEntities(except, box, ret, predicate);
        return ret;
    }

    @Override
    public void getEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, Predicate<? super net.minecraft.world.entity.Entity> predicate, List<net.minecraft.world.entity.Entity> into) {
        this.entitySliceManager.getEntities(except, box, into, predicate);
    }

    @Override
    public void getHardCollidingEntities(net.minecraft.world.entity.Entity except, AxisAlignedBB box, Predicate<? super net.minecraft.world.entity.Entity> predicate, List<net.minecraft.world.entity.Entity> into) {
        this.entitySliceManager.getHardCollidingEntities(except, box, into, predicate);
    }

    @Override
    public <T> void getEntitiesByClass(Class<? extends T> clazz, net.minecraft.world.entity.Entity except, AxisAlignedBB box, List<? super T> into, Predicate<? super T> predicate) {
        this.entitySliceManager.getEntities(clazz, except, box, into, predicate);
    }

    @Override
    public <T extends net.minecraft.world.entity.Entity> List<T> a(Class<T> entityClass, AxisAlignedBB box, Predicate<? super T> predicate) {
        ArrayList ret = new ArrayList();
        this.entitySliceManager.getEntities(entityClass, null, box, ret, predicate);
        return ret;
    }
}

