/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IStructureAccess;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureManager {
    private final GeneratorAccess a;
    private final GeneratorSettings b;
    private final StructureCheck c;

    public StructureManager(GeneratorAccess world, GeneratorSettings options, StructureCheck locator) {
        this.a = world;
        this.b = options;
        this.c = locator;
    }

    public StructureManager a(RegionLimitedWorldAccess region) {
        if (region.F() != this.a) {
            throw new IllegalStateException("Using invalid feature manager (source level: " + region.F() + ", region: " + region);
        }
        return new StructureManager(region, this.b, this.c);
    }

    public List<StructureStart> a(SectionPosition sectionPos, Predicate<StructureFeature<?, ?>> predicate) {
        Map<StructureFeature<?, ?>, LongSet> map = this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.e).h();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<StructureFeature<?, ?>, LongSet> entry : map.entrySet()) {
            StructureFeature<?, ?> configuredStructureFeature = entry.getKey();
            if (!predicate.test(configuredStructureFeature)) continue;
            this.a(configuredStructureFeature, entry.getValue(), arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public List<StructureStart> a(SectionPosition sectionPos, StructureFeature<?, ?> configuredStructureFeature) {
        return this.startsForFeature(sectionPos, configuredStructureFeature, null);
    }

    public List<StructureStart> startsForFeature(SectionPosition sectionPos, StructureFeature<?, ?> configuredStructureFeature, WorldAccess world) {
        LongSet longSet = (world == null ? this.a : world).a(sectionPos.a(), sectionPos.c(), ChunkStatus.e).b(configuredStructureFeature);
        ImmutableList.Builder builder = ImmutableList.builder();
        this.a(configuredStructureFeature, longSet, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public void a(StructureFeature<?, ?> configuredStructureFeature, LongSet longSet, Consumer<StructureStart> consumer) {
        LongIterator longIterator = longSet.iterator();
        while (longIterator.hasNext()) {
            long l2 = (Long)longIterator.next();
            SectionPosition sectionPos = SectionPosition.a(new ChunkCoordIntPair(l2), this.a.ai());
            StructureStart structureStart = this.a(sectionPos, configuredStructureFeature, this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.d));
            if (structureStart == null || !structureStart.b()) continue;
            consumer.accept(structureStart);
        }
    }

    @Nullable
    public StructureStart a(SectionPosition pos, StructureFeature<?, ?> configuredStructureFeature, IStructureAccess holder) {
        return holder.a(configuredStructureFeature);
    }

    public void a(SectionPosition pos, StructureFeature<?, ?> configuredStructureFeature, StructureStart structureStart, IStructureAccess holder) {
        holder.a(configuredStructureFeature, structureStart);
    }

    public void a(SectionPosition pos, StructureFeature<?, ?> configuredStructureFeature, long reference, IStructureAccess holder) {
        holder.a(configuredStructureFeature, reference);
    }

    public boolean a() {
        return this.b.b();
    }

    public StructureStart a(BlockPosition pos, StructureFeature<?, ?> configuredStructureFeature) {
        for (StructureStart structureStart : this.a(SectionPosition.a(pos), configuredStructureFeature)) {
            if (!structureStart.a().b(pos)) continue;
            return structureStart;
        }
        return StructureStart.b;
    }

    public StructureStart a(BlockPosition blockPos, ResourceKey<StructureFeature<?, ?>> resourceKey) {
        StructureFeature<?, ?> configuredStructureFeature = this.b().d(IRegistry.aL).a(resourceKey);
        return configuredStructureFeature == null ? StructureStart.b : this.b(blockPos, configuredStructureFeature);
    }

    public StructureStart b(BlockPosition pos, StructureFeature<?, ?> configuredStructureFeature) {
        return this.getStructureWithPieceAt(pos, configuredStructureFeature, null);
    }

    public StructureStart getStructureWithPieceAt(BlockPosition pos, StructureFeature<?, ?> configuredStructureFeature, WorldAccess world) {
        for (StructureStart structureStart : this.startsForFeature(SectionPosition.a(pos), configuredStructureFeature, world)) {
            if (!this.a(pos, structureStart)) continue;
            return structureStart;
        }
        return StructureStart.b;
    }

    public boolean a(BlockPosition blockPos, StructureStart structureStart) {
        for (StructurePiece structurePiece : structureStart.i()) {
            if (!structurePiece.f().b(blockPos)) continue;
            return true;
        }
        return false;
    }

    public boolean a(BlockPosition pos) {
        SectionPosition sectionPos = SectionPosition.a(pos);
        return this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.e).w();
    }

    public Map<StructureFeature<?, ?>, LongSet> b(BlockPosition blockPos) {
        SectionPosition sectionPos = SectionPosition.a(blockPos);
        return this.a.a(sectionPos.a(), sectionPos.c(), ChunkStatus.e).h();
    }

    public StructureCheckResult a(ChunkCoordIntPair chunkPos, StructureFeature<?, ?> configuredStructureFeature, boolean skipExistingChunk) {
        return this.c.a(chunkPos, configuredStructureFeature, skipExistingChunk);
    }

    public void a(StructureStart structureStart) {
        structureStart.e();
        this.c.a(structureStart.c(), structureStart.h());
    }

    public IRegistryCustom b() {
        return this.a.s();
    }
}

