/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IBlockAccess
extends LevelHeightAccessor {
    @Nullable
    public TileEntity c_(BlockPosition var1);

    default public <T extends TileEntity> Optional<T> a(BlockPosition pos, TileEntityTypes<T> type) {
        TileEntity tileentity = this.c_(pos);
        return tileentity != null && tileentity.u() == type ? Optional.of(tileentity) : Optional.empty();
    }

    public IBlockData a_(BlockPosition var1);

    @Nullable
    public IBlockData getBlockStateIfLoaded(BlockPosition var1);

    @Nullable
    default public Material getMaterialIfLoaded(BlockPosition blockposition) {
        IBlockData type = this.getBlockStateIfLoaded(blockposition);
        return type == null ? null : type.c();
    }

    @Nullable
    default public Block getBlockIfLoaded(BlockPosition blockposition) {
        IBlockData type = this.getBlockStateIfLoaded(blockposition);
        return type == null ? null : type.b();
    }

    @Nullable
    public Fluid getFluidIfLoaded(BlockPosition var1);

    public Fluid b_(BlockPosition var1);

    default public int h(BlockPosition pos) {
        return this.a_(pos).f();
    }

    default public int N() {
        return 15;
    }

    default public Stream<IBlockData> a(AxisAlignedBB box) {
        return BlockPosition.a(box).map(this::a_);
    }

    default public MovingObjectPositionBlock a(ClipBlockStateContext context) {
        return IBlockAccess.a(context.b(), context.a(), context, (clipblockstatecontext1, blockposition) -> {
            IBlockData iblockdata = this.a_((BlockPosition)blockposition);
            Vec3D vec3d = clipblockstatecontext1.b().d(clipblockstatecontext1.a());
            return clipblockstatecontext1.c().test(iblockdata) ? new MovingObjectPositionBlock(clipblockstatecontext1.a(), EnumDirection.a(vec3d.b, vec3d.c, vec3d.d), new BlockPosition(clipblockstatecontext1.a()), false) : null;
        }, clipblockstatecontext1 -> {
            Vec3D vec3d = clipblockstatecontext1.b().d(clipblockstatecontext1.a());
            return MovingObjectPositionBlock.a(clipblockstatecontext1.a(), EnumDirection.a(vec3d.b, vec3d.c, vec3d.d), new BlockPosition(clipblockstatecontext1.a()));
        });
    }

    default public MovingObjectPositionBlock clip(RayTrace raytrace1, BlockPosition blockposition) {
        IBlockData iblockdata = this.getBlockStateIfLoaded(blockposition);
        if (iblockdata == null) {
            Vec3D vec3d = raytrace1.b().d(raytrace1.a());
            return MovingObjectPositionBlock.a(raytrace1.a(), EnumDirection.a(vec3d.b, vec3d.c, vec3d.d), new BlockPosition(raytrace1.a()));
        }
        if (iblockdata.g()) {
            return null;
        }
        Fluid fluid = iblockdata.o();
        Vec3D vec3d = raytrace1.b();
        Vec3D vec3d1 = raytrace1.a();
        VoxelShape voxelshape = raytrace1.a(iblockdata, this, blockposition);
        MovingObjectPositionBlock movingobjectpositionblock = this.a(vec3d, vec3d1, blockposition, voxelshape, iblockdata);
        VoxelShape voxelshape1 = raytrace1.a(fluid, this, blockposition);
        MovingObjectPositionBlock movingobjectpositionblock1 = voxelshape1.a(vec3d, vec3d1, blockposition);
        double d0 = movingobjectpositionblock == null ? Double.MAX_VALUE : raytrace1.b().g(movingobjectpositionblock.e());
        double d1 = movingobjectpositionblock1 == null ? Double.MAX_VALUE : raytrace1.b().g(movingobjectpositionblock1.e());
        return d0 <= d1 ? movingobjectpositionblock : movingobjectpositionblock1;
    }

    default public MovingObjectPositionBlock a(RayTrace context) {
        return IBlockAccess.a(context.b(), context.a(), context, (raytrace1, blockposition) -> this.clip((RayTrace)raytrace1, (BlockPosition)blockposition), raytrace1 -> {
            Vec3D vec3d = raytrace1.b().d(raytrace1.a());
            return MovingObjectPositionBlock.a(raytrace1.a(), EnumDirection.a(vec3d.b, vec3d.c, vec3d.d), new BlockPosition(raytrace1.a()));
        });
    }

    @Nullable
    default public MovingObjectPositionBlock a(Vec3D start, Vec3D end, BlockPosition pos, VoxelShape shape, IBlockData state) {
        MovingObjectPositionBlock movingobjectpositionblock1;
        MovingObjectPositionBlock movingobjectpositionblock = shape.a(start, end, pos);
        if (movingobjectpositionblock != null && (movingobjectpositionblock1 = state.m(this, pos).a(start, end, pos)) != null && movingobjectpositionblock1.e().d(start).g() < movingobjectpositionblock.e().d(start).g()) {
            return movingobjectpositionblock.a(movingobjectpositionblock1.b());
        }
        return movingobjectpositionblock;
    }

    default public double a(VoxelShape blockCollisionShape, Supplier<VoxelShape> belowBlockCollisionShapeGetter) {
        if (!blockCollisionShape.b()) {
            return blockCollisionShape.c(EnumDirection.EnumAxis.b);
        }
        double d0 = belowBlockCollisionShapeGetter.get().c(EnumDirection.EnumAxis.b);
        return d0 >= 1.0 ? d0 - 1.0 : Double.NEGATIVE_INFINITY;
    }

    default public double i(BlockPosition pos) {
        return this.a(this.a_(pos).k(this, pos), () -> {
            BlockPosition blockposition1 = pos.c();
            return this.a_(blockposition1).k(this, blockposition1);
        });
    }

    public static <T, C> T a(Vec3D start, Vec3D end, C context, BiFunction<C, BlockPosition, T> blockHitFactory, Function<C, T> missFactory) {
        T object;
        int k2;
        int j2;
        if (start.equals(end)) {
            return missFactory.apply(context);
        }
        double d0 = MathHelper.d(-1.0E-7, end.b, start.b);
        double d1 = MathHelper.d(-1.0E-7, end.c, start.c);
        double d2 = MathHelper.d(-1.0E-7, end.d, start.d);
        double d3 = MathHelper.d(-1.0E-7, start.b, end.b);
        double d4 = MathHelper.d(-1.0E-7, start.c, end.c);
        double d5 = MathHelper.d(-1.0E-7, start.d, end.d);
        int i2 = MathHelper.b(d3);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(i2, j2 = MathHelper.b(d4), k2 = MathHelper.b(d5));
        T t0 = blockHitFactory.apply(context, blockposition_mutableblockposition);
        if (t0 != null) {
            return t0;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l2 = MathHelper.k(d6);
        int i1 = MathHelper.k(d7);
        int j1 = MathHelper.k(d8);
        double d9 = l2 == 0 ? Double.MAX_VALUE : (double)l2 / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l2 > 0 ? 1.0 - MathHelper.g(d3) : MathHelper.g(d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - MathHelper.g(d4) : MathHelper.g(d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - MathHelper.g(d5) : MathHelper.g(d5));
        do {
            if (d12 > 1.0 && d13 > 1.0 && d14 > 1.0) {
                return missFactory.apply(context);
            }
            if (d12 < d13) {
                if (d12 < d14) {
                    i2 += l2;
                    d12 += d9;
                    continue;
                }
                k2 += j1;
                d14 += d11;
                continue;
            }
            if (d13 < d14) {
                j2 += i1;
                d13 += d10;
                continue;
            }
            k2 += j1;
            d14 += d11;
        } while ((object = blockHitFactory.apply(context, blockposition_mutableblockposition.d(i2, j2, k2))) == null);
        return object;
    }
}

